/* gmoo - a gtk+ based graphical MOO/MUD/MUSH/... client
 * Copyright (C) 1999-2000 Gert Scholten
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef GM_RUN_H
#define GM_RUN_H

#include "config.h"

#ifdef ZVT

#include "settings.h"
#include "properties_creator.h"

typedef struct _d_run_t d_run_t; /* The dialog in de preferences dialog */
typedef struct _t_run_t t_run_t; /* The data kept for the notebook tabs */

struct _d_run_t {
    pc_win *pc;
    GtkWidget *table;
    GtkWidget *name_w;
    GtkWidget *command_w;
    GtkWidget *enable;
    GtkWidget *clist;
    GtkWidget *add_but;
    GtkWidget *update_but;
    GtkWidget *up_but;
    GtkWidget *down_but;
    GtkWidget *remove_but;
};

struct _t_run_t {
    int position;
    char *name;
    char *command;
    char *title;
    GtkWidget *main;
    GtkWidget *term;
    GtkWidget *tab_label;
};

void gm_run_init();
void gm_run_free();

d_run_t *gm_run_create_properties(GtkTable *table, settings_t *s);
void     gm_run_free_dialog(d_run_t *r);
void     gm_run_apply_changes(d_run_t *r);

GtkWidget *gm_run_create_menu();

void gm_run_set_position(t_run_t *r, int pos);
void gm_run_close(t_run_t *r);

void gm_run_try_run(const char *name, const char *command);

void gm_run_got_focus(t_run_t *r);

#endif /* ZVT */

#endif /* GM_RUN_H */
