#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"
#include "profile.h"
#include <sys/types.h>
#include <sys/stat.h>

extern void storeProfile(struct profile *p, long addr);
extern void getProfile(struct profile *p, long addr);
extern void getMgabase(struct mgabase *base, long addr);
WORD getMemrdbk(long addr);
extern void calcClock( GtkWidget* widget, struct profile *pf );
extern void checkIfPreset( GtkWidget* widget, struct profile *pf );
extern void printProfile( GtkWidget* widget, struct profile *pf );
extern void printMessage( GtkWidget* widget, const char* message, gchar* color );
extern void printStatus (GtkWidget* widget, const gchar *text );
extern int cmpProfile(struct profile *p, long addr);
extern int cmpProfile2(struct profile *p, struct profile *p2);
extern int findCard( int card );
extern int updateFields( GtkWidget *widget, struct profile *pf );
extern double clkMatch(double dsrFreq, struct profile *pf);
extern double getSyspll( void );
extern GtkWidget* create_messagebox1(void);
extern GtkWidget* create_messagebox2(void);
extern GtkWidget* create_fileselection1();
extern GtkWidget* create_fileError();

extern GtkWidget* mainWindow;
extern GtkWidget* opt3Window;
extern GtkWidget* ramWindow;
extern int presetCount, verbosity;
extern struct profile presets[];
extern int advanced_settings;
 
gint check_timer( gpointer data );
void do_saving ( gchar* filename );
void chkGclkdcyc (void);
void chkMclkdcyc (void);
void chkWclkdcyc (void);

gint gt, noretry = 0, hardpwmsk = 0, enhmemacc = 0, nohireq = 0;
extern gint load_settings;
extern gint automatic_DCC;
gchar* selected_filename = NULL;
struct mctlwtst mctl_cur = { 1, 0, 2, 0, 2, 0, 6, 0, 2, 0, 1,
			      0, 1, 0, 1, 0, 1, 0, 4 };
/* struct mctlwtst* mctl_reset = { 1, 0, 2, 0, 2, 0, 6, 0, 2, 0, 1, 0,
				1, 0, 1, 0, 1, 0, 4 };
*/

/****************************************************************/
void
on_gmgaclock_destroy                   (GtkObject       *object,
                                        gpointer         user_data)
{
   exit(0);
}

/****************************************************************/
void
on_button5_clicked                     (GtkButton       *button,
                                        gpointer         user_data)
{
   exit(0);
}

/****************************************************************/
long unsigned
getAddr(void)
{
   GtkWidget* tmpWidget;
   gint cardID;

   tmpWidget = lookup_widget( mainWindow, "spnCard" );
   cardID = gtk_spin_button_get_value_as_int ( (GtkSpinButton*) tmpWidget );   
   return(findCard(cardID));
}

/****************************************************************/
void
buildProfile( GtkWidget *widget, struct profile *pf )
{
   GtkWidget *tmpWidget;
   gchar *tmpstr;
   struct syspllp *pllp;
   unsigned char s, p;
   pllp = (struct syspllp*) &pf->pllp;

   p = pllp->p;
   s = pllp->s;

   tmpWidget = lookup_widget( (GtkWidget*) widget, "entryM" );
   tmpstr = gtk_entry_get_text( (GtkEntry*) tmpWidget );
   pf->m = strtol(tmpstr, NULL, 0);
   
   tmpWidget = lookup_widget( (GtkWidget*) widget, "entryN" );
   tmpstr = gtk_entry_get_text( (GtkEntry*) tmpWidget );
   pf->n = strtol(tmpstr, NULL, 0);

   tmpWidget = lookup_widget( (GtkWidget*) widget, "entryP" );
   tmpstr = gtk_entry_get_text( (GtkEntry*) tmpWidget );
   p = strtol(tmpstr, NULL, 0);

   tmpWidget = lookup_widget( (GtkWidget*) widget, "entryS" );
   tmpstr = gtk_entry_get_text( (GtkEntry*) tmpWidget );
   s = strtol(tmpstr, NULL, 0);

   tmpWidget = lookup_widget( (GtkWidget*) widget, "entryO1" );
   tmpstr = gtk_entry_get_text( (GtkEntry*) tmpWidget );
   pf->opt1 = strtol(tmpstr, NULL, 0);

   tmpWidget = lookup_widget( (GtkWidget*) widget, "entryO2" );
   tmpstr = gtk_entry_get_text( (GtkEntry*) tmpWidget );
   pf->opt2 = strtol(tmpstr, NULL, 0);


   tmpWidget = lookup_widget( (GtkWidget*) widget, "entryO3" );
   tmpstr = gtk_entry_get_text( (GtkEntry*) tmpWidget );
   pf->opt3 = strtol(tmpstr, NULL, 0);

   pllp->s = s;
   pllp->p = p;

   pf->pllp = (s << 3) | (p << 5);

   if (verbosity > 1) {
      printf("p: 0x%02x\n", pllp->p);
      printf("s: 0x%02x\n", pllp->s);
      printf("pllp: 0x%02x\n", pf->pllp);
   }
}

/******************************************************************/
void
chkApply (GtkWidget *widget)
{
   GtkWidget *tmpWidget;
   gchar *present;

   tmpWidget = lookup_widget( widget, "entryAddr" );
   present = gtk_entry_get_text( (GtkEntry*) tmpWidget );
   
   tmpWidget = lookup_widget( widget, "button3" );

   if( (strcasecmp(present, "0x00000000") != 0) )
   {
      gtk_widget_set_sensitive( tmpWidget, TRUE );
   }
}


/****************************************************************/
gchar*
getClksel ( WORD clksel )
{
   switch( clksel )
   {
      case 0:
	 return "PCI";
      case 1:
	 return "SysPLL";
      case 2:
	 return "MCLK";
      case 3:
	 return "AGPDLL";
      default:
	 return NULL;
   }
}

/***************************************************************/
gchar*
getClkdiv ( WORD clkdiv )
{
   switch( clkdiv )
   {
      case 0:
	 return "3";
      case 1:
	 return "2.5";
      case 2:
	 return "2.25";
      case 3:
	 return "2";
      case 4:
	 return "1.5";
      case 5:
	 return "Bypass";
      default:
	 return NULL;
   }
}

/*************************************************************/
gchar*
getClkdcyc ( WORD clkdcyc )
{
   switch( clkdcyc )
   {
      case 0:
	 return "Unaffected";
      case 1:
	 return "2.75-3.25";
      case 2:
	 return "3.25-3.75";
      case 3:
	 return "3.75-4.25";
      case 4:
	 return "4.25-4.75";
      case 5:
	 return "4.75-5.25";
      case 6:
	 return "5.25-5.75";
      case 7:
	 return "5.75-6.25";
      case 8:
	 return "6.25-6.75";
      case 9:
	 return "6.75-7.25";
      case 10:
	 return "7.25-7.75";
      case 11:
	 return "7.75-8.25";
      case 12:
	 return "8.25-8.75";
      case 13:
	 return "8.75-9.25";
      case 14:
	 return "9.25-9.75";
      case 15:
	 return "9.75-10.25";
      default:
	 return NULL;
   }
}

/*************************************************************/
WORD
setClksel ( gchar* clksel )
{
   if (strcasecmp( "PCI", clksel ) == 0)
      return 0;
   else if (strcasecmp( "SysPLL", clksel ) == 0)
      return 1;
   else if (strcasecmp( "MCLK", clksel ) == 0)
      return 2;
   else if (strcasecmp( "AGPDLL", clksel ) == 0)
      return 3;
   else
      return 0;

}

/**************************************************************/
WORD
setClkdiv ( gchar* clkdiv )
{

   if (strcasecmp( "3", clkdiv ) == 0)
      return 0;
   else if (strcasecmp( "2.5", clkdiv ) == 0)
      return 1;
   else if (strcasecmp( "2.25", clkdiv ) == 0)
      return 2;
   else if (strcasecmp( "2", clkdiv ) == 0)
      return 3;
   else if (strcasecmp( "1.5", clkdiv ) == 0)
      return 4;
   else if (strcasecmp( "Bypass", clkdiv ) == 0)
      return 5;
   else
      return 0;
}

/**************************************************************/
WORD
setClkdcyc ( gchar* clkdcyc )
{
   if (strcasecmp( "Unaffected", clkdcyc ) == 0)
      return 0;
   else if (strcasecmp( "2.75-3.25", clkdcyc ) == 0)
      return 1;
   else if (strcasecmp( "3.25-3.75", clkdcyc ) == 0)
      return 2;
   else if (strcasecmp( "3.75-4.25", clkdcyc ) == 0)
      return 3;
   else if (strcasecmp( "4.25-4.75", clkdcyc ) == 0)
      return 4;
   else if (strcasecmp( "4.75-5.25", clkdcyc ) == 0)
      return 5;
   else if (strcasecmp( "5.25-5.75", clkdcyc ) == 0)
      return 6;
   else if (strcasecmp( "5.75-6.25", clkdcyc ) == 0)
      return 7;
   else if (strcasecmp( "6.25-6.75", clkdcyc ) == 0)
      return 8;
   else if (strcasecmp( "6.75-7.25", clkdcyc ) == 0)
      return 9;
   else if (strcasecmp( "7.25-7.75", clkdcyc ) == 0)
      return 10;
   else if (strcasecmp( "7.75-8.25", clkdcyc ) == 0)
      return 11;
   else if (strcasecmp( "8.25-8.75", clkdcyc ) == 0)
      return 12;
   else if (strcasecmp( "8.75-9.25", clkdcyc ) == 0)
      return 13;
   else if (strcasecmp( "9.25-9.75", clkdcyc ) == 0)
      return 14;
   else if (strcasecmp( "9.75-10.25", clkdcyc ) == 0)
      return 15;
   else
      return 0;
}

/****************************************************************/
void
buildOpt3 ( struct g400_option3 *opt3 )
{
   GtkWidget* tmpWidget;
   gchar* tmpstr;

   /* GCLK */
   tmpWidget = lookup_widget( opt3Window, "entryGclksel" );
   tmpstr = gtk_entry_get_text( (GtkEntry*) tmpWidget );
   opt3->gclksel = setClksel( tmpstr );

   tmpWidget = lookup_widget( opt3Window, "entryGclkdiv" );
   tmpstr = gtk_entry_get_text( (GtkEntry*) tmpWidget );
   opt3->gclkdiv = setClkdiv( tmpstr );

   tmpWidget = lookup_widget( opt3Window, "entryGclkdcyc" );
   tmpstr = gtk_entry_get_text( (GtkEntry*) tmpWidget );
   opt3->gclkdcyc = setClkdcyc( tmpstr );

   /* MCLK */
   tmpWidget = lookup_widget( opt3Window, "entryMclksel" );
   tmpstr = gtk_entry_get_text( (GtkEntry*) tmpWidget );
   opt3->mclksel = setClksel( tmpstr );

   tmpWidget = lookup_widget( opt3Window, "entryMclkdiv" );
   tmpstr = gtk_entry_get_text( (GtkEntry*) tmpWidget );
   opt3->mcldiv = setClkdiv( tmpstr );

   tmpWidget = lookup_widget( opt3Window, "entryMclkdcyc" );
   tmpstr = gtk_entry_get_text( (GtkEntry*) tmpWidget );
   opt3->mclkdcyc = setClkdcyc( tmpstr );

   /* WCLK */
   tmpWidget = lookup_widget( opt3Window, "entryWclksel" );
   tmpstr = gtk_entry_get_text( (GtkEntry*) tmpWidget );
   opt3->wclksel = setClksel( tmpstr );

   tmpWidget = lookup_widget( opt3Window, "entryWclkdiv" );
   tmpstr = gtk_entry_get_text( (GtkEntry*) tmpWidget );
   opt3->wclkdiv = setClkdiv( tmpstr );

   tmpWidget = lookup_widget( opt3Window, "entryWclkdcyc" );
   tmpstr = gtk_entry_get_text( (GtkEntry*) tmpWidget );
   opt3->wclkdcyc = setClkdcyc( tmpstr );

}

/****************************************************************/
void
updO3win ( struct g400_option3* opt3 )
{
   GtkWidget* tmpWidget;
   gchar* tmpstr;

   /* GCLK */
   tmpstr = getClksel( opt3->gclksel );
   tmpWidget = lookup_widget( opt3Window, "entryGclksel" );
   gtk_entry_set_text( (GtkEntry*) tmpWidget, tmpstr );

   tmpstr = getClkdiv( opt3->gclkdiv );
   tmpWidget = lookup_widget( opt3Window, "entryGclkdiv" );
   gtk_entry_set_text( (GtkEntry*) tmpWidget, tmpstr );

   tmpstr = getClkdcyc( opt3->gclkdcyc );
   tmpWidget = lookup_widget( opt3Window, "entryGclkdcyc" );
   gtk_entry_set_text( (GtkEntry*) tmpWidget, tmpstr );
 
  /* MCLK */
   tmpstr = getClksel( opt3->mclksel );
   tmpWidget = lookup_widget( opt3Window, "entryMclksel" );
   gtk_entry_set_text( (GtkEntry*) tmpWidget, tmpstr );

   tmpstr = getClkdiv( opt3->mcldiv );
   tmpWidget = lookup_widget( opt3Window, "entryMclkdiv" );
   gtk_entry_set_text( (GtkEntry*) tmpWidget, tmpstr );

   tmpstr = getClkdcyc( opt3->mclkdcyc );
   tmpWidget = lookup_widget( opt3Window, "entryMclkdcyc" );
   gtk_entry_set_text( (GtkEntry*) tmpWidget, tmpstr );

   /* WCLK */
   tmpstr = getClksel( opt3->wclksel );
   tmpWidget = lookup_widget( opt3Window, "entryWclksel" );
   gtk_entry_set_text( (GtkEntry*) tmpWidget, tmpstr );

   tmpstr = getClkdiv( opt3->wclkdiv );
   tmpWidget = lookup_widget( opt3Window, "entryWclkdiv" );
   gtk_entry_set_text( (GtkEntry*) tmpWidget, tmpstr );

   tmpstr = getClkdcyc( opt3->wclkdcyc );
   tmpWidget = lookup_widget( opt3Window, "entryWclkdcyc" );
   gtk_entry_set_text( (GtkEntry*) tmpWidget, tmpstr );

}

/*************************************************************/
void
chkStuff (GtkWidget *widget)
{
   struct profile pf;
   
   buildProfile(widget, &pf);
   calcClock( widget, &pf );
}

/*************************************************************/
void
chkGclkspd (void)
{
   GtkWidget *tmpWidget;
   gchar *tmpstr, *spdstr;
   double speed, div;

   tmpWidget = lookup_widget( opt3Window, "entryGclkdiv" );
   tmpstr = gtk_entry_get_text( (GtkEntry*) tmpWidget );
   div = atof( tmpstr );
   if ( div < 1 ) div = 1;

   speed = getSyspll()/div;

   spdstr = g_malloc(100);
   sprintf( spdstr, "%.2fMHz", speed );
   tmpWidget = lookup_widget( opt3Window, "entryGclkspd" );
   gtk_entry_set_text( (GtkEntry*) tmpWidget, spdstr );
   g_free( spdstr );
}

/*************************************************************/   
void
chkMclkspd (void)
{
   GtkWidget *tmpWidget;
   gchar *tmpstr, *spdstr;
   double speed, div;

   tmpWidget = lookup_widget( opt3Window, "entryMclkdiv" );
   tmpstr = gtk_entry_get_text( (GtkEntry*) tmpWidget );
   div = atof( tmpstr );
   if ( div < 1 ) div = 1;

   speed = getSyspll()/div;

   spdstr = g_malloc(100);
   sprintf( spdstr, "%.2fMHz", speed );
   tmpWidget = lookup_widget( opt3Window, "entryMclkspd" );
   gtk_entry_set_text( (GtkEntry*) tmpWidget, spdstr );
   g_free( spdstr );
}

/*************************************************************/
void
chkWclkspd (void)
{
   GtkWidget *tmpWidget;
   gchar *tmpstr, *spdstr;
   double speed, div;

   tmpWidget = lookup_widget( opt3Window, "entryWclkdiv" );
   tmpstr = gtk_entry_get_text( (GtkEntry*) tmpWidget );
   div = atof( tmpstr );
   if ( div < 1 ) div = 1;

   speed = getSyspll()/div;

   spdstr = g_malloc(100);
   sprintf( spdstr, "%.2fMHz", speed );
   tmpWidget = lookup_widget( opt3Window, "entryWclkspd" );
   gtk_entry_set_text( (GtkEntry*) tmpWidget, spdstr );
   g_free( spdstr );
}

/*************************************************************/
void
on_chkAdvanced_toggled                 (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
   GtkWidget *advform;
   advform = lookup_widget( (GtkWidget*) togglebutton, "frmAdvanced" );

   if( gtk_toggle_button_get_active( togglebutton ) ) {
      gtk_widget_set_sensitive( advform, TRUE );
      advanced_settings = 1;
      printStatus ((GtkWidget*) togglebutton, "Advanced settings on.");
   } else
   {
      gtk_widget_set_sensitive( advform, FALSE );
      advanced_settings = 0;
      printStatus ((GtkWidget*) togglebutton, "Advanced settings off.");
   }
}


/*************************************************************/
void
on_spnCard_changed                     (GtkEditable     *editable,
                                        gpointer         user_data)
{
   long unsigned addr = 0x81000000;
   struct profile pf;

   addr = getAddr();

   getProfile(&pf, addr);
   
   updateFields( (GtkWidget*) editable, &pf );
}


/*************************************************************/
void
on_apply_clicked                       (GtkButton       *button,
                                        gpointer         user_data)
{
   GtkWidget *tmpWidget;
   gchar *tmpstr, *tmpstr2, *preset;
   struct profile pf, newpf;
   long unsigned addr = 0x81000000;
   double clk = 0L;
   struct g400_option3 *opt3;

   buildProfile((GtkWidget*) button, &pf);
   
   tmpWidget = lookup_widget( (GtkWidget*) button, "entryPreset" );
   preset = gtk_entry_get_text( (GtkEntry*) tmpWidget );

   if( !advanced_settings &&
      (strcasecmp( preset, "Custom" ) == 0) )
   {
      tmpWidget = lookup_widget( (GtkWidget*) button, "entryClk" );
      clk = atof ( gtk_entry_get_text( (GtkEntry*) tmpWidget ) );
      if (verbosity > 1) {
	 printf("Calculating clock.\n");
      }
      clk = clkMatch(clk, &pf);
      tmpstr = g_malloc(20);
      sprintf(tmpstr, "%.2f", clk);
      gtk_entry_set_text( (GtkEntry*) tmpWidget, tmpstr );
      if (automatic_DCC) {
	 chkGclkspd();
	 chkMclkspd();
	 chkWclkspd();
	 opt3 = (struct g400_option3*) pf.opt3;
	 updO3win( (struct g400_option3*) &opt3 );
	 chkGclkdcyc();
	 chkMclkdcyc();      
	 chkWclkdcyc();
	 tmpWidget = lookup_widget( opt3Window, "btnO3ok" );
	 on_btnO3ok_clicked( (GtkButton*) tmpWidget, NULL );
	 tmpWidget = lookup_widget( mainWindow, "entryO3" );
	 tmpstr = gtk_entry_get_text( (GtkEntry*) tmpWidget );
	 pf.opt3 = strtol( tmpstr, NULL, 0);
      }
      g_free(tmpstr);
   }

   if (verbosity > 1) {
      printf("Preset: %s\n", preset);
      printf("Advanced settings %s\n", advanced_settings?"on":"off");
      printf("clk: %.2f\n", clk);
   }

   addr = getAddr();

   storeProfile(&pf, addr);

   if (verbosity > 1) {
      printf("profile stored\n");
   }

   if ( !cmpProfile(&pf, addr) )
   {
      tmpWidget = create_updateFailed();
      gtk_widget_show(tmpWidget);
   } else {
      printStatus( (GtkWidget*) button, "Settings applied." );
      if (verbosity)
      {
	 tmpstr2 = g_malloc(20);
	 sprintf(tmpstr2, "addr: 0x%lx\n", addr);
	 printMessage((GtkWidget*) button, "New settings:\n", "red");
	 printMessage((GtkWidget*) button, tmpstr2, "black");
	 printProfile((GtkWidget*) button, &pf);
	 g_free(tmpstr2);
      }
   }
   getProfile( &newpf, addr );
   updateFields( (GtkWidget*) button, &newpf );

   tmpWidget = create_winConfirm();
   gtk_widget_show(tmpWidget);

   gt = gtk_timeout_add( 5000, check_timer, (gpointer) tmpWidget ); 

   gtk_widget_set_sensitive( (GtkWidget*) button, FALSE );
}

/*************************************************************/
gint
check_timer                            (gpointer         data)
{
   long unsigned addr;

   addr = getAddr();

   storeProfile(&presets[0], addr);
   updateFields( mainWindow, &presets[0] );
   checkIfPreset( mainWindow, &presets[0] );
   printStatus(mainWindow, "BIOS settings restored.");
   gtk_widget_destroy( (GtkWidget*) data );

   return(0);
}


/*************************************************************/
void
on_entryPreset_changed                 (GtkEditable     *editable,
                                        gpointer         user_data)
{
   gchar* tmpstr;
   int i;
   struct profile pf;
   GtkWidget *tmpWidget;

   tmpWidget = lookup_widget( (GtkWidget*) editable, "entryPreset");
   tmpstr = gtk_entry_get_text( (GtkEntry*) tmpWidget );
   if( strcasecmp(tmpstr, "Custom") == 0 )
   {
      tmpWidget = lookup_widget( (GtkWidget*) editable, "entryClk");
      gtk_widget_set_sensitive( tmpWidget, TRUE );
      return;
   } else {
      for( i=0; i < presetCount; i++ )
      {
	 if( strcasecmp( tmpstr, presets[i].name ) == 0 )
	 {
	    pf = presets[i];
	    break;
	 }
      }
      tmpWidget = lookup_widget( (GtkWidget*) editable, "entryClk");
      gtk_widget_set_sensitive( tmpWidget, FALSE );
   }
   updateFields( (GtkWidget*) editable, &pf );
   chkApply( (GtkWidget*) editable );
}

/*************************************************************/
void
on_entryO1_changed                     (GtkEditable     *editable,
                                        gpointer         user_data)
{
   chkApply( (GtkWidget*) editable );
   chkStuff ((GtkWidget*) editable);
}

/*************************************************************/
void
on_entryO2_changed                     (GtkEditable     *editable,
                                        gpointer         user_data)
{
   chkApply( (GtkWidget*) editable );
   chkStuff ((GtkWidget*) editable);
}

/*************************************************************/
void
on_entryO3_changed                     (GtkEditable     *editable,
                                        gpointer         user_data)
{
   chkApply( (GtkWidget*) editable );
/*   chkStuff ((GtkWidget*) editable); */
}

/*************************************************************/
void
on_entryP_changed                      (GtkEditable     *editable,
                                        gpointer         user_data)
{
   chkApply( (GtkWidget*) editable );
   chkStuff ((GtkWidget*) editable);
}

/*************************************************************/
void
on_entryN_changed                      (GtkEditable     *editable,
                                        gpointer         user_data)
{
   chkApply( (GtkWidget*) editable );
   chkStuff ((GtkWidget*) editable);
}

/*************************************************************/
void
on_entryM_changed                      (GtkEditable     *editable,
                                        gpointer         user_data)
{
   chkApply( (GtkWidget*) editable );
   chkStuff ((GtkWidget*) editable);
}

/*************************************************************/
void
on_entryClk_changed                    (GtkEditable     *editable,
                                        gpointer         user_data)
{
   chkApply( (GtkWidget*) editable );
}

/*************************************************************/
void
on_btnO3_clicked                       (GtkButton       *button,
                                        gpointer         user_data)
{
   struct g400_option3 *opt3;
   struct profile pf;
   
   buildProfile( (GtkWidget*) button, &pf );
   opt3 = (struct g400_option3*) pf.opt3;

   chkGclkspd();
   chkMclkspd();
   chkWclkspd();

   updO3win( (struct g400_option3*) &opt3 );

   if (automatic_DCC) {
      chkGclkdcyc();
      chkMclkdcyc();      
      chkWclkdcyc();
   }
   gtk_widget_show( opt3Window );
}

/*************************************************************/
void
on_btnO3ok_clicked                     (GtkButton       *button,
                                        gpointer         user_data)
{
   GtkWidget* tmpWidget;
   struct g400_option3 *opt3 = g_malloc0(4);
   WORD *o3;
   gchar* tmpstr;

   tmpstr = malloc(30);

   buildOpt3( opt3 );

   o3 = (WORD*) opt3;

   sprintf( tmpstr, "0x%02x", *o3);
   tmpWidget = lookup_widget( mainWindow, "entryO3" );
   gtk_entry_set_text( (GtkEntry*) tmpWidget, tmpstr);
   gtk_widget_hide( opt3Window );
   g_free(opt3);
}

/*************************************************************/
void
on_entryGclkdiv_changed                (GtkEditable     *editable,
                                        gpointer         user_data)
{
   chkGclkspd ();
   chkGclkdcyc();
}

/*************************************************************/
void
on_entryGclksel_changed                (GtkEditable     *editable,
                                        gpointer         user_data)
{
   chkGclkspd ();
}

/*************************************************************/
void
on_entryMclksel_changed                (GtkEditable     *editable,
                                        gpointer         user_data)
{
   chkMclkspd ();
}

/*************************************************************/
void
on_entryMclkdiv_changed                (GtkEditable     *editable,
                                        gpointer         user_data)
{
   chkMclkspd ();
   chkMclkdcyc();
}

/*************************************************************/
void
on_entryWclksel_changed                (GtkEditable     *editable,
                                        gpointer         user_data)
{
   chkWclkspd ();
}

/*************************************************************/
void
on_entryWclkdiv_changed                (GtkEditable     *editable,
                                        gpointer         user_data)
{
   chkWclkspd ();
   chkWclkdcyc();
}

/*************************************************************/
void
on_btnCancel_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
   gtk_widget_hide( opt3Window );
}

/*************************************************************/
void
on_open1_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
   GtkWidget* tmpWidget;
   tmpWidget = create_winOpen();
   gtk_widget_show( tmpWidget );
}

/*************************************************************/
void
on_save1_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
   gchar *filename;

   filename = gnome_util_prepend_user_home( ".gmgaclockrc" );
   do_saving( filename );

   g_free(filename);
}

/*************************************************************/
void
do_saving ( gchar* filename )
{
   GtkWidget* tmpWidget;
   gchar* tmpstr;
   FILE *fp;
   unsigned long addr;
   struct profile pf;

   tmpstr = g_malloc0(255);

   fp = fopen(filename, "w");
   if( fp == NULL )
   {
      tmpWidget = create_fileError();
      gtk_widget_show(tmpWidget);
      g_free(tmpstr);
      tmpstr = NULL;
      return;
   }

   addr = getAddr();

   getProfile( &pf, addr );
   sprintf(tmpstr, "0x%02x\n", pf.m);
   fputs(tmpstr, fp);
   sprintf(tmpstr, "0x%02x\n", pf.n);
   fputs(tmpstr, fp);
   sprintf(tmpstr, "0x%02x\n", pf.pllp);
   fputs(tmpstr, fp);
   sprintf(tmpstr, "0x%02x\n", pf.opt1);
   fputs(tmpstr, fp);
   sprintf(tmpstr, "0x%02x\n", pf.opt2);
   fputs(tmpstr, fp);
   sprintf(tmpstr, "0x%02x\n", pf.opt3);
   fputs(tmpstr, fp);

   fclose( fp );
   sprintf( tmpstr, "Settings saved in %s", filename );
   printStatus ( mainWindow, tmpstr);

   g_free(tmpstr);
}

/*************************************************************/
int
do_open (gchar* filename)
{
   GtkWidget* tmpWidget;
   GtkLabel* tmpLabel;
   FILE *fp = NULL;
   gchar* tmpstr;
   struct profile pf;
   struct stat st;

   tmpstr = g_malloc0(255);

   stat( filename, &st );

   fp = fopen(filename, "r");

   if( fp == NULL || !S_ISREG(st.st_mode))
   {
      tmpWidget = create_fileError();
      tmpLabel = (GtkLabel*) lookup_widget( tmpWidget, "lblFileError");
      gtk_label_set_text( tmpLabel, filename );
      gtk_widget_show(tmpWidget);
      tmpstr = NULL;
      g_free(tmpstr);
      return 0;
   }

   fgets( tmpstr, 6, fp);
   pf.m = strtol(tmpstr, NULL, 0);

   if (fp == NULL)
   {
      fclose(fp);
      g_free(tmpstr);
      return 0;
   }

   fgets( tmpstr, 6, fp);
   pf.n = strtol(tmpstr, NULL, 0);

   if (fp == NULL)
   {
      sprintf( tmpstr, "Error reading file %s\n", filename );
      printStatus( mainWindow, tmpstr );
      fclose(fp);
      g_free(tmpstr);
      return 0;
   }

   fgets( tmpstr, 6, fp);
   pf.pllp = strtol(tmpstr, NULL, 0);

   if (fp == NULL)
   {
      sprintf( tmpstr, "Error reading file %s\n", filename );
      printStatus( mainWindow, tmpstr );
      fclose(fp);
      g_free(tmpstr);
      g_free(tmpstr);
      return 0;
   }

   fgets( tmpstr, 13, fp);
   pf.opt1 = strtol(tmpstr, NULL, 0);

   if (fp == NULL)
   {
      sprintf( tmpstr, "Error reading file %s\n", filename );
      printStatus( mainWindow, tmpstr );
      fclose(fp);
      g_free(tmpstr);
      return 0;
   }

   fgets( tmpstr, 13, fp);
   pf.opt2 = strtol(tmpstr, NULL, 0);

   if (fp == NULL)
   {
      sprintf( tmpstr, "Error reading file %s\n", filename );
      printStatus( mainWindow, tmpstr );
      fclose(fp);
      g_free(tmpstr);
      return 0;
   }

   fgets( tmpstr, 13, fp);
   pf.opt3 = strtol(tmpstr, NULL, 0);

   updateFields( mainWindow, &pf );
   checkIfPreset( mainWindow, &pf );

   fclose(fp);

   sprintf( tmpstr, "Settings loaded from %s", filename );
   printStatus ( mainWindow, tmpstr);

   g_free(tmpstr);
   return 1;
}

/*************************************************************/
void
on_save_as1_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
   GtkWidget* tmpWidget;
   tmpWidget = create_winSaveAs();
   gtk_widget_show( tmpWidget );
}

/*************************************************************/
void
on_quit1_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
   exit(0);
}

/*************************************************************/
void
on_about1_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
   GtkWidget* tmpWidget;
   tmpWidget = create_winAbout();
   gtk_widget_show(tmpWidget);
}

/*************************************************************/
void
on_button9_clicked                     (GtkButton       *button,
                                        gpointer         user_data)
{
   GtkWidget* tmpWidget;
   tmpWidget = lookup_widget( (GtkWidget*) button, "winConfirm");
   gtk_widget_destroy(tmpWidget);
   gtk_timeout_remove( gt );
   printStatus( mainWindow, "New settings confirmed." );
}

/*************************************************************/
void
on_ok_button1_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
   GtkWidget* tmpWidget;
   selected_filename = NULL;

   tmpWidget = lookup_widget( (GtkWidget*) button, "winSaveAs" );
   selected_filename = gtk_file_selection_get_filename( (GtkFileSelection*) tmpWidget );

   gtk_widget_hide( tmpWidget );
   do_saving( selected_filename );
   gtk_widget_destroy( tmpWidget );
}

/*************************************************************/
void
on_cancel_button1_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
   GtkWidget* tmpWidget;
   tmpWidget = lookup_widget( (GtkWidget*) button, "winSaveAs" );
   gtk_widget_destroy( tmpWidget );
}

/*************************************************************/
void
on_ok_button2_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
   GtkWidget* tmpWidget;
   selected_filename = NULL;

   tmpWidget = lookup_widget( (GtkWidget*) button, "winOpen" );
   selected_filename = gtk_file_selection_get_filename( (GtkFileSelection*) tmpWidget );

   gtk_widget_hide( tmpWidget );
   do_open( selected_filename );
   gtk_widget_destroy( tmpWidget );
}

/*************************************************************/
void
on_cancel_button2_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
   GtkWidget* tmpWidget;
   tmpWidget = lookup_widget( (GtkWidget*) button, "winOpen" );
   gtk_widget_destroy( tmpWidget );
}

/*************************************************************/
void
on_load_settings_on_startup1_toggled (GtkCheckMenuItem *menuitem,
				      gpointer user_data)
{
   gchar* configfile;
   FILE* fp;

   if (menuitem->active)
   {
      load_settings = 1;
   } else {
      load_settings = 0;
   }
   gnome_config_set_int( "/gmgaclock/settings/load_settings", load_settings );
   configfile = gnome_util_home_file("gmgaclock");

   if( !g_file_exists( configfile ) )
   {
      fp = fopen( configfile, "w" );
      fclose( fp );
   }
   gnome_config_sync_file("gmgaclock");
}

/*************************************************************/
void
on_web_page1_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
   gnome_url_show("http://gmgaclock.sourceforge.net");
}

/*************************************************************/
void
on_chkDCC_toggled                      (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
   gchar* configfile;
   FILE* fp;

   GtkWidget* tmpWidget;
   if( gtk_toggle_button_get_active( togglebutton ) ) {
      tmpWidget = lookup_widget( (GtkWidget*) togglebutton, "cmbGclkdcyc" );
      gtk_widget_set_sensitive( tmpWidget, FALSE );
      tmpWidget = lookup_widget( (GtkWidget*) togglebutton, "cmbMclkdcyc" );
      gtk_widget_set_sensitive( tmpWidget, FALSE );
      tmpWidget = lookup_widget( (GtkWidget*) togglebutton, "cmbWclkdcyc" );
      gtk_widget_set_sensitive( tmpWidget, FALSE );
      automatic_DCC = 1;
      chkGclkdcyc();
      chkMclkdcyc();
      chkWclkdcyc();
   } else
   {
      tmpWidget = lookup_widget( (GtkWidget*) togglebutton, "cmbGclkdcyc" );
      gtk_widget_set_sensitive( tmpWidget, TRUE );
      tmpWidget = lookup_widget( (GtkWidget*) togglebutton, "cmbMclkdcyc" );
      gtk_widget_set_sensitive( tmpWidget, TRUE );
      tmpWidget = lookup_widget( (GtkWidget*) togglebutton, "cmbWclkdcyc" );
      gtk_widget_set_sensitive( tmpWidget, TRUE );
      automatic_DCC = 0;
   }
   gnome_config_set_int( "/gmgaclock/settings/automatic_DCC", automatic_DCC );
   configfile = gnome_util_home_file("gmgaclock");

   if( !g_file_exists( configfile ) )
   {
      fp = fopen( configfile, "w" );
      fclose( fp );
   }
   gnome_config_sync_file("gmgaclock");
}

/*************************************************************/
gchar*
getDccRange( double dcyc )
{
   if (dcyc < 2.75)
   {
      return "Unaffected";
   }
   else if (dcyc >= 2.75 && dcyc < 3.25)
   {
      return "2.75-3.25";
   }
   else if (dcyc >= 3.25 && dcyc < 3.75)
   {
      return "3.25-3.75";
   }
   else if (dcyc >= 3.75 && dcyc < 4.25)
   {
      return "3.75-4.25";
   }
   else if (dcyc >= 4.25 && dcyc < 4.75)
   {
      return "4.25-4.75";
   }
   else if (dcyc >= 4.75 && dcyc < 5.25)
   {
      return "4.75-5.25";
   }
   else if (dcyc >= 5.25 && dcyc < 5.75)
   {
      return "5.25-5.75";
   }
   else if (dcyc >= 5.75 && dcyc < 6.25)
   {
      return "5.75-6.25";
   }
   else if (dcyc >= 6.25 && dcyc < 6.75)
   {
      return "6.25-6.75";
   }
   else if (dcyc >= 6.75 && dcyc < 7.25)
   {
      return "6.75-7.25";
   }
   else if (dcyc >= 7.25 && dcyc < 7.75)
   {
      return "7.25-7.75";
   }
   else if (dcyc >= 7.75 && dcyc < 8.25)
   {
      return "7.75-8.25";
   }
   else if (dcyc >= 8.25 && dcyc < 8.75)
   {
      return "8.25-8.75";
   }
   else if (dcyc >= 8.75 && dcyc < 9.25)
   {
      return "8.75-9.25";
   }
   else if (dcyc >= 9.25 && dcyc < 9.75)
   {
      return "9.25-9.75";
   }
   else if (dcyc >= 9.75 && dcyc < 10.25)
   {
      return "4.75-5.25";
   }
   return "Unaffected";
}

/*************************************************************/
void
chkGclkdcyc (void)
{
   GtkWidget *tmpWidget;
   gchar *tmpstr, *dccstr;
   double speed, div, dcyc;

   tmpWidget = lookup_widget( opt3Window, "entryGclkdiv" );
   tmpstr = gtk_entry_get_text( (GtkEntry*) tmpWidget );
   div = atof( tmpstr );
   if ( div < 1 ) div = 1;

   speed = getSyspll()/div;

   if (speed > 97.5) {
      dcyc = (1/speed) * 1000;
   } else {
      dcyc = 8;
   }

   if ( (div == 1.5) || (div == 2.25) )
   {
      dccstr = (gchar*) getDccRange( dcyc );
   } else {
      dccstr = "Unaffected";
   }

   tmpWidget = lookup_widget( opt3Window, "entryGclkdcyc" );
   gtk_entry_set_text( (GtkEntry*) tmpWidget, dccstr );
}

/*************************************************************/
void
chkMclkdcyc (void)
{
   GtkWidget *tmpWidget;
   gchar *tmpstr, *dccstr;
   double speed, div, dcyc;

   tmpWidget = lookup_widget( opt3Window, "entryMclkdiv" );
   tmpstr = gtk_entry_get_text( (GtkEntry*) tmpWidget );
   div = atof( tmpstr );
   if ( div < 1 ) div = 1;

   speed = getSyspll()/div;

   if (speed > 97.5) {
      dcyc = (1/speed) * 1000;
   } else {
      dcyc = 8;
   }

   if ( (div == 1.5) || (div == 2.25) )
   {
      dccstr = (gchar*) getDccRange( dcyc );
   } else {
      dccstr = "Unaffected";
   }

   tmpWidget = lookup_widget( opt3Window, "entryMclkdcyc" );
   gtk_entry_set_text( (GtkEntry*) tmpWidget, dccstr );
}

/*************************************************************/
void
chkWclkdcyc (void)
{
   GtkWidget *tmpWidget;
   gchar *tmpstr, *dccstr;
   double speed, div, dcyc;

   tmpWidget = lookup_widget( opt3Window, "entryWclkdiv" );
   tmpstr = gtk_entry_get_text( (GtkEntry*) tmpWidget );
   div = atof( tmpstr );
   if ( div < 1 ) div = 1;

   speed = getSyspll()/div;

   if (speed > 97.5) {
      dcyc = (1/speed) * 1000;
   } else {
      dcyc = 8;
   }

   if ( (div == 1.5) || (div == 2.25) )
   {
      dccstr = (gchar*) getDccRange( dcyc );
   } else {
      dccstr = "Unaffected";
   }

   tmpWidget = lookup_widget( opt3Window, "entryWclkdcyc" );
   gtk_entry_set_text( (GtkEntry*) tmpWidget, dccstr );
}

/*************************************************************/
void
storeRam (void)
{
   GtkWidget* tmpWidget;
   struct mctlwtst mctl;
   long unsigned addr;
   gchar* tmpstr;

   tmpWidget = lookup_widget( ramWindow, "entcasltncy" );
   tmpstr = gtk_entry_get_text( (GtkEntry*) tmpWidget );
   mctl.casltncy = strtol( tmpstr, NULL, 0) - 2;

   tmpWidget = lookup_widget( ramWindow, "entrrddelay" );
   tmpstr = gtk_entry_get_text( (GtkEntry*) tmpWidget );
   mctl.rddelay = strtol( tmpstr, NULL, 0) - 1;

   tmpWidget = lookup_widget( ramWindow, "entrcddelay" );
   tmpstr = gtk_entry_get_text( (GtkEntry*) tmpWidget );
   mctl.rcddelay = strtol( tmpstr, NULL, 0) - 2;

   tmpWidget = lookup_widget( ramWindow, "entrasmin" );
   tmpstr = gtk_entry_get_text( (GtkEntry*) tmpWidget );
   mctl.rasmin = strtol( tmpstr, NULL, 0) - 3;

   tmpWidget = lookup_widget( ramWindow, "entrpdelay" );
   tmpstr = gtk_entry_get_text( (GtkEntry*) tmpWidget );
   mctl.rpdelay = strtol( tmpstr, NULL, 0) - 2;

   tmpWidget = lookup_widget( ramWindow, "entwrdelay" );
   tmpstr = gtk_entry_get_text( (GtkEntry*) tmpWidget );
   mctl.wrdelay = strtol( tmpstr, NULL, 0) - 1;

   tmpWidget = lookup_widget( ramWindow, "entrddelay" );
   tmpstr = gtk_entry_get_text( (GtkEntry*) tmpWidget );
   if (strcasecmp( tmpstr, "Fast" ) == 0) {
      mctl.rddelay = 0;
   } else {
      mctl.rddelay = 1;
   }


   tmpWidget = lookup_widget( ramWindow, "entsmrdelay" );
   tmpstr = gtk_entry_get_text( (GtkEntry*) tmpWidget );
   mctl.smrdelay = strtol( tmpstr, NULL, 0) - 1;

   tmpWidget = lookup_widget( ramWindow, "entbwcdelay" );
   tmpstr = gtk_entry_get_text( (GtkEntry*) tmpWidget );
   mctl.bwcdelay = strtol( tmpstr, NULL, 0) - 1;

   tmpWidget = lookup_widget( ramWindow, "entbpldelay" );
   tmpstr = gtk_entry_get_text( (GtkEntry*) tmpWidget );
   mctl.bpldelay = strtol( tmpstr, NULL, 0) - 1;

/***************************************
   tmpWidget = lookup_widget( mainWindow, "entryO1" );
   tmpstr = gtk_entry_get_text( (GtkEntry*) tmpWidget );
   mctl.rpdelay = strtol( tmpstr, NULL, 0) - 2;

   tmpstr = gtk_entry_get_text( (GtkEntry*) tmpWidget );
   value = strtol( tmpstr, NULL, 0 );
   opt = (struct g400_option*) &value;

   tmpWidget = lookup_widget( ramWindow, "spnCounter" );
   gtk_spin_button_set_value( (GtkSpinButton*) tmpWidget, (opt.rfhcnt * 64) + 1);
**************************************/

   addr = getAddr();
/*   storeMemctl( &mctl, addr ); */

}   

/*************************************************************/
void
updRamwin ( struct mctlwtst* mctl )
{
   GtkWidget* tmpWidget;
   WORD memrd;
   struct memrdbk* pmemrd = (struct memrdbk*) &memrd;
   struct g400_option* opt;
   WORD value;
   long unsigned addr;
   gchar* tmpstr;

   tmpstr = g_malloc0(100);

   sprintf( tmpstr, "%i", mctl->casltncy + 2 );
   tmpWidget = lookup_widget( ramWindow, "entcasltncy" );
   gtk_entry_set_text( (GtkEntry*) tmpWidget, tmpstr );

   sprintf( tmpstr, "%i", mctl->rrddelay + 1 );
   tmpWidget = lookup_widget( ramWindow, "entrrddelay" );
   gtk_entry_set_text( (GtkEntry*) tmpWidget, tmpstr );

   sprintf( tmpstr, "%i", mctl->rcddelay + 2 );
   tmpWidget = lookup_widget( ramWindow, "entrcddelay" );
   gtk_entry_set_text( (GtkEntry*) tmpWidget, tmpstr );

   sprintf( tmpstr, "%i", mctl->rasmin + 3 );
   tmpWidget = lookup_widget( ramWindow, "entrasmin" );
   gtk_entry_set_text( (GtkEntry*) tmpWidget, tmpstr );

   sprintf( tmpstr, "%i", mctl->rpdelay + 2 );
   tmpWidget = lookup_widget( ramWindow, "entrpdelay" );
   gtk_entry_set_text( (GtkEntry*) tmpWidget, tmpstr );

   sprintf( tmpstr, "%i", mctl->wrdelay + 1 );
   tmpWidget = lookup_widget( ramWindow, "entwrdelay" );
   gtk_entry_set_text( (GtkEntry*) tmpWidget, tmpstr );

   switch (mctl->rddelay) {
      case 0:
	 sprintf( tmpstr, "Fast" );
	 break;
      case 1:
	 sprintf( tmpstr, "Slow");
	 break;
   }
   tmpWidget = lookup_widget( ramWindow, "entrddelay" );
   gtk_entry_set_text( (GtkEntry*) tmpWidget, tmpstr );

   sprintf( tmpstr, "%i", mctl->smrdelay + 1 );
   tmpWidget = lookup_widget( ramWindow, "entsmrdelay" );
   gtk_entry_set_text( (GtkEntry*) tmpWidget, tmpstr );

   sprintf( tmpstr, "%i", mctl->bwcdelay + 1 );
   tmpWidget = lookup_widget( ramWindow, "entbwcdelay" );
   gtk_entry_set_text( (GtkEntry*) tmpWidget, tmpstr );

   sprintf( tmpstr, "%i", mctl->bpldelay + 1 );
   tmpWidget = lookup_widget( ramWindow, "entbpldelay" );
   gtk_entry_set_text( (GtkEntry*) tmpWidget, tmpstr );

   tmpWidget = lookup_widget( mainWindow, "entryO1" );
   g_free(tmpstr);

   tmpstr = gtk_entry_get_text( (GtkEntry*) tmpWidget );
   value = strtol( tmpstr, NULL, 0 );
   opt = (struct g400_option*) &value;

   tmpWidget = lookup_widget( ramWindow, "spnCounter" );
   gtk_spin_button_set_value( (GtkSpinButton*) tmpWidget, (opt->rfhcnt * 64) + 1);


   addr = getAddr();
/*   memrd = getMemrdbk( addr ); */

   printf("mrsopcod: %i\n", pmemrd->mrsopcod);
   printf("mclkbrd0: %i\n", pmemrd->mclkbrd0);
   printf("mclkbrd1: %i\n", pmemrd->mclkbrd1);

   tmpWidget = lookup_widget( ramWindow, "spnDelay0" );
   gtk_spin_button_set_value( (GtkSpinButton*) tmpWidget, (pmemrd->mclkbrd0) * 0.1);

   tmpWidget = lookup_widget( ramWindow, "spnDelay1" );
   gtk_spin_button_set_value( (GtkSpinButton*) tmpWidget, (pmemrd->mclkbrd1) * 0.1);

}

/*************************************************************/
void
on_btnRam_clicked                      (GtkButton       *button,
                                        gpointer         user_data)
{
   ramWindow = create_winRamopt();
   gtk_widget_show( ramWindow );
   updRamwin( &mctl_cur );

}

/*************************************************************/
void
on_button14_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{
   gtk_widget_destroy( ramWindow );
   ramWindow = NULL;
}

/*************************************************************/
void
on_btnMisc_clicked                     (GtkButton       *button,
                                        gpointer         user_data)
{
   struct g400_option* opt;
   WORD opt1;
   gchar* tmpstr;
   GtkWidget *tmpWidget, *winMisc;

   tmpWidget = lookup_widget( mainWindow, "entryO1" );
   tmpstr = gtk_entry_get_text( (GtkEntry*) tmpWidget );

   opt1 = strtol( tmpstr, NULL, 0 );
   opt = (struct g400_option*) &opt1;

   winMisc = create_winMisc();

   tmpWidget = lookup_widget( winMisc, "chknoretry" );
   if (opt->noretry == 0)
   {
      gtk_toggle_button_set_active( (GtkToggleButton*) tmpWidget, TRUE );
      noretry = 0;
   } else {
      gtk_toggle_button_set_active( (GtkToggleButton*) tmpWidget, FALSE );
      noretry = 1;
   }

   tmpWidget = lookup_widget( winMisc, "chkhardpwmsk" );
   if (opt->hardpwmsk == 1)
   {
      gtk_toggle_button_set_active( (GtkToggleButton*) tmpWidget, TRUE );
      hardpwmsk = 1;
   } else {
      gtk_toggle_button_set_active( (GtkToggleButton*) tmpWidget, FALSE );
      hardpwmsk = 0;
   }

   tmpWidget = lookup_widget( winMisc, "chkenhmemacc" );
   if (opt->enhmemacc == 1)
   {
      gtk_toggle_button_set_active( (GtkToggleButton*) tmpWidget, TRUE );
      enhmemacc = 1;
   } else {
      gtk_toggle_button_set_active( (GtkToggleButton*) tmpWidget, FALSE );
      enhmemacc = 0;
   }

   tmpWidget = lookup_widget( winMisc, "chknohireq" );
   if (opt->nohireq == 0)
   {
      gtk_toggle_button_set_active( (GtkToggleButton*) tmpWidget, TRUE );
      nohireq = 0;
   } else {
      gtk_toggle_button_set_active( (GtkToggleButton*) tmpWidget, FALSE );
      nohireq = 1;
   }

   gtk_widget_show( winMisc );
}

/*************************************************************/
void
on_chknoretry_toggled                  (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
   if( gtk_toggle_button_get_active( togglebutton ) ) {
      noretry = 0;
   } else
   {
      noretry = 1;
   }
}

/*************************************************************/
void
on_chkhardpwmsk_toggled                (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
   if( gtk_toggle_button_get_active( togglebutton ) ) {
      hardpwmsk = 1;
   } else
   {
      hardpwmsk = 0;
   }
}

/*************************************************************/
void
on_chkenhmemacc_toggled                (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
   if( gtk_toggle_button_get_active( togglebutton ) ) {
      enhmemacc = 1;
   } else
   {
      enhmemacc = 0;
   }
}

/*************************************************************/
void
on_chknohireq_toggled                  (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
   if( gtk_toggle_button_get_active( togglebutton ) ) {
      nohireq = 0;
   } else
   {
      nohireq = 1;
   }
}

/*************************************************************/
void
on_button17_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{
   GtkWidget* tmpWidget;
   WORD opt1;
   struct g400_option* opt;
   gchar *tmpstr, *tmpstr2;

   tmpWidget = lookup_widget( mainWindow, "entryO1" );
   tmpstr = gtk_entry_get_text( (GtkEntry*) tmpWidget );

   opt1 = strtol( tmpstr, NULL, 0 );
   opt = (struct g400_option*) &opt1;

   opt->noretry = noretry;
   opt->hardpwmsk = hardpwmsk;
   opt->enhmemacc = enhmemacc;
   opt->nohireq = nohireq;

   tmpstr2 = g_malloc(200);

   sprintf(tmpstr2, "0x%02x", opt1);

   gtk_entry_set_text( (GtkEntry*) tmpWidget, tmpstr2 );
   
   tmpWidget = lookup_widget( (GtkWidget*) button, "winMisc" );
   gtk_widget_destroy( tmpWidget );
   chkApply( mainWindow );
}

/*************************************************************/
void
on_button18_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{
   GtkWidget* tmpWidget;
   tmpWidget = lookup_widget( (GtkWidget*) button, "winMisc" );
   gtk_widget_destroy( tmpWidget );
}

/*************************************************************/
void
on_btnRamApply_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
   GtkWidget* tmpWidget;
   WORD memrd;
   struct memrdbk* pmemrd = (struct memrdbk*) &memrd;
   unsigned long addr;
   float value;

   addr = getAddr();
/*   memrd = getMemrdbk( addr ); */

   tmpWidget = lookup_widget( ramWindow, "spnDelay0" );
   value = gtk_spin_button_get_value_as_float( (GtkSpinButton*) tmpWidget ) * 10;
   pmemrd->mclkbrd0 = (WORD) value;

   tmpWidget = lookup_widget( ramWindow, "spnDelay1" );
   value = gtk_spin_button_get_value_as_float( (GtkSpinButton*) tmpWidget ) * 10;
   pmemrd->mclkbrd1 = (WORD) value;

/*   storeMemrdbk( memrd, addr ); */

/*   updRamwin( &mctl_cur ); */
}

