/*
 * Copyright (C) 2000-2010  Innocent De Marchi
 * email: tangram.peces@gmail.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#include <QtGui>
#include <QDesktopServices>

#include "configuracio.h"
#include "funcions.h"
 class QSettings;

Configuracio::Configuracio(){
charPathSeparator=QDir().separator();

configArxiu=new QSettings(QSettings::IniFormat, QSettings::UserScope,"De Marchi", "Peces");

arxiuTraduccio=new QSettings(arxiuLocale(),QSettings::IniFormat);

  tipusTangram=0;
  nivellJoc=0;
  colocaPeca=false;
  desaRecords=true;

  canviaTipusTangram(configArxiu->value("joc/tipusTangram",TIPUS_TANGRAM_T7_CLASSIC).toInt());
  canviaNivellJoc(configArxiu->value("joc/nivellJoc",NIVELL_INICIAT).toInt());


  //Comprovam si s'ha registrat l'aplicació
  if (configArxiu->value("joc/registre",0).toInt()==0){
     if(registraAplicacio()){
       configArxiu->setValue("joc/registre",1);
     };
  }
}

/*
Tradueix la cadena passada
*/
QString Configuracio::tradueixCadena(QString cadena){
//configArxiu->setValue("cadenes/"+cadena,1);
 //tot aquest follón per a què surtin els accents!!!
 QByteArray strArray = arxiuTraduccio->value(cadena,cadena).toString().toLatin1();
 const char *strCadena = strArray.data();
 return QString::fromUtf8(strCadena);
}

/*
Retorna l'arxiu de traducció adequat
*/
QString Configuracio::arxiuLocale(){
  QString locale = strLocale();
  QDir dirArxiu;
  QString nomArxiu=directoriLinux(); //QCoreApplication::applicationDirPath();
 nomArxiu.append(charPathSeparator);
 nomArxiu.append("locales");
 nomArxiu.append(charPathSeparator);
 nomArxiu.append("locale_");
 nomArxiu.append(locale);
 nomArxiu.append(".lo");


 if (dirArxiu.exists(nomArxiu)){     
     configArxiu->setValue("joc/idioma",locale);
     return nomArxiu;
 }
 else {
     configArxiu->setValue("joc/idioma","en");
     return directoriLinux()+
                     charPathSeparator+"locales"+charPathSeparator+"locale_en.lo";
 }
}

/*
Retorna les lletres del locale
*/
QString Configuracio::strLocale(){
    return configArxiu->value("joc/idioma",QLocale::system().name().mid(0,2)).toString();
}

void Configuracio::canviaArxiuLocale(QString strLocale){
QDir dirArxiu;
 QString nomArxiu=directoriLinux(); //QCoreApplication::applicationDirPath();
 nomArxiu.append(charPathSeparator);
 nomArxiu.append("locales");
 nomArxiu.append(charPathSeparator);
 nomArxiu.append("locale_");
 nomArxiu.append(strLocale);
 nomArxiu.append(".lo");


 if (dirArxiu.exists(nomArxiu)){
     arxiuTraduccio=new QSettings(nomArxiu,QSettings::IniFormat);
     configArxiu->setValue("joc/idioma",strLocale);
 }
 else {
     arxiuTraduccio=new QSettings(directoriLinux()+
                     charPathSeparator+"locales"+charPathSeparator+"locale_en.lo",QSettings::IniFormat);     
     configArxiu->setValue("joc/idioma","en");
 }
}


void Configuracio::carregaPuntuacio(){
  //Carregam la puntuació anterior
  temps=configArxiu->value(QString("%1-%2/temps").arg(tipusTangram).arg(nivellJoc),"00:00:00").toString();
  comptadorFigures=configArxiu->value(QString("%1-%2/numFig").arg(tipusTangram).arg(nivellJoc),0).toInt();
  comptadorPunts=configArxiu->value(QString("%1-%2/punts").arg(tipusTangram).arg(nivellJoc),0).toInt();
}

void Configuracio::desaPuntuacio(QString pTemps){
  if (pTemps=="00:00:00"){
      configArxiu->remove(QString("%1-%2").arg(tipusTangram).arg(nivellJoc));
  }
  else if (desaRecords){
  temps=pTemps;
  configArxiu->setValue(QString("%1-%2/temps").arg(tipusTangram).arg(nivellJoc),pTemps);
  configArxiu->setValue(QString("%1-%2/numFig").arg(tipusTangram).arg(nivellJoc),comptadorFigures);
  configArxiu->setValue(QString("%1-%2/punts").arg(tipusTangram).arg(nivellJoc),comptadorPunts);
  }
}


/**
     * Canvia el tipus de tangram segons el paràmetre passat
     * @param tipusQSettings
     */
   void Configuracio::canviaTipusTangram(int tipus){
    if (tipus!=tipusTangram){
    tipusTangram=tipus;
    configArxiu->setValue("joc/tipusTangram", tipusTangram);
    carregaPuntuacio();
          switch(tipusTangram){
              case TIPUS_TANGRAM_T7_CLASSIC:
                  arxiuDadesFigures=NOM_ARXIU_TRANGRAM_CLASSIC;
                  nomJocArbreFigures=ARBRE_FIGURES_TANGRAM_7;
                  nomIcone=T7_ICONE;
                  break;
              case TIPUS_TANGRAM_T4:
                  arxiuDadesFigures=NOM_ARXIU_TRANGRAM_4;
                  nomJocArbreFigures=ARBRE_FIGURES_TANGRAM_4;
                  nomIcone=T4_ICONE;
                  break;
              case TIPUS_TANGRAM_T4II:
                  arxiuDadesFigures=NOM_ARXIU_TRANGRAM_4II;
                  nomJocArbreFigures=ARBRE_FIGURES_TANGRAM_4II;
                  nomIcone=T4II_ICONE;
                  break;
              case TIPUS_TANGRAM_T5:
                  arxiuDadesFigures=NOM_ARXIU_TRANGRAM_5;
                  nomJocArbreFigures=ARBRE_FIGURES_TANGRAM_5;
                  nomIcone=T5_ICONE;
                  break;
              case TIPUS_TANGRAM_TSL:
                  arxiuDadesFigures=NOM_ARXIU_TRANGRAM_SL;
                  nomJocArbreFigures=ARBRE_FIGURES_TANGRAM_SL;
                  nomIcone=TSL_ICONE;
                  break;
              case TIPUS_TANGRAM_TREGULUS:
                  arxiuDadesFigures=NOM_ARXIU_TRANGRAM_REGULUS;
                  nomJocArbreFigures=ARBRE_FIGURES_TANGRAM_REGULUS;
                  nomIcone=TREG_ICONE;
                  break;
              case TIPUS_TANGRAM_T6:
                  arxiuDadesFigures=NOM_ARXIU_TRANGRAM_6;
                  nomJocArbreFigures=ARBRE_FIGURES_TANGRAM_6;
                  nomIcone=T6_ICONE;
                  break;
              case TIPUS_TANGRAM_T6II:
                  arxiuDadesFigures=NOM_ARXIU_TRANGRAM_6II;
                  nomJocArbreFigures=ARBRE_FIGURES_TANGRAM_6II;
                  nomIcone=T6II_ICONE;
                  break;
              case TIPUS_TANGRAM_T7I:
                  arxiuDadesFigures=NOM_ARXIU_TRANGRAM_7I;
                  nomJocArbreFigures=ARBRE_FIGURES_TANGRAM_7I;
                  nomIcone=T7I_ICONE;
                  break;
              case TIPUS_TANGRAM_T7II:
                  arxiuDadesFigures=NOM_ARXIU_TRANGRAM_7II;
                  nomJocArbreFigures=ARBRE_FIGURES_TANGRAM_7II;
                  nomIcone=T7II_ICONE;
                  break;
              case TIPUS_TANGRAM_TF:
                  arxiuDadesFigures=NOM_ARXIU_TRANGRAM_F;
                  nomJocArbreFigures=ARBRE_FIGURES_TANGRAM_F;
                  nomIcone=TF_ICONE;
                  break;
              case TIPUS_TANGRAM_THEP:
                  arxiuDadesFigures=NOM_ARXIU_TRANGRAM_HEP;
                  nomJocArbreFigures=ARBRE_FIGURES_TANGRAM_HEP;
                  nomIcone=THEP_ICONE;
                  break;
              case TIPUS_TANGRAM_TX:
                  arxiuDadesFigures=NOM_ARXIU_TRANGRAM_X;
                  nomJocArbreFigures=ARBRE_FIGURES_TANGRAM_X;
                  nomIcone=TX_ICONE;
                  break;
              case TIPUS_TANGRAM_TS:
                  arxiuDadesFigures=NOM_ARXIU_TRANGRAM_S;
                  nomJocArbreFigures=ARBRE_FIGURES_TANGRAM_S;
                  nomIcone=TS_ICONE;
                  break;
              case TIPUS_TANGRAM_T8:
                  arxiuDadesFigures=NOM_ARXIU_TRANGRAM_8;
                  nomJocArbreFigures=ARBRE_FIGURES_TANGRAM_8;
                  nomIcone=T8_ICONE;
                  break;
              case TIPUS_TANGRAM_TCII:
                  arxiuDadesFigures=NOM_ARXIU_TRANGRAM_CII;
                  nomJocArbreFigures=ARBRE_FIGURES_TANGRAM_CII;
                  nomIcone=TCII_ICONE;
                  break;
              case TIPUS_TANGRAM_T9:
                  arxiuDadesFigures=NOM_ARXIU_TRANGRAM_9;
                  nomJocArbreFigures=ARBRE_FIGURES_TANGRAM_9;
                  nomIcone=T9_ICONE;
                  break;
              case TIPUS_TANGRAM_T9T:
                  arxiuDadesFigures=NOM_ARXIU_TRANGRAM_9T;
                  nomJocArbreFigures=ARBRE_FIGURES_TANGRAM_9T;
                  nomIcone=T9T_ICONE;
                  break;
              case TIPUS_TANGRAM_T10:
                  arxiuDadesFigures=NOM_ARXIU_TRANGRAM_10;
                  nomJocArbreFigures=ARBRE_FIGURES_TANGRAM_10;
                  nomIcone=T10_ICONE;
                  break;
              case TIPUS_TANGRAM_TE:
                  arxiuDadesFigures=NOM_ARXIU_TRANGRAM_E;
                  nomJocArbreFigures=ARBRE_FIGURES_TANGRAM_E;
                  nomIcone=TE_ICONE;
                  break;
              case TIPUS_TANGRAM_EL:
                  arxiuDadesFigures=NOM_ARXIU_TRANGRAM_EL;
                  nomJocArbreFigures=ARBRE_FIGURES_TANGRAM_EL;
                  nomIcone=EL_ICONE;
                  break;
              case TIPUS_TANGRAM_TCIRI:
                  arxiuDadesFigures=NOM_ARXIU_TRANGRAM_CIRI;
                  nomJocArbreFigures=ARBRE_FIGURES_TANGRAM_CIRI;
                  nomIcone=TCIRI_ICONE;
                  break;
              case TIPUS_TANGRAM_T11:
                  arxiuDadesFigures=NOM_ARXIU_TRANGRAM_11;
                  nomJocArbreFigures=ARBRE_FIGURES_TANGRAM_11;
                  nomIcone=T11_ICONE;
                  break;
              case TIPUS_TANGRAM_TR:
                  arxiuDadesFigures=NOM_ARXIU_TRANGRAM_R;
                  nomJocArbreFigures=ARBRE_FIGURES_TANGRAM_R;
                  nomIcone=TR_ICONE;
                  break;
              case TIPUS_TANGRAM_T13:
                  arxiuDadesFigures=NOM_ARXIU_TRANGRAM_13;
                  nomJocArbreFigures=ARBRE_FIGURES_TANGRAM_13;
                  nomIcone=T13_ICONE;
                  break;
              case TIPUS_TANGRAM_T14:
                  arxiuDadesFigures=NOM_ARXIU_TRANGRAM_14;
                  nomJocArbreFigures=ARBRE_FIGURES_TANGRAM_14;
                  nomIcone=T14_ICONE;
                  break;
              case TIPUS_TANGRAM_TB:
                  arxiuDadesFigures=NOM_ARXIU_TRANGRAM_B;
                  nomJocArbreFigures=ARBRE_FIGURES_TANGRAM_B;
                  nomIcone=TB_ICONE;
                  break;
              case TIPUS_TANGRAM_TH:
                  arxiuDadesFigures=NOM_ARXIU_TRANGRAM_H;
                  nomJocArbreFigures=ARBRE_FIGURES_TANGRAM_H;
                  nomIcone=TH_ICONE;
                  break;
              case TIPUS_TANGRAM_TOU:
                  arxiuDadesFigures=NOM_ARXIU_TRANGRAM_OU;
                  nomJocArbreFigures=ARBRE_FIGURES_TANGRAM_OU;
                  nomIcone=TOU_ICONE;
                  break;
              case TIPUS_TANGRAM_COR:
                  arxiuDadesFigures=NOM_ARXIU_TRANGRAM_COR;
                  nomJocArbreFigures=ARBRE_FIGURES_TANGRAM_COR;
                  nomIcone=TCOR_ICONE;
                  break;
              case TIPUS_TANGRAM_STOMACH:
                  arxiuDadesFigures=NOM_ARXIU_TRANGRAM_STOMACH;
                  nomJocArbreFigures=ARBRE_FIGURES_TANGRAM_STOMACH;
                  nomIcone=TSTIII_ICONE;
                  break;
              case TIPUS_TANGRAM_STOMACHION:
                  arxiuDadesFigures=NOM_ARXIU_TRANGRAM_STOMACHION;
                  nomJocArbreFigures=ARBRE_FIGURES_TANGRAM_STOMACHION;
                  nomIcone=TST_ICONE;
                  break;
              case TIPUS_TANGRAM_STOMACHION_II:
                  arxiuDadesFigures=NOM_ARXIU_TRANGRAM_STOMACHION_II;
                  nomJocArbreFigures=ARBRE_FIGURES_TANGRAM_STOMACHION_II;
                  nomIcone=TSTII_ICONE;
                  break;
             default:
                  arxiuDadesFigures=NOM_ARXIU_TRANGRAM_CLASSIC;
                  nomJocArbreFigures=ARBRE_FIGURES_TANGRAM_7;
                  nomIcone=T7_ICONE;
                  break;
          }
//cal assegurar que l'angle de gir de les peces és correcte
actualitzaAngleGir();

      directoriArxiuDadesFigures=directoriLinux()+
                     charPathSeparator+"figures"+charPathSeparator+arxiuDadesFigures;
      }

   }//finals Configuracio::canviaTipusTangram

/**
    * Canvia el nivell de joc al parametre passat
    * @param nivell
    */
    void Configuracio::canviaNivellJoc(int nivell){
    if (nivell!=nivellJoc){
    nivellJoc=nivell;
    configArxiu->setValue("joc/nivellJoc", nivellJoc);
    carregaPuntuacio();
    switch(nivellJoc){
            case NIVELL_INFANTIL:
                mostraSilueta=true;
                nomNivellArbreFigures=NOM_NIVELL_INFANTIL;
                break;
            case NIVELL_PRINCIPIANT:
                mostraSilueta=true;
                nomNivellArbreFigures=NOM_NIVELL_PRINCIPIANT;
                break;
            case NIVELL_INICIAT:
                //Això s'ha canviat respecte a les versions
                //anteriors.
                //Ara en el nivell iniciat, la rotació és lliure
                angleGir=ROTACIO_EXPERT;
                mostraSilueta=true;
                nomNivellArbreFigures=NOM_NIVELL_INICIAT;
                break;
            case NIVELL_EXPERT:
                angleGir=ROTACIO_EXPERT;
                mostraSilueta=false;
                nomNivellArbreFigures=NOM_NIVELL_EXPERT;
                break;
            default:
                nivellJoc=NIVELL_PRINCIPIANT;
                angleGir=ROTACIO_PRINCIPIANT;
                mostraSilueta=true;
                nomNivellArbreFigures=NOM_NIVELL_PRINCIPIANT;
        }
      }
    actualitzaAngleGir();
    }//final de Configuracio::canviaNivellJoc

/*
      Actualitza la propietat angleGirPeca
    */
void Configuracio::actualitzaAngleGir(){
switch(nivellJoc){
  case NIVELL_INFANTIL:
    angleGir=ROTACIO_INFANTIL;
    //algunes figures d'aquests tangrams
    //necessiten això per poder obtenir
    //totes les posicions
    if (tipusTangram==TIPUS_TANGRAM_T10
        || tipusTangram==TIPUS_TANGRAM_T11
        || tipusTangram==TIPUS_TANGRAM_T9
        || tipusTangram==TIPUS_TANGRAM_TH
        || tipusTangram==TIPUS_TANGRAM_T7I
        || tipusTangram==TIPUS_TANGRAM_TCII ){
        angleGir=ROTACIO_INICIAT;
    }
    if (tipusTangram==TIPUS_TANGRAM_STOMACHION
        || tipusTangram==TIPUS_TANGRAM_STOMACHION_II
        || tipusTangram==TIPUS_TANGRAM_STOMACH
        || tipusTangram==TIPUS_TANGRAM_T9T ){
        angleGir=ROTACIO_INICIAT_2;
    }

    if (tipusTangram==TIPUS_TANGRAM_TSL
        || tipusTangram==TIPUS_TANGRAM_TE
        || tipusTangram==TIPUS_TANGRAM_TB
        || tipusTangram==TIPUS_TANGRAM_TCIRI ){
        angleGir=ROTACIO_SAM_LLOYD;
    }
    break;
 case NIVELL_PRINCIPIANT:
    angleGir=ROTACIO_PRINCIPIANT;
    if (tipusTangram==TIPUS_TANGRAM_T10
        || tipusTangram==TIPUS_TANGRAM_T11
        || tipusTangram==TIPUS_TANGRAM_T9
        || tipusTangram==TIPUS_TANGRAM_T9T
        || tipusTangram==TIPUS_TANGRAM_TH
        || tipusTangram==TIPUS_TANGRAM_T7I
        || tipusTangram==TIPUS_TANGRAM_TCII ){
        angleGir=ROTACIO_INICIAT;
    }
    if (tipusTangram==TIPUS_TANGRAM_STOMACHION
        || tipusTangram==TIPUS_TANGRAM_STOMACHION_II
        || tipusTangram==TIPUS_TANGRAM_STOMACH
        || tipusTangram==TIPUS_TANGRAM_T9T
        || tipusTangram==TIPUS_TANGRAM_TCIRI  ){
        angleGir=ROTACIO_INICIAT_2;
    }
    if (tipusTangram==TIPUS_TANGRAM_TSL
        || tipusTangram==TIPUS_TANGRAM_TE
        || tipusTangram==TIPUS_TANGRAM_TB){
        angleGir=ROTACIO_SAM_LLOYD;
    }
    break;
case NIVELL_INICIAT:
    //Això s'ha canviat respecte a les versions
    //anteriors.
    //Ara en el nivell iniciat, la rotació és lliure
    angleGir=ROTACIO_EXPERT;
    /*
                if (tipusTangram==TIPUS_TANGRAM_T10
                    || tipusTangram==TIPUS_TANGRAM_T11
                    || tipusTangram==TIPUS_TANGRAM_T9
                    || tipusTangram==TIPUS_TANGRAM_TH
                    || tipusTangram==TIPUS_TANGRAM_STOMACHION){
                  angleGir=ROTACIO_INICIAT_2;
                }
                */
    break;
case NIVELL_EXPERT:
    angleGir=ROTACIO_EXPERT;
    break;
default:
    angleGir=ROTACIO_PRINCIPIANT;
}
}
/*
 Mostra la pàgina web de "registre" de l'aplicació
 */
 bool Configuracio::registraAplicacio(){
   return QDesktopServices::openUrl(ADRECA_WEB_REGISTRE);
  }
