(let ((newplugin (glame_plugin_define (let* ((net (filter-new))
	(extend (filter-add-node net (filter-new (plugin_get "extend")) "extend"))
	(mix (filter-add-node net (filter-new (plugin_get "mix")) "mix"))
	(one2n (filter-add-node net (filter-new (plugin_get "one2n")) "one2n"))
	(delay (filter-add-node net (filter-new (plugin_get "delay")) "delay"))
	(volume-adjust (filter-add-node net (filter-new (plugin_get "volume_adjust")) "volume-adjust")))
   (let ((param (call-with-current-continuation
                  (lambda (return)
                    (map (lambda (param)
                           (if (string=? (param-label param) "time")
	                        (return param)))
	                  (filter-params extend))))))
     (param-set! param 600.000000)
     (set-property! param "_desc" "extend time in ms"))
   (set-property! extend "canvas_y" "5.000000")
   (set-property! extend "canvas_x" "-265.000000")
   (let ((param (call-with-current-continuation
                  (lambda (return)
                    (map (lambda (param)
                           (if (string=? (param-label param) "position")
	                        (return param)))
	                  (filter-params mix))))))
     (param-set! param 0.000000))
   (let ((param (call-with-current-continuation
                  (lambda (return)
                    (map (lambda (param)
                           (if (string=? (param-label param) "gain")
	                        (return param)))
	                  (filter-params mix))))))
     (param-set! param 1.000000))
   (set-property! mix "canvas_y" "18.000000")
   (set-property! mix "canvas_x" "-96.000000")
   (set-property! one2n "canvas_y" "18.000000")
   (set-property! one2n "canvas_x" "161.000000")
   (let ((param (call-with-current-continuation
                  (lambda (return)
                    (map (lambda (param)
                           (if (string=? (param-label param) "delay")
	                        (return param)))
	                  (filter-params delay))))))
     (param-set! param 200.000000))
   (set-property! delay "canvas_y" "142.000000")
   (set-property! delay "canvas_x" "161.000000")
   (let ((param (call-with-current-continuation
                  (lambda (return)
                    (map (lambda (param)
                           (if (string=? (param-label param) "factor")
	                        (return param)))
	                  (filter-params volume-adjust))))))
     (param-set! param 0.700000))
   (set-property! volume-adjust "canvas_y" "125.000000")
   (set-property! volume-adjust "canvas_x" "-96.000000")
   (filternetwork_add_input net extend "in" "in" "echo source")
   (filternetwork_add_param net extend "time" "extend" "time to extend")
   (filternetwork_add_param net mix "gain" "gain" "output gain")
   (filternetwork_add_output net one2n "out" "out" "source with echo")
   (filternetwork_add_param net delay "delay" "delay" "echo delay")
   (filternetwork_add_param net volume-adjust "factor" "mix" "echo mix ratio")
   (let ((pipe (filter-connect extend "out" mix "in")))
	(filterpipe_set_destparam pipe "gain" 1.000000)
	(filterpipe_set_destparam pipe "offset" 0.000000)
	#t)
   (let ((pipe (filter-connect mix "out" one2n "in")))
	#t)
   (let ((pipe (filter-connect one2n "out" delay "in")))
	#t)
   (let ((pipe (filter-connect delay "out" volume-adjust "in")))
	#t)
   (let ((pipe (filter-connect volume-adjust "out" mix "in")))
	(filterpipe_set_destparam pipe "gain" 1.000000)
	(filterpipe_set_destparam pipe "offset" 0.000000)
	#t)
   net)
 "echo2")
)) (if (filter? newplugin) newplugin 
	(begin
		(plugin_set newplugin PLUGIN_PIXMAP "echo.png")
		(plugin_set newplugin PLUGIN_LABEL "Echo (network)")
		(plugin_set newplugin PLUGIN_DESCRIPTION "echo effect")
		(plugin_set newplugin PLUGIN_CATEGORY "Effects"))))
