// $Id: scale.cc,v 1.22 2001/10/11 14:07:24 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *  Copyright (C) 1999-2000 Adolf Petig GmbH & Co. KG, written by Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "range.hh"

class Gtk_Scale : public Gtk_Range
{public:
	typedef Gtk_Range Parent;
	virtual const std::string TypeName(const Widget &w) const;
	virtual const std::string IncludeName(const Widget &w) const;
	Gtk_Scale();
	virtual void Configure(const Widget &w, CxxFile &f,const std::string &instance) const;
	// we use Parent's ConstructionArgs
};

static Gtk_Scale Gtk_Scale;

const std::string Gtk_Scale::TypeName(const Widget &w) const
{  return GtkPrefix()+(w.Class()[3]=='H' ?"HScale":"VScale");
}

const std::string Gtk_Scale::IncludeName(const Widget &w) const
{  return "gtk--/scale.h";
}

Gtk_Scale::Gtk_Scale()
{  Writer["GtkHScale"]=this;
   Writer["GtkVScale"]=this;
}

void Gtk_Scale::Configure(const Widget &w, CxxFile &f,const std::string &instance) const
{  Parent::Configure(w,f,instance);
   int digits=w.getInt("digits",0);
   f.Statement() << instance << "set_digits(" << digits << ')';
   bool draw_value=w.getInt("draw_value",true);
   f.Statement() << instance << "set_draw_value(" << PRINT_BOOL(draw_value) << ')';
   std::string value_pos=w.getString("value_pos","GTK_POS_TOP");
   f.Statement() << instance << "set_value_pos(" << value_pos << ')';
}
