// $Id: radiobutton.cc,v 1.23 2001/12/27 12:29:14 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *  Copyright (C) 1999-2000 Adolf Petig GmbH & Co. KG, written by Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "checkbutton.hh"
#include <Cxx_Fileset.hh>

class Gtk_RadioButton : public Gtk_CheckButton
{public:
	typedef Gtk_CheckButton Parent;
	virtual const std::string TypeName(const Widget &w) const;
	virtual const std::string IncludeName(const Widget &w) const;
	Gtk_RadioButton();
	virtual bool CantMemberConstruct(const Widget &w) const
	{ return true; }
	virtual void ConstructionArgs(const Widget &w, CxxFile &f) const;
	virtual bool NeedExplicitCtor(const Widget &w) const
	{ return true; }
	virtual void CreatePointer(const Widget &w,CxxFile &f) const;
};

static Gtk_RadioButton Gtk_RadioButton;

const std::string Gtk_RadioButton::TypeName(const Widget &w) const
{  return GtkPrefix()+"RadioButton";
}

const std::string Gtk_RadioButton::IncludeName(const Widget &w) const
{  return "gtk--/radiobutton.h";
}

Gtk_RadioButton::Gtk_RadioButton()
{  Writer["GtkRadioButton"]=this;
}

void Gtk_RadioButton::ConstructionArgs(const Widget &w, CxxFile &f) const
{  f.FunctionArg();
   f << "_RadioBGroup_" << Configuration.InstanceName(w.getString("group"));
   if (w.hasTag("label"))
      f.FunctionArg() << Configuration.Translatable(w.getString("label"));
}

void Gtk_RadioButton::CreatePointer(const Widget &w,CxxFile &f) const
{  if (Cxx_Fileset::NeedToDeclareRadioGroup("B:"+w.getString("group","")))
      f.Declaration() << "Gtk::RadioButton::Group _RadioBGroup_" 
		<< Configuration.InstanceName(w.getString("group",""));
   Parent::CreatePointer(w,f);
}
