// $Id: menuitem.cc,v 1.25 2001/10/11 14:07:24 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *  Copyright (C) 1999-2000 Adolf Petig GmbH & Co. KG, written by Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "menuitem.hh"

static Gtk_MenuItem Gtk_MenuItem(false);

const std::string Gtk_MenuItem::TypeName(const Widget &w) const
{  return GtkPrefix()+"MenuItem";
}

const std::string Gtk_MenuItem::IncludeName(const Widget &w) const
{  return "gtk--/list.h";
}

Gtk_MenuItem::Gtk_MenuItem(bool base_class_init)
{  if (!base_class_init) Writer["GtkMenuItem"]=this;
}

void Gtk_MenuItem::ConstructionArgs(const Widget &w, CxxFile &f) const
{  f.FunctionArg(); 
   if(w.hasTag("label"))
      f << Configuration.Translatable(w.getString("label"));
}

bool Gtk_MenuItem::NeedExplicitCtor(const Widget &w) const
{  return w.hasTag("label"); }

void Gtk_MenuItem::AddChild(const Widget &w,CxxFile &f,const std::string &instance) const
{
  // Parent's AddChild() (i.e. the one for Menu/MenuBar) also adds menu 
  // item children.
}

void Gtk_MenuItem::CreatePointer(const Widget &w, CxxFile &f) const
{
  /* Note: We only declare necessary variables and initialise to NULL,
           Gtk_Menu::AddChild creates the actual widget. */
  if (w.getString("cxx_visibility","private")=="private" && CanBeManaged(w))
     f.Declaration() << TypeName(w) << " *";
   else
     f.Statement();

  f << Configuration.InstanceName(w.Name());
  f.Assignment() << "NULL";
  f.EndLine();
  
  if(CanBeManaged(w))
    w.markManaged();
  
  CreatePointer_Toplevel(w,f);
 }
