// $Id: gnome_propertybox.cc,v 1.4 2001/10/11 14:07:24 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 2001 Adolf Petig GmbH & Co. KG, written by Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "gnome_dialog.hh"

class Gnome_PropertyBox : public Gnome_Dialog
{public:
	typedef Gnome_Dialog Parent;
	virtual const std::string TypeName(const Widget &w) const;
	virtual const std::string IncludeName(const Widget &w) const;
	Gnome_PropertyBox();
	virtual void Configure(const Widget &w, CxxFile &f,const std::string &instance) const;
	virtual void ConstructionArgs(const Widget &w, CxxFile &f) const 
	{ f.FunctionArg(); }
	virtual bool NeedExplicitCtor(const Widget &w) const
	{ return false; }
	virtual Subwidget IsSubwidget(const Widget &w,const Widget &ch) const;
	virtual void AddChildren(const Widget &w,CxxFile &f,const std::string &instance) const;
	virtual const std::string SignalHandlerArgs(const Widget &w,const std::string &signal,std::string &rettype) const;
};

static Gnome_PropertyBox Gnome_PropertyBox;

const std::string Gnome_PropertyBox::TypeName(const Widget &w) const
{  return GnomePrefix()+"PropertyBox";
}

const std::string Gnome_PropertyBox::IncludeName(const Widget &w) const
{  return "gnome--/propertybox.h";
}

Gnome_PropertyBox::Gnome_PropertyBox()
{  Writer["GnomePropertyBox"]=this;
}

void Gnome_PropertyBox::Configure(const Widget &w, CxxFile &f,const std::string &instance) const
{  Parent::Configure(w,f,instance);
   if (w.begin()==w.end()) return; 
   const Widget w2(*(w.begin()));
   assert(w2.ChildName()=="GnomePropertyBox:notebook");
   // at creation time?
   f.Declaration() << GtkPrefix() << "Notebook *" 
	<< Configuration.InstanceName(w2.Name());
   f.Assignment() << "Gtk::wrap((GtkNotebook*)GNOME_PROPERTY_BOX("
   	<< instance << "gtkobj())->notebook)";
   LookupWriter("GtkNotebook").Configure(w2,f,Configuration.InstanceName(w2.Name())+"->");
}

Subwidget Gnome_PropertyBox::IsSubwidget(const Widget &w,const Widget &ch) const
{  if (ch.ChildName()=="GnomePropertyBox:notebook") return is_Subwidget_only;
   return not_Subwidget;
}

void Gnome_PropertyBox::AddChildren(const Widget &w,CxxFile &f,const std::string &instance) const
{  if (w.begin()==w.end()) return;
   const Widget w2(*(w.begin()));
   assert(w2.ChildName()=="GnomePropertyBox:notebook");

// this is a copy of notebooks algo
   Widget::const_iterator label=w2.begin();
   Widget::const_iterator i=w2.begin();
   for (;i!=w2.end() && label!=w2.end();++i,++label)
   {  while (i!=w2.end() && (*i).hasTag("child_name")) ++i;
      if (i==w2.end()) 
      {  std::cerr << w2.Name() << ": more tabs than widgets, omitting tabs\n";
         break;
      }
      while (label!=w2.end() && !(*label).hasTag("child_name")) ++label;
      if (label==w2.end()) 
      {  std::cerr << w2.Name() << ": more widgets than tabs, omitting widgets\n";
         break;
      }
      if ((*i).Class()=="Placeholder")
      {  std::cerr << w2.Name() << ": empty pages are not yet supported.\n"
      		"\tPlease add an empty label in the page\n";
      	 exit(20);
      }
      f.Statement() << instance << "append_page(" 
           << Reference(*i) << ", " << Reference(*label) << ")";
   }
}

const std::string Gnome_PropertyBox::SignalHandlerArgs(const Widget &w,const std::string &signal,std::string &rettype) const
{  if (signal=="apply" || signal=="help") return "";
   return Parent::SignalHandlerArgs(w,signal,rettype);
}

