// $Id: gnome_app.cc,v 1.6 2001/10/11 14:07:24 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1999 Rick L. Vinyard, Jr.
 *  Copyright (C) 2000 Adolf Petig GmbH & Co. KG (gettext support)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "gnome_app.hh"

static Gnome_App Gnome_App(false);

const std::string Gnome_App::TypeName(const Widget &w) const
{  return GnomePrefix()+"App";
}

const std::string Gnome_App::IncludeName(const Widget &w) const
{  return "gnome--/app.h";
}

Gnome_App::Gnome_App(bool base_class_init)
{  if (!base_class_init) Writer["GnomeApp"]=this;
}

void Gnome_App::ConstructionArgs(const Widget &w, CxxFile &f) const
{
  f.FunctionArg() << Configuration.CString_WithQuotes(Configuration.InstanceName(w.Name()));
  f.FunctionArg() << Configuration.Translatable(w.getString("label"));
}

bool Gnome_App::NeedExplicitCtor(const Widget &w) const
{  return true;
}

void Gnome_App::Configure(const Widget &w, CxxFile &f,const std::string &instance) const
{  Parent::Configure(w,f,instance);
}

