// $Id: clist.cc,v 1.28 2001/11/05 15:28:20 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *  Copyright (C) 1999-2000  Adolf Petig GmbH & Co. KG, written by Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "clist.hh"
#include "../strsep.h"

static Gtk_CList Gtk_CList(false);

const std::string Gtk_CList::TypeName(const Widget &w) const
{  return GtkPrefix()+"CList";
}

const std::string Gtk_CList::IncludeName(const Widget &w) const
{  return "gtk--/clist.h";
}

Gtk_CList::Gtk_CList(bool base_class_init)
{  if (!base_class_init) Writer["GtkCList"]=this;
}

void Gtk_CList::ConstructionArgs(const Widget &w, CxxFile &f) const
{  f.FunctionArg() << w.getInt("columns",3);
           // 2do: look for columns and pass them ???
}

void Gtk_CList::Configure(const Widget &w, CxxFile &f,const std::string &instance) const
{  Parent::Configure(w,f,instance);
   std::string selection_mode=w.getString("selection_mode","GTK_SELECTION_SINGLE");
   bool show_titles=w.getBool("show_titles",true);
   std::string shadow_type=w.getString("shadow_type","GTK_SHADOW_IN");
   std::string hscrollbar_policy=w.getString("hscrollbar_policy","GTK_POLICY_AUTOMATIC");
   std::string vscrollbar_policy=w.getString("vscrollbar_policy","GTK_POLICY_AUTOMATIC");
   std::string column_widths=w.getString("column_widths","20");
   char *buffer=(char*)alloca(column_widths.size()+1);
   memcpy(buffer,column_widths.c_str(),column_widths.size()+1);
   char *stringp=buffer;
   // 2do: Tooltips
      
   int i=0;
   for (Widget::const_iterator ch=w.begin();ch!=w.end();++ch,++i)
   {  char *token=strsep(&stringp,",");
      int column_width=!token?20:atoi(token);
      if ((*ch).Class()=="GtkLabel")
      {  std::string label=(*ch).getString("label","");
         if (label!="")
            f.Statement() << instance << "set_column_title(" << i << ", " 
              	<< Configuration.Translatable(label) << ')';
         std::string justify=(*ch).getString("justify","GTK_JUSTIFY_LEFT");
         if (justify!="GTK_JUSTIFY_LEFT")
            f.Statement() << instance << "set_column_justification(" << i << ", "
              << justify << ')';
         f.Statement() << instance << "set_column_width(" << i << ", " << column_width << ')';
      }
      else
         std::cerr << "Gtk_CList::Configure: can't handle widget class "
              << (*ch).Class() << " as title\n";
   }
   if (selection_mode!="GTK_SELECTION_SINGLE")
      f.Statement() << instance << "set_selection_mode(" << selection_mode << ')';
   if (show_titles)
      f.Statement() << instance << "column_titles_show()";
}

Subwidget Gtk_CList::IsSubwidget(const Widget &parent,const Widget &w2) const
{  if (w2.ChildName()=="CList:title" && w2.Class()=="GtkLabel") return is_Subwidget_all;
//	&& w2.getString("cxx_visibility","private")=="private") 
   return not_Subwidget;
}

#if 0
bool Gtk_CList::SampleCode(CxxFile &f,const Widget &w,enum WriterType::CodePosition pos,const std::string misc)
{  switch(pos)
   {  case WriterType::ContainingConstructor:
         {  int cols=w.getInt("columns",3);
            int width=w.getInt("width",100);
            if (!cols) return false;
            f << "\tconst gchar * const data_" << Configuration.InstanceName(w.Name()) << "[]=\n\t{ ";
            for (int i=0;i<cols;i++)
   	       f << (i?", ":"") << '"' << i << '"';
   	    f << " };\n"
   	      << "\t" << Configuration.InstanceName(w.Name()) 
   	      << "->" << "append((gchar**)data_"
   	      << Configuration.InstanceName(w.Name()) << ");\n";
   	    if (!w.hasTag("column_widths"))
   	       f << "\tfor (int i=0;i<" << cols << ";++i)\n\t\t"
   	         << Configuration.InstanceName(w.Name()) << "->" 
   	         << "set_column_width(i,"
   	         << width/cols << ");\n";
   	 }
   	 break;
      default: break;
   }
   return false;
}
#endif

const std::string Gtk_CList::SignalHandlerArgs(const Widget &w,const std::string &signal,std::string &rettype) const
{  if (signal=="select_row" || signal=="unselect_row") 
      return "gint row, gint column, GdkEvent *event";
   else if (signal=="resize_column")
      return "gint column, gint width";
   else if (signal=="extend_selection")
      return "GtkScrollType scroll_type, gfloat position, gboolean auto_start_selection";
   else if (signal=="scroll_horizontal" || signal=="scroll_vertical")
      return "GtkScrollType scroll_type, gfloat position";
   else if (signal=="resync_selection")
      return "GdkEvent *event";
   else if (signal=="row_move")
      return "gint source_row, gint dest_row";
   else if (signal=="click_column")
      return "gint column";
   return Parent::SignalHandlerArgs(w,signal,rettype);
}

const std::string Gtk_CList::InternalInstance(const Widget &parent,const Widget &w2) const
{
#warning Fixme for non standard column headers (internal widgets)
   return Parent::InternalInstance(parent,w2);
}
