 /* GKrellM
|  Copyright (C) 1999-2004 Bill Wilson
|
|  Author:  Bill Wilson    bill@gkrellm.net
|  Latest versions might be found at:  http://gkrellm.net
|
|  Windows code: Bill Nalen bill@nalens.com
|
|  This program is free software which I release under the GNU General Public
|  License. You may redistribute and/or modify this program under the terms
|  of that license as published by the Free Software Foundation; either
|  version 2 of the License, or (at your option) any later version.
|
|  This program is distributed in the hope that it will be useful,
|  but WITHOUT ANY WARRANTY; without even the implied warranty of
|  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
|  GNU General Public License for more details.  Version 2 is in the
|  COPYRIGHT file in the top level directory of this distribution.
| 
|  To get a copy of the GNU General Puplic License, write to the Free Software
|  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <io.h>
#include <direct.h>
#include <sys/utime.h>
#include <winsock2.h>
#include <gdk/gdkwin32.h>

#if defined(WIN32) && defined(_WINDOWS) && !defined(WIN32_CLIENT)
    extern int notDone;
    void setupServerWindow(HINSTANCE hInstance);
#endif

#define snprintf _snprintf
#define random rand
#define pclose _pclose
#define popen _popen
#define strcasecmp g_strcasecmp
#define strtoull strtoul

#define SIGPIPE 13
#define SIGQUIT 3
#define W_OK 2
#define O_NONBLOCK 0x4000
#define mode_t unsigned int
typedef time_t __time_t;

#define socklen_t unsigned int
#define AI_PASSIVE 0x0001

//int getpid();
int getuid();
void fcntl(int fd, int cmd, ...);
void fchmod(int fd, mode_t mode);

// from utime.h
/* Structure describing file times.  */
//struct utimbuf
//  {
//    __time_t actime;		/* Access time.  */
//    __time_t modtime;		/* Modification time.  */
//  };


// from bits/fcntl.h
#define F_SETFL 4

// from bits/stat.h
#define	__S_IFREG	0100000	/* Regular file.  */
#define	__S_IFMT	0170000	/* These bits determine file type.  */

// from sys/stat.h
#define	__S_ISTYPE(mode, mask)	(((mode) & __S_IFMT) == (mask))
#define	S_ISREG(mode)	 __S_ISTYPE((mode), __S_IFREG)
#define S_ISLNK(mode)  0

// from bluebox for slit messages
#define BM_SLITMESSAGE	WM_USER + 0xF00D
#define BSM_UPDATEPOSITIONS		0x0001	// causes Slit to update the position of all contained items and itself.
#define BSM_REPAINT				0x0002
#define BSM_ADDWINDOW			0x0003  // lparam = hwnd
#define BSM_DELETEWINDOW		0x0004  // lparam = hwnd
#define BSM_ISVERTICAL			0x0005	// sendmessage returns 0 if horizontal, 1 if vertical
// these wparams for BM_SLITMESSAGE are sent to slit apps from the slit.
#define BSA_CLOSESLITAPP		0x1000 
#define BSA_REPAINT				0x2000
#define BSA_ENTEREDSLIT			0x3000
#define BSA_EXITEDSLIT			0x4000
#define BSA_CLOSE				0x5000

