/*
 *  
 *  $Id: wzoom.cpp 4504 2012-01-11 07:46:45Z tovar $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#include <api/globals.h>
#include "wzoom.h"
#include <main/managers/widgetsmanager.h>
#include <vtkgl.h>
#include <api/westilo.h>
#include <cmath>

//region "Implementacion de WZoomBuilder"
#include <api/icontexto.h>

GNC::GCS::Widgets::WZoomBuilder::WZoomBuilder(TWidgetsManager* pManager, GNC::GCS::ToolHandlers::IZoomHandler* pObserver, const GNC::GCS::TriggerButton& buttonMask, long gid) : GNC::GCS::Widgets::IWidgetBuilder(pManager, buttonMask, gid)
{
	m_pObserver = pObserver;
	m_MouseDown = false;
	m_Estado = WBS_Ninguno;
	m_Dentro = true;
}

GNC::GCS::Widgets::WZoomBuilder::~WZoomBuilder()
{
}

void GNC::GCS::Widgets::WZoomBuilder::OnMouseEvents(GNC::GCS::Eventos::EventoRaton& evento)
{
	
	if (!m_pManager) {
		return;
	}
	if (m_MouseDown && evento.ButtonUp(m_ButtonMask)) {
		m_MouseDown = false;
		if (m_Estado != WBS_Creando) {
			m_Estado = WBS_Ninguno;
			return;
		}
		m_Estado = WBS_Ninguno;

		m_pManager->Modificado();
		ConsumirEvento();
	}
	else if (evento.ButtonDown(m_ButtonMask)) {
		if (m_Estado != WBS_Ninguno) {
			return;
		}
		m_MouseDown = true;
		
		m_Start = evento.sY;
		m_Stop = m_Start;		
		
		//m_pManager->Modificado();
		
		m_Estado = WBS_Creando;
		evento.Skip(false);
	}
	else if (evento.Dragging() && m_MouseDown) {
		if (m_Estado != WBS_Creando) {
			return;
		}
		
		m_Stop = evento.sY;
		
		double delta = (m_Start - m_Stop) / 1.0;
		
		int steps = 0;
		if (delta != 0.0) {
			if (delta > 0.0)  {
				steps = (int)std::floor(delta);
			}
			else {
				steps = (int)std::ceil(delta);
			}
			if (steps != 0) {
				m_Start = evento.sY;
				m_pObserver->ChangeZoom(steps);
			}
		}
		
		evento.Skip(false);
	}
	else if( evento.Moving() ){
		m_NodoMoviendose = evento.iP;
		m_Estado = WBS_Ninguno;
	}

}

void GNC::GCS::Widgets::WZoomBuilder::OnKeyEvents(TEventoTeclado&)
{

}

void GNC::GCS::Widgets::WZoomBuilder::Render(GNC::GCS::Contexto3D* /*c*/)
{
}

GNC::GCS::Widgets::TipoCursor GNC::GCS::Widgets::WZoomBuilder::GetCursor()
{
	return GNC::GCS::Widgets::CUR_LUPA;
}

//endregion
