/* giFTui
 * Copyright (C) 2003 the giFTui team
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifndef __GTK_CELL_RENDERER_PROGRESS_H__
#define __GTK_CELL_RENDERER_PROGRESS_H__

#include <gtk/gtk.h>

#define GTK_TYPE_CELL_RENDERER_PROGRESS (gtk_cell_renderer_progress_get_type ())
#define GTK_CELL_RENDERER_PROGRESS(obj)	(G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_CELL_RENDERER_PROGRESS, GtkCellRendererProgress))
#define GTK_CELL_RENDERER_PROGRESS_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST ((klass), GTK_TYPE_CELL_RENDERER_PROGRESS, GtkCellRendererProgressClass))
#define GTK_IS_CELL_RENDERER_PROGRESS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_CELL_RENDERER_PROGRESS))
#define GTK_IS_CELL_RENDERER_PROGRESS_CLASS(obj) (G_TYPE_CHECK_CLASS_TYPE ((obj), GTK_TYPE_CELL_RENDERER_PROGRESS))
#define GTK_CELL_RENDERER_PROGRESS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_CELL_RENDERER_PROGRESS, GtkCellRendererProgressClass))

typedef struct _GtkCellRendererProgress GtkCellRendererProgress;
typedef struct _GtkCellRendererProgressClass GtkCellRendererProgressClass;

struct _GtkCellRendererProgress
{
	GtkCellRenderer parent_instance;
	
	/* < private > */
	gfloat value;
	gfloat value_start;
	
	PangoFontDescription *font;
	gdouble font_scale;
	PangoColor foreground;
	PangoColor background;
	
	GdkColor *progressground;
	GdkColor progressground_active;
	GdkColor progressground_completed;
	GdkColor progressground_paused;
	GdkColor progressground_canceled;
	
	PangoAttrList *extra_attrs;
	
	PangoUnderline underline_style;
		
	gint rise;
	gint fixed_height_rows;
	
	gboolean strikethrough : 1;
	
	gboolean scale_set : 1;
	
	gboolean foreground_set : 1;
	gboolean background_set : 1;
	
	gboolean progressground_set : 1;
	
	gboolean underline_set : 1;
	
	gboolean rise_set : 1;
	
	gboolean strikethrough_set : 1;
	
	gboolean editable_set : 1;
	gboolean calc_fixed_height : 1;
};

struct _GtkCellRendererProgressClass
{
	GtkCellRendererClass parent_class;
};

typedef enum
{
	GTK_CELL_RENDERER_PROGRESS_ACTIVE,
	GTK_CELL_RENDERER_PROGRESS_COMPLETED,
	GTK_CELL_RENDERER_PROGRESS_PAUSED,
	GTK_CELL_RENDERER_PROGRESS_CANCELED
} GtkCellRendererProgressColor;

GType gtk_cell_renderer_progress_get_type (void);
GtkCellRenderer *gtk_cell_renderer_progress_new (void);

#endif
