#!/bin/sh

MODULEPATH="/usr/share/giarpfanoa"
FUNCTIONPATH="/usr/share/giarpfanoa"
CONFIGFILES="$HOME/.giarpfanoa.cf /etc/giarpfanoa/giarpfanoa.conf"
# Reverse order, last is used first.
NEEDMODS="-prep- -clean-"
# Things needed by functions and modules.
IFGREP="grep -q --"
SED="sed -e"
N="[0-9][0-9]*"
H="[A-Fa-f0-9][A-Fa-f0-9]*"
C="[\.:]"

FUNCFILES=
for G in $FUNCTIONPATH ; do
    FUNCFILES="$FUNCFILES "$(ls $G/*.func 2>/dev/null)
done

FUNCFILES=$(echo "$FUNCFILES" | $SED "s/^[[:space:]]*$//;")
if [ -z "$FUNCFILES" ] ; then
    echo "No functions to load. Is there some problem with the FUNCTIONPATH?"
    exit 1
fi
for F in $FUNCFILES ; do
    if [ -r $F ] ; then
	. $F
    fi
done

pre_parse_args $*

for TMPC in $CONFIGFILES ; do
    if [ -r "$TMPC" ] ; then
	. $TMPC
    fi
done

parse_args $*

if [ -z "$MODULES" ] ; then
    for G in $MODULEPATH ; do
	MODULES="$MODULES "$(ls $G/*.mod 2>/dev/null \
	    | $SED 's|.*/||;s/\.mod$//;')
    done
fi
for NEED in $NEEDMODS ; do
    if ! echo "$MODULES" | $IFGREP "$NEED" ; then
	for G in $MODULEPATH ; do
	    MODULES=$(ls $G/*$NEED*.mod 2>/dev/null \
		| $SED 's|.*/||;s/\.mod$//;')" $MODULES"
	done
    fi
done

for TARGET in $TARGETS ; do
    for M in $MODULES ; do
	TLOAD=
	for G in $MODULEPATH ; do
	    if [ -z "$TLOAD" -a -r "$G/$M.mod" ] ; then
		. $G/$M.mod
		TLOAD=1
	    fi
	done
	if [ -z "$TLOAD" ] ; then
	    echo "Unable to load module $M."
	fi
    done
done
