module GDITypes
{-  -- still incomplete
	( POINT,        marshall_point, unmarshall_point
	, ListPOINT,    marshall_ListPOINT_
	, ListLenPOINT, marshall_ListLenPOINT_
	, RECT,         marshall_rect, unmarshall_rect
	, SIZE,         marshall_size, unmarshall_size
	, nullAddr
	, HBITMAP	, MbHBITMAP
	, HFONT		, MbHFONT
	, HCURSOR	, MbHCURSOR
	, HICON		, MbHICON
	, HRGN		, MbHRGN
	, HPALETTE	, MbHPALETTE
	, HBRUSH	, MbHBRUSH
	, HPEN		, MbHPEN
	, HACCEL	--, MbHACCEL
	, HDC		, MbHDC
	, HDWP          , MbHDWP
	, HWND		, MbHWND
	, HMENU		, MbHMENU
	, PolyFillMode
	, ArcDirection
	, MbArcDirection
	, GraphicsMode
	, MbGraphicsMode
	, BackgroundMode
	, HatchStyle
	, StretchBltMode
	, COLORREF
	, TextAlignment
	, ClippingMode
	, RegionType
	)
-}
	where

import StdDIS
import Win32Types
import Monad( zipWithM_ )
import IOExts
import Foreign


----------------------------------------------------------------
--
----------------------------------------------------------------

type POINT =
  ( LONG  -- x
  , LONG  -- y
  )
type RECT =
  ( LONG  -- left
  , LONG  -- top
  , LONG  -- right
  , LONG  -- bottom
  )
type SIZE =
  ( LONG  -- cx
  , LONG  -- cy
  )


----------------------------------------------------------------


marshall_listPOINT_ :: [POINT] -> IO Addr
marshall_listPOINT_ cs = do
  let l = length cs
  ps <- mallocPOINTs l
  zipWithM_ (setPOINT ps) [0..] cs
  return ps

marshall_listLenPOINT_ :: [POINT] -> IO (Addr, Int)
marshall_listLenPOINT_ cs = do
  let l = length cs
  ps <- mallocPOINTs l
  zipWithM_ (setPOINT ps) [0..] cs
  return (ps,l)
  
mallocPOINTs :: Int -> IO Addr
mallocPOINTs arg1 =
  prim_mallocPOINTs arg1
  >>= \ gc_result ->
  access_prim_mallocPOINTs_ps (gc_result :: Addr) >>= \ ps ->
  access_prim_mallocPOINTs_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_mallocPOINTs_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (ps))
foreign import  ccall unsafe "GDITypes_stub_ffi.h prim_mallocPOINTs" prim_mallocPOINTs :: Int -> IO (Addr)
foreign import ccall unsafe "access_prim_mallocPOINTs_ps" access_prim_mallocPOINTs_ps :: Addr -> IO (Addr)
foreign import ccall unsafe "access_prim_mallocPOINTs_gc_failed" access_prim_mallocPOINTs_gc_failed :: Addr -> IO (Int)
foreign import ccall unsafe "access_prim_mallocPOINTs_gc_failstring" access_prim_mallocPOINTs_gc_failstring :: Addr -> IO (Addr)

setPOINT :: Addr -> Int -> POINT -> IO ()
setPOINT ps i gc_arg1 =
  case gc_arg1 of { (gc_arg2,gc_arg3) ->
  prim_setPOINT ps i gc_arg2 gc_arg3}
foreign import  ccall unsafe "GDITypes_stub_ffi.h prim_setPOINT" prim_setPOINT :: Addr -> Int -> Int32 -> Int32 -> IO ()

type   LPRECT   = Addr
type MbLPRECT   = Maybe LPRECT

getRECT :: LPRECT -> IO RECT
getRECT r =
  prim_getRECT r
  >>= \ gc_result ->
  access_prim_getRECT_gc_res1 (gc_result :: Addr) >>= \ gc_res1 ->
  access_prim_getRECT_gc_res2 (gc_result :: Addr) >>= \ gc_res2 ->
  access_prim_getRECT_gc_res3 (gc_result :: Addr) >>= \ gc_res3 ->
  access_prim_getRECT_gc_res4 (gc_result :: Addr) >>= \ gc_res4 ->
  (return ((gc_res1,gc_res2,gc_res3,gc_res4)))
foreign import  ccall unsafe "GDITypes_stub_ffi.h prim_getRECT" prim_getRECT :: Addr -> IO (Addr)
foreign import ccall unsafe "access_prim_getRECT_gc_res1" access_prim_getRECT_gc_res1 :: Addr -> IO (Int32)
foreign import ccall unsafe "access_prim_getRECT_gc_res2" access_prim_getRECT_gc_res2 :: Addr -> IO (Int32)
foreign import ccall unsafe "access_prim_getRECT_gc_res3" access_prim_getRECT_gc_res3 :: Addr -> IO (Int32)
foreign import ccall unsafe "access_prim_getRECT_gc_res4" access_prim_getRECT_gc_res4 :: Addr -> IO (Int32)

----------------------------------------------------------------
-- (GDI related) Handles
----------------------------------------------------------------

type   HBITMAP    = Addr
type MbHBITMAP    = Maybe HBITMAP

type   HFONT      = Addr
type MbHFONT      = Maybe HFONT

type   HCURSOR    = Addr
type MbHCURSOR    = Maybe HCURSOR

type   HICON      = Addr
type MbHICON      = Maybe HICON


-- This is not the only handle / resource that should be
-- finalised for you, but it's a start.
-- ToDo.

type   HRGN       = ForeignObj
type MbHRGN       = Maybe HRGN

type   HPALETTE   = Addr
type MbHPALETTE   = Maybe HPALETTE

type   HBRUSH     = Addr
type MbHBRUSH     = Maybe HBRUSH

type   HPEN       = Addr
type MbHPEN       = Maybe HPEN

type   HACCEL     = Addr

type   HDC        = Addr
type MbHDC        = Maybe HDC

type   HDWP        = Addr
type MbHDWP        = Maybe HDWP

type   HWND       = Addr
type MbHWND       = Maybe HWND

hWND_BOTTOM :: HWND
hWND_BOTTOM =
  unsafePerformIO(
    prim_hWND_BOTTOM
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "GDITypes_stub_ffi.h prim_hWND_BOTTOM" prim_hWND_BOTTOM :: IO (Addr)
hWND_NOTOPMOST :: HWND
hWND_NOTOPMOST =
  unsafePerformIO(
    prim_hWND_NOTOPMOST
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "GDITypes_stub_ffi.h prim_hWND_NOTOPMOST" prim_hWND_NOTOPMOST :: IO (Addr)
hWND_TOP :: HWND
hWND_TOP =
  unsafePerformIO(
    prim_hWND_TOP
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "GDITypes_stub_ffi.h prim_hWND_TOP" prim_hWND_TOP :: IO (Addr)
hWND_TOPMOST :: HWND
hWND_TOPMOST =
  unsafePerformIO(
    prim_hWND_TOPMOST
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "GDITypes_stub_ffi.h prim_hWND_TOPMOST" prim_hWND_TOPMOST :: IO (Addr)

type   HMENU      = Addr
type MbHMENU      = Maybe HMENU

----------------------------------------------------------------
-- COLORREF
----------------------------------------------------------------

type COLORREF   = DWORD

rgb :: BYTE -> BYTE -> BYTE -> COLORREF
rgb arg1 arg2 arg3 =
  unsafePerformIO(
    prim_rgb arg1 arg2 arg3
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "GDITypes_stub_ffi.h prim_rgb" prim_rgb :: Word8 -> Word8 -> Word8 -> IO (Word32)

getRValue :: COLORREF -> BYTE
getRValue arg1 =
  unsafePerformIO(
    prim_getRValue arg1
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "GDITypes_stub_ffi.h prim_getRValue" prim_getRValue :: Word32 -> IO (Word8)
getGValue :: COLORREF -> BYTE
getGValue arg1 =
  unsafePerformIO(
    prim_getGValue arg1
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "GDITypes_stub_ffi.h prim_getGValue" prim_getGValue :: Word32 -> IO (Word8)
getBValue :: COLORREF -> BYTE
getBValue arg1 =
  unsafePerformIO(
    prim_getBValue arg1
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "GDITypes_stub_ffi.h prim_getBValue" prim_getBValue :: Word32 -> IO (Word8)

----------------------------------------------------------------
-- Miscellaneous enumerations
----------------------------------------------------------------

type PolyFillMode   = WORD
aLTERNATE :: PolyFillMode
aLTERNATE =
  unsafePerformIO(
    prim_aLTERNATE
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "GDITypes_stub_ffi.h prim_aLTERNATE" prim_aLTERNATE :: IO (Word16)
wINDING :: PolyFillMode
wINDING =
  unsafePerformIO(
    prim_wINDING
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "GDITypes_stub_ffi.h prim_wINDING" prim_wINDING :: IO (Word16)

----------------------------------------------------------------

type ArcDirection = WORD
type MbArcDirection = Maybe ArcDirection
aD_COUNTERCLOCKWISE :: ArcDirection
aD_COUNTERCLOCKWISE =
  unsafePerformIO(
    prim_aD_COUNTERCLOCKWISE
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "GDITypes_stub_ffi.h prim_aD_COUNTERCLOCKWISE" prim_aD_COUNTERCLOCKWISE :: IO (Word16)
aD_CLOCKWISE :: ArcDirection
aD_CLOCKWISE =
  unsafePerformIO(
    prim_aD_CLOCKWISE
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "GDITypes_stub_ffi.h prim_aD_CLOCKWISE" prim_aD_CLOCKWISE :: IO (Word16)

----------------------------------------------------------------

type GraphicsMode   = DWORD
type MbGraphicsMode = Maybe GraphicsMode
gM_COMPATIBLE :: GraphicsMode
gM_COMPATIBLE =
  unsafePerformIO(
    prim_gM_COMPATIBLE
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "GDITypes_stub_ffi.h prim_gM_COMPATIBLE" prim_gM_COMPATIBLE :: IO (Word32)
gM_ADVANCED :: GraphicsMode
gM_ADVANCED =
  unsafePerformIO(
    prim_gM_ADVANCED
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "GDITypes_stub_ffi.h prim_gM_ADVANCED" prim_gM_ADVANCED :: IO (Word32)

----------------------------------------------------------------

type BackgroundMode   = UINT
tRANSPARENT :: BackgroundMode
tRANSPARENT =
  unsafePerformIO(
    prim_tRANSPARENT
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "GDITypes_stub_ffi.h prim_tRANSPARENT" prim_tRANSPARENT :: IO (Word32)
oPAQUE :: BackgroundMode
oPAQUE =
  unsafePerformIO(
    prim_oPAQUE
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "GDITypes_stub_ffi.h prim_oPAQUE" prim_oPAQUE :: IO (Word32)

----------------------------------------------------------------

type HatchStyle   = WORD

hS_HORIZONTAL :: HatchStyle
hS_HORIZONTAL =
  unsafePerformIO(
    prim_hS_HORIZONTAL
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "GDITypes_stub_ffi.h prim_hS_HORIZONTAL" prim_hS_HORIZONTAL :: IO (Word16)
hS_VERTICAL :: HatchStyle
hS_VERTICAL =
  unsafePerformIO(
    prim_hS_VERTICAL
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "GDITypes_stub_ffi.h prim_hS_VERTICAL" prim_hS_VERTICAL :: IO (Word16)
hS_FDIAGONAL :: HatchStyle
hS_FDIAGONAL =
  unsafePerformIO(
    prim_hS_FDIAGONAL
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "GDITypes_stub_ffi.h prim_hS_FDIAGONAL" prim_hS_FDIAGONAL :: IO (Word16)
hS_BDIAGONAL :: HatchStyle
hS_BDIAGONAL =
  unsafePerformIO(
    prim_hS_BDIAGONAL
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "GDITypes_stub_ffi.h prim_hS_BDIAGONAL" prim_hS_BDIAGONAL :: IO (Word16)
hS_CROSS :: HatchStyle
hS_CROSS =
  unsafePerformIO(
    prim_hS_CROSS
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "GDITypes_stub_ffi.h prim_hS_CROSS" prim_hS_CROSS :: IO (Word16)
hS_DIAGCROSS :: HatchStyle
hS_DIAGCROSS =
  unsafePerformIO(
    prim_hS_DIAGCROSS
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "GDITypes_stub_ffi.h prim_hS_DIAGCROSS" prim_hS_DIAGCROSS :: IO (Word16)

----------------------------------------------------------------

type StretchBltMode   = UINT

bLACKONWHITE :: StretchBltMode
bLACKONWHITE =
  unsafePerformIO(
    prim_bLACKONWHITE
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "GDITypes_stub_ffi.h prim_bLACKONWHITE" prim_bLACKONWHITE :: IO (Word32)
wHITEONBLACK :: StretchBltMode
wHITEONBLACK =
  unsafePerformIO(
    prim_wHITEONBLACK
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "GDITypes_stub_ffi.h prim_wHITEONBLACK" prim_wHITEONBLACK :: IO (Word32)
cOLORONCOLOR :: StretchBltMode
cOLORONCOLOR =
  unsafePerformIO(
    prim_cOLORONCOLOR
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "GDITypes_stub_ffi.h prim_cOLORONCOLOR" prim_cOLORONCOLOR :: IO (Word32)
hALFTONE :: StretchBltMode
hALFTONE =
  unsafePerformIO(
    prim_hALFTONE
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "GDITypes_stub_ffi.h prim_hALFTONE" prim_hALFTONE :: IO (Word32)
sTRETCH_ANDSCANS :: StretchBltMode
sTRETCH_ANDSCANS =
  unsafePerformIO(
    prim_sTRETCH_ANDSCANS
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "GDITypes_stub_ffi.h prim_sTRETCH_ANDSCANS" prim_sTRETCH_ANDSCANS :: IO (Word32)
sTRETCH_ORSCANS :: StretchBltMode
sTRETCH_ORSCANS =
  unsafePerformIO(
    prim_sTRETCH_ORSCANS
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "GDITypes_stub_ffi.h prim_sTRETCH_ORSCANS" prim_sTRETCH_ORSCANS :: IO (Word32)
sTRETCH_DELETESCANS :: StretchBltMode
sTRETCH_DELETESCANS =
  unsafePerformIO(
    prim_sTRETCH_DELETESCANS
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "GDITypes_stub_ffi.h prim_sTRETCH_DELETESCANS" prim_sTRETCH_DELETESCANS :: IO (Word32)

----------------------------------------------------------------

type TextAlignment   = UINT

tA_NOUPDATECP :: TextAlignment
tA_NOUPDATECP =
  unsafePerformIO(
    prim_tA_NOUPDATECP
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "GDITypes_stub_ffi.h prim_tA_NOUPDATECP" prim_tA_NOUPDATECP :: IO (Word32)
tA_UPDATECP :: TextAlignment
tA_UPDATECP =
  unsafePerformIO(
    prim_tA_UPDATECP
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "GDITypes_stub_ffi.h prim_tA_UPDATECP" prim_tA_UPDATECP :: IO (Word32)
tA_LEFT :: TextAlignment
tA_LEFT =
  unsafePerformIO(
    prim_tA_LEFT
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "GDITypes_stub_ffi.h prim_tA_LEFT" prim_tA_LEFT :: IO (Word32)
tA_RIGHT :: TextAlignment
tA_RIGHT =
  unsafePerformIO(
    prim_tA_RIGHT
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "GDITypes_stub_ffi.h prim_tA_RIGHT" prim_tA_RIGHT :: IO (Word32)
tA_CENTER :: TextAlignment
tA_CENTER =
  unsafePerformIO(
    prim_tA_CENTER
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "GDITypes_stub_ffi.h prim_tA_CENTER" prim_tA_CENTER :: IO (Word32)
tA_TOP :: TextAlignment
tA_TOP =
  unsafePerformIO(
    prim_tA_TOP
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "GDITypes_stub_ffi.h prim_tA_TOP" prim_tA_TOP :: IO (Word32)
tA_BOTTOM :: TextAlignment
tA_BOTTOM =
  unsafePerformIO(
    prim_tA_BOTTOM
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "GDITypes_stub_ffi.h prim_tA_BOTTOM" prim_tA_BOTTOM :: IO (Word32)
tA_BASELINE :: TextAlignment
tA_BASELINE =
  unsafePerformIO(
    prim_tA_BASELINE
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "GDITypes_stub_ffi.h prim_tA_BASELINE" prim_tA_BASELINE :: IO (Word32)

----------------------------------------------------------------

type ClippingMode   = UINT

rGN_AND :: ClippingMode
rGN_AND =
  unsafePerformIO(
    prim_rGN_AND
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "GDITypes_stub_ffi.h prim_rGN_AND" prim_rGN_AND :: IO (Word32)
rGN_OR :: ClippingMode
rGN_OR =
  unsafePerformIO(
    prim_rGN_OR
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "GDITypes_stub_ffi.h prim_rGN_OR" prim_rGN_OR :: IO (Word32)
rGN_XOR :: ClippingMode
rGN_XOR =
  unsafePerformIO(
    prim_rGN_XOR
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "GDITypes_stub_ffi.h prim_rGN_XOR" prim_rGN_XOR :: IO (Word32)
rGN_DIFF :: ClippingMode
rGN_DIFF =
  unsafePerformIO(
    prim_rGN_DIFF
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "GDITypes_stub_ffi.h prim_rGN_DIFF" prim_rGN_DIFF :: IO (Word32)
rGN_COPY :: ClippingMode
rGN_COPY =
  unsafePerformIO(
    prim_rGN_COPY
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "GDITypes_stub_ffi.h prim_rGN_COPY" prim_rGN_COPY :: IO (Word32)

----------------------------------------------------------------

type RegionType   = WORD

eRROR :: RegionType
eRROR =
  unsafePerformIO(
    prim_eRROR
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "GDITypes_stub_ffi.h prim_eRROR" prim_eRROR :: IO (Word16)
nULLREGION :: RegionType
nULLREGION =
  unsafePerformIO(
    prim_nULLREGION
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "GDITypes_stub_ffi.h prim_nULLREGION" prim_nULLREGION :: IO (Word16)
sIMPLEREGION :: RegionType
sIMPLEREGION =
  unsafePerformIO(
    prim_sIMPLEREGION
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "GDITypes_stub_ffi.h prim_sIMPLEREGION" prim_sIMPLEREGION :: IO (Word16)
cOMPLEXREGION :: RegionType
cOMPLEXREGION =
  unsafePerformIO(
    prim_cOMPLEXREGION
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall unsafe "GDITypes_stub_ffi.h prim_cOMPLEXREGION" prim_cOMPLEXREGION :: IO (Word16)

----------------------------------------------------------------
-- End
----------------------------------------------------------------
