{-# OPTIONS -#include <windows.h> #-}
{-# OPTIONS -#include "errors.h" #-}
{-# OPTIONS -#include "win32debug.h" #-}
{-# OPTIONS -#include "finalizers.h" #-}
{-# OPTIONS -#include "Win32Clip_stub_ffi.h" #-}
module Win32Clip where

import StdDIS
import Win32Types
import GDITypes
import Win32WinMessage


type ClipboardFormat = UINT

cF_BITMAP :: ClipboardFormat
cF_BITMAP =
  unsafePerformIO(
    prim_cF_BITMAP
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_cF_BITMAP" unsafe prim_cF_BITMAP :: IO (Word32)
cF_DIB :: ClipboardFormat
cF_DIB =
  unsafePerformIO(
    prim_cF_DIB
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_cF_DIB" unsafe prim_cF_DIB :: IO (Word32)
cF_DIF :: ClipboardFormat
cF_DIF =
  unsafePerformIO(
    prim_cF_DIF
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_cF_DIF" unsafe prim_cF_DIF :: IO (Word32)
cF_DSPBITMAP :: ClipboardFormat
cF_DSPBITMAP =
  unsafePerformIO(
    prim_cF_DSPBITMAP
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_cF_DSPBITMAP" unsafe prim_cF_DSPBITMAP :: IO (Word32)
cF_DSPENHMETAFILE :: ClipboardFormat
cF_DSPENHMETAFILE =
  unsafePerformIO(
    prim_cF_DSPENHMETAFILE
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_cF_DSPENHMETAFILE" unsafe prim_cF_DSPENHMETAFILE :: IO (Word32)
cF_DSPMETAFILEPICT :: ClipboardFormat
cF_DSPMETAFILEPICT =
  unsafePerformIO(
    prim_cF_DSPMETAFILEPICT
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_cF_DSPMETAFILEPICT" unsafe prim_cF_DSPMETAFILEPICT :: IO (Word32)
cF_DSPTEXT :: ClipboardFormat
cF_DSPTEXT =
  unsafePerformIO(
    prim_cF_DSPTEXT
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_cF_DSPTEXT" unsafe prim_cF_DSPTEXT :: IO (Word32)
cF_ENHMETAFILE :: ClipboardFormat
cF_ENHMETAFILE =
  unsafePerformIO(
    prim_cF_ENHMETAFILE
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_cF_ENHMETAFILE" unsafe prim_cF_ENHMETAFILE :: IO (Word32)
cF_GDIOBJFIRST :: ClipboardFormat
cF_GDIOBJFIRST =
  unsafePerformIO(
    prim_cF_GDIOBJFIRST
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_cF_GDIOBJFIRST" unsafe prim_cF_GDIOBJFIRST :: IO (Word32)
cF_HDROP :: ClipboardFormat
cF_HDROP =
  unsafePerformIO(
    prim_cF_HDROP
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_cF_HDROP" unsafe prim_cF_HDROP :: IO (Word32)
cF_LOCALE :: ClipboardFormat
cF_LOCALE =
  unsafePerformIO(
    prim_cF_LOCALE
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_cF_LOCALE" unsafe prim_cF_LOCALE :: IO (Word32)
cF_METAFILEPICT :: ClipboardFormat
cF_METAFILEPICT =
  unsafePerformIO(
    prim_cF_METAFILEPICT
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_cF_METAFILEPICT" unsafe prim_cF_METAFILEPICT :: IO (Word32)
cF_OEMTEXT :: ClipboardFormat
cF_OEMTEXT =
  unsafePerformIO(
    prim_cF_OEMTEXT
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_cF_OEMTEXT" unsafe prim_cF_OEMTEXT :: IO (Word32)
cF_OWNERDISPLAY :: ClipboardFormat
cF_OWNERDISPLAY =
  unsafePerformIO(
    prim_cF_OWNERDISPLAY
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_cF_OWNERDISPLAY" unsafe prim_cF_OWNERDISPLAY :: IO (Word32)
cF_PALETTE :: ClipboardFormat
cF_PALETTE =
  unsafePerformIO(
    prim_cF_PALETTE
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_cF_PALETTE" unsafe prim_cF_PALETTE :: IO (Word32)
cF_PENDATA :: ClipboardFormat
cF_PENDATA =
  unsafePerformIO(
    prim_cF_PENDATA
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_cF_PENDATA" unsafe prim_cF_PENDATA :: IO (Word32)
cF_PRIVATEFIRST :: ClipboardFormat
cF_PRIVATEFIRST =
  unsafePerformIO(
    prim_cF_PRIVATEFIRST
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_cF_PRIVATEFIRST" unsafe prim_cF_PRIVATEFIRST :: IO (Word32)
cF_PRIVATELAST :: ClipboardFormat
cF_PRIVATELAST =
  unsafePerformIO(
    prim_cF_PRIVATELAST
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_cF_PRIVATELAST" unsafe prim_cF_PRIVATELAST :: IO (Word32)
cF_RIFF :: ClipboardFormat
cF_RIFF =
  unsafePerformIO(
    prim_cF_RIFF
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_cF_RIFF" unsafe prim_cF_RIFF :: IO (Word32)
cF_SYLK :: ClipboardFormat
cF_SYLK =
  unsafePerformIO(
    prim_cF_SYLK
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_cF_SYLK" unsafe prim_cF_SYLK :: IO (Word32)
cF_TEXT :: ClipboardFormat
cF_TEXT =
  unsafePerformIO(
    prim_cF_TEXT
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_cF_TEXT" unsafe prim_cF_TEXT :: IO (Word32)
cF_WAVE :: ClipboardFormat
cF_WAVE =
  unsafePerformIO(
    prim_cF_WAVE
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_cF_WAVE" unsafe prim_cF_WAVE :: IO (Word32)
cF_TIFF :: ClipboardFormat
cF_TIFF =
  unsafePerformIO(
    prim_cF_TIFF
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_cF_TIFF" unsafe prim_cF_TIFF :: IO (Word32)

-- % , CF_UNICODETEXT  -- WinNT only

changeClipboardChain :: HWND -> HWND -> IO Bool
changeClipboardChain arg1 arg2 =
  prim_changeClipboardChain arg1 arg2
  >>= \  res1  ->
  (unmarshall_bool_ res1) >>= \ gc_res1 ->
  (return (gc_res1))
foreign import  ccall "prim_changeClipboardChain" unsafe prim_changeClipboardChain :: Addr -> Addr -> IO (Int)

closeClipboard :: IO ()
closeClipboard =
  prim_closeClipboard
  >>= \ gc_result ->
  access_prim_closeClipboard_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_closeClipboard_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (()))
foreign import  ccall "prim_closeClipboard" unsafe prim_closeClipboard :: IO (Addr)
foreign import ccall "access_prim_closeClipboard_gc_failed" unsafe access_prim_closeClipboard_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_closeClipboard_gc_failstring" unsafe access_prim_closeClipboard_gc_failstring :: Addr -> IO (Addr)

countClipboardFormats :: IO Int
countClipboardFormats =
  prim_countClipboardFormats
  >>= \  res1  ->
  (return (res1))
foreign import  ccall "prim_countClipboardFormats" unsafe prim_countClipboardFormats :: IO (Int)

emptyClipboard :: IO ()
emptyClipboard =
  prim_emptyClipboard
  >>= \ gc_result ->
  access_prim_emptyClipboard_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_emptyClipboard_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (()))
foreign import  ccall "prim_emptyClipboard" unsafe prim_emptyClipboard :: IO (Addr)
foreign import ccall "access_prim_emptyClipboard_gc_failed" unsafe access_prim_emptyClipboard_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_emptyClipboard_gc_failstring" unsafe access_prim_emptyClipboard_gc_failstring :: Addr -> IO (Addr)

enumClipboardFormats :: UINT -> IO UINT
enumClipboardFormats arg1 =
  prim_enumClipboardFormats arg1
  >>= \ gc_result ->
  access_prim_enumClipboardFormats_res1 (gc_result :: Addr) >>= \ res1 ->
  access_prim_enumClipboardFormats_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_enumClipboardFormats_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (res1))
foreign import  ccall "prim_enumClipboardFormats" unsafe prim_enumClipboardFormats :: Word32 -> IO (Addr)
foreign import ccall "access_prim_enumClipboardFormats_res1" unsafe access_prim_enumClipboardFormats_res1 :: Addr -> IO (Word32)
foreign import ccall "access_prim_enumClipboardFormats_gc_failed" unsafe access_prim_enumClipboardFormats_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_enumClipboardFormats_gc_failstring" unsafe access_prim_enumClipboardFormats_gc_failstring :: Addr -> IO (Addr)

getClipboardData :: ClipboardFormat -> IO HANDLE
getClipboardData arg1 =
  prim_getClipboardData arg1
  >>= \ gc_result ->
  access_prim_getClipboardData_res1 (gc_result :: Addr) >>= \ res1 ->
  access_prim_getClipboardData_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_getClipboardData_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (res1))
foreign import  ccall "prim_getClipboardData" unsafe prim_getClipboardData :: Word32 -> IO (Addr)
foreign import ccall "access_prim_getClipboardData_res1" unsafe access_prim_getClipboardData_res1 :: Addr -> IO (Addr)
foreign import ccall "access_prim_getClipboardData_gc_failed" unsafe access_prim_getClipboardData_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_getClipboardData_gc_failstring" unsafe access_prim_getClipboardData_gc_failstring :: Addr -> IO (Addr)

getClipboardFormatName :: ClipboardFormat -> Addr -> Int -> IO Int
getClipboardFormatName arg1 arg2 arg3 =
  prim_getClipboardFormatName arg1 arg2 arg3
  >>= \ gc_result ->
  access_prim_getClipboardFormatName_res1 (gc_result :: Addr) >>= \ res1 ->
  access_prim_getClipboardFormatName_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_getClipboardFormatName_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (res1))
foreign import  ccall "prim_getClipboardFormatName" unsafe prim_getClipboardFormatName :: Word32 -> Addr -> Int -> IO (Addr)
foreign import ccall "access_prim_getClipboardFormatName_res1" unsafe access_prim_getClipboardFormatName_res1 :: Addr -> IO (Int)
foreign import ccall "access_prim_getClipboardFormatName_gc_failed" unsafe access_prim_getClipboardFormatName_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_getClipboardFormatName_gc_failstring" unsafe access_prim_getClipboardFormatName_gc_failstring :: Addr -> IO (Addr)

getClipboardOwner :: IO HWND
getClipboardOwner =
  prim_getClipboardOwner
  >>= \ gc_result ->
  access_prim_getClipboardOwner_res1 (gc_result :: Addr) >>= \ res1 ->
  access_prim_getClipboardOwner_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_getClipboardOwner_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (res1))
foreign import  ccall "prim_getClipboardOwner" unsafe prim_getClipboardOwner :: IO (Addr)
foreign import ccall "access_prim_getClipboardOwner_res1" unsafe access_prim_getClipboardOwner_res1 :: Addr -> IO (Addr)
foreign import ccall "access_prim_getClipboardOwner_gc_failed" unsafe access_prim_getClipboardOwner_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_getClipboardOwner_gc_failstring" unsafe access_prim_getClipboardOwner_gc_failstring :: Addr -> IO (Addr)

getClipboardViewer :: IO HWND
getClipboardViewer =
  prim_getClipboardViewer
  >>= \ gc_result ->
  access_prim_getClipboardViewer_res1 (gc_result :: Addr) >>= \ res1 ->
  access_prim_getClipboardViewer_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_getClipboardViewer_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (res1))
foreign import  ccall "prim_getClipboardViewer" unsafe prim_getClipboardViewer :: IO (Addr)
foreign import ccall "access_prim_getClipboardViewer_res1" unsafe access_prim_getClipboardViewer_res1 :: Addr -> IO (Addr)
foreign import ccall "access_prim_getClipboardViewer_gc_failed" unsafe access_prim_getClipboardViewer_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_getClipboardViewer_gc_failstring" unsafe access_prim_getClipboardViewer_gc_failstring :: Addr -> IO (Addr)

getOpenClipboardWindow :: IO HWND
getOpenClipboardWindow =
  prim_getOpenClipboardWindow
  >>= \ gc_result ->
  access_prim_getOpenClipboardWindow_res1 (gc_result :: Addr) >>= \ res1 ->
  access_prim_getOpenClipboardWindow_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_getOpenClipboardWindow_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (res1))
foreign import  ccall "prim_getOpenClipboardWindow" unsafe prim_getOpenClipboardWindow :: IO (Addr)
foreign import ccall "access_prim_getOpenClipboardWindow_res1" unsafe access_prim_getOpenClipboardWindow_res1 :: Addr -> IO (Addr)
foreign import ccall "access_prim_getOpenClipboardWindow_gc_failed" unsafe access_prim_getOpenClipboardWindow_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_getOpenClipboardWindow_gc_failstring" unsafe access_prim_getOpenClipboardWindow_gc_failstring :: Addr -> IO (Addr)

getPriorityClipboardFormat :: Addr -> Int -> IO Int
getPriorityClipboardFormat arg1 arg2 =
  prim_getPriorityClipboardFormat arg1 arg2
  >>= \ gc_result ->
  access_prim_getPriorityClipboardFormat_res1 (gc_result :: Addr) >>= \ res1 ->
  access_prim_getPriorityClipboardFormat_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_getPriorityClipboardFormat_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (res1))
foreign import  ccall "prim_getPriorityClipboardFormat" unsafe prim_getPriorityClipboardFormat :: Addr -> Int -> IO (Addr)
foreign import ccall "access_prim_getPriorityClipboardFormat_res1" unsafe access_prim_getPriorityClipboardFormat_res1 :: Addr -> IO (Int)
foreign import ccall "access_prim_getPriorityClipboardFormat_gc_failed" unsafe access_prim_getPriorityClipboardFormat_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_getPriorityClipboardFormat_gc_failstring" unsafe access_prim_getPriorityClipboardFormat_gc_failstring :: Addr -> IO (Addr)

isClipboardFormatAvailable :: ClipboardFormat -> IO BOOL
isClipboardFormatAvailable arg1 =
  prim_isClipboardFormatAvailable arg1
  >>= \  res1  ->
  (unmarshall_bool_ res1) >>= \ gc_res1 ->
  (return (gc_res1))
foreign import  ccall "prim_isClipboardFormatAvailable" unsafe prim_isClipboardFormatAvailable :: Word32 -> IO (Int)

openClipboard :: HWND -> IO ()
openClipboard arg1 =
  prim_openClipboard arg1
  >>= \ gc_result ->
  access_prim_openClipboard_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_openClipboard_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (()))
foreign import  ccall "prim_openClipboard" unsafe prim_openClipboard :: Addr -> IO (Addr)
foreign import ccall "access_prim_openClipboard_gc_failed" unsafe access_prim_openClipboard_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_openClipboard_gc_failstring" unsafe access_prim_openClipboard_gc_failstring :: Addr -> IO (Addr)

registerClipboardFormat :: String -> IO ClipboardFormat
registerClipboardFormat gc_arg1 =
  (marshall_string_ gc_arg1) >>= \ (arg1) ->
  prim_registerClipboardFormat arg1
  >>= \ gc_result ->
  access_prim_registerClipboardFormat_res1 (gc_result :: Addr) >>= \ res1 ->
  access_prim_registerClipboardFormat_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_registerClipboardFormat_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (res1))
foreign import  ccall "prim_registerClipboardFormat" unsafe prim_registerClipboardFormat :: Addr -> IO (Addr)
foreign import ccall "access_prim_registerClipboardFormat_res1" unsafe access_prim_registerClipboardFormat_res1 :: Addr -> IO (Word32)
foreign import ccall "access_prim_registerClipboardFormat_gc_failed" unsafe access_prim_registerClipboardFormat_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_registerClipboardFormat_gc_failstring" unsafe access_prim_registerClipboardFormat_gc_failstring :: Addr -> IO (Addr)

setClipboardData :: ClipboardFormat -> HANDLE -> IO HANDLE
setClipboardData arg1 arg2 =
  prim_setClipboardData arg1 arg2
  >>= \ gc_result ->
  access_prim_setClipboardData_res1 (gc_result :: Addr) >>= \ res1 ->
  access_prim_setClipboardData_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_setClipboardData_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (res1))
foreign import  ccall "prim_setClipboardData" unsafe prim_setClipboardData :: Word32 -> Addr -> IO (Addr)
foreign import ccall "access_prim_setClipboardData_res1" unsafe access_prim_setClipboardData_res1 :: Addr -> IO (Addr)
foreign import ccall "access_prim_setClipboardData_gc_failed" unsafe access_prim_setClipboardData_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_setClipboardData_gc_failstring" unsafe access_prim_setClipboardData_gc_failstring :: Addr -> IO (Addr)

setClipboardViewer :: HWND -> IO HWND
setClipboardViewer arg1 =
  prim_setClipboardViewer arg1
  >>= \ gc_result ->
  access_prim_setClipboardViewer_res1 (gc_result :: Addr) >>= \ res1 ->
  access_prim_setClipboardViewer_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_setClipboardViewer_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (res1))
foreign import  ccall "prim_setClipboardViewer" unsafe prim_setClipboardViewer :: Addr -> IO (Addr)
foreign import ccall "access_prim_setClipboardViewer_res1" unsafe access_prim_setClipboardViewer_res1 :: Addr -> IO (Addr)
foreign import ccall "access_prim_setClipboardViewer_gc_failed" unsafe access_prim_setClipboardViewer_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_setClipboardViewer_gc_failstring" unsafe access_prim_setClipboardViewer_gc_failstring :: Addr -> IO (Addr)







