#if MVAR
module StdGUI ( GUIFun, GUI, ProcessAttribute(..), ModifiersFunction, KeyboardFunction ) where
#else
module StdGUI ( noLS, noLS1, GUIFun, GUI, ProcessAttribute(..), ModifiersFunction, KeyboardFunction ) where
#endif

--	********************************************************************************
--	Clean to Haskell Standard Object I/O library, version 1.2
--	
--	This is a new module that provides similar functionality as StdPSt in the Clean
--	Object I/O library.
--	********************************************************************************


import {-# SOURCE #-} IOstate(GUI)
import StdIOCommon(Modifiers(..),KeyboardState(..))
#include "preprocess.h"
         -- Compile with -cpp; set MVAR=1 for MVAR version


#if MVAR
#else
{-	Lift an action (ps -> GUI ps ps) to a GUIFun ls ps.
-}
noLS :: (ps -> GUI ps ps) -> GUIFun ls ps	-- Lift action GUI ps to GUIFun ls ps
noLS action (ls,ps) = do { ps1 <- action ps; return (ls,ps1) }

{-	Lift an action (ps -> GUI ps ps) that requires x to a GUIFun ls ps that requires x.
-}
noLS1 :: (x -> ps -> GUI ps ps) -> x -> GUIFun ls ps
noLS1 action x (ls,ps) = do { ps1 <- action x ps; return (ls,ps1) }
#endif

#if MVAR
type	GUIFun a
 =	GUI a
#else
type	GUIFun ls ps
 =	(ls,ps) -> GUI ps (ls,ps)
#endif


{-	Process attributes.				-}
#if MVAR
data	ProcessAttribute				-- Default:
	= ProcessClose (GUI ())				-- Process is closed
#else
data	ProcessAttribute ps				-- Default:
	= ProcessClose (ps -> GUI ps ps)		-- Process is closed
#endif


{-	Frequently used function types.			-}

#if MVAR
type	ModifiersFunction = Modifiers     -> GUIFun ()
type	KeyboardFunction  = KeyboardState -> GUIFun ()
#else
type	ModifiersFunction ls ps = Modifiers     -> GUIFun ls ps
type	KeyboardFunction  ls ps = KeyboardState -> GUIFun ls ps
#endif
