% -----------------------------------------------------------------------------
% $Id: StablePtr.lhs,v 1.6 2001/01/11 17:25:58 simonmar Exp $
%
% (c) The GHC Team, 2000
%

\section[StablePtr]{Module @StablePtr@}

\begin{code}
module StablePtr
        ( StablePtr,         -- abstract
        , newStablePtr       -- :: a -> IO (StablePtr a)
        , makeStablePtr      -- :: a -> IO (StablePtr a) -- DEPRECATED
        , deRefStablePtr     -- :: StablePtr a -> IO a
        , freeStablePtr      -- :: StablePtr a -> IO ()
        , castStablePtrToPtr -- :: StablePtr a -> Ptr ()
        , castPtrToStablePtr -- :: Ptr () -> StablePtr a
        , stablePtrToAddr    -- :: StablePtr a -> Addr -- DEPRECATED
        , addrToStablePtr    -- :: Addr -> StablePtr a -- DEPRECATED
        ) where
\end{code}

\begin{code}
import PrelStable	( StablePtr(..), newStablePtr, deRefStablePtr, freeStablePtr )
import PrelGHC		( unsafeCoerce# )
import Addr		( Addr(..) )
import Ptr              ( Ptr(..) )
\end{code}

\begin{code}
{-# DEPRECATED makeStablePtr "use newStablePtr" #-}
makeStablePtr :: a -> IO (StablePtr a)
makeStablePtr = newStablePtr

castStablePtrToPtr :: StablePtr a -> Ptr ()
castStablePtrToPtr (StablePtr s) = Ptr (unsafeCoerce# s)

castPtrToStablePtr :: Ptr () -> StablePtr a
castPtrToStablePtr (Ptr a) = StablePtr (unsafeCoerce# a)

{-# DEPRECATED stablePtrToAddr "use castStablePtrToPtr" #-}
stablePtrToAddr :: StablePtr a -> Addr
stablePtrToAddr (StablePtr s) = A# (unsafeCoerce# s)

{-# DEPRECATED addrToStablePtr "use castPtrToStablePtr" #-}
addrToStablePtr :: Addr -> StablePtr a
addrToStablePtr (A# a) = StablePtr (unsafeCoerce# a)
\end{code}
