{-
HOpenGL - a binding of OpenGL and GLUT for Haskell.
Copyright (C) 2001  Sven Panne <Sven.Panne@BetaResearch.de>

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public
License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with this library (COPYING.LIB); if not, write to the Free
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

This module corresponds to table 6.23 (Hints) of the OpenGL 1.2.1 specs.
-}

module GL_QueryHints (
   VarHints(..)
) where

import Monad            ( liftM )

import GL_Constants     ( gl_PERSPECTIVE_CORRECTION_HINT, gl_POINT_SMOOTH_HINT,
                          gl_LINE_SMOOTH_HINT, gl_POLYGON_SMOOTH_HINT, gl_FOG_HINT )
import GL_BasicTypes    ( Gettable(..) )
import GL_Hints         ( Quality, unmarshalQuality )
import GL_QueryUtils    ( getGLenum )

---------------------------------------------------------------------------

data VarHints =
     VarPerspectiveCorrectionHint
   | VarPointSmoothHint
   | VarLineSmoothHint
   | VarPolygonSmoothHint
   | VarFogHint
   deriving (Eq,Ord)

instance Gettable VarHints Quality where
   get VarPerspectiveCorrectionHint = liftM unmarshalQuality $ getGLenum gl_PERSPECTIVE_CORRECTION_HINT
   get VarPointSmoothHint           = liftM unmarshalQuality $ getGLenum gl_POINT_SMOOTH_HINT
   get VarLineSmoothHint            = liftM unmarshalQuality $ getGLenum gl_LINE_SMOOTH_HINT
   get VarPolygonSmoothHint         = liftM unmarshalQuality $ getGLenum gl_POLYGON_SMOOTH_HINT
   get VarFogHint                   = liftM unmarshalQuality $ getGLenum gl_FOG_HINT
