{-
HOpenGL - a binding of OpenGL and GLUT for Haskell.
Copyright (C) 2001  Sven Panne <Sven.Panne@BetaResearch.de>

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public
License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with this library (COPYING.LIB); if not, write to the Free
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

This module corresponds to table 6.5 (Current Values and Associated Data)
of the OpenGL 1.2.1 specs. 
-}

module GL_QueryCurrent (
   VarCurrentRColor(..),
   VarCurrentRIndex(..),
   VarCurrentRTextureCoords(..),
   VarCurrentNormal(..),
   VarCurrentRasterPosition(..),
   VarCurrentRasterDistance(..),
   VarCurrentFlags(..)
) where

import Monad            ( liftM )

import GL_Constants     ( gl_CURRENT_COLOR, gl_CURRENT_INDEX,
                          gl_CURRENT_TEXTURE_COORDS, gl_CURRENT_NORMAL,
                          gl_CURRENT_RASTER_POSITION, gl_CURRENT_RASTER_DISTANCE,
                          gl_CURRENT_RASTER_COLOR, gl_CURRENT_RASTER_INDEX,
                          gl_CURRENT_RASTER_TEXTURE_COORDS, gl_CURRENT_RASTER_POSITION_VALID,
                          gl_EDGE_FLAG )
import GL_BasicTypes    ( GLboolean, GLint, GLfloat, Gettable(..) )
import GL_RasterPos     ( RasterPos4 )
import GL_VertexSpec    ( Vertex4, Normal3, Color4, ColorIndex(..) )
import GL_QueryUtils    ( getGLboolean, getGLint, getGLfloat, getVertex4f,
                          getNormal3f, getColor4f, getRasterPos4f )

---------------------------------------------------------------------------

data VarCurrentRColor =
     VarCurrentColor
   | VarCurrentRasterColor
   deriving (Eq,Ord)

instance Gettable VarCurrentRColor (Color4 GLfloat) where
   get VarCurrentColor       = getColor4f gl_CURRENT_COLOR
   get VarCurrentRasterColor = getColor4f gl_CURRENT_RASTER_COLOR

---------------------------------------------------------------------------

data VarCurrentRIndex =
     VarCurrentIndex
   | VarCurrentRasterIndex
   deriving (Eq,Ord)

instance Gettable VarCurrentRIndex (ColorIndex GLint) where
   get VarCurrentIndex       = liftM ColorIndex $ getGLint gl_CURRENT_INDEX
   get VarCurrentRasterIndex = liftM ColorIndex $ getGLint gl_CURRENT_RASTER_INDEX

---------------------------------------------------------------------------

data VarCurrentRTextureCoords =
     VarCurrentTextureCoords
   | VarCurrentRasterTextureCoords
   deriving (Eq,Ord)

instance Gettable VarCurrentRTextureCoords (Vertex4 GLfloat) where
   get VarCurrentTextureCoords       = getVertex4f gl_CURRENT_TEXTURE_COORDS
   get VarCurrentRasterTextureCoords = getVertex4f gl_CURRENT_RASTER_TEXTURE_COORDS

---------------------------------------------------------------------------

data VarCurrentNormal = VarCurrentNormal deriving (Eq,Ord)

instance Gettable VarCurrentNormal (Normal3 GLfloat) where
   get VarCurrentNormal = getNormal3f gl_CURRENT_NORMAL

---------------------------------------------------------------------------

data VarCurrentRasterPosition = VarCurrentRasterPosition deriving (Eq,Ord)

instance Gettable VarCurrentRasterPosition (RasterPos4 GLfloat) where
   get VarCurrentRasterPosition = getRasterPos4f gl_CURRENT_RASTER_POSITION

---------------------------------------------------------------------------

data VarCurrentRasterDistance = VarCurrentRasterDistance deriving (Eq,Ord)

instance Gettable VarCurrentRasterDistance GLfloat where
   get VarCurrentRasterDistance = getGLfloat gl_CURRENT_RASTER_DISTANCE

---------------------------------------------------------------------------

data VarCurrentFlags =
     VarCurrentRasterPositionValid
   | VarEdgeFlag
   deriving (Eq,Ord)

instance Gettable VarCurrentFlags GLboolean where
   get VarCurrentRasterPositionValid = getGLboolean gl_CURRENT_RASTER_POSITION_VALID
   get VarEdgeFlag                   = getGLboolean gl_EDGE_FLAG
