{-
HOpenGL - a binding of OpenGL and GLUT for Haskell.
Copyright (C) 2001  Sven Panne <Sven.Panne@BetaResearch.de>

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public
License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with this library (COPYING.LIB); if not, write to the Free
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

This module corresponds to table 6.8 (Coloring) of the OpenGL 1.2.1 specs.
-}

module GL_QueryColoring (
   VarFogColor(..),
   VarFogIndex(..),
   VarFogDensity(..),
   VarShadeModel(..),
) where

import Monad            ( liftM, liftM2 )

import GL_Constants     ( gl_FOG_COLOR, gl_FOG_INDEX, gl_FOG_DENSITY,
                          gl_FOG_START, gl_FOG_END, gl_FOG_MODE,
                          gl_SHADE_MODEL, gl_LINEAR, gl_EXP)
import GL_BasicTypes    ( GLfloat, GLint, Gettable(..) )
import GL_Colors        ( ShadeModel, unmarshalShadeModel )
import GL_Fog           ( FogDensity(..) )
import GL_QueryUtils    ( getGLfloat, getGLint, getGLenum, getColor4f )
import GL_VertexSpec    ( Color4, ColorIndex(..) )

---------------------------------------------------------------------------

data VarFogColor = VarFogColor deriving (Eq,Ord)

instance Gettable VarFogColor (Color4 GLfloat) where
   get VarFogColor = getColor4f gl_FOG_COLOR

data VarFogIndex = VarFogIndex deriving (Eq,Ord)

instance Gettable VarFogIndex (ColorIndex GLint) where
   get VarFogIndex = liftM ColorIndex $ getGLint gl_FOG_INDEX

data VarFogDensity = VarFogDensity deriving (Eq,Ord)

instance Gettable VarFogDensity FogDensity where
   get VarFogDensity = do
      mode <- getGLint gl_FOG_MODE
      if mode == gl_LINEAR
         then liftM2 FogLinear (getGLfloat gl_FOG_START) (getGLfloat gl_FOG_END)
         else liftM (if mode == gl_EXP then FogExp else FogExp2) $
                    getGLfloat gl_FOG_DENSITY

data VarShadeModel = VarShadeModel deriving (Eq,Ord)

instance Gettable VarShadeModel ShadeModel where
   get VarShadeModel = liftM unmarshalShadeModel $ getGLenum gl_SHADE_MODEL
