
/*
   gcdverifier.c
   
   Part of GNU Enterprise Application Server (GEAS)
 
   Copyright (C) 2001 Free Software Foundation
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.
 
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
 
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
 
   $Id: gcdverifier.c,v 1.25 2001/08/24 21:30:58 ntiffin Exp $
*/

#include <glib.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

#include <string.h>
#include <stdlib.h>

#include "classdata.h"

/* ------------------------------------------------------------------------- *\
 * 
\* ------------------------------------------------------------------------- */
int
main (int argc, char *argv[])
{
  odl_filenamelist *fl = NULL;
  odl_tree *t = NULL;
  int i, count;
  gboolean fullname = FALSE;
  gboolean verbose = FALSE;
  int number_entries = 0;       /* keeps track if we have any files or dir to process */
  if (argc < 2)
    {
      printf
        ("Usage: %s [options] [file | directory] ... [fileN | directoryN]\n", argv[0]);
      printf( "Options\n:");
      printf( "   --verbose  (not implemented)\n");
      printf( "   --version  (show version number and process files)\n");
      printf( "   -f         (show full name)\n");
      exit (EXIT_FAILURE);
    }
  count = 1;
  while (count < 2)
    {
      count++;
      /* select files to load */
      for (i = 1; i < argc; i++)
        {
          if (strcmp (argv[i], "-f") == 0)      /* show full name on output */
            {
              fullname = TRUE;
            }
          else if (strcmp (argv[i], "--verbose") == 0)
            {
              verbose = TRUE;
            }
          else if (strcmp (argv[i], "--version") == 0)
            {
              GString *revision;
              revision = g_string_new ("$Revision: 1.25 $");
              
              if (revision->len > 14)
                {
                  revision = g_string_erase (revision, 0, 11);  /* remove the '$Revsion:' part */
                  revision = g_string_erase (revision, (revision->len) - 2, 2); /* remove the last two characters */
                }
              printf ("GNUe GCD File Format Verifier, version %s (Compiled %s %s)\n",
                      revision->str, __DATE__, __TIME__);
              printf ("Part of the GNU Enterprise Project.\n");
              printf ("Copyright (c) 2000, 2001 Free Software Foundation\n");
              printf
                ("This is free software; see the source for copying conditions.\n");
              printf
                ("There is NO warranty; not even for MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.\n");
              g_string_free (revision, TRUE);
            }
          else if (odl_is_extension (argv[i], "gcd"))       /* has an extension of '.gcd. */
            {
              number_entries++;
              fl = odl_filenamelist_add (fl, argv[i]);
            }
          else
            {
              /* must be a directory */
              /* means directories with .gcd at the end will not work */
              number_entries++;
              fl = odl_get_files_from_dir (fl, argv[i]);
            }
        }
      if (number_entries > 0)
        {
          /* load the files that have been tagged */
          if (G_HAVE_GINT64 != 1)
            {
              printf("**** Platform does not support 64 bit integers.\n");
            }
          t = odl_load_files (fl, NULL);
          if (t != NULL)
            {
              /* display the files that have been loaded */
              odl_display_tree (stdout, t, fullname);
              /* odl_dump_tree (stdout, t, TRUE); */
            }
        }
      /* free memory */
      if (verbose)
        {
          printf ("Freeing class data.\n");
        }
      if (t) odl_free_tree (t);
      if (fl) odl_filenamelist_free (fl);
      fl = NULL;
    }
  exit (EXIT_SUCCESS);
}
