
/*
   query.h
   
   Part of GNU Enterprise Application Server (GEAS)
 
   Copyright (C) 2000 Free Software Foundation
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.
 
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
 
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
   
   $Id: query.h,v 1.4 2001/06/10 12:56:12 ntiffin Exp $
 
*/

#ifndef QUERY_H
#define QUERY_H

#include "geas.h"

GEAS_Query_logictype Constraint__get_logic (GEAS_object_reference * id,
                                            CORBA_Environment * ev);
void Constraint__set_logic (GEAS_object_reference * id,
                            GEAS_Query_logictype value,
                            CORBA_Environment * ev);
void Constraint_addField (GEAS_object_reference * id,
                          GEAS_Query_Field * field, CORBA_Environment * ev);
GEAS_Query_Constraint Constraint_newConstraint (GEAS_object_reference * id,
                                                CORBA_Environment * ev);


void Query_release (GEAS_object_reference * id, CORBA_Environment * ev);
void Query_clear (GEAS_object_reference * id, CORBA_Environment * ev);

CORBA_char *Query__get_orderby (GEAS_object_reference * id,
                                CORBA_Environment * ev);
void Query__set_orderby (GEAS_object_reference * id, CORBA_char * value,
                         CORBA_Environment * ev);
CORBA_boolean Query__get_reverse (GEAS_object_reference * id,
                                  CORBA_Environment * ev);
void Query__set_reverse (GEAS_object_reference * id, CORBA_boolean value,
                         CORBA_Environment * ev);

void Query__set_classname (GEAS_object_reference * id,
                           CORBA_char * value, CORBA_Environment * ev);
CORBA_char *Query__get_classname (GEAS_object_reference * id,
                                  CORBA_Environment * ev);
GEAS_ObjectReference
Query__get_id (GEAS_object_reference * id, CORBA_Environment * ev);

#endif /* QUERY_H */
