
/*
   objectlist.h
   
   Part of GNU Enterprise Application Server (GEAS)
 
   Copyright (C) 2000 Free Software Foundation
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.
 
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
 
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
   
   $Id: objectlist.h,v 1.7 2001/06/10 12:56:12 ntiffin Exp $
 
*/

#ifndef OBJECTLIST_H
#define OBJECTLIST_H

#include "geas-skeleton.h"

void
ObjectList_appendObject (GEAS_object_reference * id,
                         const GEAS_DataObject obj, CORBA_Environment * ev);
                         
void ObjectList_removeEntry (GEAS_object_reference * id,
                             CORBA_unsigned_long index,
                             CORBA_Environment * ev);
                             
void ObjectList_resort (GEAS_object_reference * id, CORBA_char * fieldname,
                        CORBA_boolean ascending, CORBA_Environment * ev);

CORBA_unsigned_long ObjectList__get_length (GEAS_object_reference * id,
                                            CORBA_Environment * ev);
                                            
GEAS_objectslist *ObjectList__get_objects (GEAS_object_reference * id,
                                           CORBA_Environment * ev);
                                           
CORBA_char *ObjectList__get_classname (GEAS_object_reference * id,
                                       CORBA_Environment * ev);
                                       
GEAS_DataObject ObjectList_getEntry (GEAS_object_reference * id, int index,
                                     CORBA_Environment * ev);
                                     
CORBA_unsigned_long ObjectList_hideObjects (GEAS_object_reference * id,
                                            CORBA_char * fieldname,
                                            CORBA_char * compare,
                                            CORBA_char * value,
                                            CORBA_Environment * ev);
                                            
CORBA_unsigned_long ObjectList_showObjects (GEAS_object_reference * id,
                                            CORBA_char * fieldname,
                                            CORBA_char * compare,
                                            CORBA_char * value,
                                            CORBA_Environment * ev);
                                            
void ObjectList_showAll (GEAS_object_reference * id, CORBA_Environment * ev);

CORBA_unsigned_long ObjectList_applyFilter (GEAS_object_reference * id,
                                            CORBA_Environment * ev);
                                            
CORBA_boolean ObjectList__get_delayFilter (GEAS_object_reference * id,
                                           CORBA_Environment * ev);
                                           
void ObjectList__set_delayFilter (GEAS_object_reference * id,
                                  CORBA_boolean value,
                                  CORBA_Environment * ev);
                                  
void ObjectList_release (GEAS_object_reference * id, CORBA_Environment * ev);

#endif
