
/*
   objectlist.c
   
   Part of GNU Enterprise Application Server (GEAS)
 
   Copyright (C) 2000 Free Software Foundation
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.
 
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
 
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
   
   $Id: objectlist.c,v 1.29 2001/07/25 17:48:24 reinhard Exp $
 
*/

/** \file objectlist.c
 *  \brief GEAS::ObjectList implementation
 */


#include "config.h"

#include <stdlib.h>

#include "geas.h"
#include "objectlist.h"
#include "objectcache/objectcache.h"
#include "config/configuration.h"
#include "objectstore/objectstore.h"
#include "exceptions.h"
#include "collectiondata.h"
#include "geas-server.h"

/* raises:  */
CORBA_unsigned_long
ObjectList__get_length (GEAS_object_reference * id, CORBA_Environment * ev)
{
  char *len;
  CORBA_unsigned_long retval = 0;
  ObjectData *ob;

  display_geas_object_reference (id);

  /* TODO: an exception, if the list is lost - needs get_throws() in IDL
     (CORBA 3) */

  ob = oc_find_object_by_key ("geas::listholder", id->listid);
  if (!ob)
    {
      return (0);
    }
  len = oc_get_object_field (ob, "length");

  /* get length */
  retval = atoi (len);
  g_free (len);

  /* done */
  return (retval);
}

/* raises:  */
GEAS_objectslist *
ObjectList__get_objects (GEAS_object_reference * id, CORBA_Environment * ev)
{
  /* GEAS_DataObject obj; */
  GEAS_objectslist *retval = NULL;
  int i, len;
  ObjectData *obj;
  GList *hacklist;
  char *classname;

  /* get length of list */
timer_start_profile( TIMER_FUNC_D );
  len = ObjectList__get_length (id, ev);
  if (ev->_major != CORBA_NO_EXCEPTION)
    {
      return (NULL);
    }
  /* allocate return structure */
  retval = GEAS_objectslist__alloc ();
  if (!retval)
    {
      /* throw exception?   *sigh*  */
      return (NULL);
    }
  retval->_maximum = len;
  retval->_length = len;
  retval->_buffer = CORBA_sequence_GEAS_DataObject_allocbuf (retval->_length);

  obj = oc_find_cached_object_by_key( "geas::listholder" , id->listid );
  classname = oc_get_object_field( obj , "classname" );
  hacklist = oc_get_object_userdata( obj );
timer_update_profile( TIMER_FUNC_D );

#if 0
xyz
  i = 0;
  while( hacklist )
   {
     dataobj = (ObjectData *)hacklist->data;
     objid = oc_get_object_key( dataobj );
     retval->_buffer[i] = make_dataobject_reference( classname , objid , id->username , id->sessionid , ev );

     hacklist = g_list_next( hacklist );
     i++;
   }
   g_free( classname );

#else
timer_start_profile( TIMER_FUNC_TEMP1 );
  for (i = 0; i < len; i++)
    {
  GEAS_DataObject xretval = CORBA_OBJECT_NIL;
  /* GEAS_DataObject lst; */
  int len;
  char *key, *classname = NULL, *pos;
  QueryData *q;
  int index = i;
timer_start_profile( TIMER_FUNC_GETENTRY );
timer_start_profile( TIMER_FUNC_A );

  len = ObjectList__get_length (id, ev);
  if (ev->_major != CORBA_NO_EXCEPTION)
    {
timer_update_profile( TIMER_FUNC_GETENTRY );
      return (CORBA_OBJECT_NIL);
    }

    {
      /* find listholder where listholder.objectid = id.listid, to read
         classname */
      ObjectData *ob;

      ob = oc_find_object_by_key ("geas::listholder", id->listid);
      classname = oc_get_object_field (ob, "classname");
timer_update_profile( TIMER_FUNC_A );

      /* create query */
timer_start_profile( TIMER_FUNC_B );
      q = oql_load_object ("geas::listitem");
      if (!q)
        {
          make_ServerError_exception (ev, "Could not create query");
          g_free (classname);
timer_update_profile( TIMER_FUNC_B );
          return (CORBA_OBJECT_NIL);
        }
      oql_add_query_constraint (q, NULL, id->listid, "=", "geas::listitem",
                                "listid");
      pos = g_strdup_printf ("%d", index);
      oql_add_query_constraint (q, NULL, pos, "=", "geas::listitem",
                                "position");
      g_free (pos);
      /* WHERE geas::listitem.listid   = id->listid AND 
       *       geas::listitem.position = index
       */
timer_update_profile( TIMER_FUNC_B );

      ob = oc_search_for_single_object (q);
      if (ob)
        {
	  ObjectData *xyz; /* sensible variable names?   this is already a nasty hack, so why start being sensible now? */

timer_start_profile( TIMER_FUNC_C );
          key = oc_get_object_field (ob, "reference");
timer_start_profile( TIMER_FUNC_MAKEREF );


	  xyz = oc_find_object_by_key( classname , key );

	  xretval = oc_get_object_userdata( xyz );
          if( xretval == NULL ) {
	    xretval =
              make_dataobject_reference (classname, key, id->username,
                                         id->sessionid, ev);
	    oc_set_object_userdata( xyz , (void *)xretval );
	    if( oc_get_object_userdata(xyz) == NULL ) printf( "hey!\n" );
	  }



timer_update_profile( TIMER_FUNC_MAKEREF );
          g_free (key);
          oql_free_query (q);
timer_update_profile( TIMER_FUNC_C );
timer_update_profile( TIMER_FUNC_GETENTRY );

      /* add object reference to the list */
      retval->_buffer[i] = CORBA_Object_duplicate(xretval,ev);
        }
    }
   }
timer_update_profile( TIMER_FUNC_TEMP1 );
#endif

  return (retval);
}

/* raises:  */
CORBA_char *
ObjectList__get_classname (GEAS_object_reference * id, CORBA_Environment * ev)
{
  CORBA_char *retval = NULL;

  return (retval);
}

/* raises: OutOfBounds */
GEAS_DataObject
ObjectList_getEntry (GEAS_object_reference * id, int index,
                     CORBA_Environment * ev)
{
  GEAS_DataObject retval = CORBA_OBJECT_NIL;
  /* GEAS_DataObject lst; */
  int len;
  char *key, *classname = NULL, *pos;
  QueryData *q;
  struct query_result *result;
  int err;
  char *errmsg;
  int idx;
timer_start_profile( TIMER_FUNC_GETENTRY );
timer_start_profile( TIMER_FUNC_A );

  len = ObjectList__get_length (id, ev);
  if (ev->_major != CORBA_NO_EXCEPTION)
    {
timer_update_profile( TIMER_FUNC_GETENTRY );
      return (CORBA_OBJECT_NIL);
    }
  if (index >= len)
    {
      if (len > 0)
        {
          make_OutOfBounds_exception (ev,
                                      "index %d is out of bounds: there are only %d entries (indexed from 0)",
                                      index, len);
        }
      else
        {
          make_OutOfBounds_exception (ev, "the collection is empty");
        }
    }
  else
    {

      /* find listholder where listholder.objectid = id.listid, to read
         classname */
      ObjectData *ob;

      ob = oc_find_object_by_key ("geas::listholder", id->listid);
      classname = oc_get_object_field (ob, "classname");
timer_update_profile( TIMER_FUNC_A );

      /* create query */
timer_start_profile( TIMER_FUNC_B );
      q = oql_load_object ("geas::listitem");
      if (!q)
        {
          make_ServerError_exception (ev, "Could not create query");
          g_free (classname);
timer_update_profile( TIMER_FUNC_B );
          return (CORBA_OBJECT_NIL);
        }
      oql_add_query_constraint (q, NULL, id->listid, "=", "geas::listitem",
                                "listid");
      pos = g_strdup_printf ("%d", index);
      oql_add_query_constraint (q, NULL, pos, "=", "geas::listitem",
                                "position");
      g_free (pos);
      /* WHERE geas::listitem.listid   = id->listid AND 
       *       geas::listitem.position = index
       */
timer_update_profile( TIMER_FUNC_B );

      ob = oc_search_for_single_object (q);
      if (ob)
        {
timer_start_profile( TIMER_FUNC_C );
          key = oc_get_object_field (ob, "reference");
timer_start_profile( TIMER_FUNC_MAKEREF );
          retval =
            make_dataobject_reference (classname, key, id->username,
                                       id->sessionid, ev);
timer_update_profile( TIMER_FUNC_MAKEREF );
          g_free (key);
          oql_free_query (q);
timer_update_profile( TIMER_FUNC_C );
timer_update_profile( TIMER_FUNC_GETENTRY );
          return (retval);
        }

      /* perform the query */
    printf( "searching object store\n" );
      result = query_objectstore (q, &err, &errmsg);
      if (errmsg || !result)
        {
          if (errmsg)
            {
              make_ServerError_exception (ev, errmsg);
            }
          else
            {
              make_ServerError_exception (ev,
                                          "Query failed (unknown reason)");
            }
          if (errmsg)
            {
              errormsg (errmsg);
              g_free (errmsg);
            }
          oql_free_query (q);
          if (result)
            {
              free_query_result (result);
            }
          g_free (classname);
timer_update_profile( TIMER_FUNC_GETENTRY );
          return (CORBA_OBJECT_NIL);
        }
      idx = oql_query_get_field_position (q, "reference");
      key = (char *) get_result_field (result, 0, idx);
      retval =
        make_dataobject_reference (classname, key, id->username,
                                   id->sessionid, ev);
      free_query_result (result);
      oql_free_query (q);
    }
  if (classname)
    {
      g_free (classname);
    }
timer_update_profile( TIMER_FUNC_GETENTRY );
  return (retval);
}

/* raises: WrongClass, ServerError */
void
ObjectList_appendObject (GEAS_object_reference * id,
                         const GEAS_DataObject obj, CORBA_Environment * ev)
{
  gboolean test;
  GEAS_DataObject lst, newobj;
  char *classname, *lenstr, *buf, *objid;
  CORBA_unsigned_long len;

  lst =
    GEAS_Connection_loadSingleObject (id->server,
                                      "geas::listholder", "objectid",
                                      id->listid, ev);
  if (ev->_major != CORBA_NO_EXCEPTION)
    {
      return;
    }
  classname = GEAS_DataObject_getField (lst, "classname", ev);
  if (ev->_major != CORBA_NO_EXCEPTION)
    {
      CORBA_Object_release (lst, ev);
      return;
    }
  test = GEAS_DataObject_ofclass (obj, classname, ev);
  if (ev->_major != CORBA_NO_EXCEPTION)
    {
      CORBA_Object_release (lst, ev);
      return;
    }
  if (!test)
    {
      make_WrongClass_exception (ev,
                                 "This list requires objects of class '%s' only",
                                 classname);
      return;
    }

  /* increment length */
  len = ObjectList__get_length (id, ev);
  if (ev->_major != CORBA_NO_EXCEPTION)
    {
      CORBA_Object_release (lst, ev);
      return;
    }
  len++;
  lenstr = g_strdup_printf ("%d", len);
  GEAS_DataObject_setField (lst, "length", lenstr, ev);
  g_free (lenstr);
  if (ev->_major != CORBA_NO_EXCEPTION)
    {
      errormsg (CORBA_exception_id (ev));
      /* CORBA_Object_release(lst, ev); */
      return;
    }
  CORBA_Object_release (lst, ev);

  /* add appropriate listitem object */
  newobj = GEAS_Connection_newObject (id->server, "geas::listitem", ev);
  if (ev->_major != CORBA_NO_EXCEPTION)
    {
      return;
    }
  /* which object was that, again?  :) */
  objid = GEAS_DataObject_getField (obj, "objectid", ev);
  if (ev->_major != CORBA_NO_EXCEPTION)
    {
      return;
    }
  /* store the object's details */
  buf = g_strdup_printf ("%d", len - 1);
  GEAS_DataObject_setField (newobj, "position", buf, ev);       /* where in list */
  g_free (buf);
  GEAS_DataObject_setField (newobj, "listid", id->listid, ev);  /* which list */
  GEAS_DataObject_setField (newobj, "reference", objid, ev);    /* what object, id */
}

/* raises: OutOfBounds, ServerError */
void
ObjectList_removeEntry (GEAS_object_reference * id, CORBA_unsigned_long index,
                        CORBA_Environment * ev)
{
  int i;
  GEAS_DataObject lst, obj;
  int len;
  char *key, *classname, *pos;
  QueryData *q;
  struct query_result *result;
  int err;
  char *errmsg, *buf;
  int idx;

  /* find listholder object */
  lst =
    GEAS_Connection_loadSingleObject (id->server,
                                      "geas::listholder", "objectid",
                                      id->listid, ev);
  if (ev->_major != CORBA_NO_EXCEPTION)
    {
      return;
    }
  len = ObjectList__get_length (id, ev);
  if (ev->_major != CORBA_NO_EXCEPTION)
    {
      CORBA_Object_release (lst, ev);
      return;
    }

  classname = GEAS_DataObject_getField (lst, "classname", ev);

  /* find specific list entry */
  /* create query */
  q = oql_load_object ("geas::listitem");
  if (!q)
    {
      CORBA_free (classname);
      make_ServerError_exception (ev, "Could not create query");
      return;
    }
  oql_add_query_constraint (q, NULL, id->listid, "=", "geas::listitem",
                            "listid");
  pos = g_strdup_printf ("%d", index);
  oql_add_query_constraint (q, NULL, pos, "=", "geas::listitem", "position");
  g_free (pos);

  /* perform the query */
  result = query_objectstore (q, &err, &errmsg);
  if (errmsg || !result)
    {
      if (errmsg)
        {
          make_ServerError_exception (ev, errmsg);
        }
      else
        {
          make_ServerError_exception (ev, "Query failed (unknown reason)");
        }
      if (errmsg)
        {
          errormsg (errmsg);
          g_free (errmsg);
        }
      oql_free_query (q);
      if (result)
        {
          free_query_result (result);
        }
      CORBA_free (classname);
      return;
    }
  idx = oql_query_get_field_position (q, "objectid");
  key = (char *) get_result_field (result, 0, idx);
  obj =
    make_dataobject_reference ("geas::listitem", key, id->username,
                               id->sessionid, ev);

  /* delete it */
  GEAS_DataObject_delete (obj, ev);
  CORBA_Object_release (obj, ev);
  if (ev->_major != CORBA_NO_EXCEPTION)
    {
      CORBA_Object_release (lst, ev);
      CORBA_free (classname);
      return;
    }

  /* renumber later entries */
  for (i = index + 1; i < len; i++)
    {
      /* find object */
      /* create query */
      q = oql_load_object ("geas::listitem");
      if (!q)
        {
          make_ServerError_exception (ev, "Could not create query");
          CORBA_free (classname);
          return;
        }
      oql_add_query_constraint (q, NULL, id->listid, "=", "geas::listitem",
                                "listid");
      pos = g_strdup_printf ("%d", i);
      oql_add_query_constraint (q, NULL, pos, "=", "geas::listitem",
                                "position");
      g_free (pos);

      /* perform the query */
      result = query_objectstore (q, &err, &errmsg);
      if (errmsg || !result)
        {
          if (errmsg)
            {
              make_ServerError_exception (ev, errmsg);
            }
          else
            {
              make_ServerError_exception (ev,
                                          "Query failed (unknown reason)");
            }
          if (errmsg)
            {
              errormsg (errmsg);
              g_free (errmsg);
            }
          oql_free_query (q);
          if (result)
            {
              free_query_result (result);
            }
          CORBA_free (classname);
          return;
        }
      idx = oql_query_get_field_position (q, "objectid");
      key = (char *) get_result_field (result, 0, idx);
      obj =
        make_dataobject_reference ("geas::listitem", key, id->username,
                                   id->sessionid, ev);

      /* set new index */
      buf = g_strdup_printf ("%d", i - 1);
      GEAS_DataObject_setField (obj, "position", buf, ev);
      g_free (buf);
      CORBA_Object_release (obj, ev);
    }

  /* decrement length */
  buf = g_strdup_printf ("%d", len - 1);
  GEAS_DataObject_setField (lst, "length", buf, ev);
  g_free (buf);
}

void
ObjectList_resort (GEAS_object_reference * id,
                   CORBA_char * fieldname,
                   CORBA_boolean ascending, CORBA_Environment * ev)
{
  /* TODO */
}

/* raises: UnknownField, ServerError */
CORBA_unsigned_long
ObjectList_hideObjects (GEAS_object_reference * id, CORBA_char * fieldname,
                        CORBA_char * compare, CORBA_char * value,
                        CORBA_Environment * ev)
{
  CORBA_unsigned_long retval = 0;
  return (retval);
}

/* raises: UnknownField, FilterNotSet, ServerError */
CORBA_unsigned_long
ObjectList_showObjects (GEAS_object_reference * id, CORBA_char * fieldname,
                        CORBA_char * compare, CORBA_char * value,
                        CORBA_Environment * ev)
{
  CORBA_unsigned_long retval = 0;

  return (retval);
}

/* raises:  */
void
ObjectList_showAll (GEAS_object_reference * id, CORBA_Environment * ev)
{
}

/* raises:  */
CORBA_unsigned_long
ObjectList_applyFilter (GEAS_object_reference * id, CORBA_Environment * ev)
{
  CORBA_unsigned_long retval = 0;

  return (retval);
}

/* raises:  */
CORBA_boolean
ObjectList__get_delayFilter (GEAS_object_reference * id,
                             CORBA_Environment * ev)
{
  CORBA_boolean retval = CORBA_FALSE;

  return (retval);
}

/* raises:  */
void
ObjectList__set_delayFilter (GEAS_object_reference * id, CORBA_boolean value,
                             CORBA_Environment * ev)
{
}

/* raises:  */
void
ObjectList_release (GEAS_object_reference * id, CORBA_Environment * ev)
{
  char *len;
  ObjectData *ob;
  int length;
  GList *hacklist,*hacklist2;

  /* QueryData *q; */
  struct query_result *result;

  timer_start_profile( TIMER_FUNC_RELEASELIST );

  ob = oc_find_object_by_key ("geas::listholder", id->listid);
  if (!ob)
    {
      make_ServerError_exception( ev , "list data lost" );
      timer_update_profile( TIMER_FUNC_RELEASELIST );
      return;
    }
  len = oc_get_object_field (ob, "length");
  length = atoi (len);
  g_free (len);

  hacklist = (GList *)oc_get_object_userdata( ob );
  hacklist2 = hacklist;
  while(hacklist2)
   {
       oc_remove_object( hacklist2->data );
       hacklist2 = g_list_next( hacklist2 );
   }
  g_list_free( hacklist );

  oc_delete_object( "geas::listholder" , id->listid );


#if 0
  for( i=0 ; i<length ; i++ )
   {
     // oc_delete_objectfrom_cache( "geas::listitem" , id->listid );
     // find geas::listitem where listid == id->listid and position == i
     QueryData *q = oql_load_object( "geas::listitem" );
     char pos[32];
     ObjectData *item;

     sprintf( pos , "%d" , i );
     oql_add_query_constraint( q,NULL,id->listid,"=","geas::listitem","listid" );
     oql_add_query_constraint( q,NULL,pos       ,"=","geas::listitem","position" );
     item = oc_search_for_single_object( q );
     if( item != NULL )
       oc_remove_object2( item );

     oql_free_query(q);
   }
  printf( "\n" );
#endif

  /* delete the geas::listholder object */
  result =
    delete_from_objectstore ("geas::listholder", id->listid, NULL, NULL);
  if (result)
    {
      free_query_result (result);
    }
  /* delete the geas::listitem instances */
  result =
    delete_all_from_objectstore ("geas::listitem", "listid", id->listid, NULL,
                                 NULL);
  if (result)
    {
      free_query_result (result);
    }
  timer_update_profile( TIMER_FUNC_RELEASELIST );
}
