/*
  methods_oaf.h - Oaf method support (incomplete).

  Copyright (C) 2001 Free Software Foundation

  This file is part of the GNU Enterprise Application Server (GEAS)

  GEAS is free software; you can redistribute it and/or modify it under
  the terms of the GNU General Public License as published by the Free
  Software Foundation; either version 2, or (at your option) any later
  version.

  GEAS is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
  for more details.

  You should have received a copy of the GNU General Public License
  along with GEAS; if not, write to the Free Software Foundation, Inc.,
  59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

  $Id: methods_oaf.h,v 1.5 2001/06/08 22:47:46 baumannd Exp $
*/

#ifndef USE_OAF
#error "USE_OAF was not defined."
#endif

#error "Currently will not compile or work anyway  :)"

#include <liboaf/liboaf.h>

typedef struct
{
  char *classname;
  char *cid;
  CORBA_Object object;
}
provider_t;

static void free_method_provider (provider_t * p);
static provider_t *allocate_method_provider (const char *classname,
                                             const char *id);

static GList *provider_list = NULL;

gboolean
initialise_method_handling (configuration config)
{
  GList *cl, *l, *fields, *fl;
  classdata *c;
  fielddata *f;
  CORBA_Object obj;
  provider_t *p;
  char *oafid;
  CORBA_Environment ev;
  int fails = 0;

  g_return_val_if_fail (config, FALSE);

  CORBA_exception_init (&ev);

  /* look for the registered providers for each business method */
  cl = get_classname_list (all_classes);
  if (!cl)
    {
      CORBA_exception_free (&ev);
      return (0);               /* done, no classes == no methods :) */
    }

  l = cl;
  while (l)
    {
      /* get the class to handle */
      c = find_class_definition (all_classes, l->data);
      debug_output (DEBUGLEVEL_2, "    class %s, class id %s",
                    get_class_name (c), get_class_id (c));

      fields = list_fields_in_class (c, FT_method, 0);
      if (fields)
        {
          /* allocate provider */
          p = allocate_method_provider (get_class_name (c), get_class_id (c));

          /* find it */
          oafid =
            g_strdup_printf ("OAFIID:Bogus.GEAS.MethodProvider:%s",
                             get_class_id (c));
          if (oafid)
            {
              debug_output (DEBUGLEVEL_1, "looking for: '%s'", oafid);
              p->object = oaf_activate_from_id (oafid, 0, NULL, &ev);
              if (ev._major != CORBA_NO_EXCEPTION)
                {
                  errormsg ("Exception: %s", CORBA_exception_id (&ev));
                }
              g_free (oafid);
            }
          if (p->object == CORBA_OBJECT_NIL)
            {
              errormsg ("Failed.");
              fails++;
            }
          else
            {
              /* verify existance of methods */
              fl = fields;
              while (fl)
                {
                  f = (fielddata *) fl->data;
                  debug_output (DEBUGLEVEL_2, "        method: %s",
                                get_fieldname (f));
                  fl = g_list_next (fl);
                }

              /* add to list */
              provider_list = g_list_append (provider_list, p);
            }

          /* done this class */
          g_list_free (fields);
        }
#ifdef DEBUG
      else
        {
          debug_output (DEBUGLEVEL_2, "        no methods");
        }
#endif

      /* next class */
      g_free (l->data);
      l = g_list_next (l);
    }
  g_list_free (cl);
  CORBA_exception_free (&ev);

  return (fails);
}

static void
free_method_provider (provider_t * p)
{
  if (p)
    {
      if (p->cid)
        g_free (p->cid);
      if (p->classname)
        g_free (p->classname);
      g_free (p);
    }
}

static provider_t *
allocate_method_provider (const char *classname, const char *id)
{
  provider_t *p = (provider_t *) g_new0 (provider_t, 1);
  if (p)
    {
      p->object = CORBA_OBJECT_NIL;
      p->classname = g_strdup (classname);
      p->cid = g_strdup (id);

      if (!p->classname || !p->cid)
        {
          free_method_provider (p);
          p = NULL;
        }
    }
  return (p);
}

gboolean
shutdown_method_handling (void)
{
  return (TRUE);
}

CORBA_char *
execute_method (GEAS_object_reference * obj,
                const char *methodname, GEAS_Arguments * args,
                CORBA_Environment * ev)
{
  GList *l = provider_list;
  char *retval = NULL;

  g_return_val_if_fail (obj, NULL);
  g_return_val_if_fail (methodname, NULL);
  g_return_val_if_fail (args, NULL);
  g_return_val_if_fail (ev, NULL);

  while (l)
    {
      provider_t *p = (provider_t *) l->data;
      if (g_strcasecmp (p->classname, obj->classname) == 0 &&
          g_strcasecmp (p->cid, obj->classid) == 0)
        {
          debug_output (DEBUGLEVEL_5, "Method %s.%s called", obj->classname,
                        methodname);
          return (CORBA_string_dup (retval));
        }
      l = g_list_next (l);
    }

  /* not found */
  make_UnknownMethod_exception (ev, "Method '%s.%s' could not be located.",
                                obj->classname, methodname);
  return (NULL);
}
