/* 
   excceptions.c - 
   
   Part of GNU Enterprise Application Server (GEAS)

   Copyright (C) 2001 Free Software Foundation

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
   
   $Id: exceptions.c,v 1.16 2001/06/02 13:17:10 ntiffin Exp $

*/

/** \file exceptions.c
 *  \brief Utility functions to create exceptions.
 */

#include "config.h"

#include <glib.h>
#include <stdarg.h>
#include <stdlib.h>

#include "geas.h"
#include "exceptions.h"

#include "geas-server.h"

#ifdef DEBUG
#define showdetail(type) \
debug_output(DEBUGLEVEL_3,"Exception: (%s) %s\n" , type , exception->detail )
#else
#define showdetail(type) /* */
#endif

void
make_ServerError_exception(CORBA_Environment * ev, char *format, ...)
   {
      GEAS_ServerError *exception = GEAS_ServerError__alloc();

      va_list args;
      char *buf;

      trace_functioncall();

      va_start( args , format );
      buf = g_strdup_vprintf( format , args );
      exception->detail = CORBA_string_dup(buf);
      g_free( buf );
      va_end( args );

      showdetail("ServerError");
      CORBA_exception_set(ev, CORBA_USER_EXCEPTION, ex_GEAS_ServerError, exception);
   }

void
make_UnknownClass_exception(CORBA_Environment * ev, char *format, ...)
   {
   GEAS_UnknownClass *exception = GEAS_UnknownClass__alloc();

      va_list args;
      char *buf;

      trace_functioncall();

      va_start( args , format );
      buf = g_strdup_vprintf( format , args );
      exception->detail = CORBA_string_dup(buf);
      g_free( buf );
      va_end( args );

      showdetail("UnknownClass");
      CORBA_exception_set(ev, CORBA_USER_EXCEPTION, ex_GEAS_UnknownClass, exception);
   }

void
make_UnknownField_exception(CORBA_Environment * ev, char *format, ...)
   {
   GEAS_UnknownField *exception = GEAS_UnknownField__alloc();

      va_list args;
      char *buf;

      trace_functioncall();

      va_start( args , format );
      buf = g_strdup_vprintf( format , args );
      exception->detail = CORBA_string_dup(buf);
      g_free( buf );
      va_end( args );

      showdetail("UnknownField");
      CORBA_exception_set(ev, CORBA_USER_EXCEPTION, ex_GEAS_UnknownField, exception);
   }

void
make_ReadOnlyField_exception(CORBA_Environment * ev, char *format, ...)
   {
   GEAS_ReadOnlyField *exception = GEAS_ReadOnlyField__alloc();

      va_list args;
      char *buf;

      trace_functioncall();

      va_start( args , format );
      buf = g_strdup_vprintf( format , args );
      exception->detail = CORBA_string_dup(buf);
      g_free( buf );
      va_end( args );

      showdetail("ReadOnlyField");
      CORBA_exception_set(ev, CORBA_USER_EXCEPTION, ex_GEAS_ReadOnlyField, exception);
   }

void
make_NotReferenceField_exception(CORBA_Environment * ev, char *format, ...)
   {
   GEAS_NotReferenceField *exception = GEAS_NotReferenceField__alloc();

      va_list args;
      char *buf;

      trace_functioncall();

      va_start( args , format );
      buf = g_strdup_vprintf( format , args );
      exception->detail = CORBA_string_dup(buf);
      g_free( buf );
      va_end( args );

      showdetail("NotReferenceField");
      CORBA_exception_set(ev, CORBA_USER_EXCEPTION, ex_GEAS_NotReferenceField, exception);
   }

void
make_NotDataField_exception(CORBA_Environment * ev, char *format, ...)
   {
   GEAS_NotDataField *exception = GEAS_NotDataField__alloc();

      va_list args;
      char *buf;

      trace_functioncall();

      va_start( args , format );
      buf = g_strdup_vprintf( format , args );
      exception->detail = CORBA_string_dup(buf);
      g_free( buf );
      va_end( args );

      showdetail("NotDataField");
      CORBA_exception_set(ev, CORBA_USER_EXCEPTION, ex_GEAS_NotDataField, exception);
   }

void
make_NotSupported_exception(CORBA_Environment * ev, char *format, ...)
   {
   GEAS_NotSupported *exception = GEAS_NotSupported__alloc();

      va_list args;
      char *buf;

      trace_functioncall();

      va_start( args , format );
      buf = g_strdup_vprintf( format , args );
      exception->detail = CORBA_string_dup(buf);
      g_free( buf );
      va_end( args );

      showdetail("NotSupported");
      CORBA_exception_set(ev, CORBA_USER_EXCEPTION, ex_GEAS_NotSupported, exception);
   }

void
make_NotReadable_exception(CORBA_Environment * ev, char *format, ...)
   {
   GEAS_NotReadable *exception = GEAS_NotReadable__alloc();

      va_list args;
      char *buf;

      trace_functioncall();

      va_start( args , format );
      buf = g_strdup_vprintf( format , args );
      exception->detail = CORBA_string_dup(buf);
      g_free( buf );
      va_end( args );

      showdetail("NotReadable");
      CORBA_exception_set(ev, CORBA_USER_EXCEPTION, ex_GEAS_NotReadable, exception);
   }

void
make_NotWriteable_exception(CORBA_Environment * ev, char *format, ...)
   {
   GEAS_NotWriteable *exception = GEAS_NotWriteable__alloc();

      va_list args;
      char *buf;

      trace_functioncall();

      va_start( args , format );
      buf = g_strdup_vprintf( format , args );
      exception->detail = CORBA_string_dup(buf);
      g_free( buf );
      va_end( args );

      showdetail("NotWriteable");
      CORBA_exception_set(ev, CORBA_USER_EXCEPTION, ex_GEAS_NotWriteable, exception);
   }

void
make_NotAuthenticated_exception(CORBA_Environment * ev, char *format, ...)
   {
   GEAS_NotAuthenticated *exception = GEAS_NotAuthenticated__alloc();

      va_list args;
      char *buf;

      trace_functioncall();

      va_start( args , format );
      buf = g_strdup_vprintf( format , args );
      exception->detail = CORBA_string_dup(buf);
      g_free( buf );
      va_end( args );

      showdetail("NotAuthenticated");
      CORBA_exception_set(ev, CORBA_USER_EXCEPTION, ex_GEAS_NotAuthenticated, exception);
   }

void
make_AuthenticationError_exception(CORBA_Environment * ev, char *format, ...)
   {
   GEAS_AuthenticationError *exception = GEAS_AuthenticationError__alloc();

      va_list args;
      char *buf;

      trace_functioncall();

      va_start( args , format );
      buf = g_strdup_vprintf( format , args );
      exception->detail = CORBA_string_dup(buf);
      g_free( buf );
      va_end( args );

      showdetail("AuthenticationError");
      CORBA_exception_set(ev, CORBA_USER_EXCEPTION, ex_GEAS_AuthenticationError, exception);
   }

void
make_WrongType_exception(CORBA_Environment * ev, char *format, ...)
   {
   GEAS_WrongType *exception = GEAS_WrongType__alloc();

      va_list args;
      char *buf;

      trace_functioncall();

      va_start( args , format );
      buf = g_strdup_vprintf( format , args );
      exception->detail = CORBA_string_dup(buf);
      g_free( buf );
      va_end( args );

      showdetail("WrongType");
      CORBA_exception_set(ev, CORBA_USER_EXCEPTION, ex_GEAS_WrongType, exception);
   }

void
make_WrongClass_exception(CORBA_Environment * ev, char *format, ...)
   {
   GEAS_WrongClass *exception = GEAS_WrongClass__alloc();

      va_list args;
      char *buf;

      trace_functioncall();

      va_start( args , format );
      buf = g_strdup_vprintf( format , args );
      exception->detail = CORBA_string_dup(buf);
      g_free( buf );
      va_end( args );

      showdetail("WrongClass");
      CORBA_exception_set(ev, CORBA_USER_EXCEPTION, ex_GEAS_WrongClass, exception);
   }

void
make_Locked_exception(CORBA_Environment * ev, char *format, ...)
   {
   GEAS_Locked *exception = GEAS_Locked__alloc();

      va_list args;
      char *buf;

      trace_functioncall();

      va_start( args , format );
      buf = g_strdup_vprintf( format , args );
      exception->detail = CORBA_string_dup(buf);
      g_free( buf );
      va_end( args );

      showdetail("Locked");
      CORBA_exception_set(ev, CORBA_USER_EXCEPTION, ex_GEAS_Locked, exception);
   }

void
make_TransactionNotInProgress_exception(CORBA_Environment * ev, char *format, ...)
   {
   GEAS_TransactionNotInProgress *exception = GEAS_TransactionNotInProgress__alloc();

      va_list args;
      char *buf;

      trace_functioncall();

      va_start( args , format );
      buf = g_strdup_vprintf( format , args );
      exception->detail = CORBA_string_dup(buf);
      g_free( buf );
      va_end( args );

      showdetail("TransactionNotInProgress");
      CORBA_exception_set(ev, CORBA_USER_EXCEPTION, ex_GEAS_TransactionNotInProgress, exception);
   }

void
make_Interrupted_exception(CORBA_Environment * ev, char *format, ...)
   {
   GEAS_Interrupted *exception = GEAS_Interrupted__alloc();

      va_list args;
      char *buf;

      trace_functioncall();

      va_start( args , format );
      buf = g_strdup_vprintf( format , args );
      exception->detail = CORBA_string_dup(buf);
      g_free( buf );
      va_end( args );

      showdetail("Interrupted");
      CORBA_exception_set(ev, CORBA_USER_EXCEPTION, ex_GEAS_Interrupted, exception);
   }

void
make_OutOfBounds_exception(CORBA_Environment * ev, char *format, ...)
   {
   GEAS_OutOfBounds *exception = GEAS_OutOfBounds__alloc();

      va_list args;
      char *buf;

      trace_functioncall();

      va_start( args , format );
      buf = g_strdup_vprintf( format , args );
      exception->detail = CORBA_string_dup(buf);
      g_free( buf );
      va_end( args );

      showdetail("OutOfBounds");
      CORBA_exception_set(ev, CORBA_USER_EXCEPTION, ex_GEAS_OutOfBounds, exception);
   }

void
make_NotLookupField_exception(CORBA_Environment * ev, char *format, ...)
   {
   GEAS_NotLookupField *exception = GEAS_NotLookupField__alloc();

      va_list args;
      char *buf;

      trace_functioncall();

      va_start( args , format );
      buf = g_strdup_vprintf( format , args );
      exception->detail = CORBA_string_dup(buf);
      g_free( buf );
      va_end( args );

      showdetail("NotLookupField");
      CORBA_exception_set(ev, CORBA_USER_EXCEPTION, ex_GEAS_NotLookupField, exception);
   }

void
make_FilterNotSet_exception(CORBA_Environment * ev, char *format, ...)
   {
   GEAS_FilterNotSet *exception = GEAS_FilterNotSet__alloc();

      va_list args;
      char *buf;

      trace_functioncall();

      va_start( args , format );
      buf = g_strdup_vprintf( format , args );
      exception->detail = CORBA_string_dup(buf);
      g_free( buf );
      va_end( args );

      showdetail("FilterNotSet");
      CORBA_exception_set(ev, CORBA_USER_EXCEPTION, ex_GEAS_FilterNotSet, exception);
   }

void
make_NullField_exception(CORBA_Environment * ev, char *format, ...)
   {
   GEAS_NullField *exception = GEAS_NullField__alloc();
      va_list args;
      char *buf;

      trace_functioncall();

      va_start( args , format );
      buf = g_strdup_vprintf( format , args );
      exception->detail = CORBA_string_dup(buf);
      g_free( buf );
      va_end( args );

      showdetail("NullField");
      CORBA_exception_set(ev, CORBA_USER_EXCEPTION, ex_GEAS_NullField, exception);
   }

void
make_InvalidArgument_exception(CORBA_Environment * ev, char *format, ...)
   {
   GEAS_InvalidArgument *exception = GEAS_InvalidArgument__alloc();

      va_list args;
      char *buf;

      trace_functioncall();

      va_start( args , format );
      buf = g_strdup_vprintf( format , args );
      exception->detail = CORBA_string_dup(buf);
      g_free( buf );
      va_end( args );

      showdetail("InvalidArgument");
      CORBA_exception_set(ev, CORBA_USER_EXCEPTION, ex_GEAS_InvalidArgument, exception);
   }

void
make_RollbackFailed_exception(CORBA_Environment * ev, char *format, ...)
   {
   GEAS_RollbackFailed *exception = GEAS_RollbackFailed__alloc();

      va_list args;
      char *buf;

      trace_functioncall();

      va_start( args , format );
      buf = g_strdup_vprintf( format , args );
      exception->detail = CORBA_string_dup(buf);
      g_free( buf );
      va_end( args );

      showdetail("RollbackFailed");
      CORBA_exception_set(ev, CORBA_USER_EXCEPTION, ex_GEAS_RollbackFailed, exception);
   }

void
make_CommitFailed_exception(CORBA_Environment * ev, char *format, ...)
   {
   GEAS_CommitFailed *exception = GEAS_CommitFailed__alloc();

      va_list args;
      char *buf;

      trace_functioncall();

      va_start( args , format );
      buf = g_strdup_vprintf( format , args );
      exception->detail = CORBA_string_dup(buf);
      g_free( buf );
      va_end( args );

      showdetail("CommitFailed");
      CORBA_exception_set(ev, CORBA_USER_EXCEPTION, ex_GEAS_CommitFailed, exception);
   }

void
make_TransactionInProgress_exception(CORBA_Environment * ev, char *format, ...)
   {
   GEAS_TransactionInProgress *exception = GEAS_TransactionInProgress__alloc();

      va_list args;
      char *buf;

      trace_functioncall();

      va_start( args , format );
      buf = g_strdup_vprintf( format , args );
      exception->detail = CORBA_string_dup(buf);
      g_free( buf );
      va_end( args );

      showdetail("TransactionInProgress");
      CORBA_exception_set(ev, CORBA_USER_EXCEPTION, ex_GEAS_TransactionInProgress, exception);
   }

void
make_NotListField_exception(CORBA_Environment * ev, char *format, ...)
   {
   GEAS_NotListField *exception = GEAS_NotListField__alloc();

      va_list args;
      char *buf;

      trace_functioncall();

      va_start( args , format );
      buf = g_strdup_vprintf( format , args );
      exception->detail = CORBA_string_dup(buf);
      g_free( buf );
      va_end( args );

      showdetail("NotListField");
      CORBA_exception_set(ev, CORBA_USER_EXCEPTION, ex_GEAS_NotListField, exception);
   }

void
make_UnknownMethod_exception(CORBA_Environment * ev, char *format, ...)
   {
   GEAS_UnknownMethod *exception = GEAS_UnknownMethod__alloc();

      va_list args;
      char *buf;

      trace_functioncall();

      va_start( args , format );
      buf = g_strdup_vprintf( format , args );
      exception->detail = CORBA_string_dup(buf);
      g_free( buf );
      va_end( args );

      showdetail("UnknownMethod");
      CORBA_exception_set(ev, CORBA_USER_EXCEPTION, ex_GEAS_UnknownMethod, exception);
   }

void make_ArgumentCount_exception(CORBA_Environment * ev, 
				  int expected , int received , char *format , ... )
{
   GEAS_ArgumentCount *exception = GEAS_ArgumentCount__alloc();

      va_list args;
      char *buf;

      trace_functioncall();

      va_start( args , format );
      buf = g_strdup_vprintf( format , args );
      exception->detail = CORBA_string_dup(buf);
      g_free( buf );
      va_end( args );

      showdetail("ArgumentCount");
      CORBA_exception_set(ev, CORBA_USER_EXCEPTION, ex_GEAS_ArgumentCount, exception);
}

void
make_MethodError_exception(CORBA_Environment * ev, char *format, ...)
   {
   GEAS_MethodError *exception = GEAS_MethodError__alloc();

      va_list args;
      char *buf;

      trace_functioncall();

      va_start( args , format );
      buf = g_strdup_vprintf( format , args );
      exception->detail = CORBA_string_dup(buf);
      g_free( buf );
      va_end( args );

      showdetail("MethodError");
      CORBA_exception_set(ev, CORBA_USER_EXCEPTION, ex_GEAS_MethodError, exception);
   }

void
make_UnknownFeature_exception(CORBA_Environment * ev, char *format, ...)
   {
   GEAS_UnknownFeature *exception = GEAS_UnknownFeature__alloc();

      va_list args;
      char *buf;

      trace_functioncall();

      va_start( args , format );
      buf = g_strdup_vprintf( format , args );
      exception->detail = CORBA_string_dup(buf);
      g_free( buf );
      va_end( args );

      showdetail("UnknownFeature");
      CORBA_exception_set(ev, CORBA_USER_EXCEPTION, ex_GEAS_UnknownFeature, exception);
   }

void
make_Format_exception(CORBA_Environment * ev, char *format, ...)
   {
   GEAS_Format *exception = GEAS_Format__alloc();

      va_list args;
      char *buf;

      trace_functioncall();

      va_start( args , format );
      buf = g_strdup_vprintf( format , args );
      exception->detail = CORBA_string_dup(buf);
      g_free( buf );
      va_end( args );

      showdetail("Format");
      CORBA_exception_set(ev, CORBA_USER_EXCEPTION, ex_GEAS_Format, exception);
   }

/** \brief Convert a user exception in a CORBA_Environment variable to an integer.
 * The main purpose of this function is to provide an integer ID that identifies
 * the exception for use in switch statements in server code that needs to react
 * to exceptions. It only handles GEAS specific user exceptions - all other exceptions
 * return GEAS_EXCEPTIONID_unknown
 */
int get_user_exception_id( CORBA_Environment * ev )
{
   if( ev->_major == CORBA_NO_EXCEPTION )
     return( GEAS_EXCEPTIONID_NONE );
   if( ev->_major == CORBA_SYSTEM_EXCEPTION )
     return( GEAS_EXCEPTIONID_SYSTEM );

   if( strcmp(ev->_repo_id,ex_GEAS_ServerError) == 0 ) return( GEAS_EXCEPTIONID_ServerError );
   if( strcmp(ev->_repo_id,ex_GEAS_NotSupported) == 0 ) return( GEAS_EXCEPTIONID_NotSupported );
   if( strcmp(ev->_repo_id,ex_GEAS_NotAuthenticated) == 0 ) return( GEAS_EXCEPTIONID_NotAuthenticated );
   if( strcmp(ev->_repo_id,ex_GEAS_AuthenticationError) == 0 ) return( GEAS_EXCEPTIONID_AuthenticationError );
   if( strcmp(ev->_repo_id,ex_GEAS_UnknownClass) == 0 ) return( GEAS_EXCEPTIONID_UnknownClass );

   if( strcmp(ev->_repo_id,ex_GEAS_UnknownField) == 0 ) return( GEAS_EXCEPTIONID_UnknownField );
   if( strcmp(ev->_repo_id,ex_GEAS_UnknownFeature) == 0 ) return( GEAS_EXCEPTIONID_UnknownFeature );
   if( strcmp(ev->_repo_id,ex_GEAS_MethodError) == 0 ) return( GEAS_EXCEPTIONID_MethodError );
   if( strcmp(ev->_repo_id,ex_GEAS_UnknownMethod) == 0 ) return( GEAS_EXCEPTIONID_UnknownMethod );
   if( strcmp(ev->_repo_id,ex_GEAS_ArgumentCount) == 0 ) return( GEAS_EXCEPTIONID_ArgumentCount );

   if( strcmp(ev->_repo_id,ex_GEAS_ReadOnlyField) == 0 ) return( GEAS_EXCEPTIONID_ReadOnlyField );
   if( strcmp(ev->_repo_id,ex_GEAS_NotReferenceField) == 0 ) return( GEAS_EXCEPTIONID_NotReferenceField );
   if( strcmp(ev->_repo_id,ex_GEAS_NotListField) == 0 ) return( GEAS_EXCEPTIONID_NotListField );
   if( strcmp(ev->_repo_id,ex_GEAS_NotLookupField) == 0 ) return( GEAS_EXCEPTIONID_NotLookupField );
   if( strcmp(ev->_repo_id,ex_GEAS_NotReadable) == 0 ) return( GEAS_EXCEPTIONID_NotReadable );

   if( strcmp(ev->_repo_id,ex_GEAS_NotWriteable) == 0 ) return( GEAS_EXCEPTIONID_NotWriteable );
   if( strcmp(ev->_repo_id,ex_GEAS_NotDataField) == 0 ) return( GEAS_EXCEPTIONID_NotDataField );
   if( strcmp(ev->_repo_id,ex_GEAS_NullField) == 0 ) return( GEAS_EXCEPTIONID_NullField );
   if( strcmp(ev->_repo_id,ex_GEAS_WrongType) == 0 ) return( GEAS_EXCEPTIONID_WrongType );
   if( strcmp(ev->_repo_id,ex_GEAS_WrongClass) == 0 ) return( GEAS_EXCEPTIONID_WrongClass );

   if( strcmp(ev->_repo_id,ex_GEAS_Locked) == 0 ) return( GEAS_EXCEPTIONID_Locked );
   if( strcmp(ev->_repo_id,ex_GEAS_TransactionNotInProgress) == 0 ) return( GEAS_EXCEPTIONID_TransactionNotInProgress );
   if( strcmp(ev->_repo_id,ex_GEAS_TransactionInProgress) == 0 ) return( GEAS_EXCEPTIONID_TransactionInProgress );
   if( strcmp(ev->_repo_id,ex_GEAS_CommitFailed) == 0 ) return( GEAS_EXCEPTIONID_CommitFailed );
   if( strcmp(ev->_repo_id,ex_GEAS_RollbackFailed) == 0 ) return( GEAS_EXCEPTIONID_RollbackFailed );

   if( strcmp(ev->_repo_id,ex_GEAS_Interrupted) == 0 ) return( GEAS_EXCEPTIONID_Interrupted );
   if( strcmp(ev->_repo_id,ex_GEAS_InvalidArgument) == 0 ) return( GEAS_EXCEPTIONID_InvalidArgument );
   if( strcmp(ev->_repo_id,ex_GEAS_OutOfBounds) == 0 ) return( GEAS_EXCEPTIONID_OutOfBounds );
   if( strcmp(ev->_repo_id,ex_GEAS_FilterNotSet) == 0 ) return( GEAS_EXCEPTIONID_FilterNotSet );
   if( strcmp(ev->_repo_id,ex_GEAS_Format) == 0 ) return( GEAS_EXCEPTIONID_Format );

   return( GEAS_EXCEPTIONID_UNKNOWN );
}
