
/* 
   collectiondata.h
   
   Part of GNU Enterprise Application Server (GEAS)

   Copyright (C) 2001 Free Software Foundation

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
   
   $Id: collectiondata.h,v 1.6 2001/06/09 23:06:40 ntiffin Exp $
*/

#ifndef COLLECTIONDATA_H
#define COLLECTIONDATA_H

#include <glib.h>
#include "geas-skeleton.h"
#include "oql/oql.h"

/* manage collections of business objects in GEAS */

/** \brief Get data. */
unsigned long int     object_collection_length (const char *holderid);
const char           *object_collection_classname (const char *holderid);
const char           *object_collection_object (const char *holderid,
                                                unsigned long int index);

/** \brief Once a connection isn't needed, delete it. */
void                  free_object_collection (const char *holderid);

/** \brief Fill an object collection with data */
/* NOTE: query must provide object key as a string in field 'objectid' */
/* returns the ID of the new listholder object */
char                 *new_object_collection_from_query (QueryData * query,
                                                        GEAS_object_reference
                                                        * id,
                                                        CORBA_Environment *
                                                        ev);

#ifdef SELF_TEST
void                  self_test_objectcontainer (void);
#endif

#endif /* COLLECTIONDATA_H */
