/* 
   gcardscheme - GNOME applet to control PCMCIA card schemes

   Copyright (C) 2000 Brian Bassett

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

*/

#include "config.h"
#include <gnome.h>
#include <applet-widget.h>

#include "interface.h"
#include "support.h"

char scheme_list[512] = { '\0' };
char curr_scheme[32] = { '\0' };

GtkWidget *choice;

void
populate (GtkCList *list)
{
    gchar **split = g_strsplit (scheme_list, ",", 0);
    int i;

    for (i = 0; split[i] != NULL; i++)
    {
    	gchar *adding[] = { split[i], NULL };
	gtk_clist_append (GTK_CLIST(list), adding);
    }

    g_strfreev (split);
}

void
depopulate (GtkCList *list)
{
    int i = 0;
    gchar *text;
    
    strcpy (scheme_list, "");

    while (gtk_clist_get_text (GTK_CLIST(list), i, 0, &text) == 1)
    {
	if (i != 0)
	    strcat (scheme_list, ",");
	strcat (scheme_list, text);
	i++;
    }
}

gint
save_session (GtkWidget *w, const char *privcfg, const char *globcfg)
{
    gnome_config_push_prefix (privcfg);
    gnome_config_set_string ("config/schemes", scheme_list);
    gnome_config_pop_prefix ();
    gnome_config_sync ();
    gnome_config_drop_all ();
    return FALSE;
}

extern int list_selected;

void
choice_clicked (GtkButton *button, gpointer data)
{
    GtkWidget *d = create_select ();
    GtkWidget *l = lookup_widget (d, "list");
    populate (GTK_CLIST(l));
    list_selected = -1;
    gtk_widget_show (d);
}

static void
schemes (AppletWidget *applet, gpointer data)
{
    GtkWidget *d = create_add_remove ();
    GtkWidget *l = lookup_widget (d, "list");
    populate (GTK_CLIST(l));
    list_selected = -1;
    gtk_widget_show (d);
}

static void
about (AppletWidget *applet, gpointer data)
{
    GtkWidget * about = create_about ();
    gtk_widget_show (about);
}

int
main (int argc, char **argv)
{
    GtkWidget *applet;
    GtkWidget *frame;
    GtkWidget *box;
    GtkWidget *label;
    gchar *string;
    gboolean deflt;
    FILE *pipe;

    /* Initialize I18N */
    bindtextdomain (PACKAGE, GNOMELOCALEDIR);
    textdomain (PACKAGE);

    /* Intialize the applet */
    applet_widget_init ("gcardscheme", NULL, argc, argv, NULL, 0, NULL);

    /* Create the applet widget */
    applet = applet_widget_new ("gcardscheme");
    if (!applet)
	g_error ("Can't create applet!\n");

    /* Read schemes from config */
    gnome_config_push_prefix (APPLET_WIDGET(applet)->privcfgpath);
    string = gnome_config_get_string_with_default ("config/schemes", &deflt);
    if (deflt)
	strcpy (scheme_list, "default");
    else
	strcpy (scheme_list, string);
    g_free (string);
    gnome_config_pop_prefix ();

    /* Determine the current scheme */
    pipe = popen (CARDCTL " scheme", "r");
    if (!pipe)
	g_error ("Can't determine current scheme!\n");
    fscanf (pipe, "Current scheme: '%s", curr_scheme);
    g_strdelimit (curr_scheme, "'", '\0');
    pclose (pipe);
    
    /* Populate the applet */
    frame = gtk_frame_new (NULL);
    gtk_widget_ref (frame);
    gtk_widget_show (frame);
    gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_IN);
    box = gtk_vbox_new (FALSE, 0);
    gtk_widget_ref (box);
    gtk_widget_show (box);
    gtk_container_add (GTK_CONTAINER (frame), box);
    gtk_container_set_border_width (GTK_CONTAINER (box), 3);
    label = gtk_label_new (_("PC Card"));
    gtk_widget_ref (label);
    gtk_widget_show (label);
    gtk_box_pack_start (GTK_BOX (box), label, FALSE, FALSE, 0);
    choice = gtk_button_new_with_label (curr_scheme);
    gtk_widget_ref (choice);
    gtk_widget_show (choice);
    gtk_box_pack_start (GTK_BOX (box), choice, FALSE, FALSE, 0);
    gtk_signal_connect (GTK_OBJECT (choice), "clicked",
            GTK_SIGNAL_FUNC (choice_clicked),
            NULL);
    applet_widget_add (APPLET_WIDGET(applet), frame);
    gtk_widget_show (applet);

    /* Register about box */
    applet_widget_register_stock_callback (APPLET_WIDGET(applet),
	    "about", GNOME_STOCK_MENU_ABOUT, _("About"), about, NULL);

    /* Register handler for adding schemes */
    applet_widget_register_stock_callback (APPLET_WIDGET(applet),
	    "schemes", GNOME_STOCK_MENU_PREF, _("Schemes..."),
	    schemes, NULL);
    
    /* Bind to the session save signal */
    gtk_signal_connect (GTK_OBJECT(applet), "save_session",
	    GTK_SIGNAL_FUNC(save_session), NULL);
    
    /* Applet main loop */
    applet_widget_gtk_main ();

    return 0;
}

