/*
 * g5 - GTK 5 in row.
 * Copyright (c) 1999, Eyal Lotem and Yair Chuchem.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.
 */

#include <string.h>
#include <stdlib.h>
#include <glib.h>

#include "game.h"
#include "coordinate.h"
#include "gui/guiinterface.h"
#include "ai/aiinterface.h"
#include "history.h"
#include "rules.h"
#include "version.h"

#define GAME_PLAYER0_NAME "Joe"
#define GAME_PLAYER1_NAME "Wogo"

int turn = 0, e_turn = 0;
PlayerType current_player = PLAYER_HUMAN;
Square game_winner = NONE;
const char _player_char[3] = "-OX";

GlobalOptions global_options = {0, FALSE, TRUE};
PlayerOptions player_options[2] = {
	{0, NULL, PLAYER_HUMAN, {3}},
	{0, NULL, PLAYER_AI, {3}}
};
Square board[BOARD_XSIZE][BOARD_YSIZE];

void _game_clear_board(void)
{
	memset(board, 0, sizeof(board));
}

void game_play(void)
{
	current_player = player_options[e_turn].pt;
	if(current_player == PLAYER_AI)
		ai_move(history_move_get(turn - 1), history_move_get(turn - 2), turn, e_turn);
}

void score_init(void)
{
	player_options[0].score = player_options[1].score = 0;
}

void game_init(void)
{
	_game_clear_board();
	gui_score_update();
	gui_board_clear();
	ai_break();
	game_winner = NONE;
	turn = 0;
	e_turn = global_options.starter;
	current_player = player_options[e_turn].pt;
}

void game_init_play(void)
{
	game_init();
	game_play();
}

void game_move_make(Coordinate *move)
{
	Coordinate *last_move = history_move_get(turn - 1);

	ARRAY_COOR(board, *move) = 1+e_turn;
	if(turn)
		gui_board_square_set_normal(last_move, ARRAY_COOR(board, *last_move) - 1);
	gui_board_square_set_last(move, e_turn);
	if(rules_win_test(move, 1+e_turn)) {
		player_options[e_turn].score++;
		if(global_options.clear_board)
			game_init_play();
		else {
			game_winner = 1+e_turn;
			gui_show_win(move);
			current_player = -1;
			turn++;
			e_turn ^= 1;
		}
	} else {
		turn++;
		e_turn ^= 1;
		/* The whole board was filled up */
		if(turn == BOARD_XSIZE * BOARD_YSIZE) {
			game_winner = -1; /* TIE */
			gui_show_win(NULL);
			return;
		}
		game_play();
	}
}

/* game_square_modify - A function that handles a move made by any player.
 */
void game_square_modify(Coordinate *move, PlayerType mover)
{
	if(mover == current_player && game_winner == NONE) {
		history_move_register(move);
		game_move_make(move);
	}
}

void title_show(void)
{
	g_print("%s (%s) by Eyal Lotem and Yair Chuchem.\n", GAME_NAME, VERSION);
}

int _init_main(void)
{
	title_show();

	player_options[0].name = strdup(GAME_PLAYER0_NAME);
	player_options[1].name = strdup(GAME_PLAYER1_NAME);

	return 0;
}

int main(int argc, char *argv[])
{
	if((_init_main() < 0) || (gui_init(&argc, &argv) < 0) || (ai_init(&argc, &argv) < 0))
		return -1;
	gui_main();
	ai_break(); /* If AI thinking process exists, kill it */

	return 0;
}
