const Fission = {
	mPrefBranch: Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("extensions.fission.").QueryInterface(Components.interfaces.nsIPrefBranch2),

/* ........ (Un)initialization .............. */

	onLoad: function()
	{
		if (!window.gProgressMeterPanel)
		{
			setTimeout(function() { Fission.onLoad(); }, 100);
			return;
		}
		this.init();
		
		document.getElementById("cmd_CustomizeToolbars").addEventListener("DOMAttrModified", this.onDOMAttrModified_command, false);
		getBrowser().tabContainer.addEventListener("TabSelect", this.onTabSelect_tabContainer, false);
		this.mPrefBranch.addObserver("", this, false);
		
		if (/onProgressChange\([^,]+, 0/.test(XULBrowserWindow.onUpdateCurrentBrowser))
		{ /* fix for Mozilla bug 477261 */
			eval("XULBrowserWindow.onUpdateCurrentBrowser = " + XULBrowserWindow.onUpdateCurrentBrowser.toString().replace(/onProgressChange\(.*?,/, "$& null, ").replace("if (loadingDone)", "if (gProgressCollapseTimer) { gProgressMeterPanel.collapsed = true; clearTimeout(gProgressCollapseTimer); gProgressCollapseTimer = null; } $&"));
			eval("gBrowser.updateCurrentBrowser = " + gBrowser.updateCurrentBrowser.toString().replace("p.onStateChange(", 'if (!("onUpdateCurrentBrowser" in p)) $&'));
		}
	},

	onUnload: function()
	{
		document.getElementById("cmd_CustomizeToolbars").removeEventListener("DOMAttrModified", this.onDOMAttrModified_command, false);
		gBrowser.tabContainer.removeEventListener("TabSelect", this.onTabSelect_tabContainer, false);
		this.mPrefBranch.removeObserver("", this);
		
		this.uninit();
		
		this.mProgressPanel = null;
		this.mProgressBar = null;
		this.mText = null;
	},

	init: function()
	{
		if (!this.mProgressPanel)
		{
			this.mProgressPanel = gProgressMeterPanel;
		}
		if (!gURLBar && !((gURLBar = document.getElementById("urlbar"))))
		{
			return;
		}
		this.mProgressBar = document.getElementById("statusbar-icon");
		
		let iconize = this.mPrefBranch.getBoolPref("iconize");
		if (iconize)
		{
			let iconBox = document.getElementById("urlbar-icons") || document.getElementById("lock-icon").parentNode;
			iconBox.insertBefore(this.mProgressBar, iconBox.firstChild);
		}
		else
		{
			gURLBar.appendChild(this.mProgressBar);
		}
		if (this.mPrefBranch.getBoolPref("textify"))
		{
			this.textify();
		}
		if (this.mPrefBranch.getBoolPref("linkify"))
		{
			this.linkify();
		}
		this.updateBackgroundColor();
		
		gProgressMeterPanel.hidden = true;
		gProgressMeterPanel = this;
		
		gURLBar.setAttribute("fission", iconize ? "icon" : "fusion");
		gURLBar.addEventListener("ValueChange", this.onValueChange_urlbar, true);
		if (this.mLinkified || this.mText && this.mText.parentNode)
		{
			gURLBar.addEventListener("focus", this.onFocusBlur_urlbar, true);
			gURLBar.addEventListener("blur", this.onFocusBlur_urlbar, true);
			delete this.mPendingOverLink;
		}
		
		if (Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefBranch).getCharPref("general.skins.selectedSkin") == "classic/1.0")
		{
			let appInfo = Components.classes["@mozilla.org/xre/app-info;1"].getService(Components.interfaces.nsIXULAppInfo).QueryInterface(Components.interfaces.nsIXULRuntime);
			gURLBar.setAttribute("fission-skin", appInfo.OS + appInfo.version);
		}
		
		this.mLoaded = true;
	},

	textify: function()
	{
		if (!this.mText)
		{
			this.mText = document.createElement("label");
			this.mText.setAttribute("id", "fission-status");
			this.mText.setAttribute("crop", "right");
			
			eval("XULBrowserWindow.updateStatusField = " + XULBrowserWindow.updateStatusField.toString().replace(/text =[^;]+;/, "$& if (Fission.updateStatusField(this.status || this.defaultStatus)) text = this.overLink || this.jsStatus || this.jsDefaultStatus;"));
		}
		let iconBox = document.getElementById("urlbar-icons") || document.getElementById("lock-icon").parentNode;
		iconBox.insertBefore(this.mText, iconBox.firstChild);
	},

	linkify: function()
	{
		if (!/Fission/.test(XULBrowserWindow.setOverLink))
		{
			eval("XULBrowserWindow.setOverLink = " + XULBrowserWindow.setOverLink.toString().replace(/{/, "$& link = Fission.setOverLink(link);"));
			if (window.focusAndSelectUrlBar)
			{
				eval("focusAndSelectUrlBar = " + focusAndSelectUrlBar.toString().replace("gURLBar.focus();", 'if (!gURLBar.hasAttribute("focused")) $&'));
			}
			eval("openLocation = " + openLocation.toString().replace("gURLBar.focus();", 'if (!gURLBar.hasAttribute("focused")) $&')); // prevent distracting focus/blur events
		}
		this.mLinkified = true;
	},

	uninit: function()
	{
		if (!this.mLoaded)
		{
			return;
		}
		
		this.updateBackgroundColor(true);
		
		gProgressMeterPanel = this.mProgressPanel;
		gProgressMeterPanel.appendChild(this.mProgressBar);
		gProgressMeterPanel.hidden = false;
		
		gURLBar.setAttribute("fission", "");
		gURLBar.removeEventListener("ValueChange", this.onValueChange_urlbar, true);
		if (this.mLinkified || this.mText && this.mText.parentNode)
		{
			gURLBar.removeEventListener("focus", this.onFocusBlur_urlbar, true);
			gURLBar.removeEventListener("blur", this.onFocusBlur_urlbar, true);
		}
		
		if (this.mText && this.mText.parentNode)
		{
			this.mText.parentNode.removeChild(this.mText);
		}
		this.mLinkified = false;
		
		this.mLoaded = false;
	},

/* ........ State Change Observers .............. */

	set collapsed(aValue)
	{
		if (aValue && this.mProgressBar.value != 100)
		{
			this.mProgressBar.value = 100;
		}
	},

	onValueChange_urlbar: function(aEvent)
	{
		if (aEvent.originalTarget == Fission.mProgressBar)
		{
			this.setAttribute("progress", Fission.mProgressBar.value);
		}
	},

	onFocusBlur_urlbar: function(aEvent)
	{
		if (this.hasAttribute("fission-link"))
		{
			this[aEvent.type == "focus" ? "addEventListener" : "removeEventListener"]("keyup", Fission.onKeyUp_urlbar, false);
		}
		if (!(Fission.mURLBar_focused = aEvent.type == "focus") && "mPendingOverLink" in Fission)
		{
			Fission.setOverLink(Fission.mPendingOverLink);
			delete Fission.mPendingOverLink;
		}
		if (Fission.mText)
		{
			Fission.mText.hidden = Fission.mURLBar_focused;
		}
	},

	onKeyUp_urlbar: function(aEvent)
	{
		if (this.hasAttribute("fission-link") && this.value != this.getAttribute("fission-link"))
		{
			this.removeAttribute("fission-link");
			this.removeEventListener("keyup", arguments.callee, false);
		}
	},

	onDOMAttrModified_command: function(aEvent)
	{
		if (aEvent.attrName == "disabled")
		{
			Fission[aEvent.newValue != "true" ? "init" : "uninit"]();
		}
	},

	onTabSelect_tabContainer: function(aEvent)
	{
		if (Fission.mProgressBar.endAnimation)
		{
			// prevent animation when changing tabs
			let tabListener = gBrowser.mTabListeners[aEvent.originalTarget._tPos] || null;
			let tabProgress = !tabListener || (tabListener.mStateFlags & Components.interfaces.nsIWebProgressListener.STATE_STOP) ? 100 : Math.round(tabListener.mTotalProgress * 100);
			Fission.mProgressBar.endAnimation(tabProgress);
		}
	},

	observe: function(aSubject, aTopic, aData)
	{
		if (aTopic == "nsPref:changed" && this.mLoaded)
		{
			switch (aData)
			{
			case "color":
				this.updateBackgroundColor();
				break;
			case "iconize":
			case "textify":
			case "linkify":
				setTimeout(function() { Fission.uninit(); Fission.init(); }, 0);
				break;
			}
		}
	},

/* ........ Auxiliary Functions .............. */

	updateStatusField: function(aString)
	{
		if (!this.mText || !this.mText.parentNode)
		{
			return false;
		}
		
		aString = aString != gNavigatorBundle.getString("nv_done") ? aString : "";
		if (this.mText.value != aString)
		{
			this.mText.value = aString;
		}
		
		return true;
	},

	setOverLink: function(aLink)
	{
		if (this.mURLBar_focused && (!document.commandDispatcher.focusedElement || document.commandDispatcher.focusedElement == gURLBar))
		{ /* ugly hack for nasty focus issue - see Mozilla bug 408060 */
			content.focus(); gURLBar.focus(); content.focus();
		}
		
		if (this.mURLBar_focused)
		{
			this.mPendingOverLink = aLink;
			return this.mLinkified ? "" : aLink;
		}
		
		if (this.mLinkified && aLink)
		{
			if (!this.mURLBar_value)
			{
				this.mURLBar_value = "@" + gURLBar.value;
			}
			if (gURLBar.getAttribute("fission-link") != aLink)
			{
				gURLBar.setAttribute("fission-link", (gURLBar.value = aLink));
			}
			return "";
		}
		
		if (this.mURLBar_value)
		{
			if (gURLBar.hasAttribute("fission-link") && gURLBar.value == gURLBar.getAttribute("fission-link"))
			{
				gURLBar.value = this.mURLBar_value.substr(1);
			}
			gURLBar.removeAttribute("fission-link");
			delete this.mURLBar_value;
		}
		
		return aLink;
	},

	updateBackgroundColor: function(aReset)
	{
		let chunk = document.getAnonymousElementByAttribute(this.mProgressBar, "class", "progress-bar");
		if (chunk)
		{
			chunk.style.background = !aReset ? this.mPrefBranch.getCharPref("color").replace(/^(url\(.+\)) #[0-9A-F]{6}$/, "$1 repeat-x left center transparent") : "";
		}
	}
};

window.addEventListener("load", function() { Fission.onLoad(); }, false);
window.addEventListener("unload", function() { Fission.onUnload(); }, false);
