/*
 * Copyright (C) 2000-2001 Chris Ross and Evan Webb
 * Copyright (C) 1999-2000 Chris Ross
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to
 * deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *   
 * The above copyright notice and this permission notice shall be included in
 * all copies of the Software, its documentation and marketing & publicity 
 * materials, and acknowledgment shall be given in the documentation, materials
 * and software packages that this Software was used.
 *    
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER 
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifndef __FERITE_GLOBALS_H__
#define __FERITE_GLOBALS_H__

extern int __ferite_call_level;
extern FeriteEnvironment *genv;
extern int show_debug;
extern int hide_mem_use;
extern FeriteVariable *ARGV;

extern void  (*__ferite_memory_init)(void);
extern void  (*__ferite_memory_deinit)(void);
extern void *(*__ferite_malloc)( size_t size, char *name, int line );
extern void *(*__ferite_calloc)( size_t size, size_t blk_size, char *name, int line );
extern void *(*__ferite_realloc)( void *ptr, size_t size );
extern void  (*__ferite_free)( void *ptr, char *file, int line );

/* these allow you to tweak the size of hashes */

#define FE_ARRAY_DEFAULT_SIZE            32

#define FE_CLASS_VARIABLE_HASH_SIZE      15
#define FE_CLASS_FUNCTION_HASH_SIZE      15

#define FE_COMPILER_INTERNAL_STACK_SIZE  20

#define FE_EXECUTOR_STACK_SIZE           32

#define FE_FUNCTION_PARAMETER_MAX_SIZE   10
#define FE_FUNCTION_OPCODE_INIT_SIZE     50
#define FE_FUNCTION_VARIABLE_SIZE        15 

#define FE_GC_INITIAL_SIZE               50
#define FE_GC_RUN_AFTER_OPS              10000

#define FE_NAMESPACE_INIT_SIZE           32

#define FE_SCANNER_STACK_SIZE            10

#define FE_SCRIPT_TOP_LEVEL_NS_SIZE      32
#define FE_SCRIPT_EXEC_STACK_SIZE        32

#define FE_SEARCH_PATH_STACK_SIZE        5

#endif /* __FERITE_GLOBALS_H__ */
