/*
 * fgoptions.h: used to generate the fbgetty_options_t structure
 *
 * fbgetty : a getty for framebuffer 
 * Copyright (C) 2001 Yann Droneaud <ydroneaud@meuh.eu.org>. 
 *
 * fbgetty is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * fbgetty is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
 *
 */

#include <fbgetty/global.h>

/* 
 * please read the README file before modifying this file
 *
 */

/* XXX all entry marked internal will move to context.h */


VARIABLE(int, master); /* is set to TRUE, the current process is fbgetty main
			* fbgetty sub-processes must have this set to FALSE
			* they are not session and process group master 
			* internal
			*/

VARIABLE(char *,tty_device);

VARIABLE(int,   tty_fd);           /* internal */
VARIABLE(int,   tty_number);       /* internal */

#ifdef USE_FRAME_BUFFER
VARIABLE(char *,fb_device);
VARIABLE(int,   fb_fd);            /* internal */
VARIABLE(int,   fb_number);        /* internal */
#endif

/* binary */
VARIABLE(int,   screen_clear);

/* XXX must determine which one will be used
 *  binary value that activate the VT_SWITCH code 
 *  currently unused
 */
VARIABLE(int,   screen_refresh);
VARIABLE(int,   vt_switch);

/* XXX 
 * This one will contain a timeout 
 *	The issue will be redisplayed at 'issue_refresh' interval
 * 0 will be the default
 */
VARIABLE(int,   issue_refresh);

VARIABLE(char *,issue_filename);

VARIABLE(char *,login_prompt);

/*
 * if set the user will blindly type is login name (as for his/her password)
 */
VARIABLE(int,   login_hide);

/*
 * after this timeout, the login typed will be clear/reset
 */
VARIABLE(int,   login_timeout);

VARIABLE(char *,login_program);

/* the name typed at login prompt */
VARIABLE(char *,login_name);       /* internal */

VARIABLE(int,   login_name_valid); /* internal */

/* see src/kbd.c and include/fbgetty/kbd.h for more information */ 
VARIABLE(unsigned int,   leds);
