#include <glib.h>
#include "entity.h"


/* TODO: These should have more checking on their inputs to insure correct *
 * arguments, and that they are within the bounds of the current data etc. */

EBufConst *
enode_get_data (ENode * node)
{
    ECHECK_RETVAL (node != NULL, NULL);

    enode_event_get_data (node);
    return (node->data);
}

/* Set data to a given value, overriding current */
void
enode_set_data (ENode * node, EBuf * data)
{
    ECHECK_RET (node != NULL);
    ECHECK_RET (data != NULL);

    if (!node->data) {
	node->data = ebuf_new_with_ebuf (data);
    } else {
	ebuf_set_to_ebuf (node->data, data);
    }

    enode_event_set_data (node, data);
}

void
enode_insert_data (ENode * node, unsigned long offset, EBuf * data)
{
    ECHECK_RET (node != NULL);

    ECHECK_RET (offset >= 0);

    if (!node->data) {
	node->data = ebuf_new_with_ebuf (data);
    } else {
	ECHECK_RET (offset <= node->data->len);
	ebuf_insert_ebuf (node->data, offset, data);
    }

    enode_event_insert_data (node, offset, data);
}

void
enode_delete_data (ENode * node, unsigned long offset, unsigned long count)
{
    ECHECK_RET (node != NULL);

    if (node->data)
	ebuf_erase (node->data, offset, count);

    enode_event_delete_data (node, offset, count);
}

void
enode_append_data (ENode * node, EBuf * data)
{
    ECHECK_RET (node != NULL);
    ECHECK_RET (data != NULL);

    if (!node->data)
	node->data = ebuf_new_with_ebuf (data);
    else
	ebuf_append_ebuf (node->data, data);

    enode_event_append_data (node, data);
}


