"**************************************************************************
"enCore 3.3.3 to 3.3.4 Patch. 
"Copyright (C) 2003 enCore Open Source Project. All Rights Reserved.
"
"This program is free software; you can redistribute it and/or modify it 
"under the terms of the GNU General Public License as published by the 
"Free Software Foundation; either version 2 of the License, or any later
"version.
"
"It is distributed in the hope that it will be useful, but WITHOUT ANY
"WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS 
"FOR A PARTICULAR PURPOSE. See the GNU General Public License for more 
"details. (http://lingua.utdallas.edu/hw/gpl.html)
"
"You install this code by pasting it into your MOO window. Read the
"instructions and verb code in this file CAREFULLY before you apply the
"patch. You MUST incorporate any changes you have made to verbs that will 
"be affected by this patch BEFORE you apply it, or else your changes WILL 
"BE LOST! 
"
"Commands and verbs MUST be applied in the order they appear in this file.
"Failure to observe these warnings may result in problems and possible 
"damage to your database. Also, to use this patch you must have applied any 
"previous patches BEFORE you apply this one. We recommend that you paste in
"only small portions of the patch at a time so you can check that everything
"is ok as you go along.
"
"BACK UP YOUR DATABASE BEFORE YOU APPLY THIS PATCH!
"
"Jan Rune Holmevik                                           Cynthia Haynes
"Dept. of Humanistic Informatics              School of Arts and Humanities
"University of Bergen                         University of Texas at Dallas
"Sydnesplass 7 HF-bygget                                 PO.Box 830688-JO31
"N-5007 Bergen, Norway                            Richardson, TX 75083-0688
"Email: jan.holmevik@uib.no                    Email: cynthiah@utdallas.edu
"**************************************************************************

@program $login:autoconnect
"=================================================================";
"Copyright (C) 1998-2003, Jan Rune Holmevik and Michel@Achieve";
"This is an auto connect version of $login:connect. User's temporary web access code is used for authentication";
"Secutity update 11/16/03 by Michel@Achieve";
"=================================================================";
" => 0 (for failed connections)";
" => objnum (for successful connections)";
caller == #0 || caller == this || raise(E_PERM);
try
  {name, ?web_access_code = 0} = args;
  name = strsub(name, " ", "_");
except (E_ARGS)
  return 0;
endtry
try
  "=================================================================";
  "=== Is our candidate name invalid?";
  if (!valid(candidate = orig_candidate = this:_match_player(name)))
    raise(E_INVARG, tostr("`", name, "' matches no player name."));
  endif
  "=================================================================";
  "=== Is our candidate unable to connect for generic security";
  "=== reasons (ie clear password, non-player object)?";
  if (`is_clear_property(candidate, "web_access_code") ! E_PROPNF' || !$object_utils:isa(candidate, $player))
    server_log(tostr("FAILED CONNECT: ", name, " (", candidate, ") on ", connection_name(player), $string_utils:connection_hostname(connection_name(player)) in candidate.all_connect_places ? "" | "******"));
    raise(E_INVARG);
  endif
  "=================================================================";
  "=== Check web access code";
  "=================================================================";
  if (typeof(cp = candidate.web_access_code) == STR)
    "=== Candidate requires a password";
    if (web_access_code)
      "=== Candidate requires a password, and one was provided";
      if (strcmp(crypt(cp, web_access_code), web_access_code))
        "=== Candidate requires a password, and one was provided, which was wrong";
        server_log(tostr("FAILED CONNECT: ", name, " (", candidate, ") on ", connection_name(player), $string_utils:connection_hostname(connection_name(player)) in candidate.all_connect_places ? "" | "******"));
        raise(E_INVARG, "Invalid web access code.");
        "=========================================================================";
        " Security update to prevent unauthorized access to with blank web access code";
        "=========================================================================";
        elseif (cp == "")
          msg = tostr("ATTEMPTED SPLOIT (text-based): ", name, " (", candidate, ") on ", connection_name(player), $string_utils:connection_hostname(connection_name(player)) in candidate.all_connect_places ? "" | "******");
          fork (0)
            server_log(msg, 1);
            for p in (connected_players())
              if (p.wizard)
                notify(p, msg);
              endif
            endfor
          endfork
          return 0;
        "----------------- added security code ends here ------------------------";
      else
        "=== Candidate requires a web access code, and one was provided, which was right";
      endif
    else
      return 0;
    endif
  elseif (cp == 0)
    "=== Candidate does not require a password";
  else
    "=== Candidate has a nonstandard password; something's wrong";
    raise(E_INVARG);
  endif
  "=================================================================";
  "=== Is the player locked out?";
  if ($no_connect_message && !candidate.wizard)
    notify(player, $no_connect_message);
    server_log(tostr("REJECTED CONNECT: ", name, " (", candidate, ") on ", connection_name(player)));
    return 0;
  endif
  "=================================================================";
  "Guest login check removed as logins with Xpress are always pre-approved";
  "=================================================================";
  "=== Check newts";
  if (candidate in this.newted)
    if (entry = $list_utils:assoc(candidate, this.temporary_newts))
      if ((uptime = this:uptime_since(entry[2])) > entry[3])
        "Temporary newting period is over.  Remove entry.  Oh, send mail, too.";
        this.temporary_newts = setremove(this.temporary_newts, entry);
        this.newted = setremove(this.newted, candidate);
        fork (0)
          player = this.owner;
          $mail_agent:send_message(player, $newt_log, tostr("automatic @unnewt ", candidate.name, " (", candidate, ")"), {"message sent from $login:connect"});
        endfork
      else
        notify(player, "");
        notify(player, this:temp_newt_registration_string(entry[3] - uptime));
        boot_player(player);
        return 0;
      endif
    else
      notify(player, "");
      notify(player, this:newt_registration_string());
      boot_player(player);
      return 0;
    endif
  endif
  "=================================================================";
  "=== Connection limits based on lag";
  if (!candidate.wizard && !(candidate in this.lag_exemptions) && (howmany = length(connected_players())) >= (max = this:max_connections()) && !$object_utils:connected(candidate))
    notify(player, $string_utils:subst(this.connection_limit_msg, {{"%n", tostr(howmany)}, {"%m", tostr(max)}, {"%l", tostr(this:current_lag())}, {"%t", candidate.last_connect_attempt ? ctime(candidate.last_connect_attempt) | "not recorded"}}));
    if ($object_utils:has_property($local, "mudlist"))
      notify(player, "You may wish to try another MUD while waiting for the MOO to unlag.  Here are a few that we know of:");
      for l in ($local.mudlist:choose(3))
        notify(player, l);
      endfor
    endif
    candidate.last_connect_attempt = time();
    server_log(tostr("CONNECTION LIMIT EXCEEDED: ", name, " (", candidate, ") on ", connection_name(player)));
    boot_player(player);
    return 0;
  endif
  "=================================================================";
  "=== Log the player on!";
  if (candidate != orig_candidate)
    notify(player, tostr("Okay,... ", name, " is in use.  Logging you in as `", candidate.name, "'"));
  endif
  this:record_connection(candidate);
  return candidate;
except (E_INVARG)
  notify(player, "Either that player does not exist, or has a different password.");
  return 0;
endtry
.

@program $httpd:authenticate
"===========================================================";
"Copyright (C) 1999-2003, Jan Rune Holmevik and Michel@Achieve";
"Performs authentication of HTTP requests.";
"Secutity update 11/16/03 by Michel@Achieve";
"===========================================================";
if (caller != $httpd)
  return E_PERM;
endif
{URI, client_headers, form_fields, requested_object, requested_verb, method} = args;
access_granted = display_login_page = 0;
message = cookie = "";
user = $no_one;
if (URI == "")
  if (form_fields != {{}, {}})
    "=========================================";
    "===== New user login. Process login =====";
    "=========================================";
    display_login_page = 1;
    user_info = form_fields;
    user_name = $string_utils:trim(user_info[2][1]) || "";
    password = $string_utils:trim(user_info[2][2]) || "";
    OS = user_info[2][3];
    if (user_name == "guest")
      if (!children($guest))
        "No guest characters has been made yet";
        message = "alert('Sorry, no guest accounts are available in this MOO. Please enter a valid user name and password to log in.');";
      else
        "===================";
        "Process guest login";
        "===================";
        user = $string_utils:match_player("guest");
        if (!valid(user = `user:defer_login(user_name) ! E_VERBNF => user:defer(user_name)'))
          "Guest login failed";
          user = $no_one;
          message = "alert('Sorry, all guest accounts are currently in use. Please try connecting again later.');";
        else
          "Guest login approved";
          {user, cookie, message} = $Xpress_client:initialize_session(user, OS);
          this.total_logins = this.total_logins + 1;
        endif
      endif
    else
      "=========================================";
      "===== Process registered user login =====";
      "=========================================";
      if (valid(user = $string_utils:match_player(user_name)))
        "Valid user name, now check password";
        if (strcmp(crypt(password, user.password), user.password))
          "Password not valid. Alert, and return user to login page";
          user = $no_one;
          message = tostr("alert('The password you entered is invalid. Remember hat passwords are case sensitive. If you have forgot your password, please send an email to ", $network.postmaster, " to receive a new one.');");
        else
          "Valid user and password, create a temporary web password and return the user's home URI";
          {user, cookie, message} = $Xpress_client:initialize_session(user, OS);
          this.total_logins = this.total_logins + 1;
        endif
      else
        "User not found. Alert, and return user to login page";
        user = $no_one;
        message = "alert('The user name you entered is invalid. Please try again.');";
      endif
    endif
  endif
else
  "=====================================================================";
  "== Logged in user is requesting a page.                            ==";
  "== Process client header for cookie information and access code    ==";
  "=====================================================================";
  access_code_found = 0;
  client_headers = $list_utils:reverse(client_headers);
  for line_nr in [1..length(client_headers)]
    line = client_headers[line_nr];
    if (position = index(line, "Access_Code="))
      cookie_data = line[position + 12..$];
      cookie_data = $string_utils:explode(cookie_data);
      user = toobj(cookie_data[1]);
      access_code = cookie_data[2];
      access_code_found = 1;
      break;
    endif
  endfor
  if (!$object_utils:isa(user, $player))
    "======================================================";
    "==    Make sure user is actually a player object    ==";
    "======================================================";
    user = $no_one;
  endif
  if (access_code_found)
    "Check to see if access code is valid";
    if (strcmp(crypt(user.web_access_code, access_code), access_code))
      "============================================================";
      "== Web access code not valid. Check if special conditions ==";
      "== apply so the user can have the page anyway             ==";
      "============================================================";
      if ($encore_web_utils:anonymous_access(requested_object, requested_verb, method))
        access_granted = 1;
      else
        "=====================================================";
        "== Authentication error, access code expired       ==";
        "=====================================================";
        display_login_page = 1;
        message = "alert('Permission denied. Your Xpress access code has expired. Please return to the login page and reconnect.');window.close();";
      endif
    "------------------ Added security code begins --------------------";
    elseif (is_clear_property(user, "web_access_code") || user.web_access_code == "")
      "======================================================================";
      "== S0m3d00d th1nk5 h3 0wnz u5. Log it and pretend we didn't notice. ==";
      "======================================================================";
      msg = tostr("ATTEMPTED SPLOIT (HTTP-based): ", name, " (", candidate, ") on ", connection_name(player), ($string_utils:connection_hostname(connection_name(player)) in candidate.all_connect_places) ? "" | "******");
      fork (0)
        server_log(msg, 1);
        for p in (connected_players())
          if (p.wizard)
            notify(p, msg);
          endif
        endfor
      endfork
      display_login_page = 1;
      message = "alert('Permission denied. Your Xpress access code has expired. Please return to the login page and reconnect.');window.close();";
    "------------------- Added security code ends ---------------------";
    else
      "===========================================";
      "== Valid user and password, grant access ==";
      "===========================================";
      access_granted = 1;
    endif
  else
    if ($encore_web_utils:anonymous_access(requested_object, requested_verb, method))
      "==========================================================";
      "== No web access code was found, but anonymous requests ==";
      "== are enabled so let it pass anyway                    ==";
      "==========================================================";
      access_granted = 1;
    else
      display_login_page = 1;
      "return message that cookie has expired and return user to login";
      message = "alert('Permission denied. You must be logged in to access this object. If you are trying to log in, please enable cookies in your browser.');window.close();";
      boot_player(user);
    endif
  endif
endif
return {access_granted, user, display_login_page, cookie, message};
.

@program $xpress_client:initialize_session
"===========================================================";
"Copyright (C) 1999-2003, Jan Rune Holmevik and Michel@Achieve";
"Initialize enCore Xpress session for user";
"===========================================================";
if (caller != $httpd)
  return E_PERM;
endif
{user, OS} = args;
user.xpress_on = 1;
user.web_access_code = tostr(random());
cookie = tostr(user) + " " + crypt(user.web_access_code);
action = "openXpress();";
if (user.xpress_layout == "vertical_layout" || user.xpress_layout == "vertical_layout_2" || user.xpress_layout == "horizontal_layout")
  user.ts_client = 1;
endif
if (OS == "MacOS" && user.xpress_layout == "vertical_layout")
  user.linelen = 50;
endif
if ($object_utils:has_property($player, "ansi"))
  user.ansi = 0;
endif
if (user.wizard)
  action = action + " alert('For security reasons, using Xpress with wizard accounts is not recommended. Please consider using the standard text interface for your wizard work');";
endif
return {user, cookie, action};
.

;;#0.("core_history") = {{"enCore enCore 3.3.4", "1.8.1", 1069049189}, {"enCore enCore 3.3.3", "1.8.1", 1043507175}, {"enCore 3.3.2", "1.8.1", 1041824617}, {"enCore 3.3.1", "1.8.1", 1040185243}, {"enCore 3.3", "1.8.1", 1040053857}, {"enCore 3.2", "1.8.1", 1001876038}, {"enCore 3.1", "1.8.1", 1000852213}, {"enCore 3.0.2", "1.8.1", 998391691}, {"enCore 3.0.1", "1.8.1", 995638174}, {"enCore 3.0", "1.8.1", 987347897}, {"enCore 2.1.1", "1.8.1", 961336324}, {"enCore 2.1", "1.8.1", 960582191}, {"enCore 2.0.6", "1.8.1", 954635799}, {"enCore 2.0.5", "1.8.1", 953998452}, {"enCore 2.0.4", "1.8.1", 950453897}, {"enCore 2.0.3", "1.8.0r5", 943788625}, {"enCore 2.0.2", "1.8.0r5", 939547732}, {"enCore 2.0.1", "1.8.0r5", 939031601}, {"enCore 2.0", "1.8.0r5", 928255674}, {"enCore 1.1", "1.8.0p6", 908817314}, {"enCore 1.0", "1.8.0p6", 892671137}, "LambdaMOO", "1.8.0p5", 854992537}

@set #0.core_version to "enCore 3.3.4"