/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.parser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import org.emboss.jemboss.parser.AcdVariableResolve;
import org.emboss.jemboss.parser.Dependent;
import org.emboss.jemboss.parser.acd.ApplicationFields;

public class ParseAcd {
    private int numofFields = 0;
    private int numofParams;
    private Vector vappF = new Vector();
    private String svalue;
    private double nvalue;
    private String attr;
    private Dependent[] dep;
    private int numOfDependents;
    private int nsection = 0;
    private int nsubsection = 0;
    private int ntextf;
    private int nint;
    private int nfloat;
    private int nbool;
    private int nseqs;
    private int nflist;
    private int nlist;
    private int mlist;
    private int nrange;
    private Vector listdefault;
    private int nmultiTextField;

    public ParseAcd(String acdText, boolean groups) {
        Vector<ApplicationFields> variables = new Vector<ApplicationFields>();
        int colonPos = 0;
        int braketPos = 0;
        try {
            String line;
            BufferedReader in = new BufferedReader(new StringReader(acdText));
            in.mark(2500);
            while ((line = in.readLine()) != null) {
                int ttype;
                ApplicationFields appF;
                if ((line = line.trim()).startsWith("#") || line.length() == 0) {
                    in.mark(2500);
                    continue;
                }
                colonPos = line.indexOf(58);
                if (colonPos < 0) {
                    colonPos = line.indexOf(61);
                }
                if (colonPos < 0) continue;
                String dataType = line.substring(0, colonPos).toLowerCase();
                if (dataType.equals("toggle")) {
                    dataType = "boolean";
                }
                String param = (braketPos = line.indexOf(91)) >= 0 ? line.substring(colonPos + 1, braketPos).trim() : line.substring(colonPos + 1).trim();
                if (line.startsWith("var:") || line.startsWith("variable")) {
                    param = param.trim();
                    ApplicationFields var = new ApplicationFields();
                    var.setNumberOfParam(2);
                    int ns = param.indexOf(" ");
                    if (ns > -1) {
                        String value = param.substring(0, ns);
                        value = value.replace('\"', ' ').trim();
                        var.setParam(0, dataType, value);
                        value = param.substring(ns);
                        value = value.replace('\"', ' ').trim();
                        var.setParam(1, "value", value);
                    }
                    variables.add(var);
                    in.mark(2500);
                    continue;
                }
                if (line.startsWith("endsection")) {
                    appF = new ApplicationFields();
                    appF.setNumberOfParam(1);
                    appF.setParam(0, dataType, param);
                    ++this.numofFields;
                    this.vappF.add(appF);
                    in.mark(2500);
                    continue;
                }
                if (line.startsWith("section")) {
                    if (param.equals("input") || param.equals("required") || param.equals("output") || param.equals("advanced") || param.equals("additional")) {
                        ++this.nsection;
                    } else {
                        ++this.nsubsection;
                    }
                }
                this.numofParams = 1;
                StreamTokenizer st = new StreamTokenizer(in);
                if (!line.endsWith("[")) {
                    in.reset();
                    st.nextToken();
                    st.nextToken();
                    st.nextToken();
                    st.nextToken();
                }
                in.mark(2500);
                do {
                    ttype = this.parseParam(in, st);
                } while (this.attr != null);
                appF = new ApplicationFields();
                this.vappF.add(appF);
                appF.setNumberOfParam(this.numofParams);
                this.numofParams = 0;
                appF.setParam(this.numofParams, dataType, param.toLowerCase());
                in.reset();
                do {
                    if ((ttype = this.parseParam(in, st)) != -2 && this.attr != null) {
                        if (variables.size() > 0) {
                            this.svalue = this.resolveVariables(variables, this.svalue);
                        }
                        if (this.svalue.indexOf("$") > -1 || this.svalue.indexOf("@") > -1) {
                            this.svalue = this.svalue.toLowerCase();
                        }
                        appF.setParam(this.numofParams, this.attr, this.svalue);
                        continue;
                    }
                    if (ttype != -2) continue;
                    appF.setParam(this.numofParams, this.attr, this.nvalue);
                } while (this.attr != null);
                this.setGuiHandleNumber(dataType, appF);
                ++this.numofFields;
                in.mark(2500);
            }
        }
        catch (IOException e) {
            System.out.println("PareAcd: Parsing acd file error");
        }
    }

    private String resolveVariables(Vector variables, String svalue) {
        String res = svalue;
        Enumeration enumer = variables.elements();
        while (enumer.hasMoreElements()) {
            ApplicationFields var = (ApplicationFields)enumer.nextElement();
            String vName = var.getParamValueStr(0);
            String vValue = var.getParamValueStr(1);
            if (res.indexOf("$") <= -1 && res.indexOf("@") <= -1) continue;
            AcdVariableResolve avresolve = new AcdVariableResolve(res, vName, vValue);
            res = avresolve.getResult();
        }
        return res;
    }

    public int getGuiHandleNumber(int field) {
        ApplicationFields aF = (ApplicationFields)this.vappF.get(field);
        return aF.getGuiHandleNumber();
    }

    public int getNumTextf() {
        return this.ntextf;
    }

    public int getNumNint() {
        return this.nint;
    }

    public int getNumNfloat() {
        return this.nfloat;
    }

    public int getNumBool() {
        return this.nbool;
    }

    public int getNumSeq() {
        return this.nseqs;
    }

    public int getNumFileList() {
        return this.nflist;
    }

    public int getNumList() {
        return this.nlist;
    }

    public int getNumMList() {
        return this.mlist;
    }

    public int getNumRange() {
        return this.nrange;
    }

    public int getNumSection() {
        return this.nsection;
    }

    public int getNumSubsection() {
        return this.nsubsection;
    }

    public String getParameterAttribute(int field, int param) {
        ApplicationFields aF = (ApplicationFields)this.vappF.get(field);
        return aF.getParamAttribute(param);
    }

    public boolean isParamValueStr(int field, int param) {
        ApplicationFields aF = (ApplicationFields)this.vappF.get(field);
        return aF.isParamValueStr(param);
    }

    public String getParamValueStr(int field, int param) {
        ApplicationFields aF = (ApplicationFields)this.vappF.get(field);
        return aF.getParamValueStr(param).trim();
    }

    private void setGuiHandleNumber(String dataType, ApplicationFields appF) {
        if (dataType.startsWith("datafile") || dataType.startsWith("featout") || dataType.startsWith("string") || dataType.startsWith("seqout") || dataType.startsWith("outfile") || dataType.startsWith("matrix") || dataType.startsWith("infile") || dataType.startsWith("regexp") || dataType.startsWith("codon") || dataType.startsWith("dirlist")) {
            appF.setGuiHandleNumber(this.ntextf);
            ++this.ntextf;
        } else if (dataType.startsWith("pattern")) {
            appF.setGuiHandleNumber(this.nmultiTextField);
            ++this.nmultiTextField;
        } else if (dataType.startsWith("int")) {
            appF.setGuiHandleNumber(this.nint);
            ++this.nint;
        } else if (dataType.startsWith("float")) {
            appF.setGuiHandleNumber(this.nfloat);
            ++this.nfloat;
        } else if (dataType.startsWith("bool")) {
            appF.setGuiHandleNumber(this.nbool);
            ++this.nbool;
        } else if (dataType.startsWith("seqset") || dataType.startsWith("seqall") || dataType.startsWith("sequence")) {
            appF.setGuiHandleNumber(this.nseqs);
            ++this.nseqs;
        } else if (dataType.startsWith("filelist")) {
            appF.setGuiHandleNumber(this.nflist);
            ++this.nflist;
        } else if (dataType.startsWith("list") || dataType.startsWith("select")) {
            double max = 1.0;
            if (this.isMaxParamValue(this.numofFields)) {
                max = Double.parseDouble(this.getMaxParam(this.numofFields));
            }
            if (max > 1.0) {
                appF.setGuiHandleNumber(this.mlist);
                ++this.mlist;
            } else {
                appF.setGuiHandleNumber(this.nlist);
                ++this.nlist;
            }
        } else if (dataType.startsWith("range")) {
            appF.setGuiHandleNumber(this.nrange);
            ++this.nrange;
        }
    }

    public double getParamValueDbl(int field, int param) {
        ApplicationFields aF = (ApplicationFields)this.vappF.get(field);
        return aF.getParamValueDbl(param);
    }

    public boolean isDefaultParamValueStr(int field) {
        int num = this.getNumofParams(field);
        for (int i = 0; i < num; ++i) {
            if (!this.getParameterAttribute(field, i).startsWith("def")) continue;
            return this.isParamValueStr(field, i);
        }
        return false;
    }

    public double getDefaultParamValueDbl(int field) {
        int num = this.getNumofParams(field);
        ApplicationFields aF = (ApplicationFields)this.vappF.get(field);
        for (int i = 0; i < num; ++i) {
            if (!this.getParameterAttribute(field, i).startsWith("def")) continue;
            return aF.getParamValueDbl(i);
        }
        return 0.0;
    }

    public boolean isDependents(String attr, int field, int numofFields) {
        String val;
        int j;
        int num;
        int i;
        this.numOfDependents = 0;
        for (i = field + 1; i < numofFields; ++i) {
            num = this.getNumofParams(i);
            for (j = 0; j < num; ++j) {
                if (!this.isParamValueStr(i, j) || !(val = this.getParamValueStr(i, j)).startsWith("$") && !val.startsWith("@")) continue;
                ++this.numOfDependents;
            }
        }
        this.dep = new Dependent[this.numOfDependents];
        this.numOfDependents = 0;
        for (i = field + 1; i < numofFields; ++i) {
            num = this.getNumofParams(i);
            for (j = 0; j < num; ++j) {
                if (!this.isParamValueStr(i, j) || !(val = this.getParamValueStr(i, j)).startsWith("$") && !val.startsWith("@")) continue;
                String type = this.getParameterAttribute(i, j);
                this.dep[this.numOfDependents] = new Dependent(i, j, val, type);
                ++this.numOfDependents;
            }
        }
        return this.numOfDependents > 0;
    }

    public Dependent[] getDependents() {
        return this.dep;
    }

    public int getNumOfDependents() {
        return this.numOfDependents;
    }

    public String getMinParam(int field) {
        int num = this.getNumofParams(field);
        String min = "";
        for (int i = 0; i < num; ++i) {
            if (!this.getParameterAttribute(field, i).startsWith("min")) continue;
            ApplicationFields aF = (ApplicationFields)this.vappF.get(field);
            if (this.isParamValueStr(field, i)) {
                min = aF.getParamValueStr(i);
            } else {
                Double val = new Double(aF.getParamValueDbl(i));
                min = this.getParameterAttribute(field, 0).startsWith("int") ? new Integer(val.intValue()).toString() : val.toString();
            }
            return min;
        }
        return min;
    }

    public String getMaxParam(int field) {
        int num = this.getNumofParams(field);
        String max = "";
        for (int i = 0; i < num; ++i) {
            if (!this.getParameterAttribute(field, i).startsWith("max")) continue;
            ApplicationFields aF = (ApplicationFields)this.vappF.get(field);
            if (this.isParamValueStr(field, i)) {
                max = aF.getParamValueStr(i);
            } else {
                Double val = new Double(aF.getParamValueDbl(i));
                max = this.getParameterAttribute(field, 0).startsWith("int") ? new Integer(val.intValue()).toString() : val.toString();
            }
            return max;
        }
        return max;
    }

    public boolean isMinParamValue(int field) {
        int num = this.getNumofParams(field);
        for (int i = 0; i < num; ++i) {
            if (!this.getParameterAttribute(field, i).startsWith("min")) continue;
            ApplicationFields aF = (ApplicationFields)this.vappF.get(field);
            return !this.isParamValueStr(field, i) || !aF.getParamValueStr(i).startsWith("$");
        }
        return false;
    }

    public boolean isMaxParamValue(int field) {
        int num = this.getNumofParams(field);
        for (int i = 0; i < num; ++i) {
            if (!this.getParameterAttribute(field, i).startsWith("max")) continue;
            return true;
        }
        return false;
    }

    public String getInfoParamValue(int field) {
        int i;
        int num = this.getNumofParams(field);
        ApplicationFields aF = (ApplicationFields)this.vappF.get(field);
        for (i = 0; i < num; ++i) {
            if (!this.getParameterAttribute(field, i).startsWith("prompt")) continue;
            return aF.getParamValueStr(i);
        }
        for (i = 0; i < num; ++i) {
            if (!this.getParameterAttribute(field, i).startsWith("info")) continue;
            return aF.getParamValueStr(i);
        }
        for (i = 0; i < num; ++i) {
            if (!this.getParameterAttribute(field, i).startsWith("help")) continue;
            return aF.getParamValueStr(i);
        }
        return "";
    }

    public String getHelpParamValue(int field) {
        int num = this.getNumofParams(field);
        ApplicationFields aF = (ApplicationFields)this.vappF.get(field);
        for (int i = 0; i < num; ++i) {
            if (!this.getParameterAttribute(field, i).startsWith("help")) continue;
            return this.formatHelpText(aF.getParamValueStr(i));
        }
        return "";
    }

    public boolean isBatchable() {
        int num = this.getNumofParams(0);
        if (num == 0) {
            return false;
        }
        ApplicationFields aF = (ApplicationFields)this.vappF.get(0);
        for (int i = 0; i < num; ++i) {
            if (!this.getParameterAttribute(0, i).startsWith("batch") || !aF.getParamValueStr(i).equalsIgnoreCase("Y") && !aF.getParamValueStr(i).equalsIgnoreCase("Yes")) continue;
            return true;
        }
        return false;
    }

    public String getExpectedCPU() {
        String cpu = "";
        int num = this.getNumofParams(0);
        ApplicationFields aF = (ApplicationFields)this.vappF.get(0);
        for (int i = 0; i < num; ++i) {
            if (!this.getParameterAttribute(0, i).startsWith("cpu")) continue;
            return aF.getParamValueStr(i);
        }
        return cpu;
    }

    public String getUrlPrefix() {
        int num = this.getNumofParams(0);
        ApplicationFields aF = (ApplicationFields)this.vappF.get(0);
        for (int i = 0; i < num; ++i) {
            if (!this.getParameterAttribute(0, i).startsWith("embassy")) continue;
            return aF.getParamValueStr(i);
        }
        return null;
    }

    protected String formatHelpText(String help) {
        int stop;
        String helpText = "";
        int start = 0;
        help = help.replace('\n', ' ');
        while ((stop = help.indexOf(32, 55)) > 0) {
            helpText = helpText.concat(help.substring(start, stop) + "\n");
            help = help.substring(stop + 1, help.length());
        }
        helpText = helpText.concat(help);
        return helpText;
    }

    public boolean isOptionalParamValue(int field) {
        int num = this.getNumofParams(field);
        for (int i = 0; i < num; ++i) {
            if (!this.getParameterAttribute(field, i).startsWith("opt")) continue;
            return true;
        }
        return false;
    }

    public boolean isOutputSequence(int field) {
        int num = this.getNumofParams(field);
        for (int i = 0; i < num; ++i) {
            if (!this.getParameterAttribute(field, i).startsWith("seqout")) continue;
            return true;
        }
        return false;
    }

    public String getOutputSequenceFile(int field) {
        int num = this.getNumofParams(field);
        for (int i = 0; i < num; ++i) {
            if (!this.getParameterAttribute(field, i).startsWith("seqout")) continue;
            return this.getParamValueStr(field, i);
        }
        return "";
    }

    public boolean isOutputGraph(int field) {
        int num = this.getNumofParams(field);
        for (int i = 0; i < num; ++i) {
            if (!this.getParameterAttribute(field, i).startsWith("graph") && !this.getParameterAttribute(field, i).startsWith("xygraph")) continue;
            return true;
        }
        return false;
    }

    public boolean isOutputFile(int field) {
        int num = this.getNumofParams(field);
        for (int i = 0; i < num; ++i) {
            if (!this.getParameterAttribute(field, i).startsWith("outfile")) continue;
            return true;
        }
        return false;
    }

    public String getDefaultParamValueStr(int field) {
        int num = this.getNumofParams(field);
        ApplicationFields aF = (ApplicationFields)this.vappF.get(field);
        for (int i = 0; i < num; ++i) {
            if (!this.getParameterAttribute(field, i).startsWith("def")) continue;
            return aF.getParamValueStr(i);
        }
        return "";
    }

    public String[] getList(int field) {
        int num = this.getNumofParams(field);
        String delim = ";";
        String codedelim = ":";
        String listAll = null;
        ApplicationFields aF = (ApplicationFields)this.vappF.get(field);
        for (int i = 0; i < num; ++i) {
            if (this.getParameterAttribute(field, i).startsWith("val")) {
                listAll = aF.getParamValueStr(i);
            }
            if (this.getParameterAttribute(field, i).startsWith("delim")) {
                delim = aF.getParamValueStr(i);
            }
            if (!this.getParameterAttribute(field, i).startsWith("codedelim")) continue;
            codedelim = aF.getParamValueStr(i);
        }
        if (delim == null || listAll == null) {
            System.out.println("getList ERROR");
        }
        StringTokenizer st = new StringTokenizer(listAll, delim);
        int n = 0;
        while (st.hasMoreTokens()) {
            st.nextToken(delim);
            ++n;
        }
        String[] list = new String[n];
        st = new StringTokenizer(listAll);
        n = 0;
        boolean ldef = false;
        Vector<String> def = new Vector<String>();
        if (this.isDefaultParamValueStr(field)) {
            ldef = true;
            String sdef = this.getDefaultParamValueStr(field);
            StringTokenizer stdef = new StringTokenizer(sdef);
            while (stdef.hasMoreTokens()) {
                def.add(stdef.nextToken(delim));
            }
        }
        this.listdefault = new Vector();
        while (st.hasMoreTokens()) {
            String key = st.nextToken(codedelim);
            String item = st.nextToken(delim);
            if (ldef) {
                int newline = key.indexOf("\n");
                if (newline > -1) {
                    key = key.substring(newline + 1, key.length());
                }
                if ((newline = key.indexOf(delim)) > -1) {
                    key = key.substring(newline + 1, key.length());
                }
                key = key.trim();
                for (int i = 0; i < def.size(); ++i) {
                    if (!key.equals((String)def.get(i))) continue;
                    this.listdefault.add(new Integer(n));
                }
            }
            item = item.substring(1, item.length()).trim();
            list[n] = new String(item);
            ++n;
        }
        return list;
    }

    public String getListLabel(int field, int index) {
        int num = this.getNumofParams(field);
        String delim = ";";
        String codedelim = ":";
        String listAll = null;
        String key = "";
        ApplicationFields aF = (ApplicationFields)this.vappF.get(field);
        for (int i = 0; i < num; ++i) {
            if (this.getParameterAttribute(field, i).startsWith("val")) {
                listAll = aF.getParamValueStr(i);
            }
            if (this.getParameterAttribute(field, i).startsWith("delim")) {
                delim = aF.getParamValueStr(i);
            }
            if (!this.getParameterAttribute(field, i).startsWith("codedelim")) continue;
            codedelim = aF.getParamValueStr(i);
        }
        if (delim == null || listAll == null) {
            System.out.println("getList ERROR");
        }
        StringTokenizer st = new StringTokenizer(listAll, delim);
        st = new StringTokenizer(listAll);
        for (int i = 0; i < index + 1; ++i) {
            key = st.nextToken(codedelim);
            st.nextToken(delim);
        }
        key = index > 0 ? key.substring(1, key.length()).trim() : key.substring(0, key.length()).trim();
        return key;
    }

    public String[] getSelect(int field) {
        int num = this.getNumofParams(field);
        String delim = ";";
        String listAll = null;
        ApplicationFields aF = (ApplicationFields)this.vappF.get(field);
        for (int i = 0; i < num; ++i) {
            if (this.getParameterAttribute(field, i).startsWith("val")) {
                listAll = aF.getParamValueStr(i);
            }
            if (!this.getParameterAttribute(field, i).startsWith("delim")) continue;
            delim = aF.getParamValueStr(i);
        }
        if (delim == null || listAll == null) {
            System.out.println("getSelect ERROR");
        }
        StringTokenizer st = new StringTokenizer(listAll, delim);
        int n = 0;
        while (st.hasMoreTokens()) {
            st.nextToken(delim);
            ++n;
        }
        String[] list = new String[n];
        boolean ldef = false;
        Vector<String> def = new Vector<String>();
        if (this.isDefaultParamValueStr(field)) {
            ldef = true;
            String sdef = this.getDefaultParamValueStr(field);
            StringTokenizer stdef = new StringTokenizer(sdef);
            while (stdef.hasMoreTokens()) {
                def.add(stdef.nextToken(delim).trim());
            }
        }
        st = new StringTokenizer(listAll);
        n = 0;
        this.listdefault = new Vector();
        while (st.hasMoreTokens()) {
            String item = st.nextToken(delim);
            if (ldef) {
                for (int i = 0; i < def.size(); ++i) {
                    if (!item.equals((String)def.get(i)) && !Integer.toString(n + 1).equals((String)def.get(i))) continue;
                    this.listdefault.add(new Integer(n));
                }
            }
            item = item.substring(0, item.length()).trim();
            list[n] = new String(item);
            ++n;
        }
        return list;
    }

    public Vector getListOrSelectDefault() {
        return this.listdefault;
    }

    public boolean isOptionalParam() {
        for (int i = 0; i < this.numofFields; ++i) {
            if (!this.isOptionalParamValue(i)) continue;
            return true;
        }
        return false;
    }

    public int getNumofFields() {
        return this.numofFields;
    }

    public int getNumofParams(int field) {
        if (this.vappF.size() == 0) {
            return 0;
        }
        ApplicationFields aF = (ApplicationFields)this.vappF.get(field);
        return aF.getNumberOfParam();
    }

    public int parseParam(BufferedReader in, StreamTokenizer st) throws IOException {
        char c;
        this.svalue = null;
        st.eolIsSignificant(false);
        st.wordChars(45, 45);
        st.wordChars(36, 36);
        st.wordChars(40, 40);
        st.wordChars(41, 41);
        st.wordChars(64, 64);
        st.wordChars(63, 63);
        st.wordChars(33, 33);
        st.wordChars(35, 35);
        st.whitespaceChars(10, 10);
        st.whitespaceChars(32, 32);
        st.whitespaceChars(58, 58);
        st.whitespaceChars(61, 61);
        st.ordinaryChars(34, 34);
        st.ordinaryChars(39, 39);
        st.nextToken();
        this.attr = st.sval;
        if (this.attr == null) {
            return 0;
        }
        if (this.attr.startsWith("#")) {
            while ((c = (char)in.read()) != '\n') {
            }
            st.nextToken();
            this.attr = st.sval;
        }
        if (this.attr == null) {
            return 0;
        }
        st.nextToken();
        this.svalue = st.sval;
        this.nvalue = st.nval;
        if (this.svalue == null && st.ttype != -2) {
            this.svalue = "";
            int last = 32;
            while ((c = (char)in.read()) != '\"') {
                if (c != ' ' || last != 32) {
                    this.svalue = this.svalue.concat(String.valueOf(c));
                }
                last = c;
            }
        }
        ++this.numofParams;
        return st.ttype;
    }

    public int getNumMultiTextField() {
        return this.nmultiTextField;
    }
}

