#ifndef _ECS_DESCR_H_
#define _ECS_DESCR_H_

/*============================================================================
 *  Prototypes des fonctions de base
 *   associées à la structure `ecs_descr_t' décrivant un descripteur de champ
 *============================================================================*/

/*
  This file is part of the Code_Saturne Preprocessor, element of the
  Code_Saturne CFD tool.

  Copyright (C) 1999-2007 EDF S.A., France

  contact: saturne-support@edf.fr

  The Code_Saturne Preprocessor is free software; you can redistribute it
  and/or modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2 of
  the License, or (at your option) any later version.

  The Code_Saturne Preprocessor is distributed in the hope that it will be
  useful, but WITHOUT ANY WARRANTY; without even the implied warranty
  of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with the Code_Saturne Preprocessor; if not, write to the
  Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor,
  Boston, MA  02110-1301  USA
*/


/*============================================================================
 *                                 Visibilité
 *============================================================================*/

/*----------------------------------------------------------------------------
 *  Fichiers `include' librairie standard C ou BFT
 *----------------------------------------------------------------------------*/

#include <bft_file.h>


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  du  paquetage global "Utilitaire"
 *----------------------------------------------------------------------------*/

#include "ecs_def.h"
#include "ecs_tab_glob.h"


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  des paquetages visibles
 *----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  du  paquetage courant
 *----------------------------------------------------------------------------*/


/*============================================================================
 *                         Déclaration de la structure
 *============================================================================*/

typedef struct _ecs_descr_t ecs_descr_t;


/*============================================================================
 *                         Définition d'enumeration
 *============================================================================*/

typedef enum {

  ECS_DESCR_COULEUR,
  ECS_DESCR_GROUPE

} ecs_descr_typ_t;


/*============================================================================
 *                         Définition de macros
 *============================================================================*/

#define ECS_DESCR_NUM_NUL                     -1

#define ECS_DESCR_ID_EXT_NUL                  -1
#define ECS_DESCR_IDE_NUL                     -1


/*============================================================================
 *                       Prototypes de fonctions publiques
 *============================================================================*/

/*----------------------------------------------------------------------------
 *    Fonction de création d'une structure de descripteur de champ
 *----------------------------------------------------------------------------*/

ecs_descr_t * ecs_descr__cree
(
       ecs_descr_typ_t         typ_e,       /* --> Type (groupe, couleur, ...)*/
 const ecs_int_t               ide,         /* --> Identificateur descripteur */
 const char             *const nom          /* --> Nom du descripteur         */
);


/*----------------------------------------------------------------------------
 *  Fonction libérant la structure `ecs_descr_t' donnée en argument.
 *  Elle renvoie un pointeur NULL
 *----------------------------------------------------------------------------*/

ecs_descr_t * ecs_descr__detruit
(
 ecs_descr_t * this_descr
);


/*----------------------------------------------------------------------------
 *  Fonction imprimant le contenu d'une structure `ecs_descr_t' donnée
 *   sur le flux décrit par la structure `bft_file_t'
 *----------------------------------------------------------------------------*/

void ecs_descr__imprime
(
 const ecs_descr_t *const this_descr,           /* --> Structure a imprimer   */
       ecs_int_t          imp_col,
       bft_file_t  *const fic_imp               /* --> Descripteur du fichier */
);


/*----------------------------------------------------------------------------
 *  Fonction qui renvoie la taille en octets d'une structure `ecs_descr_t'
 *----------------------------------------------------------------------------*/

float ecs_descr__ret_taille
(
  const ecs_descr_t *const this_descr
);


/*----------------------------------------------------------------------------
 *  Fonction qui alloue une structure `ecs_descr_t' et qui remplit
 *   son contenu en copiant le contenu de la structure donnée en argument
 *----------------------------------------------------------------------------*/

ecs_descr_t * ecs_descr__copie
(                                 /* <-- Renvoie la structure copiee          */
 ecs_descr_t * this_descr         /* --> Structure a copier                   */
);


/*----------------------------------------------------------------------------
 *  Fonction qui compare 2 descripteurs
 *
 *  La fonction renvoie :
 *  - `true'  si les deux descripteurs sont identiques
 *  - `false' sinon
 *----------------------------------------------------------------------------*/

bool       ecs_descr__compare
(
 const ecs_descr_t *const descr_1,         /* --> 1er  descripteur a comparer */
 const ecs_descr_t *const descr_2          /* --> 2eme descripteur a comparer */
);


/*----------------------------------------------------------------------------
 *  Fonction qui compare 2 descripteurs
 *
 *  La fonction renvoie :
 *  - `true'
 *           -       si les noms            des 2 descripteurs sont à `NULL'
 *                et si les identificateurs des 2 descripteurs sont identiques
 *           - ou    si les noms            des 2 descripteurs sont identiques
 *                   (et tous deux differents de `NULL')
 *  - `false' sinon
 *----------------------------------------------------------------------------*/

bool       ecs_descr__compare_selection
(
 const ecs_descr_t *const descr_1,         /* --> 1er  descripteur a comparer */
 const ecs_descr_t *const descr_2          /* --> 2eme descripteur a comparer */
);


/*----------------------------------------------------------------------------
 *  Fonction qui affiche le contenu d'un descripteur
 *
 *  Sont affichés :
 *   - l'identificateur dans le cas d'une couleur
 *   - la chaîne de caractères dans le cas d'un groupe
 *----------------------------------------------------------------------------*/

void ecs_descr__affiche
(
 const ecs_descr_t  *const descr,
 const int                 decal
);


/*----------------------------------------------------------------------------
 *  Fonction qui renvoie le type du descripteur :
 *  - soit `ECS_DESCR_TYP_COULEUR' pour un descripteur de type "couleur"
 *  - soit `ECS_DESCR_TYP_GROUPE'  pour un descripteur de type "groupe"
 *----------------------------------------------------------------------------*/

ecs_descr_typ_t ecs_descr__ret_typ
(
 const ecs_descr_t *const descr
);


/*----------------------------------------------------------------------------
 *  Fonction qui renvoie l'identificateur du descripteur donné en argument
 *----------------------------------------------------------------------------*/

int ecs_descr__ret_ide
(
 const ecs_descr_t *const descr
);


/*----------------------------------------------------------------------------
 *  Fonction qui renvoie le nom du descripteur donné en argument
 *----------------------------------------------------------------------------*/

const char * ecs_descr__ret_nom
(
 const ecs_descr_t *const descr
);


#endif /* _ECS_DESCR_H_ */
