dnl Copyright (C) 2005-2009 EDF
dnl
dnl This file is part of the Code_Saturne Preprocessor.  For license
dnl information, see the COPYING file in the top level directory of the
dnl Code_Saturne Preprocessor source distribution.

# ECS_AC_TEST_SCOTCH
#-----------------
# modifies or sets have_scotch, SCOTCH_CPPFLAGS, SCOTCH_LDFLAGS, and SCOTCH_LIBS
# depending on libraries found

AC_DEFUN([ECS_AC_TEST_SCOTCH], [

have_scotch=no

AC_ARG_WITH(scotch,
            [AS_HELP_STRING([--with-scotch=PATH],
                            [specify prefix directory for SCOTCH])],
            [if test "x$withval" = "x"; then
               with_scotch=yes
             fi],
            [with_scotch=check])

AC_ARG_WITH(scotch-include,
            [AS_HELP_STRING([--with-scotch-include=PATH],
                            [specify directory for SCOTCH include files])],
            [if test "x$with_scotch" = "xcheck"; then
               with_scotch=yes
             fi
             SCOTCH_CPPFLAGS="-I$with_scotch_include"],
            [if test "x$with_scotch" != "xno" -a "x$with_scotch" != "xyes" \
	          -a "x$with_scotch" != "xcheck"; then
               SCOTCH_CPPFLAGS="-I$with_scotch/include"
             fi])

AC_ARG_WITH(scotch-lib,
            [AS_HELP_STRING([--with-scotch-lib=PATH],
                            [specify directory for SCOTCH library])],
            [if test "x$with_scotch" = "xcheck"; then
               with_scotch=yes
             fi
             SCOTCH_LDFLAGS="-L$with_scotch_lib"],
            [if test "x$with_scotch" != "xno" -a "x$with_scotch" != "xyes" \
	          -a "x$with_scotch" != "xcheck"; then
               SCOTCH_LDFLAGS="-L$with_scotch/lib"
             fi])


if test "x$with_scotch" != "xno" ; then

  saved_CPPFLAGS="$CPPFLAGS"
  saved_LDFLAGS="$LDFLAGS"
  saved_LIBS="$LIBS"

  SCOTCH_LIBS="-lscotch -lscotcherr -lm"
  CPPFLAGS="${CPPFLAGS} ${SCOTCH_CPPFLAGS}"
  LDFLAGS="${LDFLAGS} ${SCOTCH_LDFLAGS}"
  LIBS="${LIBS} ${SCOTCH_LIBS}"

  AC_LINK_IFELSE([AC_LANG_PROGRAM(
[[#include <stdio.h>
#include <scotch.h>]],
[[ SCOTCH_graphInit((void *)0); ]])],
[AC_DEFINE([HAVE_SCOTCH], 1, [use SCOTCH])
 have_scotch=yes
],
[if test "x$with_scotch" != "xcheck" ; then
   AC_MSG_FAILURE([SCOTCH support is requested, but test for SCOTCH failed!])
 else
   AC_MSG_WARN([do not use SCOTCH])
 fi
]
)

  if test "x$have_scotch" = "xyes"; then
    SCOTCH_LIBS="-lscotch -lm" # libscotcherr functions built in cs_partition
  else
    SCOTCH_LIBS=""
  fi

fi

AM_CONDITIONAL(HAVE_SCOTCH, test x$have_scotch = xyes)

CPPFLAGS="$saved_CPPFLAGS"
LDFLAGS="$saved_LDFLAGS"
LIBS="$saved_LIBS"

unset saved_CPPFLAGS
unset saved_LDFLAGS
unset saved_LIBS

AC_SUBST(SCOTCH_CPPFLAGS)
AC_SUBST(SCOTCH_LDFLAGS)
AC_SUBST(SCOTCH_LIBS)

])dnl

