dnl Copyright (C) 2008-2009 EDF
dnl
dnl This file is part of the Code_Saturne Preprocessor.  For license
dnl information, see the LICENSE file in the top level directory of the
dnl Code_Saturne Preprocessor source distribution.

# ECS_AC_TEST_CCM
#----------------
# modifies or sets have_ccm, CCM_CPPFLAGS, CCM_LDFLAGS, and CCM_LIBS
# depending on libraries found

AC_DEFUN([ECS_AC_TEST_CCM], [

have_ccm=no
have_ccm_headers=no

AC_ARG_WITH(ccm,
            [AS_HELP_STRING([--with-ccm=DIR],
                            [specify prefix directory for CCMIO])],
            [if test "x$withval" = "x"; then
               with_ccm=yes
             fi],
            [with_ccm=check])

AC_ARG_WITH(ccm-include,
            [AS_HELP_STRING([--with-ccm-include=DIR],
                            [specify directory for CCMIO include files])],
            [if test "x$with_ccm" = "xcheck"; then
               with_ccm=yes
             fi
             CCM_CPPFLAGS="-I$with_ccm_include"],
            [if test "x$with_ccm" != "xno" -a "x$with_ccm" != "xyes" \
	          -a "x$with_ccm" != "xcheck"; then
               CCM_CPPFLAGS="-I$with_ccm/include"
             fi])

AC_ARG_WITH(ccm-lib,
            [AS_HELP_STRING([--with-ccm-lib=DIR],
                            [specify directory for CCMIO library])],
            [if test "x$with_ccm" = "xcheck"; then
               with_ccm=yes
             fi
             CCM_LDFLAGS="-L$with_ccm_lib"],
            [if test "x$with_ccm" != "xno" -a "x$with_ccm" != "xyes" \
	          -a "x$with_ccm" != "xcheck"; then
               CCM_LDFLAGS="-L$with_ccm/lib"
             fi])

# ADF may be provided directly (patched ADF with libccmio)
# or through CGNS

if test "x$with_ccm" != "xno" -a "x$have_adf" = "xno" -a "x$have_cgns" = "xno"
then
  if test "x$with_ccm" = "xcheck"; then
    with_ccm=no
    AC_MSG_WARN([no ADF library found; will not search for CCM])
  else
    AC_MSG_ERROR([no ADF library found; required for CCM])
  fi
fi

if test "x$with_ccm" != "xno" ; then

  saved_CPPFLAGS="$CPPFLAGS"
  saved_LDFLAGS="$LDFLAGS"
  saved_LIBS="$LIBS"

  if test "x$ADF_LIBS" != "x" ; then
    CCM_LIBS="-lccmio $ADF_LIBS"
    CPPFLAGS="${CPPFLAGS} ${CCM_CPPFLAGS}"
    LDFLAGS="${LDFLAGS} ${CCM_LDFLAGS} $ADF_LDFLAGS"
  elif test "x$CGNS_LIBS" != "x" ; then
    CCM_LIBS="-lccmio"
    CPPFLAGS="${CPPFLAGS} ${CCM_CPPFLAGS}"
    LDFLAGS="${LDFLAGS} ${CCM_LDFLAGS} $CGNS_LDFLAGS $HDF5_LDFLAGS"
  fi
  LIBS="${LIBS} ${CCM_LIBS} $CGNS_LIBS $HDF5_LIBS"

# Check that CCMIO header files exist

  AC_COMPILE_IFELSE([AC_LANG_PROGRAM(
[[#include <libccmio/ccmio.h>]],
[[int i = kCCMIONoErr;]])],
                    [AC_MSG_RESULT([CCMIO headers found])
                     have_ccm_headers=yes
                    ],
                    [AC_MSG_RESULT([CCMIO headers not found])
                    ])

  if test "x$have_ccm_headers" = "xyes"; then
    AC_CHECK_LIB(ccmio, CCMIOOpenFile, 
                 [ AC_DEFINE([HAVE_CCM], 1, [CCM file support])
                   have_ccm=yes
                 ], 
                 [if test "x$with_ccm" != "xcheck" ; then
                    AC_MSG_FAILURE([CCM support is requested, but test for CCM failed!])
                  else
                    AC_MSG_WARN([no CCM file support])
                  fi
                 ],
                 )
  fi

  if test "x$have_ccm" != "xyes"; then
    CCM_LIBS=""
  fi

  CPPFLAGS="$saved_CPPFLAGS"
  LDFLAGS="$saved_LDFLAGS"
  LIBS="$saved_LIBS"

  unset saved_CPPFLAGS
  unset saved_LDFLAGS
  unset saved_LIBS

fi

AM_CONDITIONAL(HAVE_CCM, test x$have_ccm = xyes)

AC_SUBST(CCM_CPPFLAGS)
AC_SUBST(CCM_LDFLAGS)
AC_SUBST(CCM_LIBS)

])dnl

