/*
 * riff.h library for RIFF file format i/o
 * Copyright (C) 2000 Arne Schirmacher <arne@schirmacher.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _RIFF_H
#define _RIFF_H 1

#include <vector>

#define QUADWORD signed long long
#define DWORD signed long
#define LONG unsigned long
#define WORD signed short
#define BYTE unsigned char
#define FOURCC unsigned long

#define RIFF_NO_PARENT (-1)
#define RIFF_LISTSIZE (4)
#define RIFF_HEADERSIZE (8)

#ifdef __cplusplus
extern "C"
{
#define fail_neg(i) real_fail_neg(i, __FILE__, __LINE__)
#define fail_null(p) real_fail_null(p, __FILE__, __LINE__)
        void real_fail_neg(int i, char *file, int line);
        void real_fail_null(void *p, char *file, int line);
        FOURCC make_fourcc(char *s);
}
#endif

class RIFFDirEntry
{
public:
        FOURCC type;
        FOURCC name;
        int     length;
        int     offset;
        int     parent;
        int     written;

        RIFFDirEntry();
        RIFFDirEntry(FOURCC t, FOURCC n, int l, int o, int p);
};


class RIFFFile
{
public:
        int fd;
	std::vector < RIFFDirEntry > directory;

public:
        RIFFFile();
        RIFFFile(char *s);
        virtual ~RIFFFile();

        virtual int AddDirectoryEntry(FOURCC type, FOURCC name, int length, int list);
        virtual void SetDirectoryEntry(int i, FOURCC type, FOURCC name, int length, int offset, int list);
        virtual void SetDirectoryEntry(int i, RIFFDirEntry entry);
        virtual void GetDirectoryEntry(int i, FOURCC &type, FOURCC &name, int &length, int &offset, int &list);
        virtual RIFFDirEntry GetDirectoryEntry(int i);
        virtual int GetFileSize(void);
        virtual void PrintDirectoryEntry(int i);
        virtual void PrintDirectoryEntryData(RIFFDirEntry entry);
        virtual void PrintDirectory(void);
        virtual int FindDirectoryEntry(FOURCC type);
        virtual void ParseChunk(int parent);
        virtual void ParseList(int parent);
        virtual void ParseRIFF(void);
        virtual void ReadChunk(int chunk_index, void *data);
        virtual void WriteChunk(int chunk_index, const void *data);
        virtual void WriteRIFF(void);
};
#endif

