/* Drip - a transcoder for Unix
 * Copyright (C) 2001-2003 Jarl van Katwijk
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <gnome.h>
#include <dirent.h>
#include <pthread.h>
#include <dvdread/dvd_reader.h>
#include <dvdread/ifo_types.h>
#include <dvdread/ifo_read.h>
#include <dvdread/nav_read.h>
#include <dvdread/nav_print.h>


/* structs */
typedef struct _drip_system_t {
    gchar *command;
    gint *exec_result;
    gboolean freebuffer;
} drip_system_t;

typedef struct _drip_cell_t {
    gint cell;
    gint angle;
    gint pc;
} drip_cell_t;

/* general proto's */
gboolean parse_clut(ifo_handle_t *ifo,gint DVDtitle,gboolean lock);
gint first_selected_titel(void);
void detect_largest_title(void);
gboolean read_dvd_title(gint);
gboolean detect_DVD_titles(gboolean lock);
gchar *fulllanguage(uint16_t descr);
gboolean save_config(gboolean lock);
void drip_error(gchar *text);
void drip_info(gchar *text);
GString* drip_system(gchar *command,gint *exec_result,gboolean freebuffer,gboolean lock);
gpointer drip_system_threaded(gpointer data);
void terminate(gboolean hard,gboolean lock);
gchar* mpeg2divx_parameters(gint);
gint dirfilter_movie_vob(const struct dirent *entry);
gint dirfilter_all_vob(const struct dirent *entry);
gint dirfilter_all(const struct dirent *entry);
gint dirfilter_divx(const struct dirent *entry);
gint manual_stream_select(gchar *video_location);
gboolean remove_cache(gboolean lock);
gboolean detect_source_filesystem(void);
void save_dvd_title_info(gboolean lock);
gboolean load_dvd_title_info(gint requested_title,gboolean lock);
gchar* detect_source_track_dir(gboolean lock);
gboolean check_for_supermount_fs(void);
gboolean user_can_mount_dvd(void);
gint detect_largest_vob_sequence(gchar *video_location);
gint dirfilter_avi(const struct dirent *entry);
void rename_divx_files(void);
gboolean eject_dvdrom(gchar *track_dir,gchar *dvddevice,gboolean lock);
gpointer make_iso_images(gpointer data);
gchar* readlink_malloc (gchar *filename);
gpointer heat_thread(gpointer data);
gboolean cache_vobs_for_ifo(void);
void cache_track(gchar *dir,gchar *track,gdouble perc,guint nr,gint);
gboolean config_ok(void);
gpointer conversion_thread(gpointer data);
gboolean parse_ifo(gint dvdtitle,gboolean lock,gboolean save_clut);
gboolean format_divxname(GString *DIVXfile,gboolean lock);
gboolean drip_dvdname_check(GString*);
void seconds2time(gint seconds,GString *time);
gboolean free_space(gchar* mountpoint,glong min_freespace,glong warning_freespace,gboolean _lock);


extern gint selected_files;
extern gint cached_files_list;
extern GString *cached_file_list[1000];

extern gboolean paused;
extern gdouble CALCframerate;
extern GString *cached_files;
/* converting thread */
extern pthread_t ripthread;
extern gint ripthread_id;


/* The ISO 639 language codes.
 * Language names with * prefix are not spelled in their own language 
 */
static struct {
        char descr[3];
        char lang_long[20];
} lang_tbl[] = {
        {"  ", "Not Specified"},
        {"aa", "*Afar"},
        {"ab", "*Abkhazian"},
        {"af", "*Afrikaans"},
        {"am", "*Amharic"},
        {"ar", "*Arabic"},
        {"as", "*Assamese"},
        {"ay", "*Aymara"},
        {"az", "*Azerbaijani"},
        {"ba", "*Bashkir"},
        {"be", "*Byelorussian"},
        {"bg", "*Bulgarian"},
        {"bh", "*Bihari"},
        {"bi", "*Bislama"},
        {"bn", "*Bengali; Bangla"},
        {"bo", "*Tibetan"},
        {"br", "*Breton"},
        {"ca", "*Catalan"},
        {"co", "*Corsican"},
        {"cs", "*Czech(Ceske)"},
        {"cy", "*Welsh"},
        {"da", "Dansk"},
        {"de", "Deutsch"},
        {"dz", "*Bhutani"},
        {"el", "*Greek"},
        {"en", "English"},
        {"eo", "*Esperanto"},
        {"es", "Espanol"},
        {"et", "*Estonian"},
        {"eu", "*Basque"},
        {"fa", "*Persian"},
        {"fi", "Suomi"},
        {"fj", "*Fiji"},
        {"fo", "*Faroese"},
        {"fr", "Francais"},
        {"fy", "*Frisian"},
        {"ga", "*Irish"},
        {"gd", "*Scots Gaelic"},
        {"gl", "*Galician"},
        {"gn", "*Guarani"},
        {"gu", "*Gujarati"},
        {"ha", "*Hausa"},
        {"he", "*Hebrew"},                              // formerly iw
        {"hi", "*Hindi"},
        {"hr", "Hrvatski"},                             // Croatian
        {"hu", "Magyar"},
        {"hy", "*Armenian"},
        {"ia", "*Interlingua"},
        {"id", "*Indonesian"},                          // formerly in
        {"ie", "*Interlingue"},
        {"ik", "*Inupiak"},
        {"in", "*Indonesian"},                          // replaced by id
        {"is", "Islenska"},
        {"it", "Italiano"},
        {"iu", "*Inuktitut"},
        {"iw", "*Hebrew"},                              // replaced by he
        {"hi", "*Hindi"},
        {"hr", "Hrvatski"},                             // Croatian
        {"hu", "Magyar"},
        {"hy", "*Armenian"},
        {"ia", "*Interlingua"},
        {"id", "*Indonesian"},                          // formerly in
        {"ie", "*Interlingue"},
        {"ik", "*Inupiak"},
        {"in", "*Indonesian"},                          // replaced by id
        {"is", "Islenska"},
        {"it", "Italiano"},
        {"iu", "*Inuktitut"},
        {"iw", "*Hebrew"},                              // replaced by he
        {"ja", "*Japanese"},
        {"ji", "*Yiddish"},                             // replaced by yi
        {"jw", "*Javanese"},
        {"ka", "*Georgian"},
        {"kk", "*Kazakh"},
        {"kl", "*Greenlandic"},
        {"km", "*Cambodian"},
        {"kn", "*Kannada"},
        {"ko", "*Korean"},
        {"ks", "*Kashmiri"},
        {"ku", "*Kurdish"},
        {"ky", "*Kirghiz"},
        {"la", "*Latin"},
        {"ln", "*Lingala"},
        {"lo", "*Laothian"},
        {"lt", "*Lithuanian"},
        {"lv", "*Latvian, Lettish"},
        {"mg", "*Malagasy"},
        {"mi", "*Maori"},
        {"mk", "*Macedonian"},
        {"ml", "*Malayalam"},
        {"mn", "*Mongolian"},
        {"mo", "*Moldavian"},
        {"mr", "*Marathi"},
        {"ms", "*Malay"},
        {"mt", "*Maltese"},
        {"my", "*Burmese"},
        {"na", "*Nauru"},
        {"ne", "*Nepali"},
        {"nl", "Nederlands"},
        {"no", "Norsk"},
        {"oc", "*Occitan"},
        {"om", "*(Afan) Oromo"},
        {"or", "*Oriya"},
        {"pa", "*Punjabi"},
        {"pl", "*Polish"},
        {"ps", "*Pashto, Pushto"},
        {"pt", "Portugues"},
        {"qu", "*Quechua"},
        {"rm", "*Rhaeto-Romance"},
        {"rn", "*Kirundi"},
        {"ro", "*Romanian"},
        {"ru", "*Russian"},
        {"rw", "*Kinyarwanda"},
        {"sa", "*Sanskrit"},
        {"sd", "*Sindhi"},
        {"sg", "*Sangho"},
        {"sh", "*Serbo-Croatian"},
        {"si", "*Sinhalese"},
        {"sk", "*Slovak"},
        {"sl", "*Slovenian"},
        {"sm", "*Samoan"},
        {"sn", "*Shona"},
        {"so", "*Somali"},
        {"sq", "*Albanian"},
        {"sr", "*Serbian"},
        {"ss", "*Siswati"},
        {"st", "*Sesotho"},
        {"su", "*Sundanese"},
        {"sv", "Svenska"},
        {"sw", "*Swahili"},
        {"ta", "*Tamil"},
        {"te", "*Telugu"},
        {"tg", "*Tajik"},
        {"th", "*Thai"},
        {"ti", "*Tigrinya"},
        {"tk", "*Turkmen"},
        {"tl", "*Tagalog"},
        {"tn", "*Setswana"},
        {"to", "*Tonga"},
        {"tr", "*Turkish"},
        {"ts", "*Tsonga"},
        {"tt", "*Tatar"},
        {"tw", "*Twi"},
        {"ug", "*Uighur"},
        {"uk", "*Ukrainian"},
        {"ur", "*Urdu"},
        {"uz", "*Uzbek"},
        {"vi", "*Vietnamese"},
        {"vo", "*Volapuk"},
        {"wo", "*Wolof"},
        {"xh", "*Xhosa"},
        {"yi", "*Yiddish"},                             // formerly ji
        {"yo", "*Yoruba"},
        {"za", "*Zhuang"},
        {"zh", "*Chinese"},
        {"zu", "*Zulu"},
        {"\0", ""}
};

