/* Drip - a transcoder for Unix
 * Copyright (C) 2001-2003 Jarl van Katwijk
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

// avi encoder
#include <videoencoder.h>
#include <avifile.h>
#include <aviplay.h>
#include <version.h>
#if (AVIFILE_MINOR_VERSION<7) 
   #error Avifile 0.7.x is needed
#else
   #include <avm_default.h>
   #include <avm_fourcc.h>
   #include <creators.h>
#endif

gpointer encode(gpointer data);
void process_frame(guint8*,uint32_t pts,gint ptsaudio);
void audio_output_codec(void);
gdouble encode_frame(IAviVideoWriteStream *stream,CImage *frame,gdouble SCR,gboolean fetching,gboolean probing,gint);

extern gboolean quit;
extern gboolean audio_output_codec_setup;
extern IAviAudioWriteStream **avifile_audio_outstream;
extern gboolean audio_buffer_filled;
extern IAviVideoWriteStream* stream;
extern CImage* im; // framebuffer image 

extern gboolean Video_Synced;
