/*
 * buffy - Mailbox watcher
 *
 * Copyright (C) 2003  Enrico Zini
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#define APPNAME PACKAGE_NAME
#else
#warning No config.h found: using fallback values
#define APPNAME __FILE__
#define PACKAGE_VERSION "unknown"
#endif

//#include "Environment.h"
#include <buffy/MailFolder.h>
#include <wibble/exception.h>
#include "CommandlineParser.h"

#include <vector>
#include <iostream>

using namespace std;
using namespace buffy;
using namespace wibble;

static vector<MailFolder> folders;

static void printStats(const MailFolder& f)
{
	cout << f.name() << ": path " << f.path()
		 << ", new " << f.getMsgNew()
		 << " unread " << f.getMsgUnread()
		 << ", total " << f.getMsgTotal()
		 << ", flagged " << f.getMsgFlagged()
		 << endl;
}

class StatsPrinter : public MailFolderConsumer
{
public:
	void consume(MailFolder& f)
	{
		f.updateStatistics();
		folders.push_back(f);
		printStats(f);
	}
};

int main(int argc, char* argv[])
{
	try {
		CommandlineParser opts(APPNAME, "[options] [file1|-]",
				"Mail folder monitor.\n"
				"Monitor new and unread messages in a collection of mail folders.\n");
		opts.add("loop", 'l', "loop", "continuously loop checking for new changes");
		opts.add("version", 0, "version", "print the program version, then exit");
		opts.add("verbose", 0, "verbose", "enable verbose output");
		opts.add("debug", 0, "debug", "enable debugging output (including verbose output)");

		// Process the commandline
		if (!opts.parse(argc, const_cast<const char**&>(argv)))
		{
			opts.printHelp();
			return 1;
		}
		if (opts.get("help").defined())
		{
			opts.printHelp();
			return 0;
		}

//		Environment::init();
		
		if (opts.get("version").defined())
		{
			printf("%s ver." PACKAGE_VERSION "\n", APPNAME);
			return 0;
		}		
//		if (opts.get("verbose").defined())
//			Environment::get().verbose(true);
//		if (opts.get("debug").defined())
//			Environment::get().debug(true);

		//MaildirMailFolder f("Test", "/home/enrico/Maildir/.0-other");
		//MaildirMailFolder f("/home/enrico/Maildir/.0-other");

		/*
		// Read the full collection
		TagcollDocument<std::string> document;

		if (argc > 1)
			document.load(argv[1]);
		else
			document.loadDebtags();
		*/

		StatsPrinter printer;
		for (int i = 1; i < argc; i++)
		{
			string path = argv[i];
			while (path.size() > 1 && path[path.size() - 1] == '/')
				path.resize(path.size() - 1);
			MailFolder::enumerateFolders(path, printer);
		}
//		Environment::enumerateFolders(printer);
		//MaildirMailFolder::enumerateFolders("/home/enrico/Maildir", buffyWindow);

		if (opts.get("loop").defined())
		{
			while (true)
			{
				sleep(1);
				for (vector<MailFolder>::iterator i = folders.begin();
						i != folders.end(); i++)
					if (i->changed())
					{
						cout << i->name() << " changed" << endl;
						i->updateStatistics();
						printStats(*i);
					}
			}
		}
		
		return 0;
	}
	catch (wibble::exception::Generic& e)
	{
//		fatal_error("%s: %.*s\n", e.type(), PFSTR(e.desc()));
		cerr << e.type() << ": " << e.fullInfo() << endl;
		return 1;
	}
}

// vim:set ts=4 sw=4:
