/*
 * Main application class
 *
 * Copyright (C) 2003  Enrico Zini
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#pragma implementation

#include "PrefDialog.h"
#include "BuffyWindow.h"

#include "Environment.h"

#include <gtkmm/stock.h>
#include <gtkmm/fileselection.h>
#include <gtkmm/messagedialog.h>
#include <gtkmm/toggleaction.h>
#include <gtkmm/spinbutton.h>
#include <gtkmm/frame.h>
#include <gtkmm/combobox.h>

#include <map>
#include <iostream>

using namespace std;
using namespace buffy;


PrefDialog::PrefDialog(Gtk::Window& parent)
	: Gtk::Dialog("Preferences", parent, true, true),
      updateInterval(Environment::get().config().general().interval(), 0, 3600, 5, 60),
	  mpconfig("Configure mail programs", *this, true, true),
	  mpconfig_configured(false)
{
	/*
	// Create the actions used by the dialog
	actionGroup = Gtk::ActionGroup::create("Actions");
	actionGroup->add(actionLocationAdd = Gtk::Action::create("AddLocation", "_Add"),
			sigc::mem_fun(*this, &PrefDialog::on_location_add));
	actionGroup->add(actionLocationDel = Gtk::Action::create("DelLocation", "_Remove"),
			sigc::mem_fun(*this, &PrefDialog::on_location_remove));
	actionGroup->add(actionLocationMod = Gtk::Action::create("ModLocation", "_Change"),
			sigc::mem_fun(*this, &PrefDialog::on_location_change));
	uimanager = Gtk::UIManager::create();
	uimanager->insert_action_group(actionGroup);
	add_accel_group(uimanager->get_accel_group());

	// Layout the actions in the main menubar
	try
	{
		Glib::ustring ui_info = 
			"<ui>"
			"  <menubar name='MenuBar'>"
			"    <menu action='FileMenu'>"
			"      <menuitem action='RescanFolders'/>"
			"      <separator/>"
			"      <menuitem action='Preferences'/>"
			"      <separator/>"
			"      <menuitem action='Quit'/>"
			"    </menu>"
			"    <menu action='ViewMenu'>"
			"      <menuitem action='ViewEmpty'/>"
			"      <menuitem action='ViewRead'/>"
			"    </menu>"
			"  </menubar>"
			"</ui>";
		uimanager->add_ui_from_string(ui_info);
	}
	catch(const Glib::Error& ex)
	{
		warning("Building menus failed: %.*s\n", PFSTR(ex.what()));
	}
	Gtk::Widget* menuBar = uimanager->get_widget("/MenuBar") ;
	mainVBox.pack_start(*menuBar, Gtk::PACK_SHRINK);
	*/

	add_button(Gtk::Stock::OK, 1);
	add_button(Gtk::Stock::CANCEL, 0);
	//add_button(Gtk::Stock::CLOSE, 2);

	Gtk::VBox* diavbox = get_vbox();

	// Update interval
	Gtk::HBox* line = Gtk::manage(new Gtk::HBox());
	diavbox->pack_start(*line, false, false);
	line->pack_start(*manage(new Gtk::Label("Update interval (seconds):")), true, true);
	line->pack_start(*manage(new Gtk::SpinButton(updateInterval)), false, false);

	// Mail programs
    editorListModel = Gtk::ListStore::create(editorListModelColumns);
	line = Gtk::manage(new Gtk::HBox());
	diavbox->pack_start(*line, false, false);
	line->pack_start(*manage(new Gtk::Label("Mail editor:")), true, true);
	line->pack_start(*manage(editorSelection = new Gtk::ComboBox(editorListModel)), false, false);
	Gtk::Button* confButton;
	line->pack_start(*manage(confButton = new Gtk::Button("Configure")), false, false);
	confButton->signal_clicked().connect(sigc::mem_fun(*this, &PrefDialog::on_configure_mail_programs));
	Gtk::CellRendererText* crt;
	editorSelection->pack_start(*manage(crt = new Gtk::CellRendererText()), true);
	editorSelection->add_attribute(crt->property_text(), editorListModelColumns.name);

	// Folder locations
	Gtk::Frame* frame = Gtk::manage(new Gtk::Frame("Folder locations"));
	diavbox->pack_start(*frame, true, true);

	Gtk::VBox* locvbox = Gtk::manage(new Gtk::VBox());
	frame->add(*locvbox);

    locationListModel = Gtk::ListStore::create(locationListModelColumns);
	locationList.set_model(locationListModel);

	Gtk::ScrolledWindow* locscroll = Gtk::manage(new Gtk::ScrolledWindow());
    locscroll->add(locationList);
	locscroll->set_policy(Gtk::POLICY_AUTOMATIC, Gtk::POLICY_AUTOMATIC);
	locvbox->pack_start(*locscroll, true, true);

	locationList.append_column("Location", locationListModelColumns.path);
	locationList.set_headers_visible(false);

	Gtk::ButtonBox* bubox = Gtk::manage(new Gtk::HButtonBox());
	bubox->set_layout(Gtk::BUTTONBOX_SPREAD);
	Gtk::Button* button;

	bubox->add(*(button = new Gtk::Button("_Add", true)));
	button->signal_clicked().connect(sigc::mem_fun(*this, &PrefDialog::on_location_add));
	bubox->add(*(button = new Gtk::Button("_Remove", true)));
	button->signal_clicked().connect(sigc::mem_fun(*this, &PrefDialog::on_location_remove));
	locvbox->pack_start(*bubox, false, true);

	show_all_children();




	/*
	menuBar.items().push_back(Gtk::Menu_Helpers::MenuElem("_File", fileMenu));
	fileMenu.items().push_back(Gtk::Menu_Helpers::StockMenuElem(Gtk::Stock::QUIT,
				sigc::mem_fun(*this, &PrefDialog::on_quit)));
	*/

	/*
	menuBar.items().push_back(Gtk::Menu_Helpers::MenuElem("_View", viewMenu));
	viewMenu.items().push_back(Gtk::Menu_Helpers::StockMenuElem(Gtk::Stock::QUIT,
				sigc::mem_fun(*this, &PrefDialog::on_quit)));
*/

	/*
	buttonBox.pack_start(updateButton, Gtk::PACK_SHRINK);
	updateButton.signal_clicked().connect(
			sigc::mem_fun(folderList, &FolderList::do_update));

	set_timer(conf.get_update_interval());
	*/
}

void PrefDialog::on_location_add()
{
	Gtk::FileSelection dialog("Add a folder location (file or directory)");
	dialog.set_transient_for(*this);
	//dialog.get_file_list()->get_parent()->hide(); //Prevent the user from selecting a file.

	int result = dialog.run();

	//Handle the response:
	switch(result)
	{
		case(Gtk::RESPONSE_OK):
		{
			Gtk::TreeModel::Row row = *(locationListModel->append());
			row[locationListModelColumns.path] = dialog.get_filename();
			break;
		}
		case(Gtk::RESPONSE_CANCEL):
		{
			break;
		}
		default:
		{
			break;
		}
	}
}

void PrefDialog::on_location_remove()
{
	Glib::RefPtr<Gtk::TreeSelection> selection = locationList.get_selection();
	Gtk::TreeSelection::ListHandle_Path lhp = selection->get_selected_rows();

	for (Gtk::TreeSelection::ListHandle_Path::const_iterator i = lhp.begin(); i != lhp.end(); i++)
		locationListModel->erase(locationListModel->get_iter(*i));
}

void PrefDialog::on_configure_mail_programs()
{
	if (!mpconfig_configured)
	{
		mpconfig.add_button(Gtk::Stock::OK, 1);
		mpconfig.add_button(Gtk::Stock::CANCEL, 0);

		Gtk::VBox* diavbox = mpconfig.get_vbox();

		// Mail programs
		progEdit.set_model(editorListModel);
		progEdit.append_column_editable("Name", editorListModelColumns.name);
		progEdit.append_column_editable("Command", editorListModelColumns.command);

		Gtk::ScrolledWindow* edscroll = Gtk::manage(new Gtk::ScrolledWindow());
		edscroll->add(progEdit);
		edscroll->set_policy(Gtk::POLICY_AUTOMATIC, Gtk::POLICY_AUTOMATIC);
		diavbox->pack_start(*edscroll, true, true);

		Gtk::ButtonBox* bubox = Gtk::manage(new Gtk::HButtonBox());
		bubox->set_layout(Gtk::BUTTONBOX_SPREAD);
		Gtk::Button* button;

		bubox->add(*(button = new Gtk::Button("_Add", true)));
		button->signal_clicked().connect(sigc::mem_fun(*this, &PrefDialog::on_mail_program_add));
		bubox->add(*(button = new Gtk::Button("_Remove", true)));
		button->signal_clicked().connect(sigc::mem_fun(*this, &PrefDialog::on_mail_program_remove));
		diavbox->pack_start(*bubox, false, true);

		mpconfig.show_all_children();
		mpconfig_configured = true;
	}

	int res = mpconfig.run();
	debug("mpconfig result: %d\n", res);
	mpconfig.hide();
}

void PrefDialog::on_mail_program_add()
{
	Gtk::TreeModel::Row row = *(editorListModel->append());
	row[editorListModelColumns.name] = "Other";
	row[editorListModelColumns.command] = "/usr/bin/sample-mail-program --folder %p";
}

void PrefDialog::on_mail_program_remove()
{
	Glib::RefPtr<Gtk::TreeSelection> selection = progEdit.get_selection();
	Gtk::TreeSelection::ListHandle_Path lhp = selection->get_selected_rows();

	for (Gtk::TreeSelection::ListHandle_Path::const_iterator i = lhp.begin(); i != lhp.end(); i++)
		editorListModel->erase(editorListModel->get_iter(*i));
}


void PrefDialog::enact(BuffyWindow& buffy)
{
	config::Config& conf = Environment::get().config();

	// Read the new settings from the dialog controls

	// Update interval
	int val = (int)updateInterval.get_value();

	if (val != conf.general().interval())
	{
		conf.general().setInterval(val);
		buffy.set_timer(val);
	}

	// Editor selection
	std::vector<config::MailProgramInfo> oldInfo = conf.mailPrograms().getInfo();	
	std::vector<config::MailProgramInfo> newInfo;

	// See what editor is currently selected
	string selectedName;
	Gtk::TreeModel::const_iterator i = editorSelection->get_active();
	if (i != editorSelection->get_model()->children().end())
	{
		Gtk::TreeModel::Row row = *i;
		Glib::ustring name(row[editorListModelColumns.name]);
		selectedName = name;
	}
	
	// Iterate through all to see if the commands changed 
	for (Gtk::TreeModel::Children::iterator i = editorListModel->children().begin();
			i != editorListModel->children().end(); i++)
	{
		Gtk::TreeModel::Row row = *i;
		Glib::ustring s1(row[editorListModelColumns.name]);
		Glib::ustring s2(row[editorListModelColumns.command]);
		newInfo.push_back(config::MailProgramInfo(s1, s2, s1 == selectedName));
	}

	if (oldInfo != newInfo)
		conf.mailPrograms().set(newInfo);
	
	// Location list
	vector<string> locations;
	for (Gtk::TreeModel::Children::iterator i = locationListModel->children().begin();
			i != locationListModel->children().end(); i++)
	{
		Gtk::TreeModel::Row row = *i;
		Glib::ustring s = (*i)[locationListModelColumns.path];
		locations.push_back(s);
	}
	vector<string> oldLocations;

	if (oldLocations != locations)
	{
		conf.locations().set(locations);
		buffy.rescanFolders();
	}
}

void PrefDialog::reset()
{
	config::Config& conf = Environment::get().config();

	// Restore dialog controls to their original values

	// Update interval
	updateInterval.set_value(conf.general().interval());

	// Editor selection
	editorListModel->clear();
	vector<config::MailProgramNode> progs(conf.mailPrograms().get());
	for (vector<config::MailProgramNode>::const_iterator i = progs.begin();
			i != progs.end(); i++)
	{
			cerr << "HANDLE " << i->name() << " " << i->selected() << endl;
		Gtk::TreeModel::iterator iter = editorListModel->append();
		Gtk::TreeModel::Row row = *iter;
		row[editorListModelColumns.name] = i->name();
		row[editorListModelColumns.command] = i->command();
		if (i->selected())
		{
			cerr << "SETSELECTED " << i->name() << endl;
			editorSelection->set_active(iter);
		}
	}

	// Location list
	locationListModel->clear();
	vector<string> locs = conf.locations().get();
	for (vector<string>::const_iterator i = locs.begin();
			i != locs.end(); i++)
	{
		Gtk::TreeModel::Row row = *(locationListModel->append());
		row[locationListModelColumns.path] = *i;
	}
}

void PrefDialog::do_dialog(BuffyWindow* buffy)
{
	reset();

	int res = run();
	debug("Preferences result: %d\n", res);
	hide();

	if (res == 1)
		enact(*buffy);
}

// vim:set ts=4 sw=4:
