/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _TEXTURELOADER_H
#define _TEXTURELOADER_H

#include <iostream>
#include <string>
#include <vector>
#include "SDL.h"
#include "glhead.h"

using namespace std;

class TextureLoader
{
	public:
		static bool loadTexture( const string & filename, const string & name );

		// Select a texture by name or index
		static bool setTexture( const string & filename );
		static bool setTexture( unsigned int index );

		// Reload all textures (for when OpenGL context is destroyed)
		static void reload();

		// Unload all textures
		static void unload();

		// Free all OpenGL resources
		static void unloadGL();

	protected:
		static GLuint loadSurface( SDL_Surface * surf );

		static unsigned int nearestPow2( unsigned int n );

		static vector<string> names;
		static vector<GLuint> textures;
		static vector<string> filenames;
	
};
#endif
