#!	/bin/sh

set -e

if [ $# -lt 1 ]; then
    echo "usage: $0 file [file ...]" 1>&2
    echo 1>&2
    echo "strip any executable files in the argument list, leave" 1>&2
    echo "other kinds of files alone." 1>&2
    exit -1
fi

EXECUTABLES=`file $* | grep ELF | sed 's/:.*$//'`

if [ -z "$EXECUTABLES" ]; then
    echo "error: no ELF executables to strip" 1>&2
    exit 1
fi

# _dl_debug_state is a symbol of ld-linux.so that is used by GDB to breakpoint
# debug dynamicaly-loaded code. I explicitly keep it here. There will no doubt
# be other symbols like this. Saving 10 or 20 of them is probably cheap enough
# that you'd never notice the space.

strip --remove-section=.note --remove-section=.comment --keep-symbol _dl_debug_state $EXECUTABLES

exit 0
