#! /bin/bash
# PReP Boot Builder.  Copyright 1999, Matt Porter <porter@debian.org> 
# This is free software under the GNU General Public License.
 
. ./common.sh
 
# Usage message 
if [ $# -lt 2 ]; then
echo "usage: "$0" archive kver" 1>&2
        cat 1>&2 << EOF
 
        archive: the directory where Debian binary packages will be downloaded
	kver: kernel version
EOF
 
        exit -1
fi                                                                  

# set this to the location of the package archive
archive=$1

# set this to the kernel version
kver=$2

#-----------------------------------------------
# build PReP bootable images
#-----------------------------------------------

# Save the current directory
top=`pwd`

# Create a tmp directory
builddir=${tmpdir}/boot-floppies/bootprep-tmp-$$
rm -rf $builddir
make_tmpdir $builddir

# Extract kernel source and patches 
THEPKG=$(grab_paths kernel-source-$kver)
dpkg --extract $THEPKG $builddir
THEPKG=$(grab_paths kernel-patch-$kver-powerpc)
dpkg --extract $THEPKG $builddir

# Unpack kernel source 
cd $builddir/usr/src
if [ -f kernel-source-${kver}.tar.gz ]; then
  tar zxf kernel-source-$kver.tar.gz
else
  tar x --bzip2 -f kernel-source-$kver.tar.bz2
fi

# Patch kernel source - FIXME: allow for other patches
cd kernel-source-$kver
# this patch may be getting applied twice.  Comment
# this out if you get messages about patches being already
# applied.
# FIXME: there are better ways to apply kernel patches!
zcat $builddir/usr/src/kernel-patches/powerpc/*.diff.gz \
 | patch -l -s -p1

# Add rootprep.bin as the ramdisk
cp $top/rootprep.bin ./arch/ppc/coffboot/ramdisk.image.gz 

# Fix .config for ramdisk rooting and kernel ip autoconfiguration.
# This image is >1440 KB and is suitable for CD/net booting. 
sed 's:# CONFIG_CMDLINE_BOOL is not set:CONFIG_CMDLINE_BOOL=y \
CONFIG_CMDLINE="root=/dev/ram ip=off":' \
$builddir/usr/src/kernel-patches/powerpc/config.prep > .config.param

# Enable kernel ip autoconfiguration
sed 's:# CONFIG_IP_PNP is not set:CONFIG_IP_PNP=y \
CONFIG_IP_PNP_ENABLE=y \
CONFIG_IP_PNP_DHCP=y \
CONFIG_IP_PNP_BOOTP=y \
CONFIG_IP_PNP_RARP=y:' \
.config.param > .config.ipauto

# Enable nfsroot
sed 's:CONFIG_NFS_FS=y:CONFIG_NFS_FS=y \
CONFIG_ROOT_NFS=y:' \
.config.ipauto > .config
 
# Set the subarch
sed 's:EXTRAVERSION =:EXTRAVERSION = PREP:' Makefile > Makefile.new
mv Makefile.new Makefile

# Build CD/net kernel boot image
make oldconfig && make dep && make clean && make zImage.initrd
cp ./arch/ppc/boot/zImage.initrd $top/bootprepfull.bin

# Copy config.prep->.config and fix up for floppy/ramdisk rooting.
# This image is <=1440 KB and is suitable for floppy booting.
sed 's:# CONFIG_CMDLINE_BOOL is not set:CONFIG_CMDLINE_BOOL=y\
CONFIG_CMDLINE="root=/dev/fd0 load_ramdisk=1":' \
$builddir/usr/src/kernel-patches/powerpc/config.prep > .config

# Build floppy-sized kernel boot image
make oldconfig && make zImage
cp ./arch/ppc/boot/zImage $top/bootprep.bin

# Clean up
rm -rf $builddir
