#!/bin/sh

# usage: mini-iso.sh <flavour>

flavour=$1
suite=woody
arch=i386

. ./common.sh

CD=${tmpdir}/minicd-$$

BF=${CD}/dists/${suite}/main/disks-${arch}/current

mkdir -p ${CD}/boot
mkdir -p ${BF}/${flavour}
mkdir -p ${BF}/images-1.44/${flavour}

cp resc2880${flavour}.bin ${CD}/boot/rescue.bin
cp drivers${flavour}.tgz ${BF}/${flavour}/drivers.tgz

mkdir -p ${CD}/.disk
touch ${CD}/.disk/kernel_installable
touch ${CD}/.disk/info

if [ -e basedebs.tar ] ; then
   echo Found basedebs.tar, installing it...
   cp basedebs.tar $CD
   touch ${CD}/.disk/base_installable
fi

if [ "x${flavour}" != "x" ]; then
  ln -s ../../../../../../../boot/rescue.bin ${BF}/images-1.44/${flavour}/rescue.bin
else
  ln -s ../../../../../../boot/rescue.bin ${BF}/images-1.44/rescue.bin
fi

touch ${CD}/dists/${suite}/Release

if [ -f xlp.tgz ]; then
  mkdir -p ${CD}/.xlp
  gzip -dc xlp.tgz | ( cd ${CD}/.xlp; tar xf - )
fi

( cd ${CD}; mkisofs -R -b boot/rescue.bin -o ${CD}.iso . )

mv ${CD}.iso boot${flavour}.iso
rm -rf ${CD}
