// This file is automatically generated.  Do not edit
#include "config.h"

#include <cstdio>
#include <cstdlib>
#include <vector>
#include <string>
#include <iostream>
#include <sstream>
#include <algorithm>

#include "parse.h"
#include "xml_util.h"
#include "db_table.h"
#include "schema_master.h"

#ifdef _WIN32
#pragma warning( disable : 4355 )
#endif

#define found(x) ((x != std::string::npos))

#ifdef USE_NAMESPACE
using namespace ifx;
#endif


const char *db_name="sah2b@sci_master_tcp";
int db_is_open;

template <>
const char * const db_type<coordinate_t>::type_name="coordinate_t";
template <>
const char * db_type<coordinate_t>::_search_tag=type_name;
template <>
const int db_type<coordinate_t>::_nfields=3;
template <>
const char * const db_type<coordinate_t>::column_names[3]= {"time","ra","dec"
                                                           };

coordinate_t::coordinate_t() :
        db_type<coordinate_t>(*this),
        time(0),
        ra(0),
dec(0) {
    db_open();
}


coordinate_t::coordinate_t(const coordinate_t &a) :
        db_type<coordinate_t>(*this),
        time(a.time),
        ra(a.ra),
dec(a.dec) {
    db_open();
}


coordinate_t::coordinate_t(const SQL_ROW &a) :
db_type<coordinate_t>(*this) {
    db_open();
    parse(a);
}


coordinate_t::coordinate_t(const std::string &s,const char *tag) :
db_type<coordinate_t>(*this) {
    db_open();
    if (xml_match_tag(s,tag)) {
        parse_xml(s,tag);
    } else {
        parse(s);
    }
}


coordinate_t &coordinate_t::operator =(const coordinate_t &a) {
    if (&a != this) {
        time=a.time;
        ra=a.ra;
        dec=a.dec;
    }
    return (*this);
}


std::string coordinate_t::update_format() const {
    std::ostringstream rv("");

    rv << "ROW(";
    for (int i=1;i<3;i++)
        rv << "?,";
    rv << "?";
    rv << ")";

    return rv.str();
}


std::string coordinate_t::insert_format() const {
    return update_format();
}

std::string coordinate_t::select_format() const {
    std::string rv("");
    for (int i=0; i<2;i++)
        rv+="?,";
    rv+="?";
    return rv;
}

std::string coordinate_t::print(int full_subtables, int show_ids, int no_refs) const {
    std::ostringstream rv("");

    rv.precision(14);
    rv << "ROW(";
    rv << time;
    rv << ',';
    rv << ra;
    rv << ',';
    rv << dec;
    rv << ")";
    return rv.str();
}


std::string coordinate_t::print_xml(int full_subtables, int show_ids, int no_refs,const char *tag) const {
    std::ostringstream rv("");

    rv.precision(14);
    rv << xml_indent() << '<' << tag << ">\n";
    xml_indent(2);
    rv << xml_indent() << "<time>" << time << "</time>\n";
    rv << xml_indent() << "<ra>" << ra << "</ra>\n";
    rv << xml_indent() << "<dec>" << dec << "</dec>\n";
    xml_indent(-2);
    rv << xml_indent() << "</" << tag << ">\n";
    return rv.str();
}


void coordinate_t::parse_xml(const std::string &s,const char *tag) {
    std::string field,sub;
    if (extract_xml_record(s,tag,field)) {
        std::string::size_type pos=0;
        if (extract_xml_record(field,"time",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> time;
        }
        if (extract_xml_record(field,"ra",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> ra;
        }
        if (extract_xml_record(field,"dec",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> dec;
        }
    }
}

void coordinate_t::parse(const SQL_ROW &s) {
    {
        std::istringstream row(*(s[0]));
        row >> time;
    }
    {
        std::istringstream row(*(s[1]));
        row >> ra;
    }
    {
        std::istringstream row(*(s[2]));
        row >> dec;
    }
}

void coordinate_t::parse(const std::string &s) {
    SQL_ROW row(s.c_str(),3);
    parse(row);
}

template <>
const char * const db_type<chirp_parameter_t>::type_name="chirp_parameter_t";
template <>
const char * db_type<chirp_parameter_t>::_search_tag=type_name;
template <>
const int db_type<chirp_parameter_t>::_nfields=2;
template <>
const char * const db_type<chirp_parameter_t>::column_names[2]= {"chirp_limit","fft_len_flags"
                                                                };

chirp_parameter_t::chirp_parameter_t() :
        db_type<chirp_parameter_t>(*this),
        chirp_limit(0),
fft_len_flags(0) {
    db_open();
}


chirp_parameter_t::chirp_parameter_t(const chirp_parameter_t &a) :
        db_type<chirp_parameter_t>(*this),
        chirp_limit(a.chirp_limit),
fft_len_flags(a.fft_len_flags) {
    db_open();
}


chirp_parameter_t::chirp_parameter_t(const SQL_ROW &a) :
db_type<chirp_parameter_t>(*this) {
    db_open();
    parse(a);
}


chirp_parameter_t::chirp_parameter_t(const std::string &s,const char *tag) :
db_type<chirp_parameter_t>(*this) {
    db_open();
    if (xml_match_tag(s,tag)) {
        parse_xml(s,tag);
    } else {
        parse(s);
    }
}


chirp_parameter_t &chirp_parameter_t::operator =(const chirp_parameter_t &a) {
    if (&a != this) {
        chirp_limit=a.chirp_limit;
        fft_len_flags=a.fft_len_flags;
    }
    return (*this);
}


std::string chirp_parameter_t::update_format() const {
    std::ostringstream rv("");

    rv << "ROW(";
    for (int i=1;i<2;i++)
        rv << "?,";
    rv << "?";
    rv << ")";

    return rv.str();
}


std::string chirp_parameter_t::insert_format() const {
    return update_format();
}

std::string chirp_parameter_t::select_format() const {
    std::string rv("");
    for (int i=0; i<1;i++)
        rv+="?,";
    rv+="?";
    return rv;
}

std::string chirp_parameter_t::print(int full_subtables, int show_ids, int no_refs) const {
    std::ostringstream rv("");

    rv.precision(14);
    rv << "ROW(";
    rv << chirp_limit;
    rv << ',';
    rv << fft_len_flags;
    rv << ")";
    return rv.str();
}


std::string chirp_parameter_t::print_xml(int full_subtables, int show_ids, int no_refs,const char *tag) const {
    std::ostringstream rv("");

    rv.precision(14);
    rv << xml_indent() << '<' << tag << ">\n";
    xml_indent(2);
    rv << xml_indent() << "<chirp_limit>" << chirp_limit << "</chirp_limit>\n";
    rv << xml_indent() << "<fft_len_flags>" << fft_len_flags << "</fft_len_flags>\n";
    xml_indent(-2);
    rv << xml_indent() << "</" << tag << ">\n";
    return rv.str();
}


void chirp_parameter_t::parse_xml(const std::string &s,const char *tag) {
    std::string field,sub;
    if (extract_xml_record(s,tag,field)) {
        std::string::size_type pos=0;
        if (extract_xml_record(field,"chirp_limit",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> chirp_limit;
        }
        if (extract_xml_record(field,"fft_len_flags",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> fft_len_flags;
        }
    }
}

void chirp_parameter_t::parse(const SQL_ROW &s) {
    {
        std::istringstream row(*(s[0]));
        row >> chirp_limit;
    }
    {
        std::istringstream row(*(s[1]));
        row >> fft_len_flags;
    }
}

void chirp_parameter_t::parse(const std::string &s) {
    SQL_ROW row(s.c_str(),2);
    parse(row);
}

template <>
const char * const db_type<subband_description_t>::type_name="subband_description_t";
template <>
const char * db_type<subband_description_t>::_search_tag=type_name;
template <>
const int db_type<subband_description_t>::_nfields=4;
template <>
const char * const db_type<subband_description_t>::column_names[4]= {"number","center","base","sample_rate"
                                                                    };

subband_description_t::subband_description_t() :
        db_type<subband_description_t>(*this),
        number(0),
        center(0),
        base(0),
sample_rate(0) {
    db_open();
}


subband_description_t::subband_description_t(const subband_description_t &a) :
        db_type<subband_description_t>(*this),
        number(a.number),
        center(a.center),
        base(a.base),
sample_rate(a.sample_rate) {
    db_open();
}


subband_description_t::subband_description_t(const SQL_ROW &a) :
db_type<subband_description_t>(*this) {
    db_open();
    parse(a);
}


subband_description_t::subband_description_t(const std::string &s,const char *tag) :
db_type<subband_description_t>(*this) {
    db_open();
    if (xml_match_tag(s,tag)) {
        parse_xml(s,tag);
    } else {
        parse(s);
    }
}


subband_description_t &subband_description_t::operator =(const subband_description_t &a) {
    if (&a != this) {
        number=a.number;
        center=a.center;
        base=a.base;
        sample_rate=a.sample_rate;
    }
    return (*this);
}


std::string subband_description_t::update_format() const {
    std::ostringstream rv("");

    rv << "ROW(";
    for (int i=1;i<4;i++)
        rv << "?,";
    rv << "?";
    rv << ")";

    return rv.str();
}


std::string subband_description_t::insert_format() const {
    return update_format();
}

std::string subband_description_t::select_format() const {
    std::string rv("");
    for (int i=0; i<3;i++)
        rv+="?,";
    rv+="?";
    return rv;
}

std::string subband_description_t::print(int full_subtables, int show_ids, int no_refs) const {
    std::ostringstream rv("");

    rv.precision(14);
    rv << "ROW(";
    rv << number;
    rv << ',';
    rv << center;
    rv << ',';
    rv << base;
    rv << ',';
    rv << sample_rate;
    rv << ")";
    return rv.str();
}


std::string subband_description_t::print_xml(int full_subtables, int show_ids, int no_refs,const char *tag) const {
    std::ostringstream rv("");

    rv.precision(14);
    rv << xml_indent() << '<' << tag << ">\n";
    xml_indent(2);
    rv << xml_indent() << "<number>" << number << "</number>\n";
    rv << xml_indent() << "<center>" << center << "</center>\n";
    rv << xml_indent() << "<base>" << base << "</base>\n";
    rv << xml_indent() << "<sample_rate>" << sample_rate << "</sample_rate>\n";
    xml_indent(-2);
    rv << xml_indent() << "</" << tag << ">\n";
    return rv.str();
}


void subband_description_t::parse_xml(const std::string &s,const char *tag) {
    std::string field,sub;
    if (extract_xml_record(s,tag,field)) {
        std::string::size_type pos=0;
        if (extract_xml_record(field,"number",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> number;
        }
        if (extract_xml_record(field,"center",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> center;
        }
        if (extract_xml_record(field,"base",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> base;
        }
        if (extract_xml_record(field,"sample_rate",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> sample_rate;
        }
    }
}

void subband_description_t::parse(const SQL_ROW &s) {
    {
        std::istringstream row(*(s[0]));
        row >> number;
    }
    {
        std::istringstream row(*(s[1]));
        row >> center;
    }
    {
        std::istringstream row(*(s[2]));
        row >> base;
    }
    {
        std::istringstream row(*(s[3]));
        row >> sample_rate;
    }
}

void subband_description_t::parse(const std::string &s) {
    SQL_ROW row(s.c_str(),4);
    parse(row);
}

template <>
const char * const db_type<data_description_t>::type_name="data_description_t";
template <>
const char * db_type<data_description_t>::_search_tag=type_name;
template <>
const int db_type<data_description_t>::_nfields=9;
template <>
const char * const db_type<data_description_t>::column_names[9]= {"start_ra","start_dec","end_ra","end_dec","true_angle_range","time_recorded","time_recorded_jd","nsamples","coords"
                                                                 };

data_description_t::data_description_t() :
        db_type<data_description_t>(*this),
        start_ra(0),
        start_dec(0),
        end_ra(0),
        end_dec(0),
        true_angle_range(0),
        time_recorded_jd(0),
        nsamples(0),
coords((coordinate_t *)0,0,_x_xml_values) {
    db_open();
    time_recorded[0]=0;
}


data_description_t::data_description_t(const data_description_t &a) :
        db_type<data_description_t>(*this),
        start_ra(a.start_ra),
        start_dec(a.start_dec),
        end_ra(a.end_ra),
        end_dec(a.end_dec),
        true_angle_range(a.true_angle_range),
        time_recorded_jd(a.time_recorded_jd),
        nsamples(a.nsamples),
coords(a.coords) {
    db_open();
    strcpy(time_recorded,a.time_recorded);
}


data_description_t::data_description_t(const SQL_ROW &a) :
db_type<data_description_t>(*this) {
    db_open();
    parse(a);
}


data_description_t::data_description_t(const std::string &s,const char *tag) :
db_type<data_description_t>(*this) {
    db_open();
    if (xml_match_tag(s,tag)) {
        parse_xml(s,tag);
    } else {
        parse(s);
    }
}


data_description_t &data_description_t::operator =(const data_description_t &a) {
    if (&a != this) {
        start_ra=a.start_ra;
        start_dec=a.start_dec;
        end_ra=a.end_ra;
        end_dec=a.end_dec;
        true_angle_range=a.true_angle_range;
        time_recorded_jd=a.time_recorded_jd;
        nsamples=a.nsamples;
        {
            coords.clear();
            std::vector<coordinate_t>::const_iterator i(a.coords.begin());
            for (;i!=a.coords.end();i++) {
                coords.push_back(*i);
            }
        }
        strcpy(time_recorded,a.time_recorded);
    }
    return (*this);
}


std::string data_description_t::update_format() const {
    std::ostringstream rv("");

    rv << "ROW(";
    for (int i=1;i<9;i++)
        rv << "?,";
    rv << "?";
    rv << ")";

    return rv.str();
}


std::string data_description_t::insert_format() const {
    return update_format();
}

std::string data_description_t::select_format() const {
    std::string rv("");
    for (int i=0; i<8;i++)
        rv+="?,";
    rv+="?";
    return rv;
}

std::string data_description_t::print(int full_subtables, int show_ids, int no_refs) const {
    std::ostringstream rv("");

    rv.precision(14);
    rv << "ROW(";
    rv << start_ra;
    rv << ',';
    rv << start_dec;
    rv << ',';
    rv << end_ra;
    rv << ',';
    rv << end_dec;
    rv << ',';
    rv << true_angle_range;
    rv << ',';
    rv << "'" << time_recorded << "'";
    rv << ',';
    rv << time_recorded_jd;
    rv << ',';
    rv << nsamples;
    rv << ',';
    rv << "LIST {";
    {
        std::vector<coordinate_t>::const_iterator p=coords.begin();
        for (;p<coords.end();p++) {
            rv << p->print();
            if (p != coords.end()-1) {
                rv << ',';
            } else {
                rv << "}";
            }
        }
    }
    rv << ")";
    return rv.str();
}


std::string data_description_t::print_xml(int full_subtables, int show_ids, int no_refs,const char *tag) const {
    std::ostringstream rv("");

    rv.precision(14);
    rv << xml_indent() << '<' << tag << ">\n";
    xml_indent(2);
    rv << xml_indent() << "<start_ra>" << start_ra << "</start_ra>\n";
    rv << xml_indent() << "<start_dec>" << start_dec << "</start_dec>\n";
    rv << xml_indent() << "<end_ra>" << end_ra << "</end_ra>\n";
    rv << xml_indent() << "<end_dec>" << end_dec << "</end_dec>\n";
    rv << xml_indent() << "<true_angle_range>" << true_angle_range << "</true_angle_range>\n";
    {
        std::string enc_field=xml_encode_string(time_recorded,std::min(strlen(time_recorded),sizeof(time_recorded)));
        rv << xml_indent() << "<time_recorded>";
        rv << enc_field << "</time_recorded>\n";
    }
    rv << xml_indent() << "<time_recorded_jd>" << time_recorded_jd << "</time_recorded_jd>\n";
    rv << xml_indent() << "<nsamples>" << nsamples << "</nsamples>\n";
    if (coords.size()) {
        rv << xml_indent() << "<coords";
        {
            std::string enc_string=coords.print_xml();
            rv << ">\n" ;
            rv << enc_string;
        }
    }
    rv << xml_indent(-2);
    rv << "</coords>\n";
    xml_indent(-2);
    rv << xml_indent() << "</" << tag << ">\n";
    return rv.str();
}


void data_description_t::parse_xml(const std::string &s,const char *tag) {
    std::string field,sub;
    if (extract_xml_record(s,tag,field)) {
        std::string::size_type pos=0;
        if (extract_xml_record(field,"start_ra",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> start_ra;
        }
        if (extract_xml_record(field,"start_dec",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> start_dec;
        }
        if (extract_xml_record(field,"end_ra",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> end_ra;
        }
        if (extract_xml_record(field,"end_dec",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> end_dec;
        }
        if (extract_xml_record(field,"true_angle_range",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> true_angle_range;
        }
        if (extract_xml_record(field,"time_recorded",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::string::size_type epos=sub.find("<",pos);
            if (epos==std::string::npos)
                epos=sub.find('\n',pos);
            if (epos==std::string::npos)
                epos=pos+strlen(sub.c_str()+pos);
            std::vector<unsigned char> in(xml_decode_string<unsigned char>((const char *)sub.c_str()+pos,epos-pos));
            strncpy(time_recorded,(const char *)&(in.front()),std::min(in.size(),(size_t)255));
            time_recorded[std::min(in.size(),(size_t)254)]=0;
        }
        if (extract_xml_record(field,"time_recorded_jd",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> time_recorded_jd;
        }
        if (extract_xml_record(field,"nsamples",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> nsamples;
        }
        coords.clear();
        if (extract_xml_record(field,"coords",sub)) {
            pos=0;
            while ((pos=sub.find("<coordinate_t",pos)) != std::string::npos) {
                coords.push_back(coordinate_t(std::string(sub.c_str()+pos)));
                pos=sub.find("</coordinate_t",pos);
                pos=sub.find(">",pos);
            }
        }
    }
}

void data_description_t::parse(const SQL_ROW &s) {
    {
        std::istringstream row(*(s[0]));
        row >> start_ra;
    }
    {
        std::istringstream row(*(s[1]));
        row >> start_dec;
    }
    {
        std::istringstream row(*(s[2]));
        row >> end_ra;
    }
    {
        std::istringstream row(*(s[3]));
        row >> end_dec;
    }
    {
        std::istringstream row(*(s[4]));
        row >> true_angle_range;
    }
    {
        strncpy(time_recorded,s[5]->c_str(),255);
        time_recorded[254]=0;
    }
    {
        std::istringstream row(*(s[6]));
        row >> time_recorded_jd;
    }
    {
        std::istringstream row(*(s[7]));
        row >> nsamples;
    }
    {
        std::string::size_type p,q;
        int i;
        coords.clear();
        SQL_ROW tmp((*s[8]).c_str());
        for (i=0;i<tmp.argc();i++) {
            coords.push_back(coordinate_t(SQL_ROW((*tmp[i]).c_str())));
        }
    }
}

void data_description_t::parse(const std::string &s) {
    SQL_ROW row(s.c_str(),9);
    parse(row);
}

template <>
const char * const db_table<receiver_config>::table_name="receiver_config";
template <>
const char * db_table<receiver_config>::_search_tag=table_name;
template <>
const int db_table<receiver_config>::_nfields=12;
template <>
const char * const db_table<receiver_config>::column_names[12]= {"id","s4_id","name","beam_width","center_freq","latitude","longitude","elevation","diameter","az_orientation","az_corr_coeff","zen_corr_coeff"
                                                                };

receiver_config::receiver_config() :
        db_table<receiver_config>(*this,-1),
        id(0),
        s4_id(0),
        beam_width(0),
        center_freq(0),
        latitude(0),
        longitude(0),
        elevation(0),
        diameter(0),
        az_orientation(0),
        az_corr_coeff((float *)0,0,_x_csv),
zen_corr_coeff((float *)0,0,_x_csv) {
    db_open();
    name[0]=0;
}


receiver_config::receiver_config(const receiver_config &a) :
        db_table<receiver_config>(*this,-1),
        id(a.id),
        s4_id(a.s4_id),
        beam_width(a.beam_width),
        center_freq(a.center_freq),
        latitude(a.latitude),
        longitude(a.longitude),
        elevation(a.elevation),
        diameter(a.diameter),
        az_orientation(a.az_orientation),
        az_corr_coeff(a.az_corr_coeff),
zen_corr_coeff(a.zen_corr_coeff) {
    db_open();
    strcpy(name,a.name);
}


receiver_config::receiver_config(const SQL_ROW &a) :
db_table<receiver_config>(*this,-1) {
    db_open();
    parse(a);
}


receiver_config::receiver_config(const std::string &s,const char *tag) :
db_table<receiver_config>(*this,-1) {
    db_open();
    if (xml_match_tag(s,tag)) {
        parse_xml(s,tag);
    } else {
        parse(s);
    }
}


receiver_config &receiver_config::operator =(const receiver_config &a) {
    if (&a != this) {
        id=a.id;
        s4_id=a.s4_id;
        beam_width=a.beam_width;
        center_freq=a.center_freq;
        latitude=a.latitude;
        longitude=a.longitude;
        elevation=a.elevation;
        diameter=a.diameter;
        az_orientation=a.az_orientation;
        {
            az_corr_coeff.clear();
            std::vector<float>::const_iterator i(a.az_corr_coeff.begin());
            for (;i!=a.az_corr_coeff.end();i++) {
                az_corr_coeff.push_back(*i);
            }
        }
        {
            zen_corr_coeff.clear();
            std::vector<float>::const_iterator i(a.zen_corr_coeff.begin());
            for (;i!=a.zen_corr_coeff.end();i++) {
                zen_corr_coeff.push_back(*i);
            }
        }
        strcpy(name,a.name);
    }
    return (*this);
}


std::string receiver_config::update_format() const {
    std::ostringstream rv("");

    for (int i=2;i<12;i++)
        rv << "?,";
    rv << "?";
    return rv.str();
}


std::string receiver_config::insert_format() const {
    return std::string("?,")+update_format();
}

std::string receiver_config::select_format() const {
    std::string rv("");
    for (int i=0; i<11;i++)
        rv+="?,";
    rv+="?";
    return rv;
}

std::string receiver_config::print(int full_subtables, int show_ids, int no_refs) const {
    std::ostringstream rv("");

    rv.precision(14);
    if (show_ids)
        rv << id;
    rv << ',';
    rv << s4_id;
    rv << ',';
    rv << "'" << name << "'";
    rv << ',';
    rv << beam_width;
    rv << ',';
    rv << center_freq;
    rv << ',';
    rv << latitude;
    rv << ',';
    rv << longitude;
    rv << ',';
    rv << elevation;
    rv << ',';
    rv << diameter;
    rv << ',';
    rv << az_orientation;
    rv << ',';
    rv << "LIST {";
    {
        std::vector<float>::const_iterator p=az_corr_coeff.begin();
        for (;p<az_corr_coeff.end();p++) {
            rv << *p;
            if (p != az_corr_coeff.end()-1) {
                rv << ',';
            } else {
                rv << "}";
            }
        }
    }
    rv << ',';
    rv << "LIST {";
    {
        std::vector<float>::const_iterator p=zen_corr_coeff.begin();
        for (;p<zen_corr_coeff.end();p++) {
            rv << *p;
            if (p != zen_corr_coeff.end()-1) {
                rv << ',';
            } else {
                rv << "}";
            }
        }
    }
    return rv.str();
}


std::string receiver_config::print_xml(int full_subtables, int show_ids, int no_refs,const char *tag) const {
    std::ostringstream rv("");

    rv.precision(14);
    rv << xml_indent() << '<' << tag << ">\n";
    xml_indent(2);
    if (show_ids)
        rv << xml_indent() << "<id>" << id << "</id>\n";
    rv << xml_indent() << "<s4_id>" << s4_id << "</s4_id>\n";
    {
        std::string enc_field=xml_encode_string(name,std::min(strlen(name),sizeof(name)));
        rv << xml_indent() << "<name>";
        rv << enc_field << "</name>\n";
    }
    rv << xml_indent() << "<beam_width>" << beam_width << "</beam_width>\n";
    rv << xml_indent() << "<center_freq>" << center_freq << "</center_freq>\n";
    rv << xml_indent() << "<latitude>" << latitude << "</latitude>\n";
    rv << xml_indent() << "<longitude>" << longitude << "</longitude>\n";
    rv << xml_indent() << "<elevation>" << elevation << "</elevation>\n";
    rv << xml_indent() << "<diameter>" << diameter << "</diameter>\n";
    rv << xml_indent() << "<az_orientation>" << az_orientation << "</az_orientation>\n";
    if (az_corr_coeff.size()) {
        rv << xml_indent() << "<az_corr_coeff";
        {
            std::string enc_string=az_corr_coeff.print_xml();
            rv << " length=" << enc_string.size() << " encoding=\"" << xml_encoding_names[az_corr_coeff.encoding] << "\">" ;
            rv << enc_string;
        }
    }
    rv << "</az_corr_coeff>\n";
    if (zen_corr_coeff.size()) {
        rv << xml_indent() << "<zen_corr_coeff";
        {
            std::string enc_string=zen_corr_coeff.print_xml();
            rv << " length=" << enc_string.size() << " encoding=\"" << xml_encoding_names[zen_corr_coeff.encoding] << "\">" ;
            rv << enc_string;
        }
    }
    rv << "</zen_corr_coeff>\n";
    xml_indent(-2);
    rv << xml_indent() << "</" << tag << ">\n";
    return rv.str();
}


void receiver_config::parse_xml(const std::string &s,const char *tag) {
    std::string field,sub;
    if (extract_xml_record(s,tag,field)) {
        std::string::size_type pos=0;
        if (extract_xml_record(field,"id",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> id;
        }
        if (extract_xml_record(field,"s4_id",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> s4_id;
        }
        if (extract_xml_record(field,"name",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::string::size_type epos=sub.find("<",pos);
            if (epos==std::string::npos)
                epos=sub.find('\n',pos);
            if (epos==std::string::npos)
                epos=pos+strlen(sub.c_str()+pos);
            std::vector<unsigned char> in(xml_decode_string<unsigned char>((const char *)sub.c_str()+pos,epos-pos));
            strncpy(name,(const char *)&(in.front()),std::min(in.size(),(size_t)255));
            name[std::min(in.size(),(size_t)254)]=0;
        }
        if (extract_xml_record(field,"beam_width",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> beam_width;
        }
        if (extract_xml_record(field,"center_freq",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> center_freq;
        }
        if (extract_xml_record(field,"latitude",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> latitude;
        }
        if (extract_xml_record(field,"longitude",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> longitude;
        }
        if (extract_xml_record(field,"elevation",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> elevation;
        }
        if (extract_xml_record(field,"diameter",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> diameter;
        }
        if (extract_xml_record(field,"az_orientation",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> az_orientation;
        }
        az_corr_coeff.clear();
        if (extract_xml_record(field,"az_corr_coeff",sub)) {
            pos=sub.find(">");
            do {
                if (pos!=std::string::npos) {
                    do {
                        pos++;
                    } while ((sub[pos]=='\n') || (sub[pos]==','));
                    std::istringstream in(std::string(sub.c_str()+pos));
                    float tmp;
                    in >> tmp;
                    az_corr_coeff.push_back(tmp);
                }
            } while ((pos=sub.find(",",pos)) != std::string::npos);
        }
        zen_corr_coeff.clear();
        if (extract_xml_record(field,"zen_corr_coeff",sub)) {
            pos=sub.find(">");
            do {
                if (pos!=std::string::npos) {
                    do {
                        pos++;
                    } while ((sub[pos]=='\n') || (sub[pos]==','));
                    std::istringstream in(std::string(sub.c_str()+pos));
                    float tmp;
                    in >> tmp;
                    zen_corr_coeff.push_back(tmp);
                }
            } while ((pos=sub.find(",",pos)) != std::string::npos);
        }
    }
}

void receiver_config::parse(const SQL_ROW &s) {
    {
        std::istringstream row(*(s[0]));
        row >> id;
    }
    {
        std::istringstream row(*(s[1]));
        row >> s4_id;
    }
    {
        strncpy(name,s[2]->c_str(),255);
        name[254]=0;
    }
    {
        std::istringstream row(*(s[3]));
        row >> beam_width;
    }
    {
        std::istringstream row(*(s[4]));
        row >> center_freq;
    }
    {
        std::istringstream row(*(s[5]));
        row >> latitude;
    }
    {
        std::istringstream row(*(s[6]));
        row >> longitude;
    }
    {
        std::istringstream row(*(s[7]));
        row >> elevation;
    }
    {
        std::istringstream row(*(s[8]));
        row >> diameter;
    }
    {
        std::istringstream row(*(s[9]));
        row >> az_orientation;
    }
    {
        std::string::size_type p,q;
        int i;
        az_corr_coeff.clear();
        SQL_ROW tmp((*s[10]).c_str());
        for (i=0;i<tmp.argc();i++) {
            std::istringstream in(*(tmp[i]));
            float tmp0;
            in >> tmp0;
            az_corr_coeff.push_back(tmp0);
        }
    }
    {
        std::string::size_type p,q;
        int i;
        zen_corr_coeff.clear();
        SQL_ROW tmp((*s[11]).c_str());
        for (i=0;i<tmp.argc();i++) {
            std::istringstream in(*(tmp[i]));
            float tmp0;
            in >> tmp0;
            zen_corr_coeff.push_back(tmp0);
        }
    }
}

void receiver_config::parse(const std::string &s) {
    SQL_ROW row(s.c_str(),12);
    parse(row);
}

template <>
const char * const db_table<recorder_config>::table_name="recorder_config";
template <>
const char * db_table<recorder_config>::_search_tag=table_name;
template <>
const int db_table<recorder_config>::_nfields=6;
template <>
const char * const db_table<recorder_config>::column_names[6]= {"id","name","bits_per_sample","sample_rate","beams","version"
                                                               };

recorder_config::recorder_config() :
        db_table<recorder_config>(*this,-1),
        id(0),
        bits_per_sample(0),
        sample_rate(0),
        beams(0),
version(0) {
    db_open();
    name[0]=0;
}


recorder_config::recorder_config(const recorder_config &a) :
        db_table<recorder_config>(*this,-1),
        id(a.id),
        bits_per_sample(a.bits_per_sample),
        sample_rate(a.sample_rate),
        beams(a.beams),
version(a.version) {
    db_open();
    strcpy(name,a.name);
}


recorder_config::recorder_config(const SQL_ROW &a) :
db_table<recorder_config>(*this,-1) {
    db_open();
    parse(a);
}


recorder_config::recorder_config(const std::string &s,const char *tag) :
db_table<recorder_config>(*this,-1) {
    db_open();
    if (xml_match_tag(s,tag)) {
        parse_xml(s,tag);
    } else {
        parse(s);
    }
}


recorder_config &recorder_config::operator =(const recorder_config &a) {
    if (&a != this) {
        id=a.id;
        bits_per_sample=a.bits_per_sample;
        sample_rate=a.sample_rate;
        beams=a.beams;
        version=a.version;
        strcpy(name,a.name);
    }
    return (*this);
}


std::string recorder_config::update_format() const {
    std::ostringstream rv("");

    for (int i=2;i<6;i++)
        rv << "?,";
    rv << "?";
    return rv.str();
}


std::string recorder_config::insert_format() const {
    return std::string("?,")+update_format();
}

std::string recorder_config::select_format() const {
    std::string rv("");
    for (int i=0; i<5;i++)
        rv+="?,";
    rv+="?";
    return rv;
}

std::string recorder_config::print(int full_subtables, int show_ids, int no_refs) const {
    std::ostringstream rv("");

    rv.precision(14);
    if (show_ids)
        rv << id;
    rv << ',';
    rv << "'" << name << "'";
    rv << ',';
    rv << bits_per_sample;
    rv << ',';
    rv << sample_rate;
    rv << ',';
    rv << beams;
    rv << ',';
    rv << version;
    return rv.str();
}


std::string recorder_config::print_xml(int full_subtables, int show_ids, int no_refs,const char *tag) const {
    std::ostringstream rv("");

    rv.precision(14);
    rv << xml_indent() << '<' << tag << ">\n";
    xml_indent(2);
    if (show_ids)
        rv << xml_indent() << "<id>" << id << "</id>\n";
    {
        std::string enc_field=xml_encode_string(name,std::min(strlen(name),sizeof(name)));
        rv << xml_indent() << "<name>";
        rv << enc_field << "</name>\n";
    }
    rv << xml_indent() << "<bits_per_sample>" << bits_per_sample << "</bits_per_sample>\n";
    rv << xml_indent() << "<sample_rate>" << sample_rate << "</sample_rate>\n";
    rv << xml_indent() << "<beams>" << beams << "</beams>\n";
    rv << xml_indent() << "<version>" << version << "</version>\n";
    xml_indent(-2);
    rv << xml_indent() << "</" << tag << ">\n";
    return rv.str();
}


void recorder_config::parse_xml(const std::string &s,const char *tag) {
    std::string field,sub;
    if (extract_xml_record(s,tag,field)) {
        std::string::size_type pos=0;
        if (extract_xml_record(field,"id",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> id;
        }
        if (extract_xml_record(field,"name",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::string::size_type epos=sub.find("<",pos);
            if (epos==std::string::npos)
                epos=sub.find('\n',pos);
            if (epos==std::string::npos)
                epos=pos+strlen(sub.c_str()+pos);
            std::vector<unsigned char> in(xml_decode_string<unsigned char>((const char *)sub.c_str()+pos,epos-pos));
            strncpy(name,(const char *)&(in.front()),std::min(in.size(),(size_t)64));
            name[std::min(in.size(),(size_t)63)]=0;
        }
        if (extract_xml_record(field,"bits_per_sample",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> bits_per_sample;
        }
        if (extract_xml_record(field,"sample_rate",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> sample_rate;
        }
        if (extract_xml_record(field,"beams",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> beams;
        }
        if (extract_xml_record(field,"version",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> version;
        }
    }
}

void recorder_config::parse(const SQL_ROW &s) {
    {
        std::istringstream row(*(s[0]));
        row >> id;
    }
    {
        strncpy(name,s[1]->c_str(),64);
        name[63]=0;
    }
    {
        std::istringstream row(*(s[2]));
        row >> bits_per_sample;
    }
    {
        std::istringstream row(*(s[3]));
        row >> sample_rate;
    }
    {
        std::istringstream row(*(s[4]));
        row >> beams;
    }
    {
        std::istringstream row(*(s[5]));
        row >> version;
    }
}

void recorder_config::parse(const std::string &s) {
    SQL_ROW row(s.c_str(),6);
    parse(row);
}

template <>
const char * const db_table<splitter_config>::table_name="splitter_config";
template <>
const char * db_table<splitter_config>::_search_tag=table_name;
template <>
const int db_table<splitter_config>::_nfields=7;
template <>
const char * const db_table<splitter_config>::column_names[7]= {"id","version","data_type","fft_len","ifft_len""filter""window"
                                                               };

splitter_config::splitter_config() :
        db_table<splitter_config>(*this,-1),
        id(0),
        version(0),
        fft_len(0),
ifft_len(0) {
    db_open();
    data_type[0]=0;
    filter[0]=0;
    window[0]=0;
}


splitter_config::splitter_config(const splitter_config &a) :
        db_table<splitter_config>(*this,-1),
        id(a.id),
        version(a.version),
        fft_len(a.fft_len),
ifft_len(a.ifft_len) {
    db_open();
    strcpy(data_type,a.data_type);
    strcpy(filter,a.filter);
    strcpy(window,a.window);
}


splitter_config::splitter_config(const SQL_ROW &a) :
db_table<splitter_config>(*this,-1) {
    db_open();
    parse(a);
}


splitter_config::splitter_config(const std::string &s,const char *tag) :
db_table<splitter_config>(*this,-1) {
    db_open();
    if (xml_match_tag(s,tag)) {
        parse_xml(s,tag);
    } else {
        parse(s);
    }
}


splitter_config &splitter_config::operator =(const splitter_config &a) {
    if (&a != this) {
        id=a.id;
        version=a.version;
        fft_len=a.fft_len;
        ifft_len=a.ifft_len;
        strcpy(data_type,a.data_type);
        strcpy(filter,a.filter);
        strcpy(window,a.window);
    }
    return (*this);
}


std::string splitter_config::update_format() const {
    std::ostringstream rv("");

    for (int i=2;i<7;i++)
        rv << "?,";
    rv << "?";
    return rv.str();
}


std::string splitter_config::insert_format() const {
    return std::string("?,")+update_format();
}

std::string splitter_config::select_format() const {
    std::string rv("");
    for (int i=0; i<6;i++)
        rv+="?,";
    rv+="?";
    return rv;
}

std::string splitter_config::print(int full_subtables, int show_ids, int no_refs) const {
    std::ostringstream rv("");

    rv.precision(14);
    if (show_ids)
        rv << id;
    rv << ',';
    rv << version;
    rv << ',';
    rv << "'" << data_type << "'";
    rv << ',';
    rv << fft_len;
    rv << ',';
    rv << ifft_len;
    rv << ',';
    rv << "'" << filter << "'";
    rv << ',';
    rv << "'" << window << "'";
    return rv.str();
}


std::string splitter_config::print_xml(int full_subtables, int show_ids, int no_refs,const char *tag) const {
    std::ostringstream rv("");

    rv.precision(14);
    rv << xml_indent() << '<' << tag << ">\n";
    xml_indent(2);
    if (show_ids)
        rv << xml_indent() << "<id>" << id << "</id>\n";
    rv << xml_indent() << "<version>" << version << "</version>\n";
    {
        std::string enc_field=xml_encode_string(data_type,std::min(strlen(data_type),sizeof(data_type)));
        rv << xml_indent() << "<data_type>";
        rv << enc_field << "</data_type>\n";
    }
    rv << xml_indent() << "<fft_len>" << fft_len << "</fft_len>\n";
    rv << xml_indent() << "<ifft_len>" << ifft_len << "</ifft_len>\n";
    {
        std::string enc_field=xml_encode_string(filter,std::min(strlen(filter),sizeof(filter)));
        rv << xml_indent() << "<filter>";
        rv << enc_field << "</filter>\n";
    }
    {
        std::string enc_field=xml_encode_string(window,std::min(strlen(window),sizeof(window)));
        rv << xml_indent() << "<window>";
        rv << enc_field << "</window>\n";
    }
    xml_indent(-2);
    rv << xml_indent() << "</" << tag << ">\n";
    return rv.str();
}


void splitter_config::parse_xml(const std::string &s,const char *tag) {
    std::string field,sub;
    if (extract_xml_record(s,tag,field)) {
        std::string::size_type pos=0;
        if (extract_xml_record(field,"id",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> id;
        }
        if (extract_xml_record(field,"version",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> version;
        }
        if (extract_xml_record(field,"data_type",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::string::size_type epos=sub.find("<",pos);
            if (epos==std::string::npos)
                epos=sub.find('\n',pos);
            if (epos==std::string::npos)
                epos=pos+strlen(sub.c_str()+pos);
            std::vector<unsigned char> in(xml_decode_string<unsigned char>((const char *)sub.c_str()+pos,epos-pos));
            strncpy(data_type,(const char *)&(in.front()),std::min(in.size(),(size_t)64));
            data_type[std::min(in.size(),(size_t)63)]=0;
        }
        if (extract_xml_record(field,"fft_len",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> fft_len;
        }
        if (extract_xml_record(field,"ifft_len",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> ifft_len;
        }
        if (extract_xml_record(field,"filter",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::string::size_type epos=sub.find("<",pos);
            if (epos==std::string::npos)
                epos=sub.find('\n',pos);
            if (epos==std::string::npos)
                epos=pos+strlen(sub.c_str()+pos);
            std::vector<unsigned char> in(xml_decode_string<unsigned char>((const char *)sub.c_str()+pos,epos-pos));
            strncpy(filter,(const char *)&(in.front()),std::min(in.size(),(size_t)64));
            filter[std::min(in.size(),(size_t)63)]=0;
        }
        if (extract_xml_record(field,"window",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::string::size_type epos=sub.find("<",pos);
            if (epos==std::string::npos)
                epos=sub.find('\n',pos);
            if (epos==std::string::npos)
                epos=pos+strlen(sub.c_str()+pos);
            std::vector<unsigned char> in(xml_decode_string<unsigned char>((const char *)sub.c_str()+pos,epos-pos));
            strncpy(window,(const char *)&(in.front()),std::min(in.size(),(size_t)64));
            window[std::min(in.size(),(size_t)63)]=0;
        }
    }
}

void splitter_config::parse(const SQL_ROW &s) {
    {
        std::istringstream row(*(s[0]));
        row >> id;
    }
    {
        std::istringstream row(*(s[1]));
        row >> version;
    }
    {
        strncpy(data_type,s[2]->c_str(),64);
        data_type[63]=0;
    }
    {
        std::istringstream row(*(s[3]));
        row >> fft_len;
    }
    {
        std::istringstream row(*(s[4]));
        row >> ifft_len;
    }
    {
        strncpy(filter,s[5]->c_str(),64);
        filter[63]=0;
    }
    {
        strncpy(window,s[6]->c_str(),64);
        window[63]=0;
    }
}

void splitter_config::parse(const std::string &s) {
    SQL_ROW row(s.c_str(),7);
    parse(row);
}

template <>
const char * const db_table<analysis_config>::table_name="analysis_config";
template <>
const char * db_table<analysis_config>::_search_tag=table_name;
template <>
const int db_table<analysis_config>::_nfields=34;
template <>
const char * const db_table<analysis_config>::column_names[34]= {"id","spike_thresh","spikes_per_spectrum","gauss_null_chi_sq_thresh","gauss_chi_sq_thresh","gauss_power_thresh","gauss_peak_power_thresh","gauss_pot_length","pulse_thresh","pulse_display_thresh","pulse_max","pulse_min","pulse_fft_max","pulse_pot_length","triplet_thresh","triplet_max","triplet_min","triplet_pot_length","pot_overlap_factor","pot_t_offset","pot_min_slew","pot_max_slew","chirp_resolution","analysis_fft_lengths","bsmooth_boxcar_length","bsmooth_chunk_size","chirps","pulse_beams","max_signals","max_spikes","max_gaussians","max_pulses","max_triplets","keyuniq"
                                                                };

analysis_config::analysis_config() :
        db_table<analysis_config>(*this,-1),
        id(0),
        spike_thresh(0),
        spikes_per_spectrum(0),
        gauss_null_chi_sq_thresh(0),
        gauss_chi_sq_thresh(0),
        gauss_power_thresh(0),
        gauss_peak_power_thresh(0),
        gauss_pot_length(0),
        pulse_thresh(0),
        pulse_display_thresh(0),
        pulse_max(0),
        pulse_min(0),
        pulse_fft_max(0),
        pulse_pot_length(0),
        triplet_thresh(0),
        triplet_max(0),
        triplet_min(0),
        triplet_pot_length(0),
        pot_overlap_factor(0),
        pot_t_offset(0),
        pot_min_slew(0),
        pot_max_slew(0),
        chirp_resolution(0),
        analysis_fft_lengths(0),
        bsmooth_boxcar_length(0),
        bsmooth_chunk_size(0),
        chirps((chirp_parameter_t *)0,0,_x_xml_values),
        pulse_beams(0),
        max_signals(0),
        max_spikes(0),
        max_gaussians(0),
        max_pulses(0),
        max_triplets(0),
keyuniq(0) {
    db_open();
}


analysis_config::analysis_config(const analysis_config &a) :
        db_table<analysis_config>(*this,-1),
        id(a.id),
        spike_thresh(a.spike_thresh),
        spikes_per_spectrum(a.spikes_per_spectrum),
        gauss_null_chi_sq_thresh(a.gauss_null_chi_sq_thresh),
        gauss_chi_sq_thresh(a.gauss_chi_sq_thresh),
        gauss_power_thresh(a.gauss_power_thresh),
        gauss_peak_power_thresh(a.gauss_peak_power_thresh),
        gauss_pot_length(a.gauss_pot_length),
        pulse_thresh(a.pulse_thresh),
        pulse_display_thresh(a.pulse_display_thresh),
        pulse_max(a.pulse_max),
        pulse_min(a.pulse_min),
        pulse_fft_max(a.pulse_fft_max),
        pulse_pot_length(a.pulse_pot_length),
        triplet_thresh(a.triplet_thresh),
        triplet_max(a.triplet_max),
        triplet_min(a.triplet_min),
        triplet_pot_length(a.triplet_pot_length),
        pot_overlap_factor(a.pot_overlap_factor),
        pot_t_offset(a.pot_t_offset),
        pot_min_slew(a.pot_min_slew),
        pot_max_slew(a.pot_max_slew),
        chirp_resolution(a.chirp_resolution),
        analysis_fft_lengths(a.analysis_fft_lengths),
        bsmooth_boxcar_length(a.bsmooth_boxcar_length),
        bsmooth_chunk_size(a.bsmooth_chunk_size),
        chirps(a.chirps),
        pulse_beams(a.pulse_beams),
        max_signals(a.max_signals),
        max_spikes(a.max_spikes),
        max_gaussians(a.max_gaussians),
        max_pulses(a.max_pulses),
        max_triplets(a.max_triplets),
keyuniq(a.keyuniq) {
    db_open();
}


analysis_config::analysis_config(const SQL_ROW &a) :
db_table<analysis_config>(*this,-1) {
    db_open();
    parse(a);
}


analysis_config::analysis_config(const std::string &s,const char *tag) :
db_table<analysis_config>(*this,-1) {
    db_open();
    if (xml_match_tag(s,tag)) {
        parse_xml(s,tag);
    } else {
        parse(s);
    }
}


analysis_config &analysis_config::operator =(const analysis_config &a) {
    if (&a != this) {
        id=a.id;
        spike_thresh=a.spike_thresh;
        spikes_per_spectrum=a.spikes_per_spectrum;
        gauss_null_chi_sq_thresh=a.gauss_null_chi_sq_thresh;
        gauss_chi_sq_thresh=a.gauss_chi_sq_thresh;
        gauss_power_thresh=a.gauss_power_thresh;
        gauss_peak_power_thresh=a.gauss_peak_power_thresh;
        gauss_pot_length=a.gauss_pot_length;
        pulse_thresh=a.pulse_thresh;
        pulse_display_thresh=a.pulse_display_thresh;
        pulse_max=a.pulse_max;
        pulse_min=a.pulse_min;
        pulse_fft_max=a.pulse_fft_max;
        pulse_pot_length=a.pulse_pot_length;
        triplet_thresh=a.triplet_thresh;
        triplet_max=a.triplet_max;
        triplet_min=a.triplet_min;
        triplet_pot_length=a.triplet_pot_length;
        pot_overlap_factor=a.pot_overlap_factor;
        pot_t_offset=a.pot_t_offset;
        pot_min_slew=a.pot_min_slew;
        pot_max_slew=a.pot_max_slew;
        chirp_resolution=a.chirp_resolution;
        analysis_fft_lengths=a.analysis_fft_lengths;
        bsmooth_boxcar_length=a.bsmooth_boxcar_length;
        bsmooth_chunk_size=a.bsmooth_chunk_size;
        {
            chirps.clear();
            std::vector<chirp_parameter_t>::const_iterator i(a.chirps.begin());
            for (;i!=a.chirps.end();i++) {
                chirps.push_back(*i);
            }
        }
        pulse_beams=a.pulse_beams;
        max_signals=a.max_signals;
        max_spikes=a.max_spikes;
        max_gaussians=a.max_gaussians;
        max_pulses=a.max_pulses;
        max_triplets=a.max_triplets;
        keyuniq=a.keyuniq;
    }
    return (*this);
}


std::string analysis_config::update_format() const {
    std::ostringstream rv("");

    for (int i=2;i<34;i++)
        rv << "?,";
    rv << "?";
    return rv.str();
}


std::string analysis_config::insert_format() const {
    return std::string("?,")+update_format();
}

std::string analysis_config::select_format() const {
    std::string rv("");
    for (int i=0; i<33;i++)
        rv+="?,";
    rv+="?";
    return rv;
}

std::string analysis_config::print(int full_subtables, int show_ids, int no_refs) const {
    std::ostringstream rv("");

    rv.precision(14);
    if (show_ids)
        rv << id;
    rv << ',';
    rv << spike_thresh;
    rv << ',';
    rv << spikes_per_spectrum;
    rv << ',';
    rv << gauss_null_chi_sq_thresh;
    rv << ',';
    rv << gauss_chi_sq_thresh;
    rv << ',';
    rv << gauss_power_thresh;
    rv << ',';
    rv << gauss_peak_power_thresh;
    rv << ',';
    rv << gauss_pot_length;
    rv << ',';
    rv << pulse_thresh;
    rv << ',';
    rv << pulse_display_thresh;
    rv << ',';
    rv << pulse_max;
    rv << ',';
    rv << pulse_min;
    rv << ',';
    rv << pulse_fft_max;
    rv << ',';
    rv << pulse_pot_length;
    rv << ',';
    rv << triplet_thresh;
    rv << ',';
    rv << triplet_max;
    rv << ',';
    rv << triplet_min;
    rv << ',';
    rv << triplet_pot_length;
    rv << ',';
    rv << pot_overlap_factor;
    rv << ',';
    rv << pot_t_offset;
    rv << ',';
    rv << pot_min_slew;
    rv << ',';
    rv << pot_max_slew;
    rv << ',';
    rv << chirp_resolution;
    rv << ',';
    rv << analysis_fft_lengths;
    rv << ',';
    rv << bsmooth_boxcar_length;
    rv << ',';
    rv << bsmooth_chunk_size;
    rv << ',';
    rv << "LIST {";
    {
        std::vector<chirp_parameter_t>::const_iterator p=chirps.begin();
        for (;p<chirps.end();p++) {
            rv << p->print();
            if (p != chirps.end()-1) {
                rv << ',';
            } else {
                rv << "}";
            }
        }
    }
    rv << ',';
    rv << pulse_beams;
    rv << ',';
    rv << max_signals;
    rv << ',';
    rv << max_spikes;
    rv << ',';
    rv << max_gaussians;
    rv << ',';
    rv << max_pulses;
    rv << ',';
    rv << max_triplets;
    rv << ',';
    rv << keyuniq;
    return rv.str();
}


std::string analysis_config::print_xml(int full_subtables, int show_ids, int no_refs,const char *tag) const {
    std::ostringstream rv("");

    rv.precision(14);
    rv << xml_indent() << '<' << tag << ">\n";
    xml_indent(2);
    if (show_ids)
        rv << xml_indent() << "<id>" << id << "</id>\n";
    rv << xml_indent() << "<spike_thresh>" << spike_thresh << "</spike_thresh>\n";
    rv << xml_indent() << "<spikes_per_spectrum>" << spikes_per_spectrum << "</spikes_per_spectrum>\n";
    rv << xml_indent() << "<gauss_null_chi_sq_thresh>" << gauss_null_chi_sq_thresh << "</gauss_null_chi_sq_thresh>\n";
    rv << xml_indent() << "<gauss_chi_sq_thresh>" << gauss_chi_sq_thresh << "</gauss_chi_sq_thresh>\n";
    rv << xml_indent() << "<gauss_power_thresh>" << gauss_power_thresh << "</gauss_power_thresh>\n";
    rv << xml_indent() << "<gauss_peak_power_thresh>" << gauss_peak_power_thresh << "</gauss_peak_power_thresh>\n";
    rv << xml_indent() << "<gauss_pot_length>" << gauss_pot_length << "</gauss_pot_length>\n";
    rv << xml_indent() << "<pulse_thresh>" << pulse_thresh << "</pulse_thresh>\n";
    rv << xml_indent() << "<pulse_display_thresh>" << pulse_display_thresh << "</pulse_display_thresh>\n";
    rv << xml_indent() << "<pulse_max>" << pulse_max << "</pulse_max>\n";
    rv << xml_indent() << "<pulse_min>" << pulse_min << "</pulse_min>\n";
    rv << xml_indent() << "<pulse_fft_max>" << pulse_fft_max << "</pulse_fft_max>\n";
    rv << xml_indent() << "<pulse_pot_length>" << pulse_pot_length << "</pulse_pot_length>\n";
    rv << xml_indent() << "<triplet_thresh>" << triplet_thresh << "</triplet_thresh>\n";
    rv << xml_indent() << "<triplet_max>" << triplet_max << "</triplet_max>\n";
    rv << xml_indent() << "<triplet_min>" << triplet_min << "</triplet_min>\n";
    rv << xml_indent() << "<triplet_pot_length>" << triplet_pot_length << "</triplet_pot_length>\n";
    rv << xml_indent() << "<pot_overlap_factor>" << pot_overlap_factor << "</pot_overlap_factor>\n";
    rv << xml_indent() << "<pot_t_offset>" << pot_t_offset << "</pot_t_offset>\n";
    rv << xml_indent() << "<pot_min_slew>" << pot_min_slew << "</pot_min_slew>\n";
    rv << xml_indent() << "<pot_max_slew>" << pot_max_slew << "</pot_max_slew>\n";
    rv << xml_indent() << "<chirp_resolution>" << chirp_resolution << "</chirp_resolution>\n";
    rv << xml_indent() << "<analysis_fft_lengths>" << analysis_fft_lengths << "</analysis_fft_lengths>\n";
    rv << xml_indent() << "<bsmooth_boxcar_length>" << bsmooth_boxcar_length << "</bsmooth_boxcar_length>\n";
    rv << xml_indent() << "<bsmooth_chunk_size>" << bsmooth_chunk_size << "</bsmooth_chunk_size>\n";
    if (chirps.size()) {
        rv << xml_indent() << "<chirps";
        {
            std::string enc_string=chirps.print_xml();
            rv << ">\n" ;
            rv << enc_string;
        }
    }
    rv << xml_indent(-2);
    rv << "</chirps>\n";
    rv << xml_indent() << "<pulse_beams>" << pulse_beams << "</pulse_beams>\n";
    rv << xml_indent() << "<max_signals>" << max_signals << "</max_signals>\n";
    rv << xml_indent() << "<max_spikes>" << max_spikes << "</max_spikes>\n";
    rv << xml_indent() << "<max_gaussians>" << max_gaussians << "</max_gaussians>\n";
    rv << xml_indent() << "<max_pulses>" << max_pulses << "</max_pulses>\n";
    rv << xml_indent() << "<max_triplets>" << max_triplets << "</max_triplets>\n";
    rv << xml_indent() << "<keyuniq>" << keyuniq << "</keyuniq>\n";
    xml_indent(-2);
    rv << xml_indent() << "</" << tag << ">\n";
    return rv.str();
}


void analysis_config::parse_xml(const std::string &s,const char *tag) {
    std::string field,sub;
    if (extract_xml_record(s,tag,field)) {
        std::string::size_type pos=0;
        if (extract_xml_record(field,"id",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> id;
        }
        if (extract_xml_record(field,"spike_thresh",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> spike_thresh;
        }
        if (extract_xml_record(field,"spikes_per_spectrum",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> spikes_per_spectrum;
        }
        if (extract_xml_record(field,"gauss_null_chi_sq_thresh",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> gauss_null_chi_sq_thresh;
        }
        if (extract_xml_record(field,"gauss_chi_sq_thresh",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> gauss_chi_sq_thresh;
        }
        if (extract_xml_record(field,"gauss_power_thresh",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> gauss_power_thresh;
        }
        if (extract_xml_record(field,"gauss_peak_power_thresh",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> gauss_peak_power_thresh;
        }
        if (extract_xml_record(field,"gauss_pot_length",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> gauss_pot_length;
        }
        if (extract_xml_record(field,"pulse_thresh",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> pulse_thresh;
        }
        if (extract_xml_record(field,"pulse_display_thresh",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> pulse_display_thresh;
        }
        if (extract_xml_record(field,"pulse_max",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> pulse_max;
        }
        if (extract_xml_record(field,"pulse_min",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> pulse_min;
        }
        if (extract_xml_record(field,"pulse_fft_max",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> pulse_fft_max;
        }
        if (extract_xml_record(field,"pulse_pot_length",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> pulse_pot_length;
        }
        if (extract_xml_record(field,"triplet_thresh",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> triplet_thresh;
        }
        if (extract_xml_record(field,"triplet_max",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> triplet_max;
        }
        if (extract_xml_record(field,"triplet_min",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> triplet_min;
        }
        if (extract_xml_record(field,"triplet_pot_length",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> triplet_pot_length;
        }
        if (extract_xml_record(field,"pot_overlap_factor",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> pot_overlap_factor;
        }
        if (extract_xml_record(field,"pot_t_offset",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> pot_t_offset;
        }
        if (extract_xml_record(field,"pot_min_slew",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> pot_min_slew;
        }
        if (extract_xml_record(field,"pot_max_slew",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> pot_max_slew;
        }
        if (extract_xml_record(field,"chirp_resolution",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> chirp_resolution;
        }
        if (extract_xml_record(field,"analysis_fft_lengths",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> analysis_fft_lengths;
        }
        if (extract_xml_record(field,"bsmooth_boxcar_length",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> bsmooth_boxcar_length;
        }
        if (extract_xml_record(field,"bsmooth_chunk_size",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> bsmooth_chunk_size;
        }
        chirps.clear();
        if (extract_xml_record(field,"chirps",sub)) {
            pos=0;
            while ((pos=sub.find("<chirp_parameter_t",pos)) != std::string::npos) {
                chirps.push_back(chirp_parameter_t(std::string(sub.c_str()+pos)));
                pos=sub.find("</chirp_parameter_t",pos);
                pos=sub.find(">",pos);
            }
        }
        if (extract_xml_record(field,"pulse_beams",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> pulse_beams;
        }
        if (extract_xml_record(field,"max_signals",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> max_signals;
        }
        if (extract_xml_record(field,"max_spikes",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> max_spikes;
        }
        if (extract_xml_record(field,"max_gaussians",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> max_gaussians;
        }
        if (extract_xml_record(field,"max_pulses",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> max_pulses;
        }
        if (extract_xml_record(field,"max_triplets",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> max_triplets;
        }
        if (extract_xml_record(field,"keyuniq",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> keyuniq;
        }
    }
}

void analysis_config::parse(const SQL_ROW &s) {
    {
        std::istringstream row(*(s[0]));
        row >> id;
    }
    {
        std::istringstream row(*(s[1]));
        row >> spike_thresh;
    }
    {
        std::istringstream row(*(s[2]));
        row >> spikes_per_spectrum;
    }
    {
        std::istringstream row(*(s[3]));
        row >> gauss_null_chi_sq_thresh;
    }
    {
        std::istringstream row(*(s[4]));
        row >> gauss_chi_sq_thresh;
    }
    {
        std::istringstream row(*(s[5]));
        row >> gauss_power_thresh;
    }
    {
        std::istringstream row(*(s[6]));
        row >> gauss_peak_power_thresh;
    }
    {
        std::istringstream row(*(s[7]));
        row >> gauss_pot_length;
    }
    {
        std::istringstream row(*(s[8]));
        row >> pulse_thresh;
    }
    {
        std::istringstream row(*(s[9]));
        row >> pulse_display_thresh;
    }
    {
        std::istringstream row(*(s[10]));
        row >> pulse_max;
    }
    {
        std::istringstream row(*(s[11]));
        row >> pulse_min;
    }
    {
        std::istringstream row(*(s[12]));
        row >> pulse_fft_max;
    }
    {
        std::istringstream row(*(s[13]));
        row >> pulse_pot_length;
    }
    {
        std::istringstream row(*(s[14]));
        row >> triplet_thresh;
    }
    {
        std::istringstream row(*(s[15]));
        row >> triplet_max;
    }
    {
        std::istringstream row(*(s[16]));
        row >> triplet_min;
    }
    {
        std::istringstream row(*(s[17]));
        row >> triplet_pot_length;
    }
    {
        std::istringstream row(*(s[18]));
        row >> pot_overlap_factor;
    }
    {
        std::istringstream row(*(s[19]));
        row >> pot_t_offset;
    }
    {
        std::istringstream row(*(s[20]));
        row >> pot_min_slew;
    }
    {
        std::istringstream row(*(s[21]));
        row >> pot_max_slew;
    }
    {
        std::istringstream row(*(s[22]));
        row >> chirp_resolution;
    }
    {
        std::istringstream row(*(s[23]));
        row >> analysis_fft_lengths;
    }
    {
        std::istringstream row(*(s[24]));
        row >> bsmooth_boxcar_length;
    }
    {
        std::istringstream row(*(s[25]));
        row >> bsmooth_chunk_size;
    }
    {
        std::string::size_type p,q;
        int i;
        chirps.clear();
        SQL_ROW tmp((*s[26]).c_str());
        for (i=0;i<tmp.argc();i++) {
            chirps.push_back(chirp_parameter_t(SQL_ROW((*tmp[i]).c_str())));
        }
    }
    {
        std::istringstream row(*(s[27]));
        row >> pulse_beams;
    }
    {
        std::istringstream row(*(s[28]));
        row >> max_signals;
    }
    {
        std::istringstream row(*(s[29]));
        row >> max_spikes;
    }
    {
        std::istringstream row(*(s[30]));
        row >> max_gaussians;
    }
    {
        std::istringstream row(*(s[31]));
        row >> max_pulses;
    }
    {
        std::istringstream row(*(s[32]));
        row >> max_triplets;
    }
    {
        std::istringstream row(*(s[33]));
        row >> keyuniq;
    }
}

void analysis_config::parse(const std::string &s) {
    SQL_ROW row(s.c_str(),34);
    parse(row);
}

template <>
const char * const db_table<tape>::table_name="tape";
template <>
const char * db_table<tape>::_search_tag=table_name;
template <>
const int db_table<tape>::_nfields=8;
template <>
const char * const db_table<tape>::column_names[8]= {"id","name","start_time","last_block_time","last_block_done","missed","tape_quality","sb_id"
                                                    };

tape::tape() :
        db_table<tape>(*this,-1),
        id(0),
        start_time(0),
        last_block_time(0),
        last_block_done(0),
        missed(0),
        tape_quality(0),
sb_id(0) {
    db_open();
    name[0]=0;
}


tape::tape(const tape &a) :
        db_table<tape>(*this,-1),
        id(a.id),
        start_time(a.start_time),
        last_block_time(a.last_block_time),
        last_block_done(a.last_block_done),
        missed(a.missed),
        tape_quality(a.tape_quality),
sb_id(a.sb_id) {
    db_open();
    strcpy(name,a.name);
}


tape::tape(const SQL_ROW &a) :
db_table<tape>(*this,-1) {
    db_open();
    parse(a);
}


tape::tape(const std::string &s,const char *tag) :
db_table<tape>(*this,-1) {
    db_open();
    if (xml_match_tag(s,tag)) {
        parse_xml(s,tag);
    } else {
        parse(s);
    }
}


tape &tape::operator =(const tape &a) {
    if (&a != this) {
        id=a.id;
        start_time=a.start_time;
        last_block_time=a.last_block_time;
        last_block_done=a.last_block_done;
        missed=a.missed;
        tape_quality=a.tape_quality;
        sb_id=a.sb_id;
        strcpy(name,a.name);
    }
    return (*this);
}


std::string tape::update_format() const {
    std::ostringstream rv("");

    for (int i=2;i<8;i++)
        rv << "?,";
    rv << "?";
    return rv.str();
}


std::string tape::insert_format() const {
    return std::string("?,")+update_format();
}

std::string tape::select_format() const {
    std::string rv("");
    for (int i=0; i<7;i++)
        rv+="?,";
    rv+="?";
    return rv;
}

std::string tape::print(int full_subtables, int show_ids, int no_refs) const {
    std::ostringstream rv("");

    rv.precision(14);
    if (show_ids)
        rv << id;
    rv << ',';
    rv << "'" << name << "'";
    rv << ',';
    rv << start_time;
    rv << ',';
    rv << last_block_time;
    rv << ',';
    rv << last_block_done;
    rv << ',';
    rv << missed;
    rv << ',';
    rv << tape_quality;
    rv << ',';
    rv << sb_id;
    return rv.str();
}


std::string tape::print_xml(int full_subtables, int show_ids, int no_refs,const char *tag) const {
    std::ostringstream rv("");

    rv.precision(14);
    rv << xml_indent() << '<' << tag << ">\n";
    xml_indent(2);
    if (show_ids)
        rv << xml_indent() << "<id>" << id << "</id>\n";
    {
        std::string enc_field=xml_encode_string(name,std::min(strlen(name),sizeof(name)));
        rv << xml_indent() << "<name>";
        rv << enc_field << "</name>\n";
    }
    rv << xml_indent() << "<start_time>" << start_time << "</start_time>\n";
    rv << xml_indent() << "<last_block_time>" << last_block_time << "</last_block_time>\n";
    rv << xml_indent() << "<last_block_done>" << last_block_done << "</last_block_done>\n";
    rv << xml_indent() << "<missed>" << missed << "</missed>\n";
    rv << xml_indent() << "<tape_quality>" << tape_quality << "</tape_quality>\n";
    rv << xml_indent() << "<sb_id>" << sb_id << "</sb_id>\n";
    xml_indent(-2);
    rv << xml_indent() << "</" << tag << ">\n";
    return rv.str();
}


void tape::parse_xml(const std::string &s,const char *tag) {
    std::string field,sub;
    if (extract_xml_record(s,tag,field)) {
        std::string::size_type pos=0;
        if (extract_xml_record(field,"id",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> id;
        }
        if (extract_xml_record(field,"name",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::string::size_type epos=sub.find("<",pos);
            if (epos==std::string::npos)
                epos=sub.find('\n',pos);
            if (epos==std::string::npos)
                epos=pos+strlen(sub.c_str()+pos);
            std::vector<unsigned char> in(xml_decode_string<unsigned char>((const char *)sub.c_str()+pos,epos-pos));
            strncpy(name,(const char *)&(in.front()),std::min(in.size(),(size_t)20));
            name[std::min(in.size(),(size_t)19)]=0;
        }
        if (extract_xml_record(field,"start_time",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> start_time;
        }
        if (extract_xml_record(field,"last_block_time",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> last_block_time;
        }
        if (extract_xml_record(field,"last_block_done",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> last_block_done;
        }
        if (extract_xml_record(field,"missed",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> missed;
        }
        if (extract_xml_record(field,"tape_quality",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> tape_quality;
        }
        if (extract_xml_record(field,"sb_id",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> sb_id;
        }
    }
}

void tape::parse(const SQL_ROW &s) {
    {
        std::istringstream row(*(s[0]));
        row >> id;
    }
    {
        strncpy(name,s[1]->c_str(),20);
        name[19]=0;
    }
    {
        std::istringstream row(*(s[2]));
        row >> start_time;
    }
    {
        std::istringstream row(*(s[3]));
        row >> last_block_time;
    }
    {
        std::istringstream row(*(s[4]));
        row >> last_block_done;
    }
    {
        std::istringstream row(*(s[5]));
        row >> missed;
    }
    {
        std::istringstream row(*(s[6]));
        row >> tape_quality;
    }
    {
        std::istringstream row(*(s[7]));
        row >> sb_id;
    }
}

void tape::parse(const std::string &s) {
    SQL_ROW row(s.c_str(),8);
    parse(row);
}

template <>
const char * const db_table<settings>::table_name="settings";
template <>
const char * db_table<settings>::_search_tag=table_name;
template <>
const int db_table<settings>::_nfields=6;
template <>
const char * const db_table<settings>::column_names[6]= {"id","active","recorder_cfg","splitter_cfg","analysis_cfg","receiver_cfg"
                                                        };

settings::settings() :
        db_table<settings>(*this,-1),
        id(0),
        active(0),
        recorder_cfg(),
        splitter_cfg(),
        analysis_cfg(),
receiver_cfg() {
    db_open();
}


settings::settings(const settings &a) :
        db_table<settings>(*this,-1),
        id(a.id),
        active(a.active),
        recorder_cfg(a.recorder_cfg),
        splitter_cfg(a.splitter_cfg),
        analysis_cfg(a.analysis_cfg),
receiver_cfg(a.receiver_cfg) {
    db_open();
}


settings::settings(const SQL_ROW &a) :
db_table<settings>(*this,-1) {
    db_open();
    parse(a);
}


settings::settings(const std::string &s,const char *tag) :
db_table<settings>(*this,-1) {
    db_open();
    if (xml_match_tag(s,tag)) {
        parse_xml(s,tag);
    } else {
        parse(s);
    }
}


settings &settings::operator =(const settings &a) {
    if (&a != this) {
        id=a.id;
        active=a.active;
        recorder_cfg=a.recorder_cfg;
        splitter_cfg=a.splitter_cfg;
        analysis_cfg=a.analysis_cfg;
        receiver_cfg=a.receiver_cfg;
    }
    return (*this);
}


std::string settings::update_format() const {
    std::ostringstream rv("");

    for (int i=2;i<6;i++)
        rv << "?,";
    rv << "?";
    return rv.str();
}


std::string settings::insert_format() const {
    return std::string("?,")+update_format();
}

std::string settings::select_format() const {
    std::string rv("");
    for (int i=0; i<5;i++)
        rv+="?,";
    rv+="?";
    return rv;
}

std::string settings::print(int full_subtables, int show_ids, int no_refs) const {
    std::ostringstream rv("");

    rv.precision(14);
    if (show_ids)
        rv << id;
    rv << ',';
    rv << active;
    rv << ',';
    if (!no_refs) {
        if (full_subtables) {
            rv << recorder_cfg.print(full_subtables,show_ids,no_refs);
        } else {
            rv << recorder_cfg.id;
        }
    }
    rv << ',';
    if (!no_refs) {
        if (full_subtables) {
            rv << splitter_cfg.print(full_subtables,show_ids,no_refs);
        } else {
            rv << splitter_cfg.id;
        }
    }
    rv << ',';
    if (!no_refs) {
        if (full_subtables) {
            rv << analysis_cfg.print(full_subtables,show_ids,no_refs);
        } else {
            rv << analysis_cfg.id;
        }
    }
    rv << ',';
    if (!no_refs) {
        if (full_subtables) {
            rv << receiver_cfg.print(full_subtables,show_ids,no_refs);
        } else {
            rv << receiver_cfg.id;
        }
    }
    return rv.str();
}


std::string settings::print_xml(int full_subtables, int show_ids, int no_refs,const char *tag) const {
    std::ostringstream rv("");

    rv.precision(14);
    rv << xml_indent() << '<' << tag << ">\n";
    xml_indent(2);
    if (show_ids)
        rv << xml_indent() << "<id>" << id << "</id>\n";
    rv << xml_indent() << "<active>" << active << "</active>\n";
    if (!no_refs) {
        if (full_subtables) {
            rv << recorder_cfg.print_xml(full_subtables,show_ids,no_refs,"recorder_cfg");
        } else {
            rv << xml_indent() << "<recorder_cfg><id>" << recorder_cfg.id << "</id></recorder_cfg>\n";
        }
    }
    if (!no_refs) {
        if (full_subtables) {
            rv << splitter_cfg.print_xml(full_subtables,show_ids,no_refs,"splitter_cfg");
        } else {
            rv << xml_indent() << "<splitter_cfg><id>" << splitter_cfg.id << "</id></splitter_cfg>\n";
        }
    }
    if (!no_refs) {
        if (full_subtables) {
            rv << analysis_cfg.print_xml(full_subtables,show_ids,no_refs,"analysis_cfg");
        } else {
            rv << xml_indent() << "<analysis_cfg><id>" << analysis_cfg.id << "</id></analysis_cfg>\n";
        }
    }
    if (!no_refs) {
        if (full_subtables) {
            rv << receiver_cfg.print_xml(full_subtables,show_ids,no_refs,"receiver_cfg");
        } else {
            rv << xml_indent() << "<receiver_cfg><id>" << receiver_cfg.id << "</id></receiver_cfg>\n";
        }
    }
    xml_indent(-2);
    rv << xml_indent() << "</" << tag << ">\n";
    return rv.str();
}


void settings::parse_xml(const std::string &s,const char *tag) {
    std::string field,sub;
    if (extract_xml_record(s,tag,field)) {
        std::string::size_type pos=0;
        if (extract_xml_record(field,"id",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> id;
        }
        if (extract_xml_record(field,"active",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> active;
        }
        if (extract_xml_record(field,"recorder_cfg",sub)) {
            recorder_cfg.parse_xml(sub,"recorder_cfg");
        }
        if (extract_xml_record(field,"splitter_cfg",sub)) {
            splitter_cfg.parse_xml(sub,"splitter_cfg");
        }
        if (extract_xml_record(field,"analysis_cfg",sub)) {
            analysis_cfg.parse_xml(sub,"analysis_cfg");
        }
        if (extract_xml_record(field,"receiver_cfg",sub)) {
            receiver_cfg.parse_xml(sub,"receiver_cfg");
        }
    }
}

void settings::parse(const SQL_ROW &s) {
    {
        std::istringstream row(*(s[0]));
        row >> id;
    }
    {
        std::istringstream row(*(s[1]));
        row >> active;
    }
    {
        recorder_cfg.parse(SQL_ROW(s[2]->c_str(),0));
    }
    {
        splitter_cfg.parse(SQL_ROW(s[3]->c_str(),0));
    }
    {
        analysis_cfg.parse(SQL_ROW(s[4]->c_str(),0));
    }
    {
        receiver_cfg.parse(SQL_ROW(s[5]->c_str(),0));
    }
}

void settings::parse(const std::string &s) {
    SQL_ROW row(s.c_str(),6);
    parse(row);
}

template <>
const char * const db_table<workunit_grp>::table_name="workunit_grp";
template <>
const char * db_table<workunit_grp>::_search_tag=table_name;
template <>
const int db_table<workunit_grp>::_nfields=9;
template <>
const char * const db_table<workunit_grp>::column_names[9]= {"id","tape_info","name","data_desc","receiver_cfg","recorder_cfg","splitter_cfg","analysis_cfg","sb_id"
                                                            };

workunit_grp::workunit_grp() :
        db_table<workunit_grp>(*this,-1),
        id(0),
        tape_info(),
        data_desc(),
        receiver_cfg(),
        recorder_cfg(),
        splitter_cfg(),
        analysis_cfg(),
sb_id(0) {
    db_open();
    name[0]=0;
}


workunit_grp::workunit_grp(const workunit_grp &a) :
        db_table<workunit_grp>(*this,-1),
        id(a.id),
        tape_info(a.tape_info),
        data_desc(a.data_desc),
        receiver_cfg(a.receiver_cfg),
        recorder_cfg(a.recorder_cfg),
        splitter_cfg(a.splitter_cfg),
        analysis_cfg(a.analysis_cfg),
sb_id(a.sb_id) {
    db_open();
    strcpy(name,a.name);
}


workunit_grp::workunit_grp(const SQL_ROW &a) :
db_table<workunit_grp>(*this,-1) {
    db_open();
    parse(a);
}


workunit_grp::workunit_grp(const std::string &s,const char *tag) :
db_table<workunit_grp>(*this,-1) {
    db_open();
    if (xml_match_tag(s,tag)) {
        parse_xml(s,tag);
    } else {
        parse(s);
    }
}


workunit_grp &workunit_grp::operator =(const workunit_grp &a) {
    if (&a != this) {
        id=a.id;
        tape_info=a.tape_info;
        data_desc=a.data_desc;
        receiver_cfg=a.receiver_cfg;
        recorder_cfg=a.recorder_cfg;
        splitter_cfg=a.splitter_cfg;
        analysis_cfg=a.analysis_cfg;
        sb_id=a.sb_id;
        strcpy(name,a.name);
    }
    return (*this);
}


std::string workunit_grp::update_format() const {
    std::ostringstream rv("");

    for (int i=2;i<9;i++)
        rv << "?,";
    rv << "?";
    return rv.str();
}


std::string workunit_grp::insert_format() const {
    return std::string("?,")+update_format();
}

std::string workunit_grp::select_format() const {
    std::string rv("");
    for (int i=0; i<8;i++)
        rv+="?,";
    rv+="?";
    return rv;
}

std::string workunit_grp::print(int full_subtables, int show_ids, int no_refs) const {
    std::ostringstream rv("");

    rv.precision(14);
    if (show_ids)
        rv << id;
    rv << ',';
    if (!no_refs) {
        if (full_subtables) {
            rv << tape_info.print(full_subtables,show_ids,no_refs);
        } else {
            rv << tape_info.id;
        }
    }
    rv << ',';
    rv << "'" << name << "'";
    rv << ',';
    rv << data_desc.print(full_subtables,show_ids,no_refs);
    rv << ',';
    if (!no_refs) {
        if (full_subtables) {
            rv << receiver_cfg.print(full_subtables,show_ids,no_refs);
        } else {
            rv << receiver_cfg.id;
        }
    }
    rv << ',';
    if (!no_refs) {
        if (full_subtables) {
            rv << recorder_cfg.print(full_subtables,show_ids,no_refs);
        } else {
            rv << recorder_cfg.id;
        }
    }
    rv << ',';
    if (!no_refs) {
        if (full_subtables) {
            rv << splitter_cfg.print(full_subtables,show_ids,no_refs);
        } else {
            rv << splitter_cfg.id;
        }
    }
    rv << ',';
    if (!no_refs) {
        if (full_subtables) {
            rv << analysis_cfg.print(full_subtables,show_ids,no_refs);
        } else {
            rv << analysis_cfg.id;
        }
    }
    rv << ',';
    rv << sb_id;
    return rv.str();
}


std::string workunit_grp::print_xml(int full_subtables, int show_ids, int no_refs,const char *tag) const {
    std::ostringstream rv("");

    rv.precision(14);
    rv << xml_indent() << '<' << tag << ">\n";
    xml_indent(2);
    if (show_ids)
        rv << xml_indent() << "<id>" << id << "</id>\n";
    if (!no_refs) {
        if (full_subtables) {
            rv << tape_info.print_xml(full_subtables,show_ids,no_refs,"tape_info");
        } else {
            rv << xml_indent() << "<tape_info><id>" << tape_info.id << "</id></tape_info>\n";
        }
    }
    {
        std::string enc_field=xml_encode_string(name,std::min(strlen(name),sizeof(name)));
        rv << xml_indent() << "<name>";
        rv << enc_field << "</name>\n";
    }
    rv << data_desc.print_xml(full_subtables,show_ids,no_refs,"data_desc");
    if (!no_refs) {
        if (full_subtables) {
            rv << receiver_cfg.print_xml(full_subtables,show_ids,no_refs,"receiver_cfg");
        } else {
            rv << xml_indent() << "<receiver_cfg><id>" << receiver_cfg.id << "</id></receiver_cfg>\n";
        }
    }
    if (!no_refs) {
        if (full_subtables) {
            rv << recorder_cfg.print_xml(full_subtables,show_ids,no_refs,"recorder_cfg");
        } else {
            rv << xml_indent() << "<recorder_cfg><id>" << recorder_cfg.id << "</id></recorder_cfg>\n";
        }
    }
    if (!no_refs) {
        if (full_subtables) {
            rv << splitter_cfg.print_xml(full_subtables,show_ids,no_refs,"splitter_cfg");
        } else {
            rv << xml_indent() << "<splitter_cfg><id>" << splitter_cfg.id << "</id></splitter_cfg>\n";
        }
    }
    if (!no_refs) {
        if (full_subtables) {
            rv << analysis_cfg.print_xml(full_subtables,show_ids,no_refs,"analysis_cfg");
        } else {
            rv << xml_indent() << "<analysis_cfg><id>" << analysis_cfg.id << "</id></analysis_cfg>\n";
        }
    }
    rv << xml_indent() << "<sb_id>" << sb_id << "</sb_id>\n";
    xml_indent(-2);
    rv << xml_indent() << "</" << tag << ">\n";
    return rv.str();
}


void workunit_grp::parse_xml(const std::string &s,const char *tag) {
    std::string field,sub;
    if (extract_xml_record(s,tag,field)) {
        std::string::size_type pos=0;
        if (extract_xml_record(field,"id",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> id;
        }
        if (extract_xml_record(field,"tape_info",sub)) {
            tape_info.parse_xml(sub,"tape_info");
        }
        if (extract_xml_record(field,"name",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::string::size_type epos=sub.find("<",pos);
            if (epos==std::string::npos)
                epos=sub.find('\n',pos);
            if (epos==std::string::npos)
                epos=pos+strlen(sub.c_str()+pos);
            std::vector<unsigned char> in(xml_decode_string<unsigned char>((const char *)sub.c_str()+pos,epos-pos));
            strncpy(name,(const char *)&(in.front()),std::min(in.size(),(size_t)64));
            name[std::min(in.size(),(size_t)63)]=0;
        }
        if (extract_xml_record(field,"data_desc",sub)) {
            data_desc.parse_xml(sub,"data_desc");
        }
        if (extract_xml_record(field,"receiver_cfg",sub)) {
            receiver_cfg.parse_xml(sub,"receiver_cfg");
        }
        if (extract_xml_record(field,"recorder_cfg",sub)) {
            recorder_cfg.parse_xml(sub,"recorder_cfg");
        }
        if (extract_xml_record(field,"splitter_cfg",sub)) {
            splitter_cfg.parse_xml(sub,"splitter_cfg");
        }
        if (extract_xml_record(field,"analysis_cfg",sub)) {
            analysis_cfg.parse_xml(sub,"analysis_cfg");
        }
        if (extract_xml_record(field,"sb_id",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> sb_id;
        }
    }
}

void workunit_grp::parse(const SQL_ROW &s) {
    {
        std::istringstream row(*(s[0]));
        row >> id;
    }
    {
        tape_info.parse(SQL_ROW(s[1]->c_str(),0));
    }
    {
        strncpy(name,s[2]->c_str(),64);
        name[63]=0;
    }
    {
        data_desc.parse(SQL_ROW(s[3]->c_str(),0));
    }
    {
        receiver_cfg.parse(SQL_ROW(s[4]->c_str(),0));
    }
    {
        recorder_cfg.parse(SQL_ROW(s[5]->c_str(),0));
    }
    {
        splitter_cfg.parse(SQL_ROW(s[6]->c_str(),0));
    }
    {
        analysis_cfg.parse(SQL_ROW(s[7]->c_str(),0));
    }
    {
        std::istringstream row(*(s[8]));
        row >> sb_id;
    }
}

void workunit_grp::parse(const std::string &s) {
    SQL_ROW row(s.c_str(),9);
    parse(row);
}

template <>
const char * const db_table<workunit_header>::table_name="workunit_header";
template <>
const char * db_table<workunit_header>::_search_tag=table_name;
template <>
const int db_table<workunit_header>::_nfields=5;
template <>
const char * const db_table<workunit_header>::column_names[5]= {"id","name","group_info","subband_desc","sb_id"
                                                               };

workunit_header::workunit_header() :
        db_table<workunit_header>(*this,-1),
        id(0),
        group_info(),
        subband_desc(),
sb_id(0) {
    db_open();
    name[0]=0;
}


workunit_header::workunit_header(const workunit_header &a) :
        db_table<workunit_header>(*this,-1),
        id(a.id),
        group_info(a.group_info),
        subband_desc(a.subband_desc),
sb_id(a.sb_id) {
    db_open();
    strcpy(name,a.name);
}


workunit_header::workunit_header(const SQL_ROW &a) :
db_table<workunit_header>(*this,-1) {
    db_open();
    parse(a);
}


workunit_header::workunit_header(const std::string &s,const char *tag) :
db_table<workunit_header>(*this,-1) {
    db_open();
    if (xml_match_tag(s,tag)) {
        parse_xml(s,tag);
    } else {
        parse(s);
    }
}


workunit_header &workunit_header::operator =(const workunit_header &a) {
    if (&a != this) {
        id=a.id;
        group_info=a.group_info;
        subband_desc=a.subband_desc;
        sb_id=a.sb_id;
        strcpy(name,a.name);
    }
    return (*this);
}


std::string workunit_header::update_format() const {
    std::ostringstream rv("");

    for (int i=2;i<5;i++)
        rv << "?,";
    rv << "?";
    return rv.str();
}


std::string workunit_header::insert_format() const {
    return std::string("?,")+update_format();
}

std::string workunit_header::select_format() const {
    std::string rv("");
    for (int i=0; i<4;i++)
        rv+="?,";
    rv+="?";
    return rv;
}

std::string workunit_header::print(int full_subtables, int show_ids, int no_refs) const {
    std::ostringstream rv("");

    rv.precision(14);
    if (show_ids)
        rv << id;
    rv << ',';
    rv << "'" << name << "'";
    rv << ',';
    if (!no_refs) {
        if (full_subtables) {
            rv << group_info.print(full_subtables,show_ids,no_refs);
        } else {
            rv << group_info.id;
        }
    }
    rv << ',';
    rv << subband_desc.print(full_subtables,show_ids,no_refs);
    rv << ',';
    rv << sb_id;
    return rv.str();
}


std::string workunit_header::print_xml(int full_subtables, int show_ids, int no_refs,const char *tag) const {
    std::ostringstream rv("");

    rv.precision(14);
    rv << xml_indent() << '<' << tag << ">\n";
    xml_indent(2);
    if (show_ids)
        rv << xml_indent() << "<id>" << id << "</id>\n";
    {
        std::string enc_field=xml_encode_string(name,std::min(strlen(name),sizeof(name)));
        rv << xml_indent() << "<name>";
        rv << enc_field << "</name>\n";
    }
    if (!no_refs) {
        if (full_subtables) {
            rv << group_info.print_xml(full_subtables,show_ids,no_refs,"group_info");
        } else {
            rv << xml_indent() << "<group_info><id>" << group_info.id << "</id></group_info>\n";
        }
    }
    rv << subband_desc.print_xml(full_subtables,show_ids,no_refs,"subband_desc");
    rv << xml_indent() << "<sb_id>" << sb_id << "</sb_id>\n";
    xml_indent(-2);
    rv << xml_indent() << "</" << tag << ">\n";
    return rv.str();
}


void workunit_header::parse_xml(const std::string &s,const char *tag) {
    std::string field,sub;
    if (extract_xml_record(s,tag,field)) {
        std::string::size_type pos=0;
        if (extract_xml_record(field,"id",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> id;
        }
        if (extract_xml_record(field,"name",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::string::size_type epos=sub.find("<",pos);
            if (epos==std::string::npos)
                epos=sub.find('\n',pos);
            if (epos==std::string::npos)
                epos=pos+strlen(sub.c_str()+pos);
            std::vector<unsigned char> in(xml_decode_string<unsigned char>((const char *)sub.c_str()+pos,epos-pos));
            strncpy(name,(const char *)&(in.front()),std::min(in.size(),(size_t)64));
            name[std::min(in.size(),(size_t)63)]=0;
        }
        if (extract_xml_record(field,"group_info",sub)) {
            group_info.parse_xml(sub,"group_info");
        }
        if (extract_xml_record(field,"subband_desc",sub)) {
            subband_desc.parse_xml(sub,"subband_desc");
        }
        if (extract_xml_record(field,"sb_id",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> sb_id;
        }
    }
}

void workunit_header::parse(const SQL_ROW &s) {
    {
        std::istringstream row(*(s[0]));
        row >> id;
    }
    {
        strncpy(name,s[1]->c_str(),64);
        name[63]=0;
    }
    {
        group_info.parse(SQL_ROW(s[2]->c_str(),0));
    }
    {
        subband_desc.parse(SQL_ROW(s[3]->c_str(),0));
    }
    {
        std::istringstream row(*(s[4]));
        row >> sb_id;
    }
}

void workunit_header::parse(const std::string &s) {
    SQL_ROW row(s.c_str(),5);
    parse(row);
}

template <>
const char * const db_table<result>::table_name="result";
template <>
const char * db_table<result>::_search_tag=table_name;
template <>
const int db_table<result>::_nfields=10;
template <>
const char * const db_table<result>::column_names[10]= {"id","boinc_result","wuid","received","hostid","versionid","return_code","overflow","reserved","sb_id"
                                                       };

result::result() :
        db_table<result>(*this,-1),
        id(0),
        boinc_result(0),
        wuid(),
        received(0),
        hostid(0),
        versionid(0),
        return_code(0),
              overflow(0),
              reserved(0),
      sb_id(0) {
          db_open();
      }


      result::result(const result &a) :
              db_table<result>(*this,-1),
              id(a.id),
              boinc_result(a.boinc_result),
              wuid(a.wuid),
              received(a.received),
              hostid(a.hostid),
              versionid(a.versionid),
              return_code(a.return_code),
                    overflow(a.overflow),
                    reserved(a.reserved),
            sb_id(a.sb_id) {
                db_open();
            }


            result::result(const SQL_ROW &a) :
            db_table<result>(*this,-1) {
                db_open();
                parse(a);
            }


            result::result(const std::string &s,const char *tag) :
            db_table<result>(*this,-1) {
                db_open();
                if (xml_match_tag(s,tag)) {
                    parse_xml(s,tag);
                } else {
                    parse(s);
                }
            }


            result &result::operator =(const result &a) {
                if (&a != this) {
                    id=a.id;
                    boinc_result=a.boinc_result;
                    wuid=a.wuid;
                    received=a.received;
                    hostid=a.hostid;
                    versionid=a.versionid;
                    return_code=a.return_code;
                    overflow=a.overflow;
                    reserved=a.reserved;
                    sb_id=a.sb_id;
                }
                return (*this);
            }


            std::string result::update_format() const {
                std::ostringstream rv("");

                for (int i=2;i<10;i++)
                    rv << "?,";
                rv << "?";
                return rv.str();
            }


            std::string result::insert_format() const {
                return std::string("?,")+update_format();
            }

            std::string result::select_format() const {
                std::string rv("");
                for (int i=0; i<9;i++)
                    rv+="?,";
                rv+="?";
                return rv;
            }

            std::string result::print(int full_subtables, int show_ids, int no_refs) const {
                std::ostringstream rv("");

                rv.precision(14);
                if (show_ids)
                    rv << id;
                rv << ',';
                rv << boinc_result;
                rv << ',';
                if (!no_refs) {
                    if (full_subtables) {
                        rv << wuid.print(full_subtables,show_ids,no_refs);
                    } else {
                        rv << wuid.id;
                    }
                }
                rv << ',';
                rv << received;
                rv << ',';
                rv << hostid;
                rv << ',';
                rv << versionid;
                rv << ',';
                rv << return_code;
                rv << ',';
                rv << overflow;
                rv << ',';
                rv << reserved;
                rv << ',';
                rv << sb_id;
                return rv.str();
            }


            std::string result::print_xml(int full_subtables, int show_ids, int no_refs,const char *tag) const {
                std::ostringstream rv("");

                rv.precision(14);
                rv << xml_indent() << '<' << tag << ">\n";
                xml_indent(2);
                if (show_ids)
                    rv << xml_indent() << "<id>" << id << "</id>\n";
                rv << xml_indent() << "<boinc_result>" << boinc_result << "</boinc_result>\n";
                if (!no_refs) {
                    if (full_subtables) {
                        rv << wuid.print_xml(full_subtables,show_ids,no_refs,"wuid");
                    } else {
                        rv << xml_indent() << "<wuid><id>" << wuid.id << "</id></wuid>\n";
                    }
                }
                rv << xml_indent() << "<received>" << received << "</received>\n";
                rv << xml_indent() << "<hostid>" << hostid << "</hostid>\n";
                rv << xml_indent() << "<versionid>" << versionid << "</versionid>\n";
                rv << xml_indent() << "<return_code>" << return_code << "</return_code>\n";
                rv << xml_indent() << "<overflow>" << overflow << "</overflow>\n";
                rv << xml_indent() << "<reserved>" << reserved << "</reserved>\n";
                rv << xml_indent() << "<sb_id>" << sb_id << "</sb_id>\n";
                xml_indent(-2);
                rv << xml_indent() << "</" << tag << ">\n";
                return rv.str();
            }


            void result::parse_xml(const std::string &s,const char *tag) {
                std::string field,sub;
                if (extract_xml_record(s,tag,field)) {
                    std::string::size_type pos=0;
                    if (extract_xml_record(field,"id",sub)) {
                        pos=sub.find(">");
                        do {
                            pos++;
                        } while(sub[pos]=='\n');
                        std::istringstream in(sub.c_str()+pos);
                        in >> id;
                    }
                    if (extract_xml_record(field,"boinc_result",sub)) {
                        pos=sub.find(">");
                        do {
                            pos++;
                        } while(sub[pos]=='\n');
                        std::istringstream in(sub.c_str()+pos);
                        in >> boinc_result;
                    }
                    if (extract_xml_record(field,"wuid",sub)) {
                        wuid.parse_xml(sub,"wuid");
                    }
                    if (extract_xml_record(field,"received",sub)) {
                        pos=sub.find(">");
                        do {
                            pos++;
                        } while(sub[pos]=='\n');
                        std::istringstream in(sub.c_str()+pos);
                        in >> received;
                    }
                    if (extract_xml_record(field,"hostid",sub)) {
                        pos=sub.find(">");
                        do {
                            pos++;
                        } while(sub[pos]=='\n');
                        std::istringstream in(sub.c_str()+pos);
                        in >> hostid;
                    }
                    if (extract_xml_record(field,"versionid",sub)) {
                        pos=sub.find(">");
                        do {
                            pos++;
                        } while(sub[pos]=='\n');
                        std::istringstream in(sub.c_str()+pos);
                        in >> versionid;
                    }
                    if (extract_xml_record(field,"return_code",sub)) {
                        pos=sub.find(">");
                        do {
                            pos++;
                        } while(sub[pos]=='\n');
                        std::istringstream in(sub.c_str()+pos);
                        in >> return_code;
                    }
                    if (extract_xml_record(field,"overflow",sub)) {
                        pos=sub.find(">");
                        do {
                            pos++;
                        } while(sub[pos]=='\n');
                        std::istringstream in(sub.c_str()+pos);
                        in >> overflow;
                    }
                    if (extract_xml_record(field,"reserved",sub)) {
                        pos=sub.find(">");
                        do {
                            pos++;
                        } while(sub[pos]=='\n');
                        std::istringstream in(sub.c_str()+pos);
                        in >> reserved;
                    }
                    if (extract_xml_record(field,"sb_id",sub)) {
                        pos=sub.find(">");
                        do {
                            pos++;
                        } while(sub[pos]=='\n');
                        std::istringstream in(sub.c_str()+pos);
                        in >> sb_id;
                    }
                }
            }

            void result::parse(const SQL_ROW &s) {
                {
                    std::istringstream row(*(s[0]));
                    row >> id;
                }
                {
                    std::istringstream row(*(s[1]));
                    row >> boinc_result;
                }
                {
                    wuid.parse(SQL_ROW(s[2]->c_str(),0));
                }
                {
                    std::istringstream row(*(s[3]));
                    row >> received;
                }
                {
                    std::istringstream row(*(s[4]));
                    row >> hostid;
                }
                {
                    std::istringstream row(*(s[5]));
                    row >> versionid;
                }
                {
                    std::istringstream row(*(s[6]));
                    row >> return_code;
                }
                {
                    std::istringstream row(*(s[7]));
                    row >> overflow;
                }
                {
                    std::istringstream row(*(s[8]));
                    row >> reserved;
                }
                {
                    std::istringstream row(*(s[9]));
                    row >> sb_id;
                }
            }

            void result::parse(const std::string &s) {
                SQL_ROW row(s.c_str(),10);
                parse(row);
            }

            template <>
const char * const db_table<triplet>::table_name="triplet";
template <>
const char * db_table<triplet>::_search_tag=table_name;
template <>
const int db_table<triplet>::_nfields=17;
template <>
const char * const db_table<triplet>::column_names[17]= {"id","result_id","peak_power","mean_power","time","ra","decl","q_pix","freq","detection_freq","barycentric_freq","fft_len","chirp_rate","rfi_checked","rfi_found","reserved","period"
                                                        };

triplet::triplet() :
        db_table<triplet>(*this,-1),
        id(0),
        result_id(),
        peak_power(0),
        mean_power(0),
        time(0),
        ra(0),
        decl(0),
        q_pix(0),
        freq(0),
        detection_freq(0),
        barycentric_freq(0),
        fft_len(0),
        chirp_rate(0),
        rfi_checked(0),
        rfi_found(0),
        reserved(0),
period(0) {
    db_open();
}


triplet::triplet(const triplet &a) :
        db_table<triplet>(*this,-1),
        id(a.id),
        result_id(a.result_id),
        peak_power(a.peak_power),
        mean_power(a.mean_power),
        time(a.time),
        ra(a.ra),
        decl(a.decl),
        q_pix(a.q_pix),
        freq(a.freq),
        detection_freq(a.detection_freq),
        barycentric_freq(a.barycentric_freq),
        fft_len(a.fft_len),
        chirp_rate(a.chirp_rate),
        rfi_checked(a.rfi_checked),
        rfi_found(a.rfi_found),
        reserved(a.reserved),
period(a.period) {
    db_open();
}


triplet::triplet(const SQL_ROW &a) :
db_table<triplet>(*this,-1) {
    db_open();
    parse(a);
}


triplet::triplet(const std::string &s,const char *tag) :
db_table<triplet>(*this,-1) {
    db_open();
    if (xml_match_tag(s,tag)) {
        parse_xml(s,tag);
    } else {
        parse(s);
    }
}


triplet &triplet::operator =(const triplet &a) {
    if (&a != this) {
        id=a.id;
        result_id=a.result_id;
        peak_power=a.peak_power;
        mean_power=a.mean_power;
        time=a.time;
        ra=a.ra;
        decl=a.decl;
        q_pix=a.q_pix;
        freq=a.freq;
        detection_freq=a.detection_freq;
        barycentric_freq=a.barycentric_freq;
        fft_len=a.fft_len;
        chirp_rate=a.chirp_rate;
        rfi_checked=a.rfi_checked;
        rfi_found=a.rfi_found;
        reserved=a.reserved;
        period=a.period;
    }
    return (*this);
}


std::string triplet::update_format() const {
    std::ostringstream rv("");

    for (int i=2;i<17;i++)
        rv << "?,";
    rv << "?";
    return rv.str();
}


std::string triplet::insert_format() const {
    return std::string("?,")+update_format();
}

std::string triplet::select_format() const {
    std::string rv("");
    for (int i=0; i<16;i++)
        rv+="?,";
    rv+="?";
    return rv;
}

std::string triplet::print(int full_subtables, int show_ids, int no_refs) const {
    std::ostringstream rv("");

    rv.precision(14);
    if (show_ids)
        rv << id;
    rv << ',';
    if (!no_refs) {
        if (full_subtables) {
            rv << result_id.print(full_subtables,show_ids,no_refs);
        } else {
            rv << result_id.id;
        }
    }
    rv << ',';
    rv << peak_power;
    rv << ',';
    rv << mean_power;
    rv << ',';
    rv << time;
    rv << ',';
    rv << ra;
    rv << ',';
    rv << decl;
    rv << ',';
    rv << q_pix;
    rv << ',';
    rv << freq;
    rv << ',';
    rv << detection_freq;
    rv << ',';
    rv << barycentric_freq;
    rv << ',';
    rv << fft_len;
    rv << ',';
    rv << chirp_rate;
    rv << ',';
    rv << rfi_checked;
    rv << ',';
    rv << rfi_found;
    rv << ',';
    rv << reserved;
    rv << ',';
    rv << period;
    return rv.str();
}


std::string triplet::print_xml(int full_subtables, int show_ids, int no_refs,const char *tag) const {
    std::ostringstream rv("");

    rv.precision(14);
    rv << xml_indent() << '<' << tag << ">\n";
    xml_indent(2);
    if (show_ids)
        rv << xml_indent() << "<id>" << id << "</id>\n";
    if (!no_refs) {
        if (full_subtables) {
            rv << result_id.print_xml(full_subtables,show_ids,no_refs,"result_id");
        } else {
            rv << xml_indent() << "<result_id><id>" << result_id.id << "</id></result_id>\n";
        }
    }
    rv << xml_indent() << "<peak_power>" << peak_power << "</peak_power>\n";
    rv << xml_indent() << "<mean_power>" << mean_power << "</mean_power>\n";
    rv << xml_indent() << "<time>" << time << "</time>\n";
    rv << xml_indent() << "<ra>" << ra << "</ra>\n";
    rv << xml_indent() << "<decl>" << decl << "</decl>\n";
    rv << xml_indent() << "<q_pix>" << q_pix << "</q_pix>\n";
    rv << xml_indent() << "<freq>" << freq << "</freq>\n";
    rv << xml_indent() << "<detection_freq>" << detection_freq << "</detection_freq>\n";
    rv << xml_indent() << "<barycentric_freq>" << barycentric_freq << "</barycentric_freq>\n";
    rv << xml_indent() << "<fft_len>" << fft_len << "</fft_len>\n";
    rv << xml_indent() << "<chirp_rate>" << chirp_rate << "</chirp_rate>\n";
    rv << xml_indent() << "<rfi_checked>" << rfi_checked << "</rfi_checked>\n";
    rv << xml_indent() << "<rfi_found>" << rfi_found << "</rfi_found>\n";
    rv << xml_indent() << "<reserved>" << reserved << "</reserved>\n";
    rv << xml_indent() << "<period>" << period << "</period>\n";
    xml_indent(-2);
    rv << xml_indent() << "</" << tag << ">\n";
    return rv.str();
}


void triplet::parse_xml(const std::string &s,const char *tag) {
    std::string field,sub;
    if (extract_xml_record(s,tag,field)) {
        std::string::size_type pos=0;
        if (extract_xml_record(field,"id",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> id;
        }
        if (extract_xml_record(field,"result_id",sub)) {
            result_id.parse_xml(sub,"result_id");
        }
        if (extract_xml_record(field,"peak_power",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> peak_power;
        }
        if (extract_xml_record(field,"mean_power",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> mean_power;
        }
        if (extract_xml_record(field,"time",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> time;
        }
        if (extract_xml_record(field,"ra",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> ra;
        }
        if (extract_xml_record(field,"decl",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> decl;
        }
        if (extract_xml_record(field,"q_pix",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> q_pix;
        }
        if (extract_xml_record(field,"freq",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> freq;
        }
        if (extract_xml_record(field,"detection_freq",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> detection_freq;
        }
        if (extract_xml_record(field,"barycentric_freq",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> barycentric_freq;
        }
        if (extract_xml_record(field,"fft_len",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> fft_len;
        }
        if (extract_xml_record(field,"chirp_rate",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> chirp_rate;
        }
        if (extract_xml_record(field,"rfi_checked",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> rfi_checked;
        }
        if (extract_xml_record(field,"rfi_found",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> rfi_found;
        }
        if (extract_xml_record(field,"reserved",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> reserved;
        }
        if (extract_xml_record(field,"period",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> period;
        }
    }
}

void triplet::parse(const SQL_ROW &s) {
    {
        std::istringstream row(*(s[0]));
        row >> id;
    }
    {
        result_id.parse(SQL_ROW(s[1]->c_str(),0));
    }
    {
        std::istringstream row(*(s[2]));
        row >> peak_power;
    }
    {
        std::istringstream row(*(s[3]));
        row >> mean_power;
    }
    {
        std::istringstream row(*(s[4]));
        row >> time;
    }
    {
        std::istringstream row(*(s[5]));
        row >> ra;
    }
    {
        std::istringstream row(*(s[6]));
        row >> decl;
    }
    {
        std::istringstream row(*(s[7]));
        row >> q_pix;
    }
    {
        std::istringstream row(*(s[8]));
        row >> freq;
    }
    {
        std::istringstream row(*(s[9]));
        row >> detection_freq;
    }
    {
        std::istringstream row(*(s[10]));
        row >> barycentric_freq;
    }
    {
        std::istringstream row(*(s[11]));
        row >> fft_len;
    }
    {
        std::istringstream row(*(s[12]));
        row >> chirp_rate;
    }
    {
        std::istringstream row(*(s[13]));
        row >> rfi_checked;
    }
    {
        std::istringstream row(*(s[14]));
        row >> rfi_found;
    }
    {
        std::istringstream row(*(s[15]));
        row >> reserved;
    }
    {
        std::istringstream row(*(s[16]));
        row >> period;
    }
}

void triplet::parse(const std::string &s) {
    SQL_ROW row(s.c_str(),17);
    parse(row);
}

template <>
const char * const db_table<gaussian>::table_name="gaussian";
template <>
const char * db_table<gaussian>::_search_tag=table_name;
template <>
const int db_table<gaussian>::_nfields=22;
template <>
const char * const db_table<gaussian>::column_names[22]= {"id","result_id","peak_power","mean_power","time","ra","decl","q_pix","freq","detection_freq","barycentric_freq","fft_len","chirp_rate","rfi_checked","rfi_found","reserved","sigma","chisqr","null_chisqr","score","max_power","pot"
                                                         };

gaussian::gaussian() :
        db_table<gaussian>(*this,-1),
        id(0),
        result_id(),
        peak_power(0),
        mean_power(0),
        time(0),
        ra(0),
        decl(0),
        q_pix(0),
        freq(0),
        detection_freq(0),
        barycentric_freq(0),
        fft_len(0),
        chirp_rate(0),
        rfi_checked(0),
        rfi_found(0),
        reserved(0),
        sigma(0),
        chisqr(0),
        null_chisqr(0),
        score(0),
        max_power(0),
pot((unsigned char *)0,0,_x_csv) {
    db_open();
}


gaussian::gaussian(const gaussian &a) :
        db_table<gaussian>(*this,-1),
        id(a.id),
        result_id(a.result_id),
        peak_power(a.peak_power),
        mean_power(a.mean_power),
        time(a.time),
        ra(a.ra),
        decl(a.decl),
        q_pix(a.q_pix),
        freq(a.freq),
        detection_freq(a.detection_freq),
        barycentric_freq(a.barycentric_freq),
        fft_len(a.fft_len),
        chirp_rate(a.chirp_rate),
        rfi_checked(a.rfi_checked),
        rfi_found(a.rfi_found),
        reserved(a.reserved),
        sigma(a.sigma),
        chisqr(a.chisqr),
        null_chisqr(a.null_chisqr),
        score(a.score),
        max_power(a.max_power),
pot(a.pot) {
    db_open();
}


gaussian::gaussian(const SQL_ROW &a) :
db_table<gaussian>(*this,-1) {
    db_open();
    parse(a);
}


gaussian::gaussian(const std::string &s,const char *tag) :
db_table<gaussian>(*this,-1) {
    db_open();
    if (xml_match_tag(s,tag)) {
        parse_xml(s,tag);
    } else {
        parse(s);
    }
}


gaussian &gaussian::operator =(const gaussian &a) {
    if (&a != this) {
        id=a.id;
        result_id=a.result_id;
        peak_power=a.peak_power;
        mean_power=a.mean_power;
        time=a.time;
        ra=a.ra;
        decl=a.decl;
        q_pix=a.q_pix;
        freq=a.freq;
        detection_freq=a.detection_freq;
        barycentric_freq=a.barycentric_freq;
        fft_len=a.fft_len;
        chirp_rate=a.chirp_rate;
        rfi_checked=a.rfi_checked;
        rfi_found=a.rfi_found;
        reserved=a.reserved;
        sigma=a.sigma;
        chisqr=a.chisqr;
        null_chisqr=a.null_chisqr;
        score=a.score;
        max_power=a.max_power;
        pot=a.pot;
    }
    return (*this);
}


std::string gaussian::update_format() const {
    std::ostringstream rv("");

    for (int i=2;i<22;i++)
        rv << "?,";
    rv << "?";
    return rv.str();
}


std::string gaussian::insert_format() const {
    return std::string("?,")+update_format();
}

std::string gaussian::select_format() const {
    std::string rv("");
    for (int i=0; i<21;i++)
        rv+="?,";
    rv+="?";
    return rv;
}

std::string gaussian::print(int full_subtables, int show_ids, int no_refs) const {
    std::ostringstream rv("");

    rv.precision(14);
    if (show_ids)
        rv << id;
    rv << ',';
    if (!no_refs) {
        if (full_subtables) {
            rv << result_id.print(full_subtables,show_ids,no_refs);
        } else {
            rv << result_id.id;
        }
    }
    rv << ',';
    rv << peak_power;
    rv << ',';
    rv << mean_power;
    rv << ',';
    rv << time;
    rv << ',';
    rv << ra;
    rv << ',';
    rv << decl;
    rv << ',';
    rv << q_pix;
    rv << ',';
    rv << freq;
    rv << ',';
    rv << detection_freq;
    rv << ',';
    rv << barycentric_freq;
    rv << ',';
    rv << fft_len;
    rv << ',';
    rv << chirp_rate;
    rv << ',';
    rv << rfi_checked;
    rv << ',';
    rv << rfi_found;
    rv << ',';
    rv << reserved;
    rv << ',';
    rv << sigma;
    rv << ',';
    rv << chisqr;
    rv << ',';
    rv << null_chisqr;
    rv << ',';
    rv << score;
    rv << ',';
    rv << max_power;
    rv << ',';
    rv << "<BYTE len=" << std::max(pot.size()*2,(size_t)1) << ">" << pot.print_hex() ;
    return rv.str();
}


std::string gaussian::print_xml(int full_subtables, int show_ids, int no_refs,const char *tag) const {
    std::ostringstream rv("");

    rv.precision(14);
    rv << xml_indent() << '<' << tag << ">\n";
    xml_indent(2);
    if (show_ids)
        rv << xml_indent() << "<id>" << id << "</id>\n";
    if (!no_refs) {
        if (full_subtables) {
            rv << result_id.print_xml(full_subtables,show_ids,no_refs,"result_id");
        } else {
            rv << xml_indent() << "<result_id><id>" << result_id.id << "</id></result_id>\n";
        }
    }
    rv << xml_indent() << "<peak_power>" << peak_power << "</peak_power>\n";
    rv << xml_indent() << "<mean_power>" << mean_power << "</mean_power>\n";
    rv << xml_indent() << "<time>" << time << "</time>\n";
    rv << xml_indent() << "<ra>" << ra << "</ra>\n";
    rv << xml_indent() << "<decl>" << decl << "</decl>\n";
    rv << xml_indent() << "<q_pix>" << q_pix << "</q_pix>\n";
    rv << xml_indent() << "<freq>" << freq << "</freq>\n";
    rv << xml_indent() << "<detection_freq>" << detection_freq << "</detection_freq>\n";
    rv << xml_indent() << "<barycentric_freq>" << barycentric_freq << "</barycentric_freq>\n";
    rv << xml_indent() << "<fft_len>" << fft_len << "</fft_len>\n";
    rv << xml_indent() << "<chirp_rate>" << chirp_rate << "</chirp_rate>\n";
    rv << xml_indent() << "<rfi_checked>" << rfi_checked << "</rfi_checked>\n";
    rv << xml_indent() << "<rfi_found>" << rfi_found << "</rfi_found>\n";
    rv << xml_indent() << "<reserved>" << reserved << "</reserved>\n";
    rv << xml_indent() << "<sigma>" << sigma << "</sigma>\n";
    rv << xml_indent() << "<chisqr>" << chisqr << "</chisqr>\n";
    rv << xml_indent() << "<null_chisqr>" << null_chisqr << "</null_chisqr>\n";
    rv << xml_indent() << "<score>" << score << "</score>\n";
    rv << xml_indent() << "<max_power>" << max_power << "</max_power>\n";
    if (pot.size()) {
        std::string enc_field=xml_encode_string(pot,pot.encoding);
        rv << xml_indent() << "<pot length=" << enc_field.size() << " encoding=\"" << xml_encoding_names[pot.encoding] << "\">";
        rv << enc_field << "</pot>\n";
    }
    xml_indent(-2);
    rv << xml_indent() << "</" << tag << ">\n";
    return rv.str();
}


void gaussian::parse_xml(const std::string &s,const char *tag) {
    std::string field,sub;
    if (extract_xml_record(s,tag,field)) {
        std::string::size_type pos=0;
        if (extract_xml_record(field,"id",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> id;
        }
        if (extract_xml_record(field,"result_id",sub)) {
            result_id.parse_xml(sub,"result_id");
        }
        if (extract_xml_record(field,"peak_power",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> peak_power;
        }
        if (extract_xml_record(field,"mean_power",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> mean_power;
        }
        if (extract_xml_record(field,"time",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> time;
        }
        if (extract_xml_record(field,"ra",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> ra;
        }
        if (extract_xml_record(field,"decl",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> decl;
        }
        if (extract_xml_record(field,"q_pix",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> q_pix;
        }
        if (extract_xml_record(field,"freq",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> freq;
        }
        if (extract_xml_record(field,"detection_freq",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> detection_freq;
        }
        if (extract_xml_record(field,"barycentric_freq",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> barycentric_freq;
        }
        if (extract_xml_record(field,"fft_len",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> fft_len;
        }
        if (extract_xml_record(field,"chirp_rate",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> chirp_rate;
        }
        if (extract_xml_record(field,"rfi_checked",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> rfi_checked;
        }
        if (extract_xml_record(field,"rfi_found",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> rfi_found;
        }
        if (extract_xml_record(field,"reserved",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> reserved;
        }
        if (extract_xml_record(field,"sigma",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> sigma;
        }
        if (extract_xml_record(field,"chisqr",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> chisqr;
        }
        if (extract_xml_record(field,"null_chisqr",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> null_chisqr;
        }
        if (extract_xml_record(field,"score",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> score;
        }
        if (extract_xml_record(field,"max_power",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> max_power;
        }
        if (extract_xml_record(field,"pot",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            pot=(xml_decode_field<unsigned char>(sub,"pot"));
        }
    }
}

void gaussian::parse(const SQL_ROW &s) {
    {
        std::istringstream row(*(s[0]));
        row >> id;
    }
    {
        result_id.parse(SQL_ROW(s[1]->c_str(),0));
    }
    {
        std::istringstream row(*(s[2]));
        row >> peak_power;
    }
    {
        std::istringstream row(*(s[3]));
        row >> mean_power;
    }
    {
        std::istringstream row(*(s[4]));
        row >> time;
    }
    {
        std::istringstream row(*(s[5]));
        row >> ra;
    }
    {
        std::istringstream row(*(s[6]));
        row >> decl;
    }
    {
        std::istringstream row(*(s[7]));
        row >> q_pix;
    }
    {
        std::istringstream row(*(s[8]));
        row >> freq;
    }
    {
        std::istringstream row(*(s[9]));
        row >> detection_freq;
    }
    {
        std::istringstream row(*(s[10]));
        row >> barycentric_freq;
    }
    {
        std::istringstream row(*(s[11]));
        row >> fft_len;
    }
    {
        std::istringstream row(*(s[12]));
        row >> chirp_rate;
    }
    {
        std::istringstream row(*(s[13]));
        row >> rfi_checked;
    }
    {
        std::istringstream row(*(s[14]));
        row >> rfi_found;
    }
    {
        std::istringstream row(*(s[15]));
        row >> reserved;
    }
    {
        std::istringstream row(*(s[16]));
        row >> sigma;
    }
    {
        std::istringstream row(*(s[17]));
        row >> chisqr;
    }
    {
        std::istringstream row(*(s[18]));
        row >> null_chisqr;
    }
    {
        std::istringstream row(*(s[19]));
        row >> score;
    }
    {
        std::istringstream row(*(s[20]));
        row >> max_power;
    }
    {
        pot=sqlblob<unsigned char>(*(s[21]));
    }
}

void gaussian::parse(const std::string &s) {
    SQL_ROW row(s.c_str(),22);
    parse(row);
}

template <>
const char * const db_table<pulse>::table_name="pulse";
template <>
const char * db_table<pulse>::_search_tag=table_name;
template <>
const int db_table<pulse>::_nfields=22;
template <>
const char * const db_table<pulse>::column_names[22]= {"id","result_id","peak_power","mean_power","time","ra","decl","q_pix","freq","detection_freq","barycentric_freq","fft_len","chirp_rate","rfi_checked","rfi_found","reserved","period","snr","thresh","score","len_prof","pot"
                                                      };

pulse::pulse() :
        db_table<pulse>(*this,-1),
        id(0),
        result_id(),
        peak_power(0),
        mean_power(0),
        time(0),
        ra(0),
        decl(0),
        q_pix(0),
        freq(0),
        detection_freq(0),
        barycentric_freq(0),
        fft_len(0),
        chirp_rate(0),
        rfi_checked(0),
        rfi_found(0),
        reserved(0),
        period(0),
        snr(0),
        thresh(0),
        score(0),
        len_prof(0),
pot((unsigned char *)0,0,_x_csv) {
    db_open();
}


pulse::pulse(const pulse &a) :
        db_table<pulse>(*this,-1),
        id(a.id),
        result_id(a.result_id),
        peak_power(a.peak_power),
        mean_power(a.mean_power),
        time(a.time),
        ra(a.ra),
        decl(a.decl),
        q_pix(a.q_pix),
        freq(a.freq),
        detection_freq(a.detection_freq),
        barycentric_freq(a.barycentric_freq),
        fft_len(a.fft_len),
        chirp_rate(a.chirp_rate),
        rfi_checked(a.rfi_checked),
        rfi_found(a.rfi_found),
        reserved(a.reserved),
        period(a.period),
        snr(a.snr),
        thresh(a.thresh),
        score(a.score),
        len_prof(a.len_prof),
pot(a.pot) {
    db_open();
}


pulse::pulse(const SQL_ROW &a) :
db_table<pulse>(*this,-1) {
    db_open();
    parse(a);
}


pulse::pulse(const std::string &s,const char *tag) :
db_table<pulse>(*this,-1) {
    db_open();
    if (xml_match_tag(s,tag)) {
        parse_xml(s,tag);
    } else {
        parse(s);
    }
}


pulse &pulse::operator =(const pulse &a) {
    if (&a != this) {
        id=a.id;
        result_id=a.result_id;
        peak_power=a.peak_power;
        mean_power=a.mean_power;
        time=a.time;
        ra=a.ra;
        decl=a.decl;
        q_pix=a.q_pix;
        freq=a.freq;
        detection_freq=a.detection_freq;
        barycentric_freq=a.barycentric_freq;
        fft_len=a.fft_len;
        chirp_rate=a.chirp_rate;
        rfi_checked=a.rfi_checked;
        rfi_found=a.rfi_found;
        reserved=a.reserved;
        period=a.period;
        snr=a.snr;
        thresh=a.thresh;
        score=a.score;
        len_prof=a.len_prof;
        pot=a.pot;
    }
    return (*this);
}


std::string pulse::update_format() const {
    std::ostringstream rv("");

    for (int i=2;i<22;i++)
        rv << "?,";
    rv << "?";
    return rv.str();
}


std::string pulse::insert_format() const {
    return std::string("?,")+update_format();
}

std::string pulse::select_format() const {
    std::string rv("");
    for (int i=0; i<21;i++)
        rv+="?,";
    rv+="?";
    return rv;
}

std::string pulse::print(int full_subtables, int show_ids, int no_refs) const {
    std::ostringstream rv("");

    rv.precision(14);
    if (show_ids)
        rv << id;
    rv << ',';
    if (!no_refs) {
        if (full_subtables) {
            rv << result_id.print(full_subtables,show_ids,no_refs);
        } else {
            rv << result_id.id;
        }
    }
    rv << ',';
    rv << peak_power;
    rv << ',';
    rv << mean_power;
    rv << ',';
    rv << time;
    rv << ',';
    rv << ra;
    rv << ',';
    rv << decl;
    rv << ',';
    rv << q_pix;
    rv << ',';
    rv << freq;
    rv << ',';
    rv << detection_freq;
    rv << ',';
    rv << barycentric_freq;
    rv << ',';
    rv << fft_len;
    rv << ',';
    rv << chirp_rate;
    rv << ',';
    rv << rfi_checked;
    rv << ',';
    rv << rfi_found;
    rv << ',';
    rv << reserved;
    rv << ',';
    rv << period;
    rv << ',';
    rv << snr;
    rv << ',';
    rv << thresh;
    rv << ',';
    rv << score;
    rv << ',';
    rv << len_prof;
    rv << ',';
    rv << "<BYTE len=" << std::max(pot.size()*2,(size_t)1) << ">" << pot.print_hex() ;
    return rv.str();
}


std::string pulse::print_xml(int full_subtables, int show_ids, int no_refs,const char *tag) const {
    std::ostringstream rv("");

    rv.precision(14);
    rv << xml_indent() << '<' << tag << ">\n";
    xml_indent(2);
    if (show_ids)
        rv << xml_indent() << "<id>" << id << "</id>\n";
    if (!no_refs) {
        if (full_subtables) {
            rv << result_id.print_xml(full_subtables,show_ids,no_refs,"result_id");
        } else {
            rv << xml_indent() << "<result_id><id>" << result_id.id << "</id></result_id>\n";
        }
    }
    rv << xml_indent() << "<peak_power>" << peak_power << "</peak_power>\n";
    rv << xml_indent() << "<mean_power>" << mean_power << "</mean_power>\n";
    rv << xml_indent() << "<time>" << time << "</time>\n";
    rv << xml_indent() << "<ra>" << ra << "</ra>\n";
    rv << xml_indent() << "<decl>" << decl << "</decl>\n";
    rv << xml_indent() << "<q_pix>" << q_pix << "</q_pix>\n";
    rv << xml_indent() << "<freq>" << freq << "</freq>\n";
    rv << xml_indent() << "<detection_freq>" << detection_freq << "</detection_freq>\n";
    rv << xml_indent() << "<barycentric_freq>" << barycentric_freq << "</barycentric_freq>\n";
    rv << xml_indent() << "<fft_len>" << fft_len << "</fft_len>\n";
    rv << xml_indent() << "<chirp_rate>" << chirp_rate << "</chirp_rate>\n";
    rv << xml_indent() << "<rfi_checked>" << rfi_checked << "</rfi_checked>\n";
    rv << xml_indent() << "<rfi_found>" << rfi_found << "</rfi_found>\n";
    rv << xml_indent() << "<reserved>" << reserved << "</reserved>\n";
    rv << xml_indent() << "<period>" << period << "</period>\n";
    rv << xml_indent() << "<snr>" << snr << "</snr>\n";
    rv << xml_indent() << "<thresh>" << thresh << "</thresh>\n";
    rv << xml_indent() << "<score>" << score << "</score>\n";
    rv << xml_indent() << "<len_prof>" << len_prof << "</len_prof>\n";
    if (pot.size()) {
        std::string enc_field=xml_encode_string(pot,pot.encoding);
        rv << xml_indent() << "<pot length=" << enc_field.size() << " encoding=\"" << xml_encoding_names[pot.encoding] << "\">";
        rv << enc_field << "</pot>\n";
    }
    xml_indent(-2);
    rv << xml_indent() << "</" << tag << ">\n";
    return rv.str();
}


void pulse::parse_xml(const std::string &s,const char *tag) {
    std::string field,sub;
    if (extract_xml_record(s,tag,field)) {
        std::string::size_type pos=0;
        if (extract_xml_record(field,"id",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> id;
        }
        if (extract_xml_record(field,"result_id",sub)) {
            result_id.parse_xml(sub,"result_id");
        }
        if (extract_xml_record(field,"peak_power",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> peak_power;
        }
        if (extract_xml_record(field,"mean_power",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> mean_power;
        }
        if (extract_xml_record(field,"time",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> time;
        }
        if (extract_xml_record(field,"ra",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> ra;
        }
        if (extract_xml_record(field,"decl",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> decl;
        }
        if (extract_xml_record(field,"q_pix",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> q_pix;
        }
        if (extract_xml_record(field,"freq",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> freq;
        }
        if (extract_xml_record(field,"detection_freq",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> detection_freq;
        }
        if (extract_xml_record(field,"barycentric_freq",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> barycentric_freq;
        }
        if (extract_xml_record(field,"fft_len",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> fft_len;
        }
        if (extract_xml_record(field,"chirp_rate",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> chirp_rate;
        }
        if (extract_xml_record(field,"rfi_checked",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> rfi_checked;
        }
        if (extract_xml_record(field,"rfi_found",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> rfi_found;
        }
        if (extract_xml_record(field,"reserved",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> reserved;
        }
        if (extract_xml_record(field,"period",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> period;
        }
        if (extract_xml_record(field,"snr",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> snr;
        }
        if (extract_xml_record(field,"thresh",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> thresh;
        }
        if (extract_xml_record(field,"score",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> score;
        }
        if (extract_xml_record(field,"len_prof",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> len_prof;
        }
        if (extract_xml_record(field,"pot",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            pot=(xml_decode_field<unsigned char>(sub,"pot"));
        }
    }
}

void pulse::parse(const SQL_ROW &s) {
    {
        std::istringstream row(*(s[0]));
        row >> id;
    }
    {
        result_id.parse(SQL_ROW(s[1]->c_str(),0));
    }
    {
        std::istringstream row(*(s[2]));
        row >> peak_power;
    }
    {
        std::istringstream row(*(s[3]));
        row >> mean_power;
    }
    {
        std::istringstream row(*(s[4]));
        row >> time;
    }
    {
        std::istringstream row(*(s[5]));
        row >> ra;
    }
    {
        std::istringstream row(*(s[6]));
        row >> decl;
    }
    {
        std::istringstream row(*(s[7]));
        row >> q_pix;
    }
    {
        std::istringstream row(*(s[8]));
        row >> freq;
    }
    {
        std::istringstream row(*(s[9]));
        row >> detection_freq;
    }
    {
        std::istringstream row(*(s[10]));
        row >> barycentric_freq;
    }
    {
        std::istringstream row(*(s[11]));
        row >> fft_len;
    }
    {
        std::istringstream row(*(s[12]));
        row >> chirp_rate;
    }
    {
        std::istringstream row(*(s[13]));
        row >> rfi_checked;
    }
    {
        std::istringstream row(*(s[14]));
        row >> rfi_found;
    }
    {
        std::istringstream row(*(s[15]));
        row >> reserved;
    }
    {
        std::istringstream row(*(s[16]));
        row >> period;
    }
    {
        std::istringstream row(*(s[17]));
        row >> snr;
    }
    {
        std::istringstream row(*(s[18]));
        row >> thresh;
    }
    {
        std::istringstream row(*(s[19]));
        row >> score;
    }
    {
        std::istringstream row(*(s[20]));
        row >> len_prof;
    }
    {
        pot=sqlblob<unsigned char>(*(s[21]));
    }
}

void pulse::parse(const std::string &s) {
    SQL_ROW row(s.c_str(),22);
    parse(row);
}

template <>
const char * const db_table<pointing>::table_name="pointing";
template <>
const char * db_table<pointing>::_search_tag=table_name;
template <>
const int db_table<pointing>::_nfields=7;
template <>
const char * const db_table<pointing>::column_names[7]= {"time_id","time","ra","dec","q_pix","angle_range","bad"
                                                        };

pointing::pointing() :
        db_table<pointing>(*this,-1),
        time_id(0),
        time(0),
        ra(0),
        dec(0),
        q_pix(0),
        angle_range(0),
bad(0) {
    db_open();
}


pointing::pointing(const pointing &a) :
        db_table<pointing>(*this,-1),
        time_id(a.time_id),
        time(a.time),
        ra(a.ra),
        dec(a.dec),
        q_pix(a.q_pix),
        angle_range(a.angle_range),
bad(a.bad) {
    db_open();
}


pointing::pointing(const SQL_ROW &a) :
db_table<pointing>(*this,-1) {
    db_open();
    parse(a);
}


pointing::pointing(const std::string &s,const char *tag) :
db_table<pointing>(*this,-1) {
    db_open();
    if (xml_match_tag(s,tag)) {
        parse_xml(s,tag);
    } else {
        parse(s);
    }
}


pointing &pointing::operator =(const pointing &a) {
    if (&a != this) {
        time_id=a.time_id;
        time=a.time;
        ra=a.ra;
        dec=a.dec;
        q_pix=a.q_pix;
        angle_range=a.angle_range;
        bad=a.bad;
    }
    return (*this);
}


std::string pointing::update_format() const {
    std::ostringstream rv("");

    for (int i=2;i<7;i++)
        rv << "?,";
    rv << "?";
    return rv.str();
}


std::string pointing::insert_format() const {
    return std::string("?,")+update_format();
}

std::string pointing::select_format() const {
    std::string rv("");
    for (int i=0; i<6;i++)
        rv+="?,";
    rv+="?";
    return rv;
}

std::string pointing::print(int full_subtables, int show_ids, int no_refs) const {
    std::ostringstream rv("");

    rv.precision(14);
    if (show_ids)
        rv << time_id;
    rv << ',';
    rv << time;
    rv << ',';
    rv << ra;
    rv << ',';
    rv << dec;
    rv << ',';
    rv << q_pix;
    rv << ',';
    rv << angle_range;
    rv << ',';
    rv << bad;
    return rv.str();
}


std::string pointing::print_xml(int full_subtables, int show_ids, int no_refs,const char *tag) const {
    std::ostringstream rv("");

    rv.precision(14);
    rv << xml_indent() << '<' << tag << ">\n";
    xml_indent(2);
    if (show_ids)
        rv << xml_indent() << "<time_id>" << time_id << "</time_id>\n";
    rv << xml_indent() << "<time>" << time << "</time>\n";
    rv << xml_indent() << "<ra>" << ra << "</ra>\n";
    rv << xml_indent() << "<dec>" << dec << "</dec>\n";
    rv << xml_indent() << "<q_pix>" << q_pix << "</q_pix>\n";
    rv << xml_indent() << "<angle_range>" << angle_range << "</angle_range>\n";
    rv << xml_indent() << "<bad>" << bad << "</bad>\n";
    xml_indent(-2);
    rv << xml_indent() << "</" << tag << ">\n";
    return rv.str();
}


void pointing::parse_xml(const std::string &s,const char *tag) {
    std::string field,sub;
    if (extract_xml_record(s,tag,field)) {
        std::string::size_type pos=0;
        if (extract_xml_record(field,"time_id",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> time_id;
        }
        if (extract_xml_record(field,"time",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> time;
        }
        if (extract_xml_record(field,"ra",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> ra;
        }
        if (extract_xml_record(field,"dec",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> dec;
        }
        if (extract_xml_record(field,"q_pix",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> q_pix;
        }
        if (extract_xml_record(field,"angle_range",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> angle_range;
        }
        if (extract_xml_record(field,"bad",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> bad;
        }
    }
}

void pointing::parse(const SQL_ROW &s) {
    {
        std::istringstream row(*(s[0]));
        row >> time_id;
    }
    {
        std::istringstream row(*(s[1]));
        row >> time;
    }
    {
        std::istringstream row(*(s[2]));
        row >> ra;
    }
    {
        std::istringstream row(*(s[3]));
        row >> dec;
    }
    {
        std::istringstream row(*(s[4]));
        row >> q_pix;
    }
    {
        std::istringstream row(*(s[5]));
        row >> angle_range;
    }
    {
        std::istringstream row(*(s[6]));
        row >> bad;
    }
}

void pointing::parse(const std::string &s) {
    SQL_ROW row(s.c_str(),7);
    parse(row);
}

template <>
const char * const db_table<sky_map>::table_name="sky_map";
template <>
const char * db_table<sky_map>::_search_tag=table_name;
template <>
const int db_table<sky_map>::_nfields=13;
template <>
const char * const db_table<sky_map>::column_names[13]= {"npix","qpix","fpix","spike_max_id","gaussian_max_id","pulse_max_id","triplet_max_id","spike_count","gaussian_count","pulse_count","triplet_count","new_data","score"
                                                        };

sky_map::sky_map() :
        db_table<sky_map>(*this,-1),
        npix(0),
        qpix(0),
        fpix(0),
        spike_max_id(0),
        gaussian_max_id(0),
        pulse_max_id(0),
        triplet_max_id(0),
        spike_count(0),
        gaussian_count(0),
        pulse_count(0),
        triplet_count(0),
        new_data(0),
score(0) {
    db_open();
}


sky_map::sky_map(const sky_map &a) :
        db_table<sky_map>(*this,-1),
        npix(a.npix),
        qpix(a.qpix),
        fpix(a.fpix),
        spike_max_id(a.spike_max_id),
        gaussian_max_id(a.gaussian_max_id),
        pulse_max_id(a.pulse_max_id),
        triplet_max_id(a.triplet_max_id),
        spike_count(a.spike_count),
        gaussian_count(a.gaussian_count),
        pulse_count(a.pulse_count),
        triplet_count(a.triplet_count),
        new_data(a.new_data),
score(a.score) {
    db_open();
}


sky_map::sky_map(const SQL_ROW &a) :
db_table<sky_map>(*this,-1) {
    db_open();
    parse(a);
}


sky_map::sky_map(const std::string &s,const char *tag) :
db_table<sky_map>(*this,-1) {
    db_open();
    if (xml_match_tag(s,tag)) {
        parse_xml(s,tag);
    } else {
        parse(s);
    }
}


sky_map &sky_map::operator =(const sky_map &a) {
    if (&a != this) {
        npix=a.npix;
        qpix=a.qpix;
        fpix=a.fpix;
        spike_max_id=a.spike_max_id;
        gaussian_max_id=a.gaussian_max_id;
        pulse_max_id=a.pulse_max_id;
        triplet_max_id=a.triplet_max_id;
        spike_count=a.spike_count;
        gaussian_count=a.gaussian_count;
        pulse_count=a.pulse_count;
        triplet_count=a.triplet_count;
        new_data=a.new_data;
        score=a.score;
    }
    return (*this);
}


std::string sky_map::update_format() const {
    std::ostringstream rv("");

    for (int i=2;i<13;i++)
        rv << "?,";
    rv << "?";
    return rv.str();
}


std::string sky_map::insert_format() const {
    return std::string("?,")+update_format();
}

std::string sky_map::select_format() const {
    std::string rv("");
    for (int i=0; i<12;i++)
        rv+="?,";
    rv+="?";
    return rv;
}

std::string sky_map::print(int full_subtables, int show_ids, int no_refs) const {
    std::ostringstream rv("");

    rv.precision(14);
    if (show_ids)
        rv << npix;
    rv << ',';
    rv << qpix;
    rv << ',';
    rv << fpix;
    rv << ',';
    rv << spike_max_id;
    rv << ',';
    rv << gaussian_max_id;
    rv << ',';
    rv << pulse_max_id;
    rv << ',';
    rv << triplet_max_id;
    rv << ',';
    rv << spike_count;
    rv << ',';
    rv << gaussian_count;
    rv << ',';
    rv << pulse_count;
    rv << ',';
    rv << triplet_count;
    rv << ',';
    rv << new_data;
    rv << ',';
    rv << score;
    return rv.str();
}


std::string sky_map::print_xml(int full_subtables, int show_ids, int no_refs,const char *tag) const {
    std::ostringstream rv("");

    rv.precision(14);
    rv << xml_indent() << '<' << tag << ">\n";
    xml_indent(2);
    if (show_ids)
        rv << xml_indent() << "<npix>" << npix << "</npix>\n";
    rv << xml_indent() << "<qpix>" << qpix << "</qpix>\n";
    rv << xml_indent() << "<fpix>" << fpix << "</fpix>\n";
    rv << xml_indent() << "<spike_max_id>" << spike_max_id << "</spike_max_id>\n";
    rv << xml_indent() << "<gaussian_max_id>" << gaussian_max_id << "</gaussian_max_id>\n";
    rv << xml_indent() << "<pulse_max_id>" << pulse_max_id << "</pulse_max_id>\n";
    rv << xml_indent() << "<triplet_max_id>" << triplet_max_id << "</triplet_max_id>\n";
    rv << xml_indent() << "<spike_count>" << spike_count << "</spike_count>\n";
    rv << xml_indent() << "<gaussian_count>" << gaussian_count << "</gaussian_count>\n";
    rv << xml_indent() << "<pulse_count>" << pulse_count << "</pulse_count>\n";
    rv << xml_indent() << "<triplet_count>" << triplet_count << "</triplet_count>\n";
    rv << xml_indent() << "<new_data>" << new_data << "</new_data>\n";
    rv << xml_indent() << "<score>" << score << "</score>\n";
    xml_indent(-2);
    rv << xml_indent() << "</" << tag << ">\n";
    return rv.str();
}


void sky_map::parse_xml(const std::string &s,const char *tag) {
    std::string field,sub;
    if (extract_xml_record(s,tag,field)) {
        std::string::size_type pos=0;
        if (extract_xml_record(field,"npix",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> npix;
        }
        if (extract_xml_record(field,"qpix",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> qpix;
        }
        if (extract_xml_record(field,"fpix",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> fpix;
        }
        if (extract_xml_record(field,"spike_max_id",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> spike_max_id;
        }
        if (extract_xml_record(field,"gaussian_max_id",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> gaussian_max_id;
        }
        if (extract_xml_record(field,"pulse_max_id",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> pulse_max_id;
        }
        if (extract_xml_record(field,"triplet_max_id",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> triplet_max_id;
        }
        if (extract_xml_record(field,"spike_count",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> spike_count;
        }
        if (extract_xml_record(field,"gaussian_count",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> gaussian_count;
        }
        if (extract_xml_record(field,"pulse_count",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> pulse_count;
        }
        if (extract_xml_record(field,"triplet_count",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> triplet_count;
        }
        if (extract_xml_record(field,"new_data",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> new_data;
        }
        if (extract_xml_record(field,"score",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> score;
        }
    }
}

void sky_map::parse(const SQL_ROW &s) {
    {
        std::istringstream row(*(s[0]));
        row >> npix;
    }
    {
        std::istringstream row(*(s[1]));
        row >> qpix;
    }
    {
        std::istringstream row(*(s[2]));
        row >> fpix;
    }
    {
        std::istringstream row(*(s[3]));
        row >> spike_max_id;
    }
    {
        std::istringstream row(*(s[4]));
        row >> gaussian_max_id;
    }
    {
        std::istringstream row(*(s[5]));
        row >> pulse_max_id;
    }
    {
        std::istringstream row(*(s[6]));
        row >> triplet_max_id;
    }
    {
        std::istringstream row(*(s[7]));
        row >> spike_count;
    }
    {
        std::istringstream row(*(s[8]));
        row >> gaussian_count;
    }
    {
        std::istringstream row(*(s[9]));
        row >> pulse_count;
    }
    {
        std::istringstream row(*(s[10]));
        row >> triplet_count;
    }
    {
        std::istringstream row(*(s[11]));
        row >> new_data;
    }
    {
        std::istringstream row(*(s[12]));
        row >> score;
    }
}

void sky_map::parse(const std::string &s) {
    SQL_ROW row(s.c_str(),13);
    parse(row);
}

template <>
const char * const db_table<spike>::table_name="spike";
template <>
const char * db_table<spike>::_search_tag=table_name;
template <>
const int db_table<spike>::_nfields=16;
template <>
const char * const db_table<spike>::column_names[16]= {"id","result_id","peak_power","mean_power","time","ra","decl","q_pix","freq","detection_freq","barycentric_freq","fft_len","chirp_rate","rfi_checked","rfi_found","reserved"
                                                      };

spike::spike() :
        db_table<spike>(*this,-1),
        id(0),
        result_id(),
        peak_power(0),
        mean_power(0),
        time(0),
        ra(0),
        decl(0),
        q_pix(0),
        freq(0),
        detection_freq(0),
        barycentric_freq(0),
        fft_len(0),
        chirp_rate(0),
        rfi_checked(0),
        rfi_found(0),
reserved(0) {
    db_open();
}


spike::spike(const spike &a) :
        db_table<spike>(*this,-1),
        id(a.id),
        result_id(a.result_id),
        peak_power(a.peak_power),
        mean_power(a.mean_power),
        time(a.time),
        ra(a.ra),
        decl(a.decl),
        q_pix(a.q_pix),
        freq(a.freq),
        detection_freq(a.detection_freq),
        barycentric_freq(a.barycentric_freq),
        fft_len(a.fft_len),
        chirp_rate(a.chirp_rate),
        rfi_checked(a.rfi_checked),
        rfi_found(a.rfi_found),
reserved(a.reserved) {
    db_open();
}


spike::spike(const SQL_ROW &a) :
db_table<spike>(*this,-1) {
    db_open();
    parse(a);
}


spike::spike(const std::string &s,const char *tag) :
db_table<spike>(*this,-1) {
    db_open();
    if (xml_match_tag(s,tag)) {
        parse_xml(s,tag);
    } else {
        parse(s);
    }
}


spike &spike::operator =(const spike &a) {
    if (&a != this) {
        id=a.id;
        result_id=a.result_id;
        peak_power=a.peak_power;
        mean_power=a.mean_power;
        time=a.time;
        ra=a.ra;
        decl=a.decl;
        q_pix=a.q_pix;
        freq=a.freq;
        detection_freq=a.detection_freq;
        barycentric_freq=a.barycentric_freq;
        fft_len=a.fft_len;
        chirp_rate=a.chirp_rate;
        rfi_checked=a.rfi_checked;
        rfi_found=a.rfi_found;
        reserved=a.reserved;
    }
    return (*this);
}


std::string spike::update_format() const {
    std::ostringstream rv("");

    for (int i=2;i<16;i++)
        rv << "?,";
    rv << "?";
    return rv.str();
}


std::string spike::insert_format() const {
    return std::string("?,")+update_format();
}

std::string spike::select_format() const {
    std::string rv("");
    for (int i=0; i<15;i++)
        rv+="?,";
    rv+="?";
    return rv;
}

std::string spike::print(int full_subtables, int show_ids, int no_refs) const {
    std::ostringstream rv("");

    rv.precision(14);
    if (show_ids)
        rv << id;
    rv << ',';
    if (!no_refs) {
        if (full_subtables) {
            rv << result_id.print(full_subtables,show_ids,no_refs);
        } else {
            rv << result_id.id;
        }
    }
    rv << ',';
    rv << peak_power;
    rv << ',';
    rv << mean_power;
    rv << ',';
    rv << time;
    rv << ',';
    rv << ra;
    rv << ',';
    rv << decl;
    rv << ',';
    rv << q_pix;
    rv << ',';
    rv << freq;
    rv << ',';
    rv << detection_freq;
    rv << ',';
    rv << barycentric_freq;
    rv << ',';
    rv << fft_len;
    rv << ',';
    rv << chirp_rate;
    rv << ',';
    rv << rfi_checked;
    rv << ',';
    rv << rfi_found;
    rv << ',';
    rv << reserved;
    return rv.str();
}


std::string spike::print_xml(int full_subtables, int show_ids, int no_refs,const char *tag) const {
    std::ostringstream rv("");

    rv.precision(14);
    rv << xml_indent() << '<' << tag << ">\n";
    xml_indent(2);
    if (show_ids)
        rv << xml_indent() << "<id>" << id << "</id>\n";
    if (!no_refs) {
        if (full_subtables) {
            rv << result_id.print_xml(full_subtables,show_ids,no_refs,"result_id");
        } else {
            rv << xml_indent() << "<result_id><id>" << result_id.id << "</id></result_id>\n";
        }
    }
    rv << xml_indent() << "<peak_power>" << peak_power << "</peak_power>\n";
    rv << xml_indent() << "<mean_power>" << mean_power << "</mean_power>\n";
    rv << xml_indent() << "<time>" << time << "</time>\n";
    rv << xml_indent() << "<ra>" << ra << "</ra>\n";
    rv << xml_indent() << "<decl>" << decl << "</decl>\n";
    rv << xml_indent() << "<q_pix>" << q_pix << "</q_pix>\n";
    rv << xml_indent() << "<freq>" << freq << "</freq>\n";
    rv << xml_indent() << "<detection_freq>" << detection_freq << "</detection_freq>\n";
    rv << xml_indent() << "<barycentric_freq>" << barycentric_freq << "</barycentric_freq>\n";
    rv << xml_indent() << "<fft_len>" << fft_len << "</fft_len>\n";
    rv << xml_indent() << "<chirp_rate>" << chirp_rate << "</chirp_rate>\n";
    rv << xml_indent() << "<rfi_checked>" << rfi_checked << "</rfi_checked>\n";
    rv << xml_indent() << "<rfi_found>" << rfi_found << "</rfi_found>\n";
    rv << xml_indent() << "<reserved>" << reserved << "</reserved>\n";
    xml_indent(-2);
    rv << xml_indent() << "</" << tag << ">\n";
    return rv.str();
}


void spike::parse_xml(const std::string &s,const char *tag) {
    std::string field,sub;
    if (extract_xml_record(s,tag,field)) {
        std::string::size_type pos=0;
        if (extract_xml_record(field,"id",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> id;
        }
        if (extract_xml_record(field,"result_id",sub)) {
            result_id.parse_xml(sub,"result_id");
        }
        if (extract_xml_record(field,"peak_power",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> peak_power;
        }
        if (extract_xml_record(field,"mean_power",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> mean_power;
        }
        if (extract_xml_record(field,"time",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> time;
        }
        if (extract_xml_record(field,"ra",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> ra;
        }
        if (extract_xml_record(field,"decl",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> decl;
        }
        if (extract_xml_record(field,"q_pix",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> q_pix;
        }
        if (extract_xml_record(field,"freq",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> freq;
        }
        if (extract_xml_record(field,"detection_freq",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> detection_freq;
        }
        if (extract_xml_record(field,"barycentric_freq",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> barycentric_freq;
        }
        if (extract_xml_record(field,"fft_len",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> fft_len;
        }
        if (extract_xml_record(field,"chirp_rate",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> chirp_rate;
        }
        if (extract_xml_record(field,"rfi_checked",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> rfi_checked;
        }
        if (extract_xml_record(field,"rfi_found",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> rfi_found;
        }
        if (extract_xml_record(field,"reserved",sub)) {
            pos=sub.find(">");
            do {
                pos++;
            } while(sub[pos]=='\n');
            std::istringstream in(sub.c_str()+pos);
            in >> reserved;
        }
    }
}

void spike::parse(const SQL_ROW &s) {
    {
        std::istringstream row(*(s[0]));
        row >> id;
    }
    {
        result_id.parse(SQL_ROW(s[1]->c_str(),0));
    }
    {
        std::istringstream row(*(s[2]));
        row >> peak_power;
    }
    {
        std::istringstream row(*(s[3]));
        row >> mean_power;
    }
    {
        std::istringstream row(*(s[4]));
        row >> time;
    }
    {
        std::istringstream row(*(s[5]));
        row >> ra;
    }
    {
        std::istringstream row(*(s[6]));
        row >> decl;
    }
    {
        std::istringstream row(*(s[7]));
        row >> q_pix;
    }
    {
        std::istringstream row(*(s[8]));
        row >> freq;
    }
    {
        std::istringstream row(*(s[9]));
        row >> detection_freq;
    }
    {
        std::istringstream row(*(s[10]));
        row >> barycentric_freq;
    }
    {
        std::istringstream row(*(s[11]));
        row >> fft_len;
    }
    {
        std::istringstream row(*(s[12]));
        row >> chirp_rate;
    }
    {
        std::istringstream row(*(s[13]));
        row >> rfi_checked;
    }
    {
        std::istringstream row(*(s[14]));
        row >> rfi_found;
    }
    {
        std::istringstream row(*(s[15]));
        row >> reserved;
    }
}

void spike::parse(const std::string &s) {
    SQL_ROW row(s.c_str(),16);
    parse(row);
}

