{-
    BNF Converter: Haskell main file
    Copyright (C) 2004  Author:  Markus Forberg, Peter Gammie, Aarne Ranta

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
-}

module HaskellTop (makeAll) where 



-- import Utils
import CF
import CFtoHappy
import CFtoAlex
import CFtoAlex2
import CFtoLatex
import CFtoAbstract
import CFtoTemplate
import CFtoPrinter
import CFtoLayout
import CFtoXML
-- import CFtoGF		( cf2AbsGF, cf2ConcGF )
-- import System
import GetCF

import Char
import System
import Monad(when)
import Directory(createDirectory, doesDirectoryExist)

-- naming conventions

noLang :: String -> String -> String
noLang name _ = name

withLang :: String -> String -> String
withLang name lang = name ++ lang

mkMod :: (String -> String -> String) -> String -> Bool -> String -> FilePath
mkMod addLang name inDir lang = 
    if inDir 
       then lang ++ "." ++ name 
       else addLang name lang

mkFile :: (String -> String -> String) -> String -> String -> Bool -> String -> FilePath
mkFile addLang name ext inDir lang = 
    if inDir 
       then lang ++ "/" ++ name ++ "." ++ ext
       else addLang name lang ++ if null ext then "" else "." ++ ext

nameMod :: String -> Bool -> String -> FilePath
nameMod = mkMod withLang

nameFile :: String -> String -> Bool -> String -> FilePath
nameFile = mkFile withLang

nameModNoLang :: String -> Bool -> String -> FilePath
nameModNoLang = mkMod noLang

nameFileNoLang :: String -> String -> Bool -> String -> FilePath
nameFileNoLang = mkFile noLang

absFile, absFileM, alexFile, alexFileM, dviFile,
 gfAbs, gfConc,
 happyFile, happyFileM,
 latexFile, errFile, errFileM,
 templateFile, templateFileM, 
 printerFile, printerFileM,
 layoutFile, layoutFileM, 
 psFile, tFile, tFileM, mFile :: Bool -> String -> FilePath
absFile       = nameFile "Abs" "hs"
absFileM      = nameMod  "Abs" 
alexFile      = nameFile "Lex" "x"
alexFileM     = nameMod  "Lex"
happyFile     = nameFile "Par" "y"
happyFileM    = nameMod  "Par"
latexFile     = nameFile "Doc" "tex"
templateFile  = nameFile "Skel" "hs"
templateFileM = nameMod  "Skel"
printerFile   = nameFile "Print" "hs"
printerFileM  = nameMod  "Print"
dviFile       = nameFile "Doc" "dvi"
psFile        = nameFile "Doc" "ps"
gfAbs         = nameFile "" "Abs.gf"
gfConc        = nameFile "" "Conc.gf"
tFile         = nameFile "Test" "hs"
tFileM        = nameMod  "Test"
mFile         = nameFileNoLang "Makefile" ""
errFile       = nameFileNoLang "ErrM" "hs"
errFileM      = nameModNoLang "ErrM"
shareFile     = nameFileNoLang "SharedString" "hs"
shareFileM    = nameModNoLang "SharedString"
layoutFileM   = nameMod  "Layout"
xmlFileM      = nameMod  "XML"
layoutFile    = nameFile "Layout" "hs"

makeAll :: Bool -> Bool -> Bool -> Bool -> Bool -> Int -> FilePath -> IO ()
makeAll make alex1 inDir shareStrings glr xml file = do
  let name   = takeWhile (/= '.') file
      absMod = absFileM      inDir name
      lexMod = alexFileM     inDir name
      parMod = happyFileM    inDir name
      prMod  = printerFileM  inDir name
      layMod = layoutFileM   inDir name
      tplMod = templateFileM inDir name
      errMod = errFileM      inDir name
      shareMod = shareFileM  inDir name
      mode = if glr then GLR else Standard
  (cf, isOK) <- tryReadCF $ name
  if isOK then do

    when inDir (prepareDir name)
    writeFileRep (absFile  inDir name) $ cf2Abstract (absFileM inDir name) cf
    if (alex1) then do
		    writeFileRep (alexFile inDir name) $ cf2alex lexMod errMod cf
		    putStrLn "   (Use Alex 1.1 to compile.)" 
	       else do
		    writeFileRep (alexFile inDir name) $ cf2alex2 lexMod errMod shareMod shareStrings cf
                    putStrLn "   (Use Alex 2.0 to compile.)"
    writeFileRep (happyFile inDir name) $ 
		 cf2HappyS parMod absMod lexMod errMod mode cf
    putStrLn "   (Tested with Happy 1.15)"
    writeFileRep (latexFile inDir name)    $ cfToLatex name cf
    writeFileRep (templateFile inDir name) $ 
		 cf2Template tplMod absMod errMod cf
    writeFileRep (printerFile inDir name)  $ cf2Printer prMod absMod cf
    if hasLayout cf then 
      writeFileRep (layoutFile inDir name) $ cf2Layout alex1 inDir layMod lexMod cf
      else return ()
    writeFileRep (tFile inDir name)        $ testfile inDir name (xml>0) glr cf
    writeFileRep (errFile inDir name)      $ errM errMod cf
    when shareStrings $ writeFileRep (shareFile inDir name)    $ sharedString shareMod cf
    when make $ writeFileRep (mFile inDir name) $ makefile glr inDir name
    case xml of
      2 -> makeXML name True cf
      1 -> makeXML name False cf
      _ -> return ()
    putStrLn $ "Done!"
   else do putStrLn $ "Failed!"
	   exitFailure

prepareDir :: String -> IO ()
prepareDir dirname = do
  b <- doesDirectoryExist dirname
  if b then return () else createDirectory dirname

makefile :: Bool -> Bool -> String -> String
makefile glr inDir name = makeA where
  glr_params = if glr then "--glr --decode " else ""  
  name' = if inDir then "" else name -- Makefile is inDir
  ghcCommand = "ghc --make "++ tFile inDir name ++ " -o " ++ 
                      if inDir then name ++ "/" ++ "Test" else "Test" ++ name
  makeA = unlines 
                [
 		 "all:", 
                 "\thappy -gca " ++ glr_params ++ happyFile False name', 
		 "\talex -g "  ++ alexFile  False name',
                 "\tlatex " ++ latexFile False name',
		 "\tdvips " ++ dviFile   False name' ++ " -o " ++ psFile False name',
		 "\t" ++ if inDir then 
		           "(" ++ "cd ..; " ++ ghcCommand ++ ")"
                         else ghcCommand,
		 "clean:",
		 "\t rm -f " ++ unwords [
                                         "*.log *.aux *.hi *.o *.dvi",
				         psFile False name',
				         "*.o"
                                        ],
		 "distclean: " ++ if inDir then "" else "clean",
		 if inDir then
		   "\t rm -rf ../" ++ name -- erase this directory!
		 else
		   "\t rm -f " ++ unwords [
					   "Doc" ++ name ++ ".*",
					   "Lex" ++ name ++ ".*",
					   "Par" ++ name ++ ".*",
					   "Par" ++ name ++ "Data.*",
					   "Layout" ++ name ++ ".*",
					   "Skel" ++ name ++ ".*",
					   "Print" ++ name ++ ".*",
					   "Test" ++ name ++ ".*",
					   "Abs" ++ name ++ ".*", 
					   "Test" ++ name,
					   "ErrM.*",
					   "SharedString.*",
                                           name ++ ".dtd",
					   "XML" ++ name ++ ".*", 
					   "Makefile*"
					  ]
		]


testfile :: Bool -> String -> Bool -> Bool -> CF -> String
testfile inDir name xml glr cf = makeA where

  makeA = let lay = hasLayout cf 
              xpr = if xml then "XPrint a, "     else ""
              if_glr s = if glr then s else ""
          in unlines
	        ["-- automatically generated by BNF Converter",
		 "module Main where\n",
	         "",
	         "import IO ( stdin, hGetContents )",
	         "import System ( getArgs, getProgName )",
		 "",
		 "import " ++ alexFileM     inDir name,
		 "import " ++ happyFileM    inDir name,
		 "import " ++ templateFileM inDir name,
	         "import " ++ printerFileM  inDir name,
	         "import " ++ absFileM      inDir name,
	         if lay then ("import " ++ layoutFileM inDir name) else "",
	         if xml then ("import " ++ xmlFileM inDir name) else "",
	         if_glr "import Data.FiniteMap(FiniteMap, lookupFM, fmToList)",
	         if_glr "import Maybe(fromJust)",
	         "import " ++ errFileM      inDir name,
		 "",
		 if glr 
		   then "type ParseFun a = [[Token]] -> (GLRResult, GLR_Output (Err a))"
		   else "type ParseFun a = [Token] -> Err a",
	         "",
                 "myLLexer = " ++ if lay then "resolveLayout True . myLexer" 
                                         else "myLexer",
                 "",
                 "type Verbosity = Int",
                 "",
                 "putStrV :: Verbosity -> String -> IO ()",
                 "putStrV v s = if v > 1 then putStrLn s else return ()",
                 "",
		 "runFile :: (" ++ xpr ++ if_glr "TreeDecode a, " ++ "Print a, Show a) => Verbosity -> ParseFun a -> FilePath -> IO ()",
		 "runFile v p f = putStrLn f >> readFile f >>= run v p",
		 "",
		 "run :: (" ++ xpr ++ if_glr "TreeDecode a, " ++ "Print a, Show a) => Verbosity -> ParseFun a -> String -> IO ()",
		 if glr then run_glr else run_std xml,
		 "",
		 "showTree :: (Show a, Print a) => Int -> a -> IO ()",
		 "showTree v tree",
		 " = do",
		 "      putStrV v $ \"\\n[Abstract Syntax]\\n\\n\" ++ show tree",
		 "      putStrV v $ \"\\n[Linearized tree]\\n\\n\" ++ printTree tree",
		 "",
		 "main :: IO ()",
		 "main = do args <- getArgs",
		 "          case args of",
		 "            [] -> hGetContents stdin >>= run 2 " ++ firstParser,
		 "            \"-s\":fs -> mapM_ (runFile 0 " ++ firstParser ++ ") fs",
		 "            fs -> mapM_ (runFile 2 " ++ firstParser ++ ") fs",
		 "",
		 if_glr $ "the_parser :: ParseFun " ++ topType,
		 if_glr $ "the_parser = lift_parser " ++ parserName,
		 if_glr $ "",
		 if_glr $ lift_parser
		 ]
		  where 
			firstParser = if glr then "the_parser" else parserName
			parserName = 'p' : topType
			topType = firstEntry cf

run_std xml
 = unlines 
   [ "run v p s = let ts = myLLexer s in case p ts of"
   , "           Bad s    -> do putStrLn \"\\nParse              Failed...\\n\""
   , "                          putStrV v \"Tokens:\""
   , "                          putStrV v $ show ts"
   , "                          putStrLn s"
   , "           Ok  tree -> do putStrLn \"\\nParse Successful!\""
   , "                          showTree v tree"
   , if xml then
     "                          putStrV v $ \"\\n[XML]\\n\\n\" ++ printXML tree"
     else ""
   ]

run_glr
 = unlines 
   [ "run v p s"
   , " = let ts = map (:[]) $ myLLexer s"
   , "       (raw_output, simple_output) = p ts in"
   , "   case simple_output of"
   , "     GLR_Fail major minor -> do"
   , "                               putStrLn major"
   , "                               putStrV v minor"
   , "     GLR_Result df trees  -> do"
   , "                               putStrLn \"\\nParse Successful!\""
   , "                               case trees of"
   , "                                 []       -> error \"No results but parse succeeded?\""
   , "                                 [Ok x]   -> showTree v x"
   , "                                 xs@(_:_) -> showSeveralTrees v xs"
   , "   where"
   , "	showSeveralTrees :: (Print b, Show b) => Int -> [Err b] -> IO ()"
   , "	showSeveralTrees v trees"
   , "	 = sequence_ "
   , "	   [ do putStrV v (replicate 40 '-')"
   , "	        putStrV v $ \"Parse number: \" ++ show n"
   , "	        showTree v t"
   , "	   | (Ok t,n) <- zip trees [1..]"
   , "	   ]"
   ]
   

lift_parser
 = unlines 
   [ "type Forest = FiniteMap ForestId [Branch]      -- omitted in ParX export."
   , "data GLR_Output a"
   , " = GLR_Result { pruned_decode     :: (Forest -> Forest) -> [a]"
   , "              , semantic_result   :: [a]"
   , "              }"
   , " | GLR_Fail   { main_message :: String"
   , "              , extra_info   :: String"
   , "              }"
   , ""
   , "lift_parser"
   , " :: (TreeDecode a, Show a, Print a)"
   , " => ([[Token]] -> GLRResult) -> ParseFun a"
   , "lift_parser parser ts"
   , " = let result = parser ts in"
   , "   (\\o -> (result, o)) $"
   , "   case result of"
   , "     ParseError ts f -> GLR_Fail \"Parse failed, unexpected token(s)\\n\""
   , "                                 (\"Tokens: \" ++ show ts)"
   , "     ParseEOF   f    -> GLR_Fail \"Parse failed, unexpected EOF\\n\""
   , "                                 (\"Partial forest:\\n\""
   , "                                    ++ unlines (map show $ fmToList f))"
   , "     ParseOK r f     -> let find   f = fromJust . lookupFM f"
   , "                            dec_fn f = decode (find f) r"
   , "                        in GLR_Result (\\ff -> dec_fn $ ff f) (dec_fn f)"
   ]


errM :: String -> b -> String
errM errMod _ = unlines
	   [
	    "-- BNF Converter: Error Monad",
	    "-- Copyright (C) 2004  Author:  Aarne Ranta",
	    "",
	    "-- This file comes with NO WARRANTY and may be used FOR ANY PURPOSE.",
	    "module " ++ errMod ++ " where",
	    "",
	    "-- the Error monad: like Maybe type with error msgs",
	    "",
	    "data Err a = Ok a | Bad String",
	    "  deriving (Read, Show, Eq)",
	    "",
	    "instance Monad Err where",
	    "  return      = Ok",
	    "  fail        = Bad",
	    "  Ok a  >>= f = f a",
	    "  Bad s >>= f = Bad s"
	   ]

sharedString :: String -> CF -> String
sharedString shareMod _ = unlines 
    [
     "module " ++ shareMod ++ " (shareString) where",
     "",
     "import Data.HashTable as H",
     "import System.IO.Unsafe (unsafePerformIO)",
     "",
     "{-# NOINLINE stringPool #-}",
     "stringPool :: HashTable String String",
     "stringPool = unsafePerformIO $ new (==) hashString",
     "",
     "{-# NOINLINE shareString #-}",
     "shareString :: String -> String",
     "shareString s = unsafePerformIO $ do",
     "  mv <- H.lookup stringPool s",
     "  case mv of",
     "       Just s' -> return s'",
     "       Nothing -> do",
     "                  H.insert stringPool s s",
     "                  return s"
    ]

{-		 

makeGF :: FilePath -> IO ()
makeGF file = do
  let name = takeWhile (/= '.') file
  cf <- readCF $ name
  writeFileRep (gfAbs name)        $ cf2AbsGF     name cf
  writeFileRep (gfConc name)       $ cf2ConcGF    name cf
  putStrLn $ "Done!"

readCF :: FilePath -> IO CF
readCF f = tryReadCF f >>= return . fst

tryReadCF :: FilePath -> IO (CF,Bool)
tryReadCF name = do
  s <- readFile $ cfFile name
  putStrLn $ "\nReading grammar from " ++ name
  let (cf,msg) = getCF s
  if not (null msg) then do
    putStrLn $ unlines msg
    return (cf,False)
   else do
    putStrLn $ show (length (rulesOfCF cf)) +++ "rules accepted\n"
    case (notUniqueFuns cf) of
     [] -> return (cf,True)
     xs -> do  
       putStrLn $ "Warning :" 
       putStrLn $ "  Non-unique label name(s) : " ++ unwords xs
       putStrLn $ "  There may be problems with the pretty-printer.\n"
       return (cf, True)

writeFileRep :: FilePath -> String -> IO()
writeFileRep f s = writeFile f s >> putStrLn ("wrote file " ++ f)
-}
